from aws_cdk import App, Stack, Environment
from must_cdk import EcsCodeDeploy
import os

class EcsBlueGreenStack(Stack):
    def __init__(self, scope: App, id: str, **kwargs):
        super().__init__(scope, id, **kwargs)

        EcsCodeDeploy(self, "EcsService",
            service_name="sample-service",
            cluster={
                "name": "production-cluster",
                "vpc": {
                    "maxAzs": 2
                }
            },
            task_definition={
                "taskCPU": 1024,
                "memoryLimit": 2048,
                "containers": [
                    {
                        "name": "web",
                        "image": "nginx:latest",
                        "containerPort": 80,
                        "healthCheck": {
                            "command": ["CMD-SHELL", "curl -f http://localhost/ || exit 1"],
                            "interval": 30,
                            "retries": 3,
                            "timeout": 5
                        }
                    }
                ]
            },
            load_balancer={
                "healthCheckPath": "/",
                "port": 80
            },
            deployment={
                "type": "BLUE_GREEN",
                "autoRollback": True,
                "terminationWaitTime": 10
            },
            desired_count=2,
            auto_scaling={
                "minCapacity": 2,
                "maxCapacity": 10,
                "targetCpuUtilization": 75
            }
        )

app = App()
EcsBlueGreenStack(app, "EcsBlueGreenStack",
    env=Environment(
        account=os.getenv("CDK_DEFAULT_ACCOUNT"),
        region="ap-northeast-2"
    )
)
app.synth()
