"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmplifyApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const amplify = require("aws-cdk-lib/aws-amplify");
const constructs_1 = require("constructs");
class AmplifyApp extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.branches = [];
        // Create Amplify App
        this.app = new amplify.CfnApp(this, "App", {
            name: props.appName,
            repository: props.repository,
            accessToken: props.accessToken,
            environmentVariables: this.formatEnvVars(props.environmentVariables),
            buildSpec: props.buildSpec || this.getDefaultBuildSpec(props.platform),
            platform: props.platform || "WEB_COMPUTE",
            customRules: props.customRules || this.getDefaultCustomRules(),
            autoBranchCreationConfig: {
                enableAutoBuild: props.buildSettings?.enableBranchAutoBuild ?? false,
                enableAutoBranchCreation: props.buildSettings?.enableAutoBranchCreation ?? false,
                enablePullRequestPreview: true,
            },
            basicAuthConfig: props.basicAuth
                ? {
                    enableBasicAuth: props.basicAuth.enableBasicAuth ?? true,
                    username: props.basicAuth.username,
                    password: props.basicAuth.password,
                }
                : undefined,
            tags: props.tags
                ? Object.entries(props.tags).map(([key, value]) => ({ key, value }))
                : undefined,
        });
        // Create branches
        if (props.branches) {
            props.branches.forEach((branch, index) => {
                const cfnBranch = new amplify.CfnBranch(this, `Branch${index}`, {
                    appId: this.app.attrAppId,
                    branchName: branch.branchName,
                    stage: branch.stage || "PRODUCTION",
                    environmentVariables: this.formatEnvVars(branch.environmentVariables),
                    enableAutoBuild: branch.enableAutoBuild ?? true,
                    framework: branch.framework,
                    buildSpec: branch.buildSpec,
                });
                this.branches.push(cfnBranch);
            });
        }
        else {
            // Default main branch
            const mainBranch = new amplify.CfnBranch(this, "MainBranch", {
                appId: this.app.attrAppId,
                branchName: "main",
                stage: "PRODUCTION",
                enableAutoBuild: true,
            });
            this.branches.push(mainBranch);
        }
        // Custom domain setup
        if (props.customDomain) {
            this.domain = new amplify.CfnDomain(this, "Domain", {
                appId: this.app.attrAppId,
                domainName: props.customDomain.domainName,
                enableAutoSubDomain: props.customDomain.enableAutoSubdomain,
                autoSubDomainCreationPatterns: props.customDomain.autoSubdomainCreationPatterns,
                subDomainSettings: props.customDomain.subDomains?.map((sub) => ({
                    branchName: sub.branchName,
                    prefix: sub.prefix,
                })) || [
                    {
                        branchName: "main",
                        prefix: "",
                    },
                ],
            });
        }
        // Outputs
        new aws_cdk_lib_1.CfnOutput(this, "AppId", {
            value: this.app.attrAppId,
            description: "Amplify App ID",
        });
        new aws_cdk_lib_1.CfnOutput(this, "DefaultDomain", {
            value: this.app.attrDefaultDomain,
            description: "Amplify Default Domain",
        });
        if (this.domain) {
            new aws_cdk_lib_1.CfnOutput(this, "CustomDomain", {
                value: props.customDomain.domainName,
                description: "Amplify Custom Domain",
            });
        }
    }
    formatEnvVars(envVars) {
        if (!envVars)
            return undefined;
        return Object.entries(envVars).map(([name, value]) => ({ name, value }));
    }
    getDefaultCustomRules() {
        return [
            {
                source: "/<*>",
                target: "/index.html",
                status: "404-200",
            },
        ];
    }
    getDefaultBuildSpec(platform) {
        if (platform === "WEB_COMPUTE") {
            return `version: 1
frontend:
  phases:
    preBuild:
      commands:
        - yarn install
    build:
      commands:
        - yarn run build
  artifacts:
    baseDirectory: .next
    files:
      - '**/*'
  cache:
    paths:
      - .next/cache/**/*
      - node_modules/**/*`;
        }
        return `version: 1
frontend:
  phases:
    preBuild:
      commands:
        - npm ci
    build:
      commands:
        - npm run build
  artifacts:
    baseDirectory: dist
    files:
      - '**/*'
  cache:
    paths:
      - node_modules/**/*`;
    }
}
exports.AmplifyApp = AmplifyApp;
_a = JSII_RTTI_SYMBOL_1;
AmplifyApp[_a] = { fqn: "must-cdk.AmplifyApp", version: "0.0.68" };
//# sourceMappingURL=data:application/json;base64,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