export interface AmplifyAppProps {
    readonly appName: string;
    readonly repository: string;
    readonly accessToken?: string;
    readonly environmentVariables?: Record<string, string>;
    readonly buildSpec?: string;
    readonly customDomain?: CustomDomainOptions;
    readonly branches?: BranchOptions[];
    readonly platform?: "WEB" | "WEB_COMPUTE";
    readonly buildSettings?: BuildSettings;
    readonly customRules?: CustomRule[];
    readonly basicAuth?: BasicAuthConfig;
    readonly tags?: {
        [key: string]: string;
    };
}
export interface BuildSettings {
    readonly computeType?: "STANDARD" | "STANDARD_8GB";
    readonly cacheType?: "NO_CACHE" | "AMPLIFY_MANAGED" | "AMPLIFY_MANAGED_NO_COOKIES" | "S3";
    readonly enableAutoBranchCreation?: boolean;
    readonly enableAutoBranchDeletion?: boolean;
    readonly enableBranchAutoBuild?: boolean;
}
export interface CustomRule {
    readonly source: string;
    readonly target: string;
    readonly status?: string;
    readonly condition?: string;
}
export interface CustomDomainOptions {
    readonly domainName: string;
    readonly subDomains?: SubDomainOptions[];
    readonly enableAutoSubdomain?: boolean;
    readonly autoSubdomainCreationPatterns?: string[];
}
export interface SubDomainOptions {
    readonly branchName: string;
    readonly prefix: string;
}
export interface BasicAuthConfig {
    readonly username: string;
    readonly password: string;
    readonly enableBasicAuth?: boolean;
}
export interface BranchOptions {
    readonly branchName: string;
    readonly stage?: string;
    readonly environmentVariables?: Record<string, string>;
    readonly pullRequestPreview?: boolean;
    readonly enableAutoBuild?: boolean;
    readonly framework?: string;
    readonly buildSpec?: string;
}
