import * as api from "aws-cdk-lib/aws-apigateway";
import * as acm from "aws-cdk-lib/aws-certificatemanager";
import * as lambda from "aws-cdk-lib/aws-lambda";
import * as logs from "aws-cdk-lib/aws-logs";
import * as route53 from "aws-cdk-lib/aws-route53";
import { Construct } from "constructs";
import { ApiGatewayToLambdaProps, CustomRoute } from "./rest-interface";
export declare class ApiGatewayToLambda extends Construct {
    readonly apiGateway: api.RestApi;
    readonly apiGatewayLogGroup?: logs.LogGroup;
    readonly lambdaFunction: lambda.IFunction;
    readonly aRecord?: route53.ARecord;
    readonly certificate?: acm.ICertificate;
    readonly domain?: api.DomainName;
    readonly usagePlan?: api.UsagePlan;
    constructor(scope: Construct, id: string, props: ApiGatewayToLambdaProps);
    /**
     * Add custom routes to the API
     */
    private addCustomRoutes;
    /**
     * Setup custom domain with certificate and Route53 record
     */
    private setupCustomDomain;
    /**
     * Setup usage plan
     */
    private setupUsagePlan;
    /**
     * Add a custom route after construction (for dynamic route addition)
     */
    addRoute(route: CustomRoute): api.Method;
    get apiUrl(): string;
}
