"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupLogging = setupLogging;
const iam = require("aws-cdk-lib/aws-iam");
const logs = require("aws-cdk-lib/aws-logs");
function setupLogging(scope, apiName, logGroupProps) {
    const logGroup = new logs.LogGroup(scope, "ApiGatewayLogGroup", {
        logGroupName: `/aws/apigateway/${apiName}`,
        ...logGroupProps,
    });
    const role = new iam.Role(scope, "ApiGatewayCloudWatchRole", {
        assumedBy: new iam.ServicePrincipal("apigateway.amazonaws.com"),
        managedPolicies: [
            iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AmazonAPIGatewayPushToCloudWatchLogs"),
        ],
    });
    return { logGroup, role };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvYXBpZ3ctbGFtYmRhL3V0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBSUEsb0NBdUJDO0FBM0JELDJDQUEyQztBQUMzQyw2Q0FBNkM7QUFHN0MsU0FBZ0IsWUFBWSxDQUMxQixLQUFnQixFQUNoQixPQUFlLEVBQ2YsYUFBa0M7SUFLbEMsTUFBTSxRQUFRLEdBQUcsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxvQkFBb0IsRUFBRTtRQUM5RCxZQUFZLEVBQUUsbUJBQW1CLE9BQU8sRUFBRTtRQUMxQyxHQUFHLGFBQWE7S0FDakIsQ0FBQyxDQUFDO0lBRUgsTUFBTSxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSwwQkFBMEIsRUFBRTtRQUMzRCxTQUFTLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsMEJBQTBCLENBQUM7UUFDL0QsZUFBZSxFQUFFO1lBQ2YsR0FBRyxDQUFDLGFBQWEsQ0FBQyx3QkFBd0IsQ0FDeEMsbURBQW1ELENBQ3BEO1NBQ0Y7S0FDRixDQUFDLENBQUM7SUFFSCxPQUFPLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDO0FBQzVCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1pYW1cIjtcbmltcG9ydCAqIGFzIGxvZ3MgZnJvbSBcImF3cy1jZGstbGliL2F3cy1sb2dzXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuXG5leHBvcnQgZnVuY3Rpb24gc2V0dXBMb2dnaW5nKFxuICBzY29wZTogQ29uc3RydWN0LFxuICBhcGlOYW1lOiBzdHJpbmcsXG4gIGxvZ0dyb3VwUHJvcHM/OiBsb2dzLkxvZ0dyb3VwUHJvcHMsXG4pOiB7XG4gIGxvZ0dyb3VwOiBsb2dzLkxvZ0dyb3VwO1xuICByb2xlOiBpYW0uUm9sZTtcbn0ge1xuICBjb25zdCBsb2dHcm91cCA9IG5ldyBsb2dzLkxvZ0dyb3VwKHNjb3BlLCBcIkFwaUdhdGV3YXlMb2dHcm91cFwiLCB7XG4gICAgbG9nR3JvdXBOYW1lOiBgL2F3cy9hcGlnYXRld2F5LyR7YXBpTmFtZX1gLFxuICAgIC4uLmxvZ0dyb3VwUHJvcHMsXG4gIH0pO1xuXG4gIGNvbnN0IHJvbGUgPSBuZXcgaWFtLlJvbGUoc2NvcGUsIFwiQXBpR2F0ZXdheUNsb3VkV2F0Y2hSb2xlXCIsIHtcbiAgICBhc3N1bWVkQnk6IG5ldyBpYW0uU2VydmljZVByaW5jaXBhbChcImFwaWdhdGV3YXkuYW1hem9uYXdzLmNvbVwiKSxcbiAgICBtYW5hZ2VkUG9saWNpZXM6IFtcbiAgICAgIGlhbS5NYW5hZ2VkUG9saWN5LmZyb21Bd3NNYW5hZ2VkUG9saWN5TmFtZShcbiAgICAgICAgXCJzZXJ2aWNlLXJvbGUvQW1hem9uQVBJR2F0ZXdheVB1c2hUb0Nsb3VkV2F0Y2hMb2dzXCIsXG4gICAgICApLFxuICAgIF0sXG4gIH0pO1xuXG4gIHJldHVybiB7IGxvZ0dyb3VwLCByb2xlIH07XG59XG4iXX0=