import { aws_ec2 as ec2, aws_ecs as ecs, aws_iam as iam } from "aws-cdk-lib";
import { ICertificate } from "aws-cdk-lib/aws-certificatemanager";
/**
 * Configuration for the ECS Fargate task definition and container.
 */
export interface ContainerProps {
    /** Hard memory limit in MiB for the task (default: 2048). */
    readonly memoryLimit?: number;
    /** Soft memory reservation in MiB for the container (default: 1024). */
    readonly memoryReservation?: number;
    /** Container image to deploy. */
    readonly image: ecs.ContainerImage;
    /** Optional container health check configuration. */
    readonly healthCheck?: ecs.HealthCheck;
    /** The port number the container listens on. */
    readonly containerPort: number;
}
/**
 * Configuration for ECS service auto-scaling.
 */
export interface AutoScalingProps {
    /** Minimum number of tasks to run. */
    readonly minCapacity: number;
    /** Maximum number of tasks to run. */
    readonly maxCapacity: number;
    /** Scale task based on CPU utilization. */
    readonly cpuScale?: ecs.CpuUtilizationScalingProps;
    /** Scale task based on memory utilization. */
    readonly memoryScale?: ecs.MemoryUtilizationScalingProps;
}
/**
 * Properties for the EcsCodeDeploy construct.
 */
export interface EcsCodeDeployProps {
    /** VPC in which to deploy ECS and ALB resources. */
    readonly vpc: ec2.IVpc;
    /** Security group config */
    readonly securityGroups: ec2.ISecurityGroup[];
    /** Select which subnets the Service and ALB will placed on  */
    readonly subnets: ec2.SubnetSelection;
    /** ECS Cluster where the service will run. */
    readonly cluster: ecs.ICluster;
    /** Task role for the ECS task */
    readonly taskRole?: iam.IRole;
    /** Task execution role for the ECS task */
    readonly taskExecRole?: iam.IRole;
    /** Base name used for resources like log groups, roles, services, etc. */
    readonly serviceName: string;
    /** CPU units for the task (default: 1024). */
    readonly taskCPU?: number;
    readonly memoryLimit?: number;
    /** Configuration related to the task definition and container. */
    readonly containers: ContainerProps[];
    /** The ALB target port */
    readonly albTargetPort?: number;
    /** Whether the load balancer should be internet-facing (default: false). */
    readonly enablePublicLoadBalancer?: boolean;
    /** Optional ACM certificates for HTTPS termination. */
    readonly certificates: ICertificate[];
    /** Optional auto-scaling configuration. */
    readonly autoScaling?: AutoScalingProps;
}
