# Contributing Guidelines

:tada: **First off, thank you for considering contributing to our project!** :tada:

This is a community-driven project, so it's people like you that make it useful and
successful. These are some of the many ways to contribute:

* :bug: Submitting bug reports and feature requests
* :memo: Writing tutorials or examples
* :mag: Fixing typos and improving the documentation
* :bulb: Writing code for everyone to use
* :people_holding_hands: Community engagement and outreach

If you get stuck at any point you can create an
[issue](https://github.com/RedDotRocket/AgentUp/issues) on GitHub
or jump on [Discord](https://discord.com/invite/pPcjYzGvbS)

For more information on contributing to open source projects,
[GitHub's own guide](https://opensource.guide/how-to-contribute)
is a great starting point if you are new to version control. Also, checkout the
[Zen of Scientific Software Maintenance](https://jrleeman.github.io/ScientificSoftwareMaintenance/)
for some guiding principles on how to create high quality scientific software
contributions.

## Ground Rules

The goal is to maintain a diverse community that's pleasant for everyone.
**Please be considerate and respectful of others**. Everyone must abide by our
[Code of Conduct](https://github.com/RedDotRocket/AgentUp/blob/main/CODE_OF_CONDUCT.md)
and we encourage all to read it carefully.

## Developer Certificate Of Origin

By submitting a pull request or contribution to this project, I certify that:


(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.

## How to Agree to DCO

- Use `git commit -s` for automatic sign-off, OR  
- Comment "I agree to the DCO" in your pull request, OR
- Simply submitting a pull request constitutes agreement to the above DCO terms
