"""add status automation field

Revision ID: 29fe01a6c9eb
Revises: e3f6db74cc1e
Create Date: 2022-04-04 18:49:55.263997

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "29fe01a6c9eb"
down_revision = "e3f6db74cc1e"
branch_labels = None
depends_on = None

CHANGE_TYPES = [("status", "Status"), ("ready_for", "Ready for")]


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "status_automation",
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("entity_type", sa.String(length=40), nullable=True),
        sa.Column(
            "in_task_type_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
        sa.Column(
            "in_task_status_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
        sa.Column(
            "out_field_type",
            sqlalchemy_utils.types.choice.ChoiceType(CHANGE_TYPES),
            nullable=True,
        ),
        sa.Column(
            "out_task_type_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
        sa.Column(
            "out_task_status_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["in_task_status_id"],
            ["task_status.id"],
        ),
        sa.ForeignKeyConstraint(
            ["in_task_type_id"],
            ["task_type.id"],
        ),
        sa.ForeignKeyConstraint(
            ["out_task_status_id"],
            ["task_status.id"],
        ),
        sa.ForeignKeyConstraint(
            ["out_task_type_id"],
            ["task_type.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_status_automation_in_task_status_id"),
        "status_automation",
        ["in_task_status_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_status_automation_in_task_type_id"),
        "status_automation",
        ["in_task_type_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_status_automation_out_task_status_id"),
        "status_automation",
        ["out_task_status_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_status_automation_out_task_type_id"),
        "status_automation",
        ["out_task_type_id"],
        unique=False,
    )
    op.create_table(
        "project_status_automation_link",
        sa.Column(
            "project_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "status_automation_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.id"],
        ),
        sa.ForeignKeyConstraint(
            ["status_automation_id"],
            ["status_automation.id"],
        ),
        sa.PrimaryKeyConstraint("project_id", "status_automation_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("project_status_automation_link")
    op.drop_index(
        op.f("ix_status_automation_out_task_type_id"),
        table_name="status_automation",
    )
    op.drop_index(
        op.f("ix_status_automation_out_task_status_id"),
        table_name="status_automation",
    )
    op.drop_index(
        op.f("ix_status_automation_in_task_type_id"),
        table_name="status_automation",
    )
    op.drop_index(
        op.f("ix_status_automation_in_task_status_id"),
        table_name="status_automation",
    )
    op.drop_table("status_automation")
    # ### end Alembic commands ###
