"""Add TaskStatus.is_wip

Revision ID: 4d585b6956f2
Revises: d80f02824047
Create Date: 2025-06-30 01:11:29.146591

"""

from alembic import op
import sqlalchemy as sa
from alembic import op
import sqlalchemy as sa
from sqlalchemy.orm.session import Session
from sqlalchemy.ext.declarative import declarative_base
from zou.migrations.utils.base import BaseMixin
from sqlalchemy.sql import expression


# revision identifiers, used by Alembic.
revision = "4d585b6956f2"
down_revision = "d80f02824047"
branch_labels = None
depends_on = None

base = declarative_base()


class TaskStatus(base, BaseMixin):
    """
    Describe the state of a task. A status marked as reviewable expects a
    preview file linked to relate comment.
    """

    __tablename__ = "task_status"
    name = sa.Column(sa.String(40), nullable=False)
    archived = sa.Column(sa.Boolean(), default=False)
    short_name = sa.Column(
        sa.String(10), unique=True, nullable=False, index=True
    )
    description = sa.Column(sa.Text())
    color = sa.Column(sa.String(7), nullable=False)
    priority = sa.Column(sa.Integer, default=1)

    is_done = sa.Column(sa.Boolean(), default=False, index=True)
    is_artist_allowed = sa.Column(sa.Boolean(), default=True)
    is_client_allowed = sa.Column(sa.Boolean(), default=True)
    is_retake = sa.Column(sa.Boolean(), default=False)
    is_feedback_request = sa.Column(sa.Boolean(), default=False, index=True)
    is_default = sa.Column(sa.Boolean(), default=False, index=True)
    is_wip = sa.Column(
        sa.Boolean(),
        server_default=expression.false(),
        default=False,
        index=True,
    )
    shotgun_id = sa.Column(sa.Integer)

    for_concept = sa.Column(
        sa.Boolean(), server_default=expression.false(), default=False
    )


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("task_status", schema=None) as batch_op:
        batch_op.add_column(sa.Column("is_wip", sa.Boolean(), nullable=True))
        batch_op.create_index(
            batch_op.f("ix_task_status_is_wip"), ["is_wip"], unique=False
        )
    session = Session(bind=op.get_bind())
    session.query(TaskStatus).update(
        {
            TaskStatus.is_wip: TaskStatus.short_name == "wip",
        }
    )
    session.commit()

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("task_status", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_task_status_is_wip"))
        batch_op.drop_column("is_wip")

    # ### end Alembic commands ###
