########################################################################
#
# Copyright (C) 2024
# Associated Universities, Inc. Washington DC, USA.
#
# This script is free software; you can redistribute it and/or modify it
# under the terms of the GNU Library General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.
#
# This library is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
# License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with this library; if not, write to the Free Software Foundation,
# Inc., 675 Massachusetts Ave, Cambridge, MA 02139, USA.
#
# Correspondence concerning AIPS++ should be adressed as follows:
#        Internet email: casa-feedback@nrao.edu.
#        Postal address: AIPS++ Project Office
#                        National Radio Astronomy Observatory
#                        520 Edgemont Road
#                        Charlottesville, VA 22903-2475 USA
#
########################################################################
##################### generated by xml-casa (v2) from createregion.xml
##################### e874c3dc805a7c790b9067fcbe4b97ef ##############################
from __future__ import absolute_import
import numpy
from casatools.typecheck import CasaValidator as _val_ctor
_pc = _val_ctor( )
from casatools.coercetype import coerce as _coerce
from casatools.errors import create_error_string
from casatasks.private.task_logging import start_log as _start_log
from casatasks.private.task_logging import end_log as _end_log
from casatasks.private.task_logging import except_log as _except_log
from cubevis.private.apps import CreateRegion

def _createregion_t( *args, **kwargs ):
    cm = CreateRegion( *args, **kwargs )
    return cm( )

class _createregion:
    """
    createregion ---- Create astropy regions interactively with a GUI

    Create one or more regions for CASA images using a GUI.
    Regions can be drawn on the image and upon completion a list of
    regions is returned to python.


    --------- parameter descriptions ---------------------------------------------

    image

    --------- examples -----------------------------------------------------------




    """

    _info_group_ = """imaging"""
    _info_desc_ = """Create astropy regions interactively with a GUI"""

    def __call__( self, image=[ ] ):
        schema = { 'image': {'anyof': [{'type': 'cReqPath', 'coerce': _coerce.expand_path}, {'type': 'cReqPathVec', 'coerce': [_coerce.to_list,_coerce.expand_pathvec]}]},  }
        doc = { 'image': image,  }
        assert _pc.validate(doc,schema), create_error_string(_pc.errors)
        _logging_state_ = _start_log( 'createregion', [ 'image=' + repr(_pc.document['image']),  ] )
        task_result = None
        try:
            task_result = _createregion_t( image=_pc.document['image'],  )
        except Exception as exc:
            _except_log('createregion', exc)
            raise
        finally:
            task_result = _end_log( _logging_state_, 'createregion', task_result )
        return task_result

createregion = _createregion( )
