# generated by datamodel-codegen:
#   filename:  cell-counting.schema.json
#   timestamp: 2024-06-04T03:30:31+00:00

from __future__ import annotations

from dataclasses import dataclass

from allotropy.allotrope.models.shared.definitions.custom import (
    TQuantityValueCell,
    TQuantityValueMicroliter,
    TQuantityValueMicrometer,
    TQuantityValueMillionCellsPerMilliliter,
    TQuantityValueMilliSecond,
    TQuantityValueNanometer,
    TQuantityValuePercent,
    TQuantityValueTODO,
    TQuantityValueUnitless,
)
from allotropy.allotrope.models.shared.definitions.definitions import (
    TDatacubeData,
    TDatacubeStructure,
    TDateTimeValue,
    TStringValue,
)


@dataclass(kw_only=True)
class DeviceSystemDocument:
    device_identifier: TStringValue | None = None
    model_number: TStringValue | None = None
    device_serial_number: TStringValue | None = None


@dataclass(kw_only=True)
class DataSystemDocument:
    data_system_instance_identifier: TStringValue | None = None
    file_name: TStringValue | None = None
    UNC_path: TStringValue | None = None
    software_name: TStringValue | None = None
    software_version: TStringValue | None = None
    ASM_converter_name: TStringValue | None = None
    ASM_converter_version: TStringValue | None = None


@dataclass(kw_only=True)
class SampleDocument:
    sample_identifier: TStringValue | None = None
    batch_identifier: TStringValue | None = None
    sample_role_type: TStringValue | None = None
    location_identifier: TStringValue | None = None


@dataclass(kw_only=True)
class DeviceControlDocumentItem:
    device_type: TStringValue
    sample_volume_setting: TQuantityValueMicroliter | None = None
    detection_type: TStringValue | None = None
    excitation_wavelength_setting: TQuantityValueNanometer | None = None
    emission_wavelength_setting: TQuantityValueNanometer | None = None
    illumination_setting: TQuantityValuePercent | None = None
    exposure_duration_setting: TQuantityValueMilliSecond | None = None
    detector_gain_setting: TStringValue | None = None
    fluorescence_tag_setting: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class DeviceControlAggregateDocument:
    device_control_document: list[DeviceControlDocumentItem]


@dataclass(kw_only=True)
class DataProcessingDocument:
    cell_type_processing_method: TStringValue | None = None
    minimum_cell_diameter: TQuantityValueMicrometer | None = None
    maximum_cell_diameter: TQuantityValueMicrometer | None = None
    cell_density_dilution_factor: TQuantityValueUnitless | None = None


@dataclass(kw_only=True)
class ImageDocumentItem:
    experimental_data_identifier: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class ImageAggregateDocument:
    image_document: list[ImageDocumentItem] | None = None


@dataclass(kw_only=True)
class TotalCellDiameterDistributionDataCube:
    label: str | None = None
    cube_structure: TDatacubeStructure | None = None
    data: TDatacubeData | None = None


@dataclass(kw_only=True)
class ProcessedDataDocument:
    data_processing_document: DataProcessingDocument
    viability__cell_counter_: TQuantityValuePercent
    viable_cell_density__cell_counter_: TQuantityValueMillionCellsPerMilliliter
    total_cell_count: TQuantityValueCell
    total_cell_density__cell_counter_: TQuantityValueMillionCellsPerMilliliter | None = (
        None
    )
    dead_cell_density__cell_counter_: TQuantityValueMillionCellsPerMilliliter | None = (
        None
    )
    average_total_cell_diameter: TQuantityValueMicrometer | None = None
    average_live_cell_diameter__cell_counter_: TQuantityValueMicrometer | None = None
    average_dead_cell_diameter__cell_counter_: TQuantityValueMicrometer | None = None
    total_cell_diameter_distribution_data_cube: TotalCellDiameterDistributionDataCube | None = (
        None
    )
    viable_cell_count: TQuantityValueCell | None = None
    dead_cell_count: TQuantityValueCell | None = None
    average_total_cell_circularity: TQuantityValueUnitless | None = None
    average_viable_cell_circularity: TQuantityValueUnitless | None = None
    fluorescence_tag_positive_cell_count: TQuantityValueTODO | None = None
    fluorescence_tag_positive_cell_density: TQuantityValueTODO | None = None
    fluorescence_tag_positive_cell_percentage: TQuantityValueTODO | None = None


@dataclass(kw_only=True)
class MeasurementDocumentItem:
    measurement_identifier: TStringValue
    measurement_time: TDateTimeValue
    sample_document: SampleDocument
    device_control_aggregate_document: DeviceControlAggregateDocument
    processed_data_document: ProcessedDataDocument
    image_aggregate_document: ImageAggregateDocument | None = None


@dataclass(kw_only=True)
class MeasurementAggregateDocument:
    measurement_document: list[MeasurementDocumentItem]


@dataclass(kw_only=True)
class CellCountingDocumentItem:
    analyst: TStringValue
    measurement_aggregate_document: MeasurementAggregateDocument
    submitter: TStringValue | None = None


@dataclass(kw_only=True)
class CellCountingAggregateDocument:
    device_system_document: DeviceSystemDocument
    cell_counting_document: list[CellCountingDocumentItem]
    data_system_document: DataSystemDocument | None = None


@dataclass(kw_only=True)
class Model:
    cell_counting_aggregate_document: CellCountingAggregateDocument
    manifest: str = "http://purl.allotrope.org/manifests/cell-counting/BENCHLING/2023/09/cell-counting.manifest"
