# generated by datamodel-codegen:
#   filename:  electrophoresis.schema.json
#   timestamp: 2024-08-13T06:10:50+00:00

from __future__ import annotations

from dataclasses import dataclass
from typing import Any

from allotropy.allotrope.models.shared.definitions.custom import (
    TQuantityValueDegreeCelsius,
    TQuantityValueKiloDalton,
    TQuantityValueMilliAbsorbanceUnit,
    TQuantityValueNanometer,
    TQuantityValueNumber,
    TQuantityValuePercent,
    TQuantityValueRelativeFluorescenceUnit,
    TQuantityValueSecondTime,
    TQuantityValueUnitless,
)
from allotropy.allotrope.models.shared.definitions.definitions import (
    TClass,
    TDatacube,
    TDateTimeStampValue,
    TIntegerValue,
    TStatisticDatumRole,
    TStringValue,
    TUnit,
)


@dataclass(kw_only=True)
class DiagnosticTraceDocumentItem:
    description: Any


@dataclass(kw_only=True)
class DiagnosticTraceAggregateDocument:
    diagnostic_trace_document: list[DiagnosticTraceDocumentItem] | None = None


@dataclass(kw_only=True)
class AdmCoreREC202403ManifestSchema:
    vocabulary: list[str]
    json_schemas: list[str]
    field_id: str | None = None
    field_type: str | None = None
    shapes: list[str] | None = None


@dataclass(kw_only=True)
class ErrorDocumentItem:
    error: TStringValue
    error_feature: TStringValue | None = None


@dataclass(kw_only=True)
class ErrorAggregateDocument:
    error_document: list[ErrorDocumentItem] | None = None


@dataclass(kw_only=True)
class ImageDocumentItem:
    index: TIntegerValue | None = None
    experimental_data_identifier: TStringValue | None = None


@dataclass(kw_only=True)
class ImageAggregateDocument:
    image_document: list[ImageDocumentItem] | None = None


@dataclass(kw_only=True)
class StatisticsDocumentItem:
    statistical_feature: TClass


@dataclass(kw_only=True)
class StatisticsAggregateDocument:
    statistics_document: list[StatisticsDocumentItem] | None = None


@dataclass(kw_only=True)
class TQuantityValueModel:
    value: float
    unit: TUnit
    has_statistic_datum_role: TStatisticDatumRole | None = None
    field_type: TClass | None = None


@dataclass(kw_only=True)
class DeviceDocumentItem:
    device_type: TStringValue
    device_identifier: TStringValue | None = None
    model_number: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    brand_name: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class DeviceSystemDocument:
    asset_management_identifier: TStringValue | None = None
    description: Any | None = None
    brand_name: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    device_identifier: TStringValue | None = None
    model_number: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    device_document: list[DeviceDocumentItem] | None = None


@dataclass(kw_only=True)
class DataSystemDocument:
    data_system_instance_identifier: TStringValue | None = None
    file_name: TStringValue | None = None
    UNC_path: TStringValue | None = None
    software_name: TStringValue | None = None
    software_version: TStringValue | None = None
    ASM_converter_name: TStringValue | None = None
    ASM_converter_version: TStringValue | None = None


@dataclass(kw_only=True)
class DeviceControlDocumentItem:
    device_type: TStringValue
    device_identifier: TStringValue | None = None
    detection_type: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    brand_name: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    model_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    field_index: int | None = None
    detector_wavelength_setting: TQuantityValueNanometer | None = None
    detector_bandwidth_setting: TQuantityValueNanometer | None = None
    excitation_wavelength_setting: TQuantityValueNanometer | None = None
    excitation_bandwidth_setting: TQuantityValueNanometer | None = None


@dataclass(kw_only=True)
class DeviceControlAggregateDocument:
    device_control_document: list[DeviceControlDocumentItem]


@dataclass(kw_only=True)
class SampleDocument:
    sample_identifier: TStringValue
    description: Any | None = None
    batch_identifier: TStringValue | None = None
    sample_role_type: TClass | None = None
    written_name: TStringValue | None = None
    location_identifier: TStringValue | None = None


@dataclass(kw_only=True)
class PeakItem:
    peak_identifier: TStringValue
    peak_name: TStringValue | None = None
    written_name: TStringValue | None = None
    peak_height: TQuantityValueMilliAbsorbanceUnit | TQuantityValueRelativeFluorescenceUnit | None = (
        None
    )
    relative_peak_height: TQuantityValueKiloDalton | TQuantityValueNumber | TQuantityValueSecondTime | None = (
        None
    )
    peak_start: TQuantityValueKiloDalton | TQuantityValueNumber | TQuantityValueSecondTime | None = (
        None
    )
    peak_end: TQuantityValueKiloDalton | TQuantityValueNumber | TQuantityValueSecondTime | None = (
        None
    )
    peak_position: TQuantityValueKiloDalton | TQuantityValueNumber | TQuantityValueSecondTime | None = (
        None
    )
    peak_area: TQuantityValueUnitless | None = None
    relative_peak_area: TQuantityValuePercent | None = None
    relative_corrected_peak_area: TQuantityValuePercent | None = None
    comment: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class PeakList:
    peak: list[PeakItem]


@dataclass(kw_only=True)
class DataRegionDocumentItem:
    region_identifier: TStringValue
    region_name: TStringValue | None = None
    written_name: TStringValue | None = None
    region_start: TQuantityValueKiloDalton | TQuantityValueNumber | TQuantityValueSecondTime | None = (
        None
    )
    region_end: TQuantityValueKiloDalton | TQuantityValueNumber | TQuantityValueSecondTime | None = (
        None
    )
    region_area: TQuantityValueUnitless | None = None
    relative_region_area: TQuantityValuePercent | None = None
    comment: TStringValue | None = None


@dataclass(kw_only=True)
class DataRegionAggregateDocument:
    data_region_document: list[DataRegionDocumentItem]


@dataclass(kw_only=True)
class DataSourceDocumentItem:
    data_source_identifier: TStringValue
    data_source_feature: TStringValue
    field_index: int | None = None


@dataclass(kw_only=True)
class DataSourceAggregateDocument:
    data_source_document: list[DataSourceDocumentItem]


@dataclass(kw_only=True)
class ProcessedDataAggregateDocument:
    processed_data_document: list[ProcessedDataDocumentItem]


@dataclass(kw_only=True)
class CalculatedDataDocumentItem:
    calculated_data_name: TStringValue
    calculated_result: TQuantityValueModel
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    calculated_data_identifier: TStringValue | None = None
    calculation_description: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class CalculatedDataAggregateDocument:
    calculated_data_document: list[CalculatedDataDocumentItem]


@dataclass(kw_only=True)
class ProcessedDataDocumentItem:
    peak_list: PeakList | None = None
    data_processing_document: dict[str, Any] | None = None
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    processed_data_identifier: TStringValue | None = None
    field_index: int | None = None
    derived_electropherogram_data_cube: TDatacube | None = None
    data_region_aggregate_document: DataRegionAggregateDocument | None = None


@dataclass(kw_only=True)
class MeasurementDocumentItem:
    measurement_time: TDateTimeStampValue
    measurement_identifier: TStringValue
    device_control_aggregate_document: DeviceControlAggregateDocument
    sample_document: SampleDocument
    processed_data_aggregate_document: ProcessedDataAggregateDocument
    detection_type: TStringValue | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    image_aggregate_document: ImageAggregateDocument | None = None
    error_aggregate_document: ErrorAggregateDocument | None = None
    compartment_temperature: TQuantityValueDegreeCelsius | None = None
    electropherogram_data_cube: TDatacube | None = None


@dataclass(kw_only=True)
class MeasurementAggregateDocument:
    measurement_document: list[MeasurementDocumentItem]
    diagnostic_trace_aggregate_document: DiagnosticTraceAggregateDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    image_aggregate_document: ImageAggregateDocument | None = None
    error_aggregate_document: ErrorAggregateDocument | None = None


@dataclass(kw_only=True)
class ElectrophoresisDocumentItem:
    measurement_aggregate_document: MeasurementAggregateDocument
    analyst: TStringValue | None = None
    submitter: TStringValue | None = None
    analytical_method_identifier: TStringValue | None = None
    method_version: TStringValue | None = None
    experimental_data_identifier: TStringValue | None = None
    experiment_type: TStringValue | None = None


@dataclass(kw_only=True)
class ElectrophoresisAggregateDocument:
    data_system_document: DataSystemDocument
    electrophoresis_document: list[ElectrophoresisDocumentItem]
    device_system_document: DeviceSystemDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None


@dataclass(kw_only=True)
class Model:
    electrophoresis_aggregate_document: ElectrophoresisAggregateDocument
    field_asm_manifest: AdmCoreREC202403ManifestSchema | str
