# generated by datamodel-codegen:
#   filename:  flow-cytometry.schema.json
#   timestamp: 2025-04-18T18:03:31+00:00

from __future__ import annotations

from dataclasses import dataclass
from typing import Any

from allotropy.allotrope.models.shared.definitions.custom import (
    TQuantityValueCounts,
    TQuantityValueDegreeCelsius,
    TQuantityValueRelativeFluorescenceUnit,
    TQuantityValueSecondTime,
    TQuantityValueUnitless,
)
from allotropy.allotrope.models.shared.definitions.definitions import (
    TBooleanValue,
    TClass,
    TDateTimeStampValue,
    TDateTimeValue,
    TDoubleValue,
    TIntegerValue,
    TQuantityValue,
    TStringValue,
)


@dataclass(kw_only=True)
class CustomInformationDocumentItem:
    scalar_double_datum: TDoubleValue | None = None
    unit: TStringValue | None = None
    scalar_string_datum: TStringValue | None = None
    scalar_timestamp_datum: TDateTimeValue | None = None
    scalar_boolean_datum: TBooleanValue | None = None
    datum_label: TStringValue | None = None


@dataclass(kw_only=True)
class ElectronicProjectRecord:
    written_name: TStringValue
    description: Any | None = None
    start_time: TDateTimeValue | None = None


@dataclass(kw_only=True)
class ErrorDocumentItem:
    error: TStringValue
    error_feature: TStringValue | None = None


@dataclass(kw_only=True)
class ErrorAggregateDocument:
    error_document: list[ErrorDocumentItem] | None = None


@dataclass(kw_only=True)
class ImageDocumentItem:
    experimental_data_identifier: TStringValue | None = None
    index: TIntegerValue | None = None


@dataclass(kw_only=True)
class ImageAggregateDocument:
    image_document: list[ImageDocumentItem] | None = None


@dataclass(kw_only=True)
class StatisticsAggregateDocument:
    statistics_document: list[StatisticsDocumentItem] | None = None


@dataclass(kw_only=True)
class DataProcessingDocument:
    data_processing_time: TDateTimeStampValue | None = None
    method_version: TStringValue | None = None


@dataclass(kw_only=True)
class VertexDocumentItem:
    vertex_role: TStringValue | None = None
    x_coordinate: TQuantityValueRelativeFluorescenceUnit | TQuantityValueSecondTime | None = (
        None
    )
    y_coordinate: TQuantityValueRelativeFluorescenceUnit | TQuantityValueSecondTime | None = (
        None
    )


@dataclass(kw_only=True)
class VertexAggregateDocument:
    vertex_document: list[VertexDocumentItem] | None = None


@dataclass(kw_only=True)
class DataRegionDocumentItem:
    data_region_identifier: TStringValue | None = None
    parent_data_region_identifier: TStringValue | None = None
    region_type: TStringValue | None = None
    vertex_aggregate_document: VertexAggregateDocument | None = None
    x_coordinate_dimension_identifier: TStringValue | None = None
    y_coordinate_dimension_identifier: TStringValue | None = None


@dataclass(kw_only=True)
class DataRegionAggregateDocument:
    data_region_document: list[DataRegionDocumentItem] | None = None


@dataclass(kw_only=True)
class StatisticDimensionDocumentItem:
    dimension_identifier: TStringValue | None = None
    statistical_value: TQuantityValue | None = None


@dataclass(kw_only=True)
class StatisticDimensionAggregateDocument:
    statistic_dimension_document: list[StatisticDimensionDocumentItem] | None = None


@dataclass(kw_only=True)
class StatisticsDocumentItem:
    statistical_feature: TClass
    statistic_dimension_aggregate_document: StatisticDimensionAggregateDocument | None = (
        None
    )


@dataclass(kw_only=True)
class PopulationDocumentItem:
    count: TQuantityValueCounts | None = None
    data_region_identifier: TStringValue | None = None
    parent_population_identifier: TStringValue | None = None
    population_aggregate_document: list[PopulationAggregateDocumentItem] | None = None
    population_identifier: TStringValue | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    written_name: TStringValue | None = None


@dataclass(kw_only=True)
class PopulationAggregateDocumentItem:
    population_document: list[PopulationDocumentItem] | None = None


@dataclass(kw_only=True)
class MatrixDocumentItem:
    compensation_value: TQuantityValueUnitless | None = None
    dimension_identifier: TStringValue | None = None


@dataclass(kw_only=True)
class MatrixAggregateDocument:
    matrix_document: list[MatrixDocumentItem] | None = None


@dataclass(kw_only=True)
class CompensationMatrixDocumentItem:
    dimension_identifier: TStringValue | None = None
    matrix_aggregate_document: MatrixAggregateDocument | None = None


@dataclass(kw_only=True)
class CompensationMatrixAggregateDocument:
    compensation_matrix_document: list[CompensationMatrixDocumentItem] | None = None


@dataclass(kw_only=True)
class CustomInformationAggregateDocument:
    custom_information_document: list[CustomInformationDocumentItem]


@dataclass(kw_only=True)
class DataSourceDocumentItem:
    data_source_identifier: TStringValue
    data_source_feature: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class DataSourceAggregateDocument:
    data_source_document: list[DataSourceDocumentItem]


@dataclass(kw_only=True)
class ElectronicSignatureDocumentItem:
    account_identifier: TStringValue
    personal_name: TStringValue
    signature_role_type: TStringValue
    time: TStringValue
    identifier: TStringValue | None = None
    measurement_identifier: TStringValue | None = None
    method_identifier: TStringValue | None = None
    processed_data_identifier: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class ElectronicSignatureAggregateDocument:
    electronic_signature_document: list[ElectronicSignatureDocumentItem] | None = None


@dataclass(kw_only=True)
class ProcessedDataAggregateDocument:
    processed_data_document: list[ProcessedDataDocumentItem]
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    electronic_project_record: ElectronicProjectRecord | None = None


@dataclass(kw_only=True)
class AnalysisSequenceDocument:
    written_name: TStringValue
    UNC_path: TStringValue | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    end_time: TDateTimeValue | None = None
    file_name: TStringValue | None = None
    identifier: TStringValue | None = None
    method_identifier: TStringValue | None = None
    method_name: TStringValue | None = None
    start_time: TDateTimeValue | None = None
    version_number: TStringValue | None = None


@dataclass(kw_only=True)
class DataSystemDocument:
    ASM_file_identifier: TStringValue
    data_system_instance_identifier: TStringValue
    UNC_path: TStringValue | None = None
    file_name: TStringValue | None = None
    ASM_converter_name: TStringValue | None = None
    ASM_converter_version: TStringValue | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    database_primary_key: TStringValue | None = None
    software_name: TStringValue | None = None
    software_version: TStringValue | None = None


@dataclass(kw_only=True)
class DeviceDocumentItem:
    device_type: TStringValue
    brand_name: TStringValue | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    device_identifier: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    model_number: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    written_name: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class DeviceSystemDocument:
    asset_management_identifier: TStringValue | None = None
    brand_name: TStringValue | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    description: Any | None = None
    device_document: list[DeviceDocumentItem] | None = None
    device_identifier: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    model_number: TStringValue | None = None
    product_manufacturer: TStringValue | None = None


@dataclass(kw_only=True)
class DiagnosticTraceDocumentItem:
    description: Any
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )


@dataclass(kw_only=True)
class DiagnosticTraceAggregateDocument:
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    diagnostic_trace_document: list[DiagnosticTraceDocumentItem] | None = None


@dataclass(kw_only=True)
class DeviceControlDocumentItem:
    device_type: TStringValue
    brand_name: TStringValue | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    detection_type: TStringValue | None = None
    device_identifier: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    model_number: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class DeviceControlAggregateDocument:
    device_control_document: list[DeviceControlDocumentItem]
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )


@dataclass(kw_only=True)
class ProcessedDataDocumentItem:
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    data_processing_document: DataProcessingDocument | None = None
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    electronic_project_record: ElectronicProjectRecord | None = None
    processed_data_identifier: TStringValue | None = None
    field_index: int | None = None
    data_region_aggregate_document: DataRegionAggregateDocument | None = None
    population_aggregate_document: list[PopulationAggregateDocumentItem] | None = None


@dataclass(kw_only=True)
class SampleDocument:
    sample_identifier: TStringValue
    batch_identifier: TStringValue | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    description: Any | None = None
    location_identifier: TStringValue | None = None
    sample_role_type: TClass | None = None
    written_name: TStringValue | None = None
    well_plate_identifier: TStringValue | None = None


@dataclass(kw_only=True)
class CalculatedDataDocumentItem:
    calculated_data_name: TStringValue
    calculated_result: TQuantityValue
    calculated_data_identifier: TStringValue | None = None
    calculation_description: TStringValue | None = None
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    electronic_project_record: ElectronicProjectRecord | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class CalculatedDataAggregateDocument:
    calculated_data_document: list[CalculatedDataDocumentItem]


@dataclass(kw_only=True)
class MeasurementDocumentItem:
    device_control_aggregate_document: DeviceControlAggregateDocument
    measurement_identifier: TStringValue
    sample_document: SampleDocument
    analytical_method_identifier: TStringValue | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    detection_type: TStringValue | None = None
    electronic_project_record: ElectronicProjectRecord | None = None
    error_aggregate_document: ErrorAggregateDocument | None = None
    experimental_data_identifier: TStringValue | None = None
    image_aggregate_document: ImageAggregateDocument | None = None
    measurement_time: TDateTimeStampValue | None = None
    method_version: TStringValue | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None


@dataclass(kw_only=True)
class MeasurementAggregateDocument:
    measurement_document: list[MeasurementDocumentItem]
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    diagnostic_trace_aggregate_document: DiagnosticTraceAggregateDocument | None = None
    error_aggregate_document: ErrorAggregateDocument | None = None
    image_aggregate_document: ImageAggregateDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    analyst: TStringValue | None = None
    analytical_method_identifier: TStringValue | None = None
    compartment_temperature: TQuantityValueDegreeCelsius | None = None
    experiment_type: TStringValue | None = None
    experimental_data_identifier: TStringValue | None = None
    measurement_time: TDateTimeStampValue | None = None


@dataclass(kw_only=True)
class FlowCytometryDocumentItem:
    measurement_aggregate_document: MeasurementAggregateDocument
    analyst: TStringValue | None = None
    electronic_project_record: ElectronicProjectRecord | None = None
    submitter: TStringValue | None = None
    compensation_matrix_aggregate_document: CompensationMatrixAggregateDocument | None = (
        None
    )


@dataclass(kw_only=True)
class FlowCytometryAggregateDocument:
    flow_cytometry_document: list[FlowCytometryDocumentItem]
    analysis_sequence_document: AnalysisSequenceDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    data_system_document: DataSystemDocument | None = None
    device_system_document: DeviceSystemDocument | None = None
    electronic_project_record: ElectronicProjectRecord | None = None
    electronic_signature_aggregate_document: ElectronicSignatureAggregateDocument | None = (
        None
    )
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None


@dataclass(kw_only=True)
class Model:
    manifest: str = "http://purl.allotrope.org/manifests/flow-cytometry/CR/2025/03/flow-cytometry.manifest"
    flow_cytometry_aggregate_document: FlowCytometryAggregateDocument | None = None
