# generated by datamodel-codegen:
#   filename:  light-obscuration.schema.json
#   timestamp: 2024-06-04T03:30:35+00:00

from __future__ import annotations

from dataclasses import dataclass
from typing import Any

from allotropy.allotrope.models.shared.definitions.custom import (
    TQuantityValueCountsPerMilliliter,
    TQuantityValueMicrometer,
    TQuantityValueMilliliter,
    TQuantityValueUnitless,
)
from allotropy.allotrope.models.shared.definitions.definitions import (
    TBooleanValue,
    TDateTimeStampValue,
    TIntValue,
    TStringValue,
)


@dataclass(kw_only=True)
class DataSourceDocumentItem:
    data_source_identifier: TStringValue
    data_source_feature: TStringValue


@dataclass(kw_only=True)
class TDataSourceAggregateDocument:
    data_source_document: list[DataSourceDocumentItem]


@dataclass(kw_only=True)
class SampleDocument:
    sample_identifier: TStringValue


@dataclass(kw_only=True)
class Manifest:
    vocabulary: list[str]
    json_schemas: list[str]
    field_id: str | None = None
    field_type: str | None = None
    shapes: list[str] | None = None


@dataclass(kw_only=True)
class DataSystemDocument:
    data_system_instance_identifier: TStringValue | None = None
    file_name: TStringValue | None = None
    UNC_path: TStringValue | None = None
    software_name: TStringValue | None = None
    software_version: TStringValue | None = None
    ASM_converter_name: TStringValue | None = None
    ASM_converter_version: TStringValue | None = None


@dataclass(kw_only=True)
class DeviceDocumentItem:
    detector_identifier: TStringValue
    detector_model_number: TStringValue
    field_index: int | None = None


@dataclass(kw_only=True)
class DeviceSystemDocument:
    asset_management_identifier: TStringValue | None = None
    description: Any | None = None
    brand_name: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    device_identifier: TStringValue | None = None
    model_number: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    device_document: list[DeviceDocumentItem] | None = None


@dataclass(kw_only=True)
class DeviceControlDocumentItem:
    flush_volume_setting: TQuantityValueMilliliter
    detector_view_volume: TQuantityValueMilliliter
    repetition_setting: TIntValue
    sample_volume_setting: TQuantityValueMilliliter
    field_index: int | None = None


@dataclass(kw_only=True)
class DeviceControlAggregateDocument:
    device_control_document: list[DeviceControlDocumentItem] | None = None


@dataclass(kw_only=True)
class CalculatedDataDocumentItem:
    calculated_data_name: TStringValue
    calculated_result: TQuantityValueCountsPerMilliliter | TQuantityValueMicrometer | TQuantityValueUnitless
    data_source_aggregate_document: TDataSourceAggregateDocument | None = None
    calculated_data_identifier: TStringValue | None = None
    calculation_description: TStringValue | None = None


@dataclass(kw_only=True)
class TCalculatedDataAggregateDocument:
    calculated_data_document: list[CalculatedDataDocumentItem]


@dataclass(kw_only=True)
class DataProcessingDocument:
    dilution_factor_setting: TQuantityValueUnitless | None = None
    data_processing_omission_setting: TBooleanValue | None = None


@dataclass(kw_only=True)
class DistributionItem:
    particle_size: TQuantityValueMicrometer
    cumulative_count: TQuantityValueUnitless
    cumulative_particle_density: TQuantityValueCountsPerMilliliter
    distribution_identifier: TStringValue | None = None
    differential_particle_density: TQuantityValueCountsPerMilliliter | None = None
    differential_count: TQuantityValueUnitless | None = None


@dataclass(kw_only=True)
class DistributionDocumentItem:
    distribution: list[DistributionItem]
    field_index: int | None = None


@dataclass(kw_only=True)
class DistributionAggregateDocument:
    distribution_document: list[DistributionDocumentItem]


@dataclass(kw_only=True)
class ProcessedDataDocumentItem:
    data_processing_document: DataProcessingDocument | None = None
    distribution_aggregate_document: DistributionAggregateDocument | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class ProcessedDataAggregateDocument:
    processed_data_document: list[ProcessedDataDocumentItem]


@dataclass(kw_only=True)
class MeasurementDocumentItem:
    measurement_identifier: TStringValue
    measurement_time: TDateTimeStampValue
    device_control_aggregate_document: DeviceControlAggregateDocument | None = None
    sample_document: SampleDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None


@dataclass(kw_only=True)
class MeasurementAggregateDocument:
    analyst: TStringValue
    submitter: TStringValue | None = None
    measurement_document: list[MeasurementDocumentItem] | None = None


@dataclass(kw_only=True)
class LightObscurationDocumentItem:
    measurement_aggregate_document: MeasurementAggregateDocument


@dataclass(kw_only=True)
class LightObscurationAggregateDocument:
    light_obscuration_document: list[LightObscurationDocumentItem]
    data_system_document: DataSystemDocument | None = None
    device_system_document: DeviceSystemDocument | None = None
    calculated_data_aggregate_document: TCalculatedDataAggregateDocument | None = None


@dataclass(kw_only=True)
class Model:
    field_asm_manifest: Manifest | str
    light_obscuration_aggregate_document: LightObscurationAggregateDocument | None = (
        None
    )
