# generated by datamodel-codegen:
#   filename:  plate-reader.schema.json
#   timestamp: 2024-12-10T17:30:27+00:00

from __future__ import annotations

from dataclasses import dataclass
from enum import Enum
from typing import Any

from allotropy.allotrope.models.shared.definitions.custom import (
    TQuantityValueDegreeCelsius,
    TQuantityValueMicroliter,
    TQuantityValueMilliAbsorbanceUnit,
    TQuantityValueMillimeter,
    TQuantityValueMilliSecond,
    TQuantityValueNanometer,
    TQuantityValueNumber,
    TQuantityValuePercent,
    TQuantityValuePicogramPerMilliliter,
    TQuantityValueRelativeFluorescenceUnit,
    TQuantityValueRelativeLightUnit,
    TQuantityValueSecondTime,
    TQuantityValueUnitless,
)
from allotropy.allotrope.models.shared.definitions.definitions import (
    TBooleanValue,
    TClass,
    TDatacube,
    TDateTimeStampValue,
    TDateTimeValue,
    TDoubleValue,
    TQuantityValue,
    TStringValue,
    TUnit,
)


class ContainerType(Enum):
    reactor = "reactor"
    controlled_lab_reactor = "controlled lab reactor"
    tube = "tube"
    well_plate = "well plate"
    differential_scanning_calorimetry_pan = "differential scanning calorimetry pan"
    qPCR_reaction_block = "qPCR reaction block"
    vial_rack = "vial rack"
    pan = "pan"
    reservoir = "reservoir"
    array_card_block = "array card block"
    capillary = "capillary"
    disintegration_apparatus_basket = "disintegration apparatus basket"
    jar = "jar"
    container = "container"
    tray = "tray"
    basket = "basket"
    cell_holder = "cell holder"


@dataclass(kw_only=True)
class DiagnosticTraceDocumentItem:
    description: Any


@dataclass(kw_only=True)
class DiagnosticTraceAggregateDocument:
    diagnostic_trace_document: list[DiagnosticTraceDocumentItem] | None = None


@dataclass(kw_only=True)
class CustomInformationDocumentItem:
    scalar_double_datum: TDoubleValue | None = None
    unit: TUnit | None = None
    scalar_string_datum: TStringValue | None = None
    scalar_timestamp_datum: TDateTimeValue | None = None
    scalar_boolean_datum: TBooleanValue | None = None
    data_cube: TDatacube | None = None
    datum_label: TStringValue | None = None


@dataclass(kw_only=True)
class DataSourceDocumentItem:
    data_source_identifier: TStringValue
    data_source_feature: TStringValue
    field_index: int | None = None


@dataclass(kw_only=True)
class DataSourceAggregateDocument:
    data_source_document: list[DataSourceDocumentItem]


class StatisticalFeature(Enum):
    inner_diameter = "inner diameter"
    plate_heater_temperature = "plate heater temperature"
    linear_velocity = "linear velocity"
    enthalpy_of_fusion = "enthalpy of fusion"
    angular_velocity = "angular velocity"
    purity = "purity"
    intensity = "intensity"
    protein_attenuation_coefficient = "protein attenuation coefficient"
    electron_beam_working_distance = "electron beam working distance"
    temperature = "temperature"
    end_height = "end height"
    relative_humidity = "relative humidity"
    saturation_vapor_pressure = "saturation vapor pressure"
    heat_flow = "heat flow"
    quality_quantification_facet = "quality quantification facet"
    heat_transfer_coefficient = "heat transfer coefficient"
    molar_concentration = "molar concentration"
    average_total_cell_diameter = "average total cell diameter"
    pH = "pH"
    foam_height = "foam height"
    relative_weight_loss_on_drying = "relative weight loss on drying"
    dilution_volume = "dilution volume"
    flow_ratio = "flow ratio"
    electric_conductance = "electric conductance"
    sample_temperature = "sample temperature"
    container_diameter = "container diameter"
    absorbance = "absorbance"
    sample_thickness = "sample thickness"
    humidity = "humidity"
    Raman_intensity = "Raman intensity"
    voltage = "voltage"
    actual_P_P0_result = "actual P/P0 result"
    polyol_reservoir_temperature = "polyol reservoir temperature"
    turbidity = "turbidity"
    enthalpy_of_sublimation = "enthalpy of sublimation"
    osmolality = "osmolality"
    ambient_humidity = "ambient humidity"
    molar_enthalpy_of_vaporization = "molar enthalpy of vaporization"
    total_foam_height = "total foam height"
    strain = "strain"
    thermal_conductivity = "thermal conductivity"
    coating_gap_height = "coating gap height"
    measurement_chamber_free_space_volume = "measurement chamber free space volume"
    fracture_energy = "fracture energy"
    heat_capacity = "heat capacity"
    yield_strain = "yield strain"
    incident_radiation_angle = "incident radiation angle"
    mass_fraction = "mass fraction"
    liquid_height = "liquid height"
    chromatography_column_length = "chromatography column length"
    sample_width = "sample width"
    molar_enthalpy_of_sublimation = "molar enthalpy of sublimation"
    Raman_wavenumber_shift = "Raman wavenumber shift"
    relative_response = "relative response"
    length = "length"
    velocity = "velocity"
    electric_charge = "electric charge"
    molar_mass = "molar mass"
    image_height = "image height"
    concentration = "concentration"
    sample_weight_before_drying = "sample weight before drying"
    dilution_factor = "dilution factor"
    temperature_rate = "temperature rate"
    relative_permittivity = "relative permittivity"
    transition_enthalpy = "transition enthalpy"
    total_gas_flow_rate = "total gas flow rate"
    gloss = "gloss"
    water_mass_fraction = "water mass fraction"
    dielectric_polarization = "dielectric polarization"
    normalized_foam_height = "normalized foam height"
    peak_onset_temperature = "peak onset temperature"
    electric_current = "electric current"
    angle = "angle"
    energy__datum_ = "energy (datum)"
    abrasion_weight = "abrasion weight"
    absolute_water_content = "absolute water content"
    electric_resistance = "electric resistance"
    attenuation_coefficient = "attenuation coefficient"
    molar_enthalpy_of_fusion = "molar enthalpy of fusion"
    water_mass_concentration = "water mass concentration"
    partial_pressure = "partial pressure"
    volume = "volume"
    position_count = "position count"
    thermal_conductance = "thermal conductance"
    dry_sample_weight = "dry sample weight"
    adsorbed_volume_at_STP = "adsorbed volume at STP"
    force = "force"
    birefringence = "birefringence"
    monolayer_quantity = "monolayer quantity"
    peak_temperature = "peak temperature"
    dry_gas_flow_rate = "dry gas flow rate"
    gross_weight = "gross weight"
    sample_weight = "sample weight"
    image_width = "image width"
    m_z = "m/z"
    container_height = "container height"
    flow_rate = "flow rate"
    solvent_reservoir_temperature = "solvent reservoir temperature"
    isocyanate_reservoir_temperature = "isocyanate reservoir temperature"
    ambient_pressure = "ambient pressure"
    eccentricity = "eccentricity"
    mass = "mass"
    molar_absorptivity = "molar absorptivity"
    height = "height"
    column_inner_diameter = "column inner diameter"
    heat_seal_length = "heat seal length"
    specific_surface_area = "specific surface area"
    reference_material_weight = "reference material weight"
    thickness = "thickness"
    tare_weight = "tare weight"
    power = "power"
    chromatography_column_particle_size = "chromatography column particle size"
    saturated_gas_flow_rate = "saturated gas flow rate"
    well_volume = "well volume"
    degassed_sample_weight = "degassed sample weight"
    voltage_range = "voltage range"
    relative_intensity = "relative intensity"
    width = "width"
    yield_stress = "yield stress"
    total_cell_diameter = "total cell diameter"
    stress = "stress"
    relative_pressure__BET_ = "relative pressure (BET)"
    break_stress = "break stress"
    mass_concentration = "mass concentration"
    chromatography_column_film_thickness = "chromatography column film thickness"
    average_particle_size = "average particle size"
    wavelength = "wavelength"
    heat_capacity__dsc_ = "heat capacity (dsc)"
    acquisition_volume = "acquisition volume"
    collision_energy = "collision energy"
    background_corrected_turbidity = "background corrected turbidity"
    mass_change = "mass change"
    chemical_shift = "chemical shift"
    titer = "titer"
    refractive_index = "refractive index"
    enthalpy_of_vaporization = "enthalpy of vaporization"
    volume_fraction = "volume fraction"
    transmittance = "transmittance"
    electric_conductivity = "electric conductivity"
    fill_depth = "fill depth"
    Young_modulus = "Young modulus"
    total_material_height = "total material height"
    specific_rotation = "specific rotation"
    qNMR_purity_result = "qNMR purity result"
    size__datum_ = "size (datum)"
    break_strain = "break strain"
    specific_enthalpy_of_vaporization = "specific enthalpy of vaporization"
    absolute_intensity = "absolute intensity"
    BET_C_constant = "BET C constant"
    plate_well_count = "plate well count"
    plate_temperature = "plate temperature"
    volume_concentration = "volume concentration"
    specific_enthalpy_of_sublimation = "specific enthalpy of sublimation"
    enthalpy = "enthalpy"
    area = "area"
    peak_load_force = "peak load force"
    fluorescence = "fluorescence"
    start_height = "start height"
    polarity = "polarity"
    angle_of_optical_rotation = "angle of optical rotation"
    peak_analyte_amount = "peak analyte amount"
    extrapolated_moisture_content = "extrapolated moisture content"
    inlet_gas_pressure = "inlet gas pressure"
    hardness = "hardness"
    molecular_mass = "molecular mass"
    specific_enthalpy_of_fusion = "specific enthalpy of fusion"
    electric_impedance = "electric impedance"
    hold_up_volume = "hold-up volume"
    particle_size = "particle size"
    diameter = "diameter"
    tablet_thickness = "tablet thickness"
    pressure = "pressure"
    weight_loss = "weight loss"
    cell_path_length = "cell path length"
    glass_transition_temperature = "glass transition temperature"
    specific_heat_capacity = "specific heat capacity"
    wavenumber = "wavenumber"
    reservoir_temperature = "reservoir temperature"
    electric_resistivity = "electric resistivity"
    luminescence = "luminescence"
    compartment_temperature = "compartment temperature"
    viscosity = "viscosity"
    exhaust_gas_flow_rate = "exhaust gas flow rate"
    Raman_interferogram_intensity = "Raman interferogram intensity"
    ambient_temperature = "ambient temperature"
    reflectance = "reflectance"
    detector_view_volume = "detector view volume"
    stirring_rate = "stirring rate"


@dataclass(kw_only=True)
class StatisticsDocumentItem:
    statistical_feature: StatisticalFeature


@dataclass(kw_only=True)
class StatisticsAggregateDocument:
    statistics_document: list[StatisticsDocumentItem] | None = None


class ScanPositionSettingPlateReader(Enum):
    bottom_scan_position__plate_reader_ = "bottom scan position (plate reader)"
    scan_position_configuration__plate_reader_ = (
        "scan position configuration (plate reader)"
    )
    top_scan_position__plate_reader_ = "top scan position (plate reader)"


@dataclass(kw_only=True)
class ImageDocumentItem:
    experimental_data_identifier: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class OpticalImagingAggregateDocument:
    image_document: list[ImageDocumentItem]


class TransmittedLightSetting(Enum):
    brightfield = "brightfield"
    darkfield = "darkfield"
    phase_contrast = "phase contrast"


@dataclass(kw_only=True)
class Manifest:
    vocabulary: list[str]
    json_schemas: list[str]
    field_id: str | None = None
    field_type: str | None = None
    shapes: list[str] | None = None


@dataclass(kw_only=True)
class DeviceDocumentItem:
    device_type: TStringValue
    device_identifier: TStringValue | None = None
    model_number: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    brand_name: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class DeviceSystemDocument:
    device_identifier: TStringValue
    model_number: TStringValue
    asset_management_identifier: TStringValue | None = None
    description: Any | None = None
    brand_name: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    device_document: list[DeviceDocumentItem] | None = None


@dataclass(kw_only=True)
class DataSystemDocument:
    data_system_instance_identifier: TStringValue | None = None
    file_name: TStringValue | None = None
    UNC_path: TStringValue | None = None
    software_name: TStringValue | None = None
    software_version: TStringValue | None = None
    ASM_converter_name: TStringValue | None = None
    ASM_converter_version: TStringValue | None = None


@dataclass(kw_only=True)
class CalculatedDataDocumentItem:
    calculated_data_name: TStringValue
    calculated_result: TQuantityValue
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    calculated_data_identifier: TStringValue | None = None
    calculation_description: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class CalculatedDataAggregateDocument:
    calculated_data_document: list[CalculatedDataDocumentItem]


@dataclass(kw_only=True)
class ImageFeatureDocumentItem:
    image_feature_identifier: TStringValue
    image_feature_name: TStringValue | None = None
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    image_feature_result: TQuantityValueUnitless | None = None


@dataclass(kw_only=True)
class ImageFeatureAggregateDocument:
    image_feature_document: list[ImageFeatureDocumentItem]


@dataclass(kw_only=True)
class ProcessedDataDocumentItem:
    data_processing_document: dict[str, Any] | None = None
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    processed_data_identifier: TStringValue | None = None
    image_feature_aggregate_document: ImageFeatureAggregateDocument | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class ProcessedDataAggregateDocument:
    processed_data_document: list[ProcessedDataDocumentItem]


@dataclass(kw_only=True)
class CalculatedDataAggregateDocumentModel:
    calculated_data_document: list[CalculatedDataDocumentItem]


@dataclass(kw_only=True)
class SampleDocument:
    sample_identifier: TStringValue
    location_identifier: TStringValue
    description: Any | None = None
    batch_identifier: TStringValue | None = None
    sample_role_type: TClass | None = None
    written_name: TStringValue | None = None
    well_location_identifier: TStringValue | None = None
    vial_location_identifier: TStringValue | None = None
    well_plate_identifier: TStringValue | None = None
    mass_concentration: TQuantityValuePicogramPerMilliliter | None = None


@dataclass(kw_only=True)
class DeviceControlDocument:
    device_type: TStringValue
    device_identifier: TStringValue | None = None
    detection_type: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    brand_name: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    model_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    shaking_configuration_description: TStringValue | None = None
    detector_distance_setting__plate_reader_: TQuantityValueMillimeter | None = None
    integration_time: TQuantityValueSecondTime | None = None
    number_of_averages: TQuantityValueNumber | None = None
    detector_gain_setting: TStringValue | None = None
    scan_position_setting__plate_reader_: ScanPositionSettingPlateReader | None = None
    detector_carriage_speed_setting: TStringValue | None = None


@dataclass(kw_only=True)
class OpticalImagingDeviceControlDocumentItem(DeviceControlDocument):
    excitation_wavelength_setting: TQuantityValueNanometer | None = None
    detector_wavelength_setting: TQuantityValueNanometer | None = None
    magnification_setting: TQuantityValueUnitless | None = None
    exposure_duration_setting: TQuantityValueMilliSecond | None = None
    illumination_setting: TQuantityValuePercent | TQuantityValueUnitless | None = None
    image_count_setting: TQuantityValueUnitless | None = None
    auto_focus_setting: TBooleanValue | None = None
    transmitted_light_setting: TransmittedLightSetting | None = None
    fluorescent_tag_setting: TStringValue | None = None
    field_index: int | None = None


OpticalImagingDeviceControlDocument = list[OpticalImagingDeviceControlDocumentItem]


@dataclass(kw_only=True)
class OpticalImagingDeviceControlAggregateDocument:
    device_control_document: OpticalImagingDeviceControlDocument | None = None


@dataclass(kw_only=True)
class UltravioletAbsorbancePointDetectionDeviceControlDocumentItem(
    DeviceControlDocument
):
    detector_wavelength_setting: TQuantityValueNanometer | None = None
    detector_bandwidth_setting: TQuantityValueNanometer | None = None
    electronic_absorbance_wavelength_setting: TQuantityValueNanometer | None = None
    electronic_absorbance_bandwidth_setting: TQuantityValueNanometer | None = None
    electronic_absorbance_reference_bandwidth_setting: TQuantityValueNanometer | None = (
        None
    )
    electronic_absorbance_reference_wavelength_setting: TQuantityValueNanometer | None = (
        None
    )
    field_index: int | None = None


UltravioletAbsorbancePointDetectionDeviceControlDocument = list[
    UltravioletAbsorbancePointDetectionDeviceControlDocumentItem
]


@dataclass(kw_only=True)
class UltravioletAbsorbancePointDetectionDeviceControlAggregateDocument:
    device_control_document: UltravioletAbsorbancePointDetectionDeviceControlDocument


@dataclass(kw_only=True)
class FluorescencePointDetectionDeviceControlDocumentItem(DeviceControlDocument):
    detector_wavelength_setting: TQuantityValueNanometer | None = None
    detector_bandwidth_setting: TQuantityValueNanometer | None = None
    wavelength_filter_cutoff_setting: TQuantityValueNanometer | None = None
    excitation_bandwidth_setting: TQuantityValueNanometer | None = None
    excitation_wavelength_setting: TQuantityValueNanometer | None = None
    field_index: int | None = None


FluorescencePointDetectionDeviceControlDocument = list[
    FluorescencePointDetectionDeviceControlDocumentItem
]


@dataclass(kw_only=True)
class FluorescencePointDetectionDeviceControlAggregateDocument:
    device_control_document: FluorescencePointDetectionDeviceControlDocument


@dataclass(kw_only=True)
class LuminescencePointDetectionDeviceControlDocumentItem(DeviceControlDocument):
    detector_wavelength_setting: TQuantityValueNanometer | None = None
    detector_bandwidth_setting: TQuantityValueNanometer | None = None
    field_index: int | None = None


LuminescencePointDetectionDeviceControlDocument = list[
    LuminescencePointDetectionDeviceControlDocumentItem
]


@dataclass(kw_only=True)
class LuminescencePointDetectionDeviceControlAggregateDocument:
    device_control_document: LuminescencePointDetectionDeviceControlDocument


@dataclass(kw_only=True)
class CustomInformationAggregateDocument:
    custom_information_document: list[CustomInformationDocumentItem]


@dataclass(kw_only=True)
class MeasurementDocument:
    measurement_identifier: TStringValue
    device_control_aggregate_document: FluorescencePointDetectionDeviceControlAggregateDocument | LuminescencePointDetectionDeviceControlAggregateDocument | OpticalImagingDeviceControlAggregateDocument | UltravioletAbsorbancePointDetectionDeviceControlAggregateDocument
    sample_document: SampleDocument
    image_aggregate_document: OpticalImagingAggregateDocument | None = None
    measurement_time: TDateTimeStampValue | None = None
    detection_type: TStringValue | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocumentModel | None = (
        None
    )
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    compartment_temperature: TQuantityValueDegreeCelsius | None = None
    mass_concentration: TQuantityValuePicogramPerMilliliter | None = None
    custom_information_aggregate_document: CustomInformationAggregateDocument | None = (
        None
    )
    absorbance: TQuantityValueMilliAbsorbanceUnit | None = None
    fluorescence: TQuantityValueRelativeFluorescenceUnit | None = None
    luminescence: TQuantityValueRelativeLightUnit | None = None


@dataclass(kw_only=True)
class MeasurementAggregateDocument:
    measurement_time: TDateTimeStampValue
    plate_well_count: TQuantityValueNumber
    measurement_document: list[MeasurementDocument]
    analytical_method_identifier: TStringValue | None = None
    experimental_data_identifier: TStringValue | None = None
    experiment_type: TStringValue | None = None
    container_type: ContainerType | None = None
    well_volume: TQuantityValueMicroliter | None = None
    image_aggregate_document: OpticalImagingAggregateDocument | None = None
    diagnostic_trace_aggregate_document: DiagnosticTraceAggregateDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocumentModel | None = (
        None
    )
    statistics_aggregate_document: StatisticsAggregateDocument | None = None


@dataclass(kw_only=True)
class PlateReaderDocumentItem:
    measurement_aggregate_document: MeasurementAggregateDocument
    analyst: TStringValue | None = None
    submitter: TStringValue | None = None


@dataclass(kw_only=True)
class PlateReaderAggregateDocument:
    plate_reader_document: list[PlateReaderDocumentItem]
    device_system_document: DeviceSystemDocument | None = None
    data_system_document: DataSystemDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None


@dataclass(kw_only=True)
class Model:
    field_asm_manifest: Manifest | str
    plate_reader_aggregate_document: PlateReaderAggregateDocument | None = None
