# generated by datamodel-codegen:
#   filename:  solution-analyzer.schema.json
#   timestamp: 2024-08-13T06:10:53+00:00

from __future__ import annotations

from dataclasses import dataclass
from typing import Any

from allotropy.allotrope.models.shared.definitions.custom import (
    TQuantityValueCell,
    TQuantityValueDegreeCelsius,
    TQuantityValueGramPerLiter,
    TQuantityValueMicrometer,
    TQuantityValueMilliAbsorbanceUnit,
    TQuantityValueMilliliterPerLiter,
    TQuantityValueMillimeterOfMercury,
    TQuantityValueMillimolePerLiter,
    TQuantityValueMillionCellsPerMilliliter,
    TQuantityValueMilliOsmolesPerKilogram,
    TQuantityValueNanometer,
    TQuantityValuePercent,
    TQuantityValuePH,
    TQuantityValuePicogramPerMilliliter,
    TQuantityValueUnitless,
)
from allotropy.allotrope.models.shared.definitions.definitions import (
    TClass,
    TDatacube,
    TDateTimeStampValue,
    TIntegerValue,
    TStatisticDatumRole,
    TStringValue,
    TUnit,
)


@dataclass(kw_only=True)
class DiagnosticTraceDocumentItem:
    description: Any


@dataclass(kw_only=True)
class DiagnosticTraceAggregateDocument:
    diagnostic_trace_document: list[DiagnosticTraceDocumentItem] | None = None


@dataclass(kw_only=True)
class AdmCoreREC202403ManifestSchema:
    vocabulary: list[str]
    json_schemas: list[str]
    field_id: str | None = None
    field_type: str | None = None
    shapes: list[str] | None = None


@dataclass(kw_only=True)
class ErrorDocumentItem:
    error: TStringValue
    error_feature: TStringValue | None = None


@dataclass(kw_only=True)
class ErrorAggregateDocument:
    error_document: list[ErrorDocumentItem] | None = None


@dataclass(kw_only=True)
class ImageDocumentItem:
    index: TIntegerValue | None = None
    experimental_data_identifier: TStringValue | None = None


@dataclass(kw_only=True)
class ImageAggregateDocument:
    image_document: list[ImageDocumentItem] | None = None


@dataclass(kw_only=True)
class StatisticsDocumentItem:
    statistical_feature: TClass


@dataclass(kw_only=True)
class StatisticsAggregateDocument:
    statistics_document: list[StatisticsDocumentItem] | None = None


@dataclass(kw_only=True)
class TQuantityValueModel:
    value: float
    unit: TUnit
    has_statistic_datum_role: TStatisticDatumRole | None = None
    field_type: TClass | None = None


@dataclass(kw_only=True)
class DeviceDocumentItem:
    device_type: TStringValue
    device_identifier: TStringValue | None = None
    model_number: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    brand_name: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class DeviceSystemDocument:
    asset_management_identifier: TStringValue | None = None
    description: Any | None = None
    brand_name: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    device_identifier: TStringValue | None = None
    model_number: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    device_document: list[DeviceDocumentItem] | None = None


@dataclass(kw_only=True)
class DataSystemDocument:
    data_system_instance_identifier: TStringValue | None = None
    file_name: TStringValue | None = None
    UNC_path: TStringValue | None = None
    software_name: TStringValue | None = None
    software_version: TStringValue | None = None
    ASM_converter_name: TStringValue | None = None
    ASM_converter_version: TStringValue | None = None


@dataclass(kw_only=True)
class DeviceControlDocumentItem:
    device_type: TStringValue
    device_identifier: TStringValue | None = None
    detection_type: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    brand_name: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    model_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    field_index: int | None = None
    detector_wavelength_setting: TQuantityValueNanometer | None = None
    detector_bandwidth_setting: TQuantityValueNanometer | None = None
    electronic_absorbance_wavelength_setting: TQuantityValueNanometer | None = None
    electronic_absorbance_bandwidth_setting: TQuantityValueNanometer | None = None
    electronic_absorbance_reference_bandwidth_setting: TQuantityValueNanometer | None = (
        None
    )
    electronic_absorbance_reference_wavelength_setting: TQuantityValueNanometer | None = (
        None
    )
    excitation_wavelength_setting: TQuantityValueNanometer | None = None


@dataclass(kw_only=True)
class DeviceControlAggregateDocument:
    device_control_document: list[DeviceControlDocumentItem]


@dataclass(kw_only=True)
class SampleDocument:
    sample_identifier: TStringValue
    description: Any | None = None
    batch_identifier: TStringValue | None = None
    sample_role_type: TClass | None = None
    written_name: TStringValue | None = None


@dataclass(kw_only=True)
class DataProcessingDocument:
    cell_type_processing_method: TStringValue | None = None
    cell_density_dilution_factor: TQuantityValueUnitless | None = None
    minimum_cell_diameter_setting: TQuantityValueMicrometer | None = None
    maximum_cell_diameter_setting: TQuantityValueMicrometer | None = None


@dataclass(kw_only=True)
class AnalyteDocument:
    analyte_name: TStringValue
    mass_concentration: TQuantityValueGramPerLiter | None = None
    volume_concentration: TQuantityValueMilliliterPerLiter | None = None
    molar_concentration: TQuantityValueMillimolePerLiter | None = None


@dataclass(kw_only=True)
class AnalyteAggregateDocument:
    analyte_document: list[AnalyteDocument]


@dataclass(kw_only=True)
class DataSourceDocumentItem:
    data_source_identifier: TStringValue
    data_source_feature: TStringValue
    field_index: int | None = None


@dataclass(kw_only=True)
class DataSourceAggregateDocument:
    data_source_document: list[DataSourceDocumentItem]


@dataclass(kw_only=True)
class ProcessedDataAggregateDocument:
    processed_data_document: list[ProcessedDataDocumentItem]


@dataclass(kw_only=True)
class CalculatedDataDocumentItem:
    calculated_data_name: TStringValue
    calculated_result: TQuantityValueModel
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    calculated_data_identifier: TStringValue | None = None
    calculation_description: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class CalculatedDataAggregateDocument:
    calculated_data_document: list[CalculatedDataDocumentItem]


@dataclass(kw_only=True)
class MeasurementDocument:
    measurement_time: TDateTimeStampValue
    measurement_identifier: TStringValue
    device_control_aggregate_document: DeviceControlAggregateDocument
    sample_document: SampleDocument
    osmolality: TQuantityValueMilliOsmolesPerKilogram | None = None
    detection_type: TStringValue | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    image_aggregate_document: ImageAggregateDocument | None = None
    error_aggregate_document: ErrorAggregateDocument | None = None
    field_index: int | None = None
    absorbance: TQuantityValueMilliAbsorbanceUnit | None = None
    mass_concentration: TQuantityValuePicogramPerMilliliter | None = None
    pH: TQuantityValuePH | None = None
    temperature: TQuantityValueDegreeCelsius | None = None
    pO2: TQuantityValueMillimeterOfMercury | None = None
    pCO2: TQuantityValueMillimeterOfMercury | None = None
    carbon_dioxide_saturation: TQuantityValuePercent | None = None
    oxygen_saturation: TQuantityValuePercent | None = None
    analyte_aggregate_document: AnalyteAggregateDocument | None = None


@dataclass(kw_only=True)
class ProcessedDataDocumentItem:
    viability__cell_counter_: TQuantityValuePercent | None = None
    viable_cell_density__cell_counter_: TQuantityValueMillionCellsPerMilliliter | None = (
        None
    )
    data_processing_document: DataProcessingDocument | None = None
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    processed_data_identifier: TStringValue | None = None
    field_index: int | None = None
    total_cell_density__cell_counter_: TQuantityValueMillionCellsPerMilliliter | None = (
        None
    )
    dead_cell_density__cell_counter_: TQuantityValueMillionCellsPerMilliliter | None = (
        None
    )
    average_total_cell_diameter: TQuantityValueMicrometer | None = None
    average_live_cell_diameter__cell_counter_: TQuantityValueMicrometer | None = None
    average_dead_cell_diameter__cell_counter_: TQuantityValueMicrometer | None = None
    total_cell_diameter_distribution: TDatacube | None = None
    total_cell_count: TQuantityValueCell | None = None
    viable_cell_count: TQuantityValueCell | None = None
    dead_cell_count: TQuantityValueCell | None = None
    average_total_cell_circularity: TQuantityValueUnitless | None = None
    average_viable_cell_circularity: TQuantityValueUnitless | None = None


@dataclass(kw_only=True)
class MeasurementAggregateDocument:
    measurement_document: list[MeasurementDocument]
    diagnostic_trace_aggregate_document: DiagnosticTraceAggregateDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    image_aggregate_document: ImageAggregateDocument | None = None
    error_aggregate_document: ErrorAggregateDocument | None = None
    data_processing_time: TDateTimeStampValue | None = None


@dataclass(kw_only=True)
class SolutionAnalyzerDocumentItem:
    measurement_aggregate_document: MeasurementAggregateDocument
    analyst: TStringValue | None = None
    submitter: TStringValue | None = None


@dataclass(kw_only=True)
class SolutionAnalyzerAggregateDocument:
    solution_analyzer_document: list[SolutionAnalyzerDocumentItem]
    device_system_document: DeviceSystemDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    data_system_document: DataSystemDocument | None = None


@dataclass(kw_only=True)
class Model:
    field_asm_manifest: AdmCoreREC202403ManifestSchema | str
    solution_analyzer_aggregate_document: SolutionAnalyzerAggregateDocument | None = (
        None
    )
