# generated by datamodel-codegen:
#   filename:  spectrophotometry.schema.json
#   timestamp: 2024-10-31T13:33:24+00:00

from __future__ import annotations

from dataclasses import dataclass
from enum import Enum
from typing import Any

from allotropy.allotrope.models.shared.definitions.custom import (
    TQuantityValueCentimeter,
    TQuantityValueDegreeCelsius,
    TQuantityValueGramPerLiter,
    TQuantityValueMicrogramPerMicroliter,
    TQuantityValueMicrogramPerMilliliter,
    TQuantityValueMilliAbsorbanceUnit,
    TQuantityValueMilligramPerLiter,
    TQuantityValueMilligramPerMilliliter,
    TQuantityValueMillimeter,
    TQuantityValueNanogramPerMicroliter,
    TQuantityValueNanogramPerMilliliter,
    TQuantityValueNanometer,
    TQuantityValuePartsPerBillion,
    TQuantityValuePartsPerMillion,
    TQuantityValuePicogramPerMilliliter,
    TQuantityValueRelativeFluorescenceUnit,
    TQuantityValueRelativeLightUnit,
    TQuantityValueSecondTime,
    TQuantityValueSquareCentimetersPerGram,
)
from allotropy.allotrope.models.shared.definitions.definitions import (
    TClass,
    TDatacube,
    TDateTimeStampValue,
    TQuantityValue,
    TStringValue,
)


class ContainerType(Enum):
    reactor = "reactor"
    controlled_lab_reactor = "controlled lab reactor"
    tube = "tube"
    well_plate = "well plate"
    differential_scanning_calorimetry_pan = "differential scanning calorimetry pan"
    qPCR_reaction_block = "qPCR reaction block"
    vial_rack = "vial rack"
    pan = "pan"
    reservoir = "reservoir"
    array_card_block = "array card block"
    capillary = "capillary"
    disintegration_apparatus_basket = "disintegration apparatus basket"
    jar = "jar"
    container = "container"
    tray = "tray"
    basket = "basket"
    cell_holder = "cell holder"


@dataclass(kw_only=True)
class DiagnosticTraceDocumentItem:
    description: Any


@dataclass(kw_only=True)
class DiagnosticTraceAggregateDocument:
    diagnostic_trace_document: list[DiagnosticTraceDocumentItem] | None = None


@dataclass(kw_only=True)
class DataSourceDocumentItem:
    data_source_identifier: TStringValue
    data_source_feature: TStringValue
    field_index: int | None = None


@dataclass(kw_only=True)
class DataSourceAggregateDocument:
    data_source_document: list[DataSourceDocumentItem]


class StatisticalFeature(Enum):
    inner_diameter = "inner diameter"
    plate_heater_temperature = "plate heater temperature"
    linear_velocity = "linear velocity"
    enthalpy_of_fusion = "enthalpy of fusion"
    angular_velocity = "angular velocity"
    purity = "purity"
    intensity = "intensity"
    protein_attenuation_coefficient = "protein attenuation coefficient"
    electron_beam_working_distance = "electron beam working distance"
    temperature = "temperature"
    end_height = "end height"
    relative_humidity = "relative humidity"
    saturation_vapor_pressure = "saturation vapor pressure"
    heat_flow = "heat flow"
    quality_quantification_facet = "quality quantification facet"
    heat_transfer_coefficient = "heat transfer coefficient"
    molar_concentration = "molar concentration"
    average_total_cell_diameter = "average total cell diameter"
    pH = "pH"
    foam_height = "foam height"
    relative_weight_loss_on_drying = "relative weight loss on drying"
    dilution_volume = "dilution volume"
    flow_ratio = "flow ratio"
    electric_conductance = "electric conductance"
    sample_temperature = "sample temperature"
    container_diameter = "container diameter"
    absorbance = "absorbance"
    sample_thickness = "sample thickness"
    humidity = "humidity"
    Raman_intensity = "Raman intensity"
    voltage = "voltage"
    actual_P_P0_result = "actual P/P0 result"
    polyol_reservoir_temperature = "polyol reservoir temperature"
    turbidity = "turbidity"
    enthalpy_of_sublimation = "enthalpy of sublimation"
    osmolality = "osmolality"
    ambient_humidity = "ambient humidity"
    molar_enthalpy_of_vaporization = "molar enthalpy of vaporization"
    total_foam_height = "total foam height"
    strain = "strain"
    thermal_conductivity = "thermal conductivity"
    coating_gap_height = "coating gap height"
    measurement_chamber_free_space_volume = "measurement chamber free space volume"
    fracture_energy = "fracture energy"
    heat_capacity = "heat capacity"
    yield_strain = "yield strain"
    incident_radiation_angle = "incident radiation angle"
    mass_fraction = "mass fraction"
    liquid_height = "liquid height"
    chromatography_column_length = "chromatography column length"
    sample_width = "sample width"
    molar_enthalpy_of_sublimation = "molar enthalpy of sublimation"
    Raman_wavenumber_shift = "Raman wavenumber shift"
    relative_response = "relative response"
    length = "length"
    velocity = "velocity"
    electric_charge = "electric charge"
    molar_mass = "molar mass"
    image_height = "image height"
    concentration = "concentration"
    sample_weight_before_drying = "sample weight before drying"
    dilution_factor = "dilution factor"
    temperature_rate = "temperature rate"
    relative_permittivity = "relative permittivity"
    transition_enthalpy = "transition enthalpy"
    total_gas_flow_rate = "total gas flow rate"
    gloss = "gloss"
    water_mass_fraction = "water mass fraction"
    dielectric_polarization = "dielectric polarization"
    normalized_foam_height = "normalized foam height"
    peak_onset_temperature = "peak onset temperature"
    electric_current = "electric current"
    angle = "angle"
    energy__datum_ = "energy (datum)"
    abrasion_weight = "abrasion weight"
    absolute_water_content = "absolute water content"
    electric_resistance = "electric resistance"
    attenuation_coefficient = "attenuation coefficient"
    molar_enthalpy_of_fusion = "molar enthalpy of fusion"
    water_mass_concentration = "water mass concentration"
    partial_pressure = "partial pressure"
    volume = "volume"
    position_count = "position count"
    thermal_conductance = "thermal conductance"
    dry_sample_weight = "dry sample weight"
    adsorbed_volume_at_STP = "adsorbed volume at STP"
    force = "force"
    birefringence = "birefringence"
    monolayer_quantity = "monolayer quantity"
    peak_temperature = "peak temperature"
    dry_gas_flow_rate = "dry gas flow rate"
    gross_weight = "gross weight"
    sample_weight = "sample weight"
    image_width = "image width"
    m_z = "m/z"
    container_height = "container height"
    flow_rate = "flow rate"
    solvent_reservoir_temperature = "solvent reservoir temperature"
    isocyanate_reservoir_temperature = "isocyanate reservoir temperature"
    ambient_pressure = "ambient pressure"
    eccentricity = "eccentricity"
    mass = "mass"
    molar_absorptivity = "molar absorptivity"
    height = "height"
    column_inner_diameter = "column inner diameter"
    heat_seal_length = "heat seal length"
    specific_surface_area = "specific surface area"
    reference_material_weight = "reference material weight"
    thickness = "thickness"
    tare_weight = "tare weight"
    power = "power"
    chromatography_column_particle_size = "chromatography column particle size"
    saturated_gas_flow_rate = "saturated gas flow rate"
    well_volume = "well volume"
    degassed_sample_weight = "degassed sample weight"
    voltage_range = "voltage range"
    relative_intensity = "relative intensity"
    width = "width"
    yield_stress = "yield stress"
    total_cell_diameter = "total cell diameter"
    stress = "stress"
    relative_pressure__BET_ = "relative pressure (BET)"
    break_stress = "break stress"
    mass_concentration = "mass concentration"
    chromatography_column_film_thickness = "chromatography column film thickness"
    average_particle_size = "average particle size"
    wavelength = "wavelength"
    heat_capacity__dsc_ = "heat capacity (dsc)"
    acquisition_volume = "acquisition volume"
    collision_energy = "collision energy"
    background_corrected_turbidity = "background corrected turbidity"
    mass_change = "mass change"
    chemical_shift = "chemical shift"
    titer = "titer"
    refractive_index = "refractive index"
    enthalpy_of_vaporization = "enthalpy of vaporization"
    volume_fraction = "volume fraction"
    transmittance = "transmittance"
    electric_conductivity = "electric conductivity"
    fill_depth = "fill depth"
    Young_modulus = "Young modulus"
    total_material_height = "total material height"
    specific_rotation = "specific rotation"
    qNMR_purity_result = "qNMR purity result"
    size__datum_ = "size (datum)"
    break_strain = "break strain"
    specific_enthalpy_of_vaporization = "specific enthalpy of vaporization"
    absolute_intensity = "absolute intensity"
    BET_C_constant = "BET C constant"
    plate_well_count = "plate well count"
    plate_temperature = "plate temperature"
    volume_concentration = "volume concentration"
    specific_enthalpy_of_sublimation = "specific enthalpy of sublimation"
    enthalpy = "enthalpy"
    area = "area"
    peak_load_force = "peak load force"
    fluorescence = "fluorescence"
    start_height = "start height"
    polarity = "polarity"
    angle_of_optical_rotation = "angle of optical rotation"
    peak_analyte_amount = "peak analyte amount"
    extrapolated_moisture_content = "extrapolated moisture content"
    inlet_gas_pressure = "inlet gas pressure"
    hardness = "hardness"
    molecular_mass = "molecular mass"
    specific_enthalpy_of_fusion = "specific enthalpy of fusion"
    electric_impedance = "electric impedance"
    hold_up_volume = "hold-up volume"
    particle_size = "particle size"
    diameter = "diameter"
    tablet_thickness = "tablet thickness"
    pressure = "pressure"
    weight_loss = "weight loss"
    cell_path_length = "cell path length"
    glass_transition_temperature = "glass transition temperature"
    specific_heat_capacity = "specific heat capacity"
    wavenumber = "wavenumber"
    reservoir_temperature = "reservoir temperature"
    electric_resistivity = "electric resistivity"
    luminescence = "luminescence"
    compartment_temperature = "compartment temperature"
    viscosity = "viscosity"
    exhaust_gas_flow_rate = "exhaust gas flow rate"
    Raman_interferogram_intensity = "Raman interferogram intensity"
    ambient_temperature = "ambient temperature"
    reflectance = "reflectance"
    detector_view_volume = "detector view volume"
    stirring_rate = "stirring rate"


@dataclass(kw_only=True)
class StatisticsDocumentItem:
    statistical_feature: StatisticalFeature


@dataclass(kw_only=True)
class StatisticsAggregateDocument:
    statistics_document: list[StatisticsDocumentItem] | None = None


@dataclass(kw_only=True)
class SampleDocument:
    sample_identifier: TStringValue
    description: Any | None = None
    batch_identifier: TStringValue | None = None
    sample_role_type: TClass | None = None
    written_name: TStringValue | None = None
    location_identifier: TStringValue | None = None
    well_plate_identifier: TStringValue | None = None


@dataclass(kw_only=True)
class Manifest:
    vocabulary: list[str]
    json_schemas: list[str]
    field_id: str | None = None
    field_type: str | None = None
    shapes: list[str] | None = None


@dataclass(kw_only=True)
class DeviceDocumentItem:
    device_type: TStringValue
    device_identifier: TStringValue | None = None
    model_number: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    brand_name: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class DeviceSystemDocument:
    device_identifier: TStringValue
    model_number: TStringValue
    asset_management_identifier: TStringValue | None = None
    description: Any | None = None
    brand_name: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    device_document: list[DeviceDocumentItem] | None = None


@dataclass(kw_only=True)
class DataSystemDocument:
    data_system_instance_identifier: TStringValue | None = None
    file_name: TStringValue | None = None
    UNC_path: TStringValue | None = None
    software_name: TStringValue | None = None
    software_version: TStringValue | None = None
    ASM_converter_name: TStringValue | None = None
    ASM_converter_version: TStringValue | None = None


@dataclass(kw_only=True)
class CalculatedDataDocumentItem:
    calculated_data_name: TStringValue
    calculated_result: TQuantityValue
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    calculated_data_identifier: TStringValue | None = None
    calculation_description: TStringValue | None = None
    field_index: int | None = None


@dataclass(kw_only=True)
class CalculatedDataAggregateDocument:
    calculated_data_document: list[CalculatedDataDocumentItem]


@dataclass(kw_only=True)
class DataProcessingDocument:
    cell_path_length: TQuantityValueCentimeter | TQuantityValueMillimeter | None = None
    attenuation_coefficient: TQuantityValueSquareCentimetersPerGram | None = None


@dataclass(kw_only=True)
class ProcessedDataDocumentItem:
    data_processing_document: DataProcessingDocument | None = None
    data_source_aggregate_document: DataSourceAggregateDocument | None = None
    processed_data_identifier: TStringValue | None = None
    mass_concentration: TQuantityValueGramPerLiter | TQuantityValueMicrogramPerMicroliter | TQuantityValueMicrogramPerMilliliter | TQuantityValueMilligramPerLiter | TQuantityValueMilligramPerMilliliter | TQuantityValueNanogramPerMicroliter | TQuantityValueNanogramPerMilliliter | TQuantityValuePartsPerBillion | TQuantityValuePartsPerMillion | TQuantityValuePicogramPerMilliliter | None = (
        None
    )
    field_index: int | None = None


@dataclass(kw_only=True)
class ProcessedDataAggregateDocument:
    processed_data_document: list[ProcessedDataDocumentItem]


@dataclass(kw_only=True)
class DeviceControlDocument:
    device_type: TStringValue
    device_identifier: TStringValue | None = None
    detection_type: TStringValue | None = None
    product_manufacturer: TStringValue | None = None
    brand_name: TStringValue | None = None
    equipment_serial_number: TStringValue | None = None
    model_number: TStringValue | None = None
    firmware_version: TStringValue | None = None
    exposure_duration_setting: TQuantityValueSecondTime | None = None


@dataclass(kw_only=True)
class UltravioletAbsorbancePointDetectionDeviceControlDocumentItem(
    DeviceControlDocument
):
    detector_wavelength_setting: TQuantityValueNanometer | None = None
    detector_bandwidth_setting: TQuantityValueNanometer | None = None
    electronic_absorbance_wavelength_setting: TQuantityValueNanometer | None = None
    electronic_absorbance_bandwidth_setting: TQuantityValueNanometer | None = None
    electronic_absorbance_reference_bandwidth_setting: TQuantityValueNanometer | None = (
        None
    )
    electronic_absorbance_reference_wavelength_setting: TQuantityValueNanometer | None = (
        None
    )
    field_index: int | None = None


UltravioletAbsorbancePointDetectionDeviceControlDocument = list[
    UltravioletAbsorbancePointDetectionDeviceControlDocumentItem
]


@dataclass(kw_only=True)
class UltravioletAbsorbancePointDetectionDeviceControlAggregateDocument:
    device_control_document: UltravioletAbsorbancePointDetectionDeviceControlDocument


@dataclass(kw_only=True)
class UltravioletAbsorbancePointDetectionMeasurementDocumentItems:
    measurement_identifier: TStringValue
    device_control_aggregate_document: UltravioletAbsorbancePointDetectionDeviceControlAggregateDocument
    sample_document: SampleDocument
    absorbance: TQuantityValueMilliAbsorbanceUnit
    measurement_time: TDateTimeStampValue | None = None
    detection_type: TStringValue | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    compartment_temperature: TQuantityValueDegreeCelsius | None = None


@dataclass(kw_only=True)
class FluorescencePointDetectionDeviceControlDocumentItem(DeviceControlDocument):
    detector_wavelength_setting: TQuantityValueNanometer | None = None
    detector_bandwidth_setting: TQuantityValueNanometer | None = None
    wavelength_filter_cutoff_setting: TQuantityValueNanometer | None = None
    excitation_bandwidth_setting: TQuantityValueNanometer | None = None
    excitation_wavelength_setting: TQuantityValueNanometer | None = None
    field_index: int | None = None


FluorescencePointDetectionDeviceControlDocument = list[
    FluorescencePointDetectionDeviceControlDocumentItem
]


@dataclass(kw_only=True)
class LuminescencePointDetectionDeviceControlDocumentItem(DeviceControlDocument):
    detector_wavelength_setting: TQuantityValueNanometer | None = None
    detector_bandwidth_setting: TQuantityValueNanometer | None = None
    field_index: int | None = None


LuminescencePointDetectionDeviceControlDocument = list[
    LuminescencePointDetectionDeviceControlDocumentItem
]


@dataclass(kw_only=True)
class LuminescencePointDetectionDeviceControlAggregateDocument:
    device_control_document: LuminescencePointDetectionDeviceControlDocument


@dataclass(kw_only=True)
class LuminescencePointDetectionMeasurementDocumentItems:
    measurement_identifier: TStringValue
    device_control_aggregate_document: LuminescencePointDetectionDeviceControlAggregateDocument
    sample_document: SampleDocument
    luminescence: TQuantityValueRelativeLightUnit
    measurement_time: TDateTimeStampValue | None = None
    detection_type: TStringValue | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    compartment_temperature: TQuantityValueDegreeCelsius | None = None
    mass_concentration: TQuantityValuePicogramPerMilliliter | None = None


@dataclass(kw_only=True)
class UltravioletAbsorbanceSpectrumDetectionDeviceControlDocumentItem(
    DeviceControlDocument
):
    field_index: int | None = None


UltravioletAbsorbanceSpectrumDetectionDeviceControlDocument = list[
    UltravioletAbsorbanceSpectrumDetectionDeviceControlDocumentItem
]


@dataclass(kw_only=True)
class UltravioletAbsorbanceSpectrumDetectionDeviceControlAggregateDocument:
    device_control_document: UltravioletAbsorbanceSpectrumDetectionDeviceControlDocument


@dataclass(kw_only=True)
class FluorescenceEmissionSpectrumDetectionDeviceControlDocumentItem(
    DeviceControlDocument
):
    wavelength_filter_cutoff_setting: TQuantityValueNanometer | None = None
    excitation_bandwidth_setting: TQuantityValueNanometer | None = None
    excitation_wavelength_setting: TQuantityValueNanometer | None = None
    field_index: int | None = None


FluorescenceEmissionSpectrumDetectionDeviceControlDocument = list[
    FluorescenceEmissionSpectrumDetectionDeviceControlDocumentItem
]


@dataclass(kw_only=True)
class FluorescenceEmissionSpectrumDetectionDeviceControlAggregateDocument:
    device_control_document: FluorescenceEmissionSpectrumDetectionDeviceControlDocument


@dataclass(kw_only=True)
class FluorescencePointDetectionDeviceControlAggregateDocument:
    device_control_document: FluorescencePointDetectionDeviceControlDocument


@dataclass(kw_only=True)
class FluorescencePointDetectionMeasurementDocumentItems:
    measurement_identifier: TStringValue
    device_control_aggregate_document: FluorescencePointDetectionDeviceControlAggregateDocument
    sample_document: SampleDocument
    fluorescence: TQuantityValueRelativeFluorescenceUnit
    measurement_time: TDateTimeStampValue | None = None
    detection_type: TStringValue | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    compartment_temperature: TQuantityValueDegreeCelsius | None = None
    mass_concentration: TQuantityValuePicogramPerMilliliter | None = None


@dataclass(kw_only=True)
class UltravioletAbsorbanceSpectrumDetectionMeasurementDocumentItems:
    measurement_identifier: TStringValue
    device_control_aggregate_document: UltravioletAbsorbanceSpectrumDetectionDeviceControlAggregateDocument
    sample_document: SampleDocument
    absorption_spectrum_data_cube: TDatacube
    measurement_time: TDateTimeStampValue | None = None
    detection_type: TStringValue | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    compartment_temperature: TQuantityValueDegreeCelsius | None = None


@dataclass(kw_only=True)
class FluorescenceEmissionSpectrumDetectionMeasurementDocumentItems:
    measurement_identifier: TStringValue
    device_control_aggregate_document: FluorescenceEmissionSpectrumDetectionDeviceControlAggregateDocument
    sample_document: SampleDocument
    fluorescence_emission_spectrum_data_cube: TDatacube
    measurement_time: TDateTimeStampValue | None = None
    detection_type: TStringValue | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None
    compartment_temperature: TQuantityValueDegreeCelsius | None = None


@dataclass(kw_only=True)
class MeasurementAggregateDocument:
    measurement_time: TDateTimeStampValue
    measurement_document: list[
        FluorescenceEmissionSpectrumDetectionMeasurementDocumentItems
        | FluorescencePointDetectionMeasurementDocumentItems
        | LuminescencePointDetectionMeasurementDocumentItems
        | UltravioletAbsorbancePointDetectionMeasurementDocumentItems
        | UltravioletAbsorbanceSpectrumDetectionMeasurementDocumentItems
    ]
    experiment_type: TStringValue | None = None
    container_type: ContainerType | None = None
    diagnostic_trace_aggregate_document: DiagnosticTraceAggregateDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None


@dataclass(kw_only=True)
class SpectrophotometryDocumentItem:
    measurement_aggregate_document: MeasurementAggregateDocument
    analyst: TStringValue | None = None
    submitter: TStringValue | None = None


@dataclass(kw_only=True)
class SpectrophotometryAggregateDocument:
    spectrophotometry_document: list[SpectrophotometryDocumentItem]
    device_system_document: DeviceSystemDocument | None = None
    data_system_document: DataSystemDocument | None = None
    processed_data_aggregate_document: ProcessedDataAggregateDocument | None = None
    calculated_data_aggregate_document: CalculatedDataAggregateDocument | None = None
    statistics_aggregate_document: StatisticsAggregateDocument | None = None


@dataclass(kw_only=True)
class Model:
    field_asm_manifest: Manifest | str
    spectrophotometry_aggregate_document: SpectrophotometryAggregateDocument | None = (
        None
    )
