from enum import StrEnum

class Message(StrEnum):
    UNEXPECTED_ERROR_MSG = 'Something went wrong while processing your request. Please try again later.'
    PORTAL_ACCESS_RESTRICTED_MSG = 'You are not authorized to access this portal.'
    PROCESS_SUCCESS_MSG = 'Process executed successfully.'
    NO_RESULTS_FOUND_MSG = 'No records were found matching your request.'
    INVALID_REQUEST_PARAMS_MSG = 'Please review the required fields and try again.'
    SERVER_NETWORK_ACCESS_ERROR_MSG = 'Error making the server accessible on the network.'
    HEXAGONAL_SERVICE_CREATED_MSG = 'The hexagonal service structure was created.'
    PYCACHE_CLEANUP_SUCCESS_MSG = 'All __pycache__ have been removed.'
    NO_PASSWORD_CHARACTERS_MSG = 'There are no characters available to generate the password.'
    INSUFFICIENT_LENGTH_MSG = 'Insufficient length to meet minimum rules.'
    LEGACY_NAME_REQUIRED_MSG = 'Legacy name cannot be empty.'
    REFRESH_TOKEN_EXP_REQUIRED_MSG = 'Refresh token expiration time cannot be empty.'
    ACCESS_TOKEN_EXP_REQUIRED_MSG = 'Access token expiration time cannot be empty.'
    PUBLIC_KEY2_REQUIRED_MSG = 'Public key 2 cannot be empty.'
    PRIVATE_KEY1_REQUIRED_MSG = 'Private key 1 cannot be empty.'
    PRIVATE_KEY2_REQUIRED_MSG = 'Private key 2 cannot be empty.'
    AES_KEY_USER_REQUIRED_MSG = 'AES key user cannot be empty.'
    AES_KEY_AUTH_REQUIRED_MSG = 'AES key auth cannot be empty.'
    MISSING_FIELD_ERROR_MSG = 'A required field is missing. Please review the data.'
    ID_CDATA_INTEGRATION_REQUIRED = 'Cdata integration cannot be empty or null'
    EXP_TIME_REQUIRED = 'Expiration time (cdata integration) cannot be empty or null'
    KEY_PRIVATE_REQUIRED = 'Key private cannot be empty or null'
    SUB_ACCOUNT_REQUIRED = 'Sub account parameter is required'
    CATALOG_DATA_CREDENTIALS_MISSED = 'Catalog data or/and data credentials not found'
    PROFILE_PERMISSION_DENIED_MSG = 'Your profile does not have permission to perform this action.'
    INVALID_FORMAT_MSG = 'The provided data format is invalid.'
    INVALID_AES_JSON_FORMAT_MSG = 'Invalid JSON format in AES decrypted data.'
    UNEXPECTED_DECRYPTED_DATA_FORMAT_MSG = 'Unexpected format in decrypted data.'
    REDIS_CLEANUP_SUCCESS_MSG = 'Redis cleanup completed successfully.'
    REDIS_CLEANUP_ERROR_MSG = 'An error occurred while attempting to clean up Redis.'
    DATABASE_EXECUTION_ERROR_MSG = 'An unexpected error occurred while executing a database operation.'
    DATABASE_INTEGRITY_ERROR_MSG = 'A database integrity constraint was violated during execution.'
    QUERY_NOT_PROVIDED_MSG = 'Query not provided. Please include a valid query in your request.'
    FILE_PATH_NOT_PROVIDED_MSG = 'File path not provided.'
    PROTO_FILES_GENERATED_MSG = 'Proto files have been successfully generated.'
    ERROR_INVALID_DATA_TYPE = 'Invalid data type: expected dict, str, or list.'