# Copyright 2024 Pex project contributors.
# Licensed under the Apache License, Version 2.0 (see LICENSE).

from __future__ import absolute_import

import re
from textwrap import dedent

from pex import targets
from testing.cli import run_pex3
from testing.pytest_utils.tmp import Tempdir


def test_independent_logs_for_independent_runs(tmpdir):
    # type: (Tempdir) -> None

    lock = tmpdir.join("lock.json")
    log = tmpdir.join("pip.log")
    run_pex3(
        "lock", "sync", "--lock", lock, "--pip-log", log, "ansicolors==1.1.8", "cowsay==6.0"
    ).assert_success()
    target = str(targets.current().platform.tag)
    run_pex3("lock", "sync", "--lock", lock, "--pip-log", log, "ansicolors==1.1.8").assert_success(
        expected_error_re=r".*{footer}$".format(
            footer=re.escape(
                dedent(
                    """\
                    Updates for lock generated by {target}:
                      Deleted cowsay 6
                    Updates to lock input requirements:
                      Deleted 'cowsay==6.0'
                    """
                ).format(target=target)
            )
        ),
        re_flags=re.DOTALL,
    )
    run_pex3("lock", "sync", "--lock", lock, "--pip-log", log, "ansicolors==1.1.8").assert_success(
        expected_error_re=r".*No updates for lock generated by {target}\.$".format(
            target=re.escape(target)
        ),
        re_flags=re.DOTALL,
    )
