# Copyright 2021 Pex project contributors.
# Licensed under the Apache License, Version 2.0 (see LICENSE).

import pytest

from testing import IS_ARM_64, IS_PYPY, run_pex_command, subprocess
from testing.pytest_utils.tmp import Tempdir


@pytest.mark.skipif(
    IS_ARM_64 or IS_PYPY,
    reason=(
        "No wheels are published for arm or PyPy and the sdist fails to compile against modern "
        "OpenSSL."
    ),
)
def test_devendoring_required(tmpdir):
    # type: (Tempdir) -> None
    # The cryptography distribution does not have a whl released for python3 on linux at version 2.5.
    # As a result, we're forced to build it under python3 and, prior to the fix for
    # https://github.com/pex-tool/pex/issues/661, this would fail using the vendored setuptools
    # inside pex.
    cryptography_pex = tmpdir.join("cryptography.pex")
    run_pex_command(["cryptography==2.5", "-o", cryptography_pex]).assert_success()

    subprocess.check_call([cryptography_pex, "-c", "import cryptography"])
