"""Check the generated client code from various server endpoints."""


class TestGeneratedClient:  # pylint: disable=too-many-public-methods, protected-access
    """
    Tests that verify the server's generated Python client code by running it
    """

    def run_generated_create_node_client_code(
        self,
        module__session_with_examples,
        node: str,
    ):
        """
        Calls the server endpoint to get the generated client code for this node and runs it.
        """
        response = module__session_with_examples.get(
            f"/datajunction-clients/python/new_node/{node}?replace_namespace=roadscopy",
        )
        create_node_client_code = str(response.json())
        create_node_client_code = create_node_client_code.replace(
            "DJBuilder(DJ_URL)",
            "DJBuilder(requests_session=module__session_with_examples)",
        ).replace('dj.basic_login("dj", "dj")', "")
        exec(create_node_client_code)  # pylint: disable=exec-used

    def test_export_nodes(self, module__session_with_examples):
        """
        Verify that the code generated by /datajunction-clients/python/new_node works
        """
        response = module__session_with_examples.post("/namespaces/roadscopy")
        assert response.status_code == 201

        # Copy all source nodes to new namespace
        for source_node in set(
            module__session_with_examples.get("/nodes?node_type=source").json(),
        ):
            if source_node.startswith("default"):
                response = module__session_with_examples.post(
                    f"/nodes/{source_node}/copy?new_name=roadscopy.{source_node.split('.')[-1]}",
                )
                assert response.status_code == 200

        # Verify that the remaining nodes can be recreated with the generated Python client code
        # under the new namespace `roadscopy`
        nodes = [
            node["name"]
            for node in module__session_with_examples.get("/namespaces/default").json()
            if node["type"] not in ("source", "cube")
        ]
        for node in nodes:
            self.run_generated_create_node_client_code(
                module__session_with_examples,
                node,
            )
            shortname = node.split(".")[-1]
            result = module__session_with_examples.get(
                f"/nodes/roadscopy.{shortname}",
            ).json()
            assert result["name"] == f"roadscopy.{shortname}"
            assert "roadscopy" in result["query"]

        for node in nodes:
            # Verify that the generated linking dimensions code also works
            response = module__session_with_examples.get(
                f"/datajunction-clients/python/dimension_links/{node}"
                "?replace_namespace=roadscopy&include_client_setup=true",
            )
            dimension_links_client_code = str(response.json())
            dimension_links_client_code = dimension_links_client_code.replace(
                "DJBuilder(DJ_URL)",
                "DJBuilder(requests_session=module__session_with_examples)",
            ).replace('dj.basic_login("dj", "dj")', "")
            exec(dimension_links_client_code)  # pylint: disable=exec-used

        # Check linked dimensions
        dimensions = module__session_with_examples.get(
            "/nodes/roadscopy.num_repair_orders/dimensions",
        ).json()
        assert len(dimensions) == 31

        nodes = [
            node["name"]
            for node in module__session_with_examples.get("/namespaces/default").json()
            if node["type"] in ("cube")
        ]
        # Check that cubes can now be created after the dimension linking
        for node in nodes:
            shortname = node.split(".")[-1]
            self.run_generated_create_node_client_code(
                module__session_with_examples,
                node,
            )
            result = module__session_with_examples.get(
                f"/cubes/roadscopy.{shortname}",
            ).json()
            assert result["name"] == f"roadscopy.{shortname}"
            assert result["cube_node_metrics"] == ["roadscopy.num_repair_orders"]
            assert result["cube_node_dimensions"] == [
                "default.municipality_dim.local_region",
            ]

        result = module__session_with_examples.get(
            f"/nodes/roadscopy.{shortname}/dimensions",
        ).json()
        assert len(result) > 0
