# Third-Party Licenses and Notices

This project uses third-party libraries and components that are distributed under their own licenses. Below is a list of these dependencies and their respective license information.

---

## pyOpenMS

**License:** BSD 3-Clause License  
**Copyright:** OpenMS Team  
**Source:** https://github.com/OpenMS/OpenMS

pyOpenMS is a Python wrapper for OpenMS, a library for mass spectrometry data analysis.

### BSD 3-Clause License

```
Copyright (c) 2002-2025, The OpenMS Team
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
```

---

## Other Dependencies

This project also depends on the following open-source libraries. Please refer to their respective repositories for detailed license information:

- **NumPy** - BSD License
- **Pandas** - BSD License
- **SciPy** - BSD License
- **Matplotlib** - PSF-based License
- **h5py** - BSD License
- **Bokeh** - BSD License
- **Panel** - BSD License
- **Polars** - MIT License
- **scikit-learn** - BSD License
- **and others** - See pyproject.toml for complete dependency list

For the most up-to-date license information for these dependencies, please refer to their official repositories and documentation.
