---
title: AioFauna
---

# AioFauna

🚀 Introducing aiofauna: A full-stack framework built on top of Aiohttp, Pydantic and FaunaDB.

🔥 Inspired by FastAPI focuses on Developer Experience, Productivity and Versatility.

🌟 Features:

✅ Supports Python 3.7+, comes with an opinionated ODM (Object Document Mapper) out of the box for FaunaDB that abstracts out complex FQL expressions into pythonic, fully typed asynchronous methods for all CRUD operations.

✅ Powerful and Scalable: Being built on top of Aiohttp an asyncio based http server/client and FaunaDB an scalable serverless database for modern applications allows for powerful and seamless integrations.

✅ Performant: As a framework built on top of Aiohttp it leverages the power of asyncio and the fastest python `HTTPClient` aiohttp plus the ubiquiness of FaunaDB to achieve high performance.

✅ Automatic Swagger UI generation: Automatic generation of interactive Swagger UI documentation for instant testing of your `Api`.

✅ SSE (Server Sent Events): Built-in support for SSE (Server Sent Events) for real-time streaming of data from FaunaDB to your application.

✅ Websockets: Built-in support for Websockets for real-time bidirectional communication between your application and the resources served by AioFauna `Api`.

✅ Robust data validation: Utilizes the rich features of Pydantic for data validation and serialization.

✅ Auto-provisioning: Automatic management of indexes, unique indexes, and collections with `FaunaModel` ODM.

✅ Full JSON communication: Focus on your data, don't worry about the communication protocol. Your `Api` will receive and return JSON.

✅ Markdown and Html support with live reload: experiment an smooth frontend devserver experience without leaving your backend code with familiar syntax, `render_template` and `markdown_it` functions enable you to render static markdown files and html jinja templates with live reload.

✅ Inspired by fastapi, you will work with almost the same syntax and features like path operations, path parameters, query parameters, request body, status codes, `/docs` automatic interactive API documentation, and decorated view functions and automatic serialization and deserialization of your data.

💡 With aiofauna, you can build fast, scalable, and reliable modern applications, avoiding decision fatigue and focusing on what really matters, your data and your business logic.

📚 Check out the aiofauna library, and start building your next-gen applications today! 🚀

#Python #FaunaDB #Async #Pydantic #aiofauna

⚙️ If you are using a synchronous framework check out [Faudantic](https://github.com/obahamonde/faudantic) for a similar experience with FaunaDB and Pydantic.

📚 [Documentation](https://obahamonde-aiofauna-docs.smartpro.solutions) (Built with aiofauna)

📦 [PyPi](https://pypi.org/project/aiofauna/)

📦 [Demo](https://aiofauna-fwuw7gz7oq-uc.a.run.app/) (Whatsapp clone built with aiofauna)

📦 [Swagger UI](https://aiofauna-fwuw7gz7oq-uc.a.run.app/docs) (Whatsapp clone built with aiofauna)

📦 [GitHub](https://github.com/obahamonde/aiofauna)
