# -*- coding: utf-8 -*-
# Author: Yiping Liu
# Description: This script calculates the average of a list of numbers.
# Version: 1.0
# Last Modified: May 7, 2023

import pandas as pd

pd.set_option('display.precision', 11)

species = {
    ('b0', 'Li+', 'Cl-'): {
        'a1': 0.2185836,
        'a2': -2.51e-04,
        'a3': 0,
        'a4': 0,
        'a5': 9.696362,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
    ('b1', 'Li+', 'Cl-'): {
        'a1': -0.583294,
        'a2': 2.165e-03,
        'a3': 0,
        'a4': 0,
        'a5': 3.722014,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
    ('b2', 'Li+', 'Cl-'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
    ('c_phi', 'Li+', 'Cl-'): {
        'a1': -0.01755,
        'a2': 1.64e-05,
        'a3': 0,
        'a4': 0,
        'a5': 3.56052,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
    ('theta', 'Li+', 'Na+'): {
        'a1': -2.304375225,
        'a2': 9.185919e-3,
        'a3': -11.382562e-6,
        'a4': 0,
        'a5': 195.8054794,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
    ('theta', 'Li+', 'K+'): {
        'a1': -1.397383255,
        'a2': -1.08356e-3,
        'a3': 0.0172043e-6,
        'a4': 0,
        'a5': 0,
        'a6': 0.302809885,
        'a7': -0.085261601,
        'a8': 0.714329411,
    },
    ('lambda', 'Li+', 'LiCl0'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
    ('lambda', 'Cl-', 'LiCl0'): {
        'a1': 0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
    ('lambda', 'K+', 'LiCl0'): {
        'a1': -2.879993582,
        'a2': -1.996147e-3,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0.590495613,
        'a7': 0.016767927,
        'a8': 0,
    },
    ('lambda', 'Na+', 'LiCl0'): {
        'a1': -0.112759482,
        'a2': 0.0394693e-3,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
    ('b0', 'Na+', 'Cl-'): {
        'a1': 1.43783204e01,
        'a2': 5.60767406e-03,
        'a3': -4.22185236e02,
        'a4': -2.51226677e00,
        'a5': 0,
        'a6': -2.61718135e-06,
        'a7': 4.43854508e00,
        'a8': -1.70502337e00,
    },
    ('b1', 'Na+', 'Cl-'): {
        'a1': -4.83060685e-01,
        'a2': 1.40677479e-03,
        'a3': 1.19311989e02,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
        'a8': -4.23433299e00,
    },
    ('c_phi', 'Na+', 'Cl-'): {
        'a1': -1.00588714e-01,
        'a2': -1.80529413e-05,
        'a3': 8.61185543e00,
        'a4': 1.24880954e-02,
        'a5': 0,
        'a6': 3.41172106e-08,
        'a7': 6.83040995e-02,
        'a8': 2.93922611e-01,
    },
    ('b0', 'Cl-', 'K+'): {
        'a1': 2.67375563E01,
        'a2': 1.00721050E-02,
        'a3': -7.58485453E02,
        'a4': -4.70624175E00,
        'a5': 0,
        'a6': -3.75994338E-06,
        'a7': 0,
        'a8': 0,
    },

    ('b1', 'Cl-', 'K+'): {
        'a1': -7.4155926E00,
        'a2': 0,
        'a3': 3.22892989E+02,
        'a4': 1.16438557E00,
        'a5': 0,
        'a6': 0,
        'a7': 0,
        'a8': -5.94578140E00,
    },
    ('c_phi', 'Cl-', 'K+'): {
        'a1': -3.30531334e00,
        'a2': -1.29807848e-03,
        'a3': 9.12712100e01,
        'a4': 5.86450181e-01,
        'a5': 0,
        'a6': 4.95713573e-07,
        'a7': 0,
        'a8': 0,
    },
    ('theta', 'Na+', 'K+'): {
        'a1': -5.02312111e-02,
        'a2': 0,
        'a3': 1.40213141e01,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
    ('b0', 'Cl-', 'Ca+2'): {
        'a1': -9.41895832e+01,
        'a2': -4.04750026e-02,
        'a3': 2.34550368e+03,
        'a4': 1.70912300e+01,
        'a5': -9.22885841e-01,
        'a6': 1.51488122e-05,
        'a7': -1.39082000e00,
        'a8': 0,
    },

    ('b1', 'Cl-', 'Ca+2'): {
        'a1': 3.47870000e00,
        'a2': -1.54170000e-02,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 3.17910000e-05,
        'a7': 0,
        'a8': 0,
    },
    ('c_phi', 'Cl-', 'Ca+2'): {
        'a1': -3.03578731e+01,
        'a2': -1.36264728e-02,
        'a3': 7.64582238e+02,
        'a4': 5.50458061e00,
        'a5': -3.27377782e-01,
        'a6': 5.69405869e-06,
        'a7': -5.36231106e-01,
        'a8': 0,
    },
    ('theta', 'Na+', 'Ca+2'): {
        'a1': 0.05e0,
        'a2': 0,
        'a3': 0,
        'a4': 0,
        'a5': 0,
        'a6': 0,
        'a7': 0,
        'a8': 0,
    },
}

index = pd.MultiIndex.from_tuples([('pr1', 'pr2', 'pr3')], names=["parameter", "species1", "species2"])
df = pd.DataFrame(columns=['a1', 'a2', 'a3', 'a4', 'a5', 'a6', 'a7', 'a8'], index=index)
for key, value in species.items():
    df.loc[key, :] = pd.Series(value)
df.sort_index()

lassin_binary = df
