"""Contains the data models for keepa requests."""

from typing import Optional, Union

from pydantic import BaseModel


class ProductParams(BaseModel):
    """Product request parameters.

    See:
    https://github.com/keepacom/api_backend/blob/6f2048e1b8551875324445113e30041bbe37a147/src/main/java/com/keepa/api/backend/structs/ProductFinderRequest.java

    Examples
    --------
    Use attributes:

    >>> import keepa
    >>> product_params = keepa.ProductParams()
    >>> product_params.author = "J. R. R. Tolkien"

    Use keywords:

    >>> product_params = keepa.ProductParams(author="J. R. R. Tolkien")

    Use within :func:`keepa.Keepa.product_finder`:

    >>> import keepa
    >>> api = keepa.Keepa("<ENTER_ACTUAL_KEY_HERE>")
    >>> product_params = keepa.ProductParams(author="J. R. R. Tolkien")
    >>> asins = api.product_finder(product_parms, n_products=100)

    """

    author: Optional[Union[list[str], str]] = None
    availabilityAmazon: Optional[int] = None
    avg180_AMAZON_lte: Optional[int] = None
    avg180_AMAZON_gte: Optional[int] = None
    avg180_BUY_BOX_SHIPPING_lte: Optional[int] = None
    avg180_BUY_BOX_SHIPPING_gte: Optional[int] = None
    avg180_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    avg180_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    avg180_COLLECTIBLE_lte: Optional[int] = None
    avg180_COLLECTIBLE_gte: Optional[int] = None
    avg180_COUNT_COLLECTIBLE_lte: Optional[int] = None
    avg180_COUNT_COLLECTIBLE_gte: Optional[int] = None
    avg180_COUNT_NEW_lte: Optional[int] = None
    avg180_COUNT_NEW_gte: Optional[int] = None
    avg180_COUNT_REFURBISHED_lte: Optional[int] = None
    avg180_COUNT_REFURBISHED_gte: Optional[int] = None
    avg180_COUNT_REVIEWS_lte: Optional[int] = None
    avg180_COUNT_REVIEWS_gte: Optional[int] = None
    avg180_COUNT_USED_lte: Optional[int] = None
    avg180_COUNT_USED_gte: Optional[int] = None
    avg180_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    avg180_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    avg180_EBAY_USED_SHIPPING_lte: Optional[int] = None
    avg180_EBAY_USED_SHIPPING_gte: Optional[int] = None
    avg180_LIGHTNING_DEAL_lte: Optional[int] = None
    avg180_LIGHTNING_DEAL_gte: Optional[int] = None
    avg180_LISTPRICE_lte: Optional[int] = None
    avg180_LISTPRICE_gte: Optional[int] = None
    avg180_NEW_lte: Optional[int] = None
    avg180_NEW_gte: Optional[int] = None
    avg180_NEW_FBA_lte: Optional[int] = None
    avg180_NEW_FBA_gte: Optional[int] = None
    avg180_NEW_FBM_SHIPPING_lte: Optional[int] = None
    avg180_NEW_FBM_SHIPPING_gte: Optional[int] = None
    avg180_PRIME_EXCL_lte: Optional[int] = None
    avg180_PRIME_EXCL_gte: Optional[int] = None
    avg180_RATING_lte: Optional[int] = None
    avg180_RATING_gte: Optional[int] = None
    avg180_REFURBISHED_lte: Optional[int] = None
    avg180_REFURBISHED_gte: Optional[int] = None
    avg180_REFURBISHED_SHIPPING_lte: Optional[int] = None
    avg180_REFURBISHED_SHIPPING_gte: Optional[int] = None
    avg180_RENT_lte: Optional[int] = None
    avg180_RENT_gte: Optional[int] = None
    avg180_SALES_lte: Optional[int] = None
    avg180_SALES_gte: Optional[int] = None
    avg180_TRADE_IN_lte: Optional[int] = None
    avg180_TRADE_IN_gte: Optional[int] = None
    avg180_USED_lte: Optional[int] = None
    avg180_USED_gte: Optional[int] = None
    avg180_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    avg180_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    avg180_USED_GOOD_SHIPPING_lte: Optional[int] = None
    avg180_USED_GOOD_SHIPPING_gte: Optional[int] = None
    avg180_USED_NEW_SHIPPING_lte: Optional[int] = None
    avg180_USED_NEW_SHIPPING_gte: Optional[int] = None
    avg180_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    avg180_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    avg180_WAREHOUSE_lte: Optional[int] = None
    avg180_WAREHOUSE_gte: Optional[int] = None
    avg1_AMAZON_lte: Optional[int] = None
    avg1_AMAZON_gte: Optional[int] = None
    avg1_BUY_BOX_SHIPPING_lte: Optional[int] = None
    avg1_BUY_BOX_SHIPPING_gte: Optional[int] = None
    avg1_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    avg1_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    avg1_COLLECTIBLE_lte: Optional[int] = None
    avg1_COLLECTIBLE_gte: Optional[int] = None
    avg1_COUNT_COLLECTIBLE_lte: Optional[int] = None
    avg1_COUNT_COLLECTIBLE_gte: Optional[int] = None
    avg1_COUNT_NEW_lte: Optional[int] = None
    avg1_COUNT_NEW_gte: Optional[int] = None
    avg1_COUNT_REFURBISHED_lte: Optional[int] = None
    avg1_COUNT_REFURBISHED_gte: Optional[int] = None
    avg1_COUNT_REVIEWS_lte: Optional[int] = None
    avg1_COUNT_REVIEWS_gte: Optional[int] = None
    avg1_COUNT_USED_lte: Optional[int] = None
    avg1_COUNT_USED_gte: Optional[int] = None
    avg1_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    avg1_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    avg1_EBAY_USED_SHIPPING_lte: Optional[int] = None
    avg1_EBAY_USED_SHIPPING_gte: Optional[int] = None
    avg1_LIGHTNING_DEAL_lte: Optional[int] = None
    avg1_LIGHTNING_DEAL_gte: Optional[int] = None
    avg1_LISTPRICE_lte: Optional[int] = None
    avg1_LISTPRICE_gte: Optional[int] = None
    avg1_NEW_lte: Optional[int] = None
    avg1_NEW_gte: Optional[int] = None
    avg1_NEW_FBA_lte: Optional[int] = None
    avg1_NEW_FBA_gte: Optional[int] = None
    avg1_NEW_FBM_SHIPPING_lte: Optional[int] = None
    avg1_NEW_FBM_SHIPPING_gte: Optional[int] = None
    avg1_PRIME_EXCL_lte: Optional[int] = None
    avg1_PRIME_EXCL_gte: Optional[int] = None
    avg1_RATING_lte: Optional[int] = None
    avg1_RATING_gte: Optional[int] = None
    avg1_REFURBISHED_lte: Optional[int] = None
    avg1_REFURBISHED_gte: Optional[int] = None
    avg1_REFURBISHED_SHIPPING_lte: Optional[int] = None
    avg1_REFURBISHED_SHIPPING_gte: Optional[int] = None
    avg1_RENT_lte: Optional[int] = None
    avg1_RENT_gte: Optional[int] = None
    avg1_SALES_lte: Optional[int] = None
    avg1_SALES_gte: Optional[int] = None
    avg1_TRADE_IN_lte: Optional[int] = None
    avg1_TRADE_IN_gte: Optional[int] = None
    avg1_USED_lte: Optional[int] = None
    avg1_USED_gte: Optional[int] = None
    avg1_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    avg1_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    avg1_USED_GOOD_SHIPPING_lte: Optional[int] = None
    avg1_USED_GOOD_SHIPPING_gte: Optional[int] = None
    avg1_USED_NEW_SHIPPING_lte: Optional[int] = None
    avg1_USED_NEW_SHIPPING_gte: Optional[int] = None
    avg1_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    avg1_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    avg1_WAREHOUSE_lte: Optional[int] = None
    avg1_WAREHOUSE_gte: Optional[int] = None
    avg30_AMAZON_lte: Optional[int] = None
    avg30_AMAZON_gte: Optional[int] = None
    avg30_BUY_BOX_SHIPPING_lte: Optional[int] = None
    avg30_BUY_BOX_SHIPPING_gte: Optional[int] = None
    avg30_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    avg30_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    avg30_COLLECTIBLE_lte: Optional[int] = None
    avg30_COLLECTIBLE_gte: Optional[int] = None
    avg30_COUNT_COLLECTIBLE_lte: Optional[int] = None
    avg30_COUNT_COLLECTIBLE_gte: Optional[int] = None
    avg30_COUNT_NEW_lte: Optional[int] = None
    avg30_COUNT_NEW_gte: Optional[int] = None
    avg30_COUNT_REFURBISHED_lte: Optional[int] = None
    avg30_COUNT_REFURBISHED_gte: Optional[int] = None
    avg30_COUNT_REVIEWS_lte: Optional[int] = None
    avg30_COUNT_REVIEWS_gte: Optional[int] = None
    avg30_COUNT_USED_lte: Optional[int] = None
    avg30_COUNT_USED_gte: Optional[int] = None
    avg30_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    avg30_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    avg30_EBAY_USED_SHIPPING_lte: Optional[int] = None
    avg30_EBAY_USED_SHIPPING_gte: Optional[int] = None
    avg30_LIGHTNING_DEAL_lte: Optional[int] = None
    avg30_LIGHTNING_DEAL_gte: Optional[int] = None
    avg30_LISTPRICE_lte: Optional[int] = None
    avg30_LISTPRICE_gte: Optional[int] = None
    avg30_NEW_lte: Optional[int] = None
    avg30_NEW_gte: Optional[int] = None
    avg30_NEW_FBA_lte: Optional[int] = None
    avg30_NEW_FBA_gte: Optional[int] = None
    avg30_NEW_FBM_SHIPPING_lte: Optional[int] = None
    avg30_NEW_FBM_SHIPPING_gte: Optional[int] = None
    avg30_PRIME_EXCL_lte: Optional[int] = None
    avg30_PRIME_EXCL_gte: Optional[int] = None
    avg30_RATING_lte: Optional[int] = None
    avg30_RATING_gte: Optional[int] = None
    avg30_REFURBISHED_lte: Optional[int] = None
    avg30_REFURBISHED_gte: Optional[int] = None
    avg30_REFURBISHED_SHIPPING_lte: Optional[int] = None
    avg30_REFURBISHED_SHIPPING_gte: Optional[int] = None
    avg30_RENT_lte: Optional[int] = None
    avg30_RENT_gte: Optional[int] = None
    avg30_SALES_lte: Optional[int] = None
    avg30_SALES_gte: Optional[int] = None
    avg30_TRADE_IN_lte: Optional[int] = None
    avg30_TRADE_IN_gte: Optional[int] = None
    avg30_USED_lte: Optional[int] = None
    avg30_USED_gte: Optional[int] = None
    avg30_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    avg30_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    avg30_USED_GOOD_SHIPPING_lte: Optional[int] = None
    avg30_USED_GOOD_SHIPPING_gte: Optional[int] = None
    avg30_USED_NEW_SHIPPING_lte: Optional[int] = None
    avg30_USED_NEW_SHIPPING_gte: Optional[int] = None
    avg30_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    avg30_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    avg30_WAREHOUSE_lte: Optional[int] = None
    avg30_WAREHOUSE_gte: Optional[int] = None
    avg7_AMAZON_lte: Optional[int] = None
    avg7_AMAZON_gte: Optional[int] = None
    avg7_BUY_BOX_SHIPPING_lte: Optional[int] = None
    avg7_BUY_BOX_SHIPPING_gte: Optional[int] = None
    avg7_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    avg7_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    avg7_COLLECTIBLE_lte: Optional[int] = None
    avg7_COLLECTIBLE_gte: Optional[int] = None
    avg7_COUNT_COLLECTIBLE_lte: Optional[int] = None
    avg7_COUNT_COLLECTIBLE_gte: Optional[int] = None
    avg7_COUNT_NEW_lte: Optional[int] = None
    avg7_COUNT_NEW_gte: Optional[int] = None
    avg7_COUNT_REFURBISHED_lte: Optional[int] = None
    avg7_COUNT_REFURBISHED_gte: Optional[int] = None
    avg7_COUNT_REVIEWS_lte: Optional[int] = None
    avg7_COUNT_REVIEWS_gte: Optional[int] = None
    avg7_COUNT_USED_lte: Optional[int] = None
    avg7_COUNT_USED_gte: Optional[int] = None
    avg7_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    avg7_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    avg7_EBAY_USED_SHIPPING_lte: Optional[int] = None
    avg7_EBAY_USED_SHIPPING_gte: Optional[int] = None
    avg7_LIGHTNING_DEAL_lte: Optional[int] = None
    avg7_LIGHTNING_DEAL_gte: Optional[int] = None
    avg7_LISTPRICE_lte: Optional[int] = None
    avg7_LISTPRICE_gte: Optional[int] = None
    avg7_NEW_lte: Optional[int] = None
    avg7_NEW_gte: Optional[int] = None
    avg7_NEW_FBA_lte: Optional[int] = None
    avg7_NEW_FBA_gte: Optional[int] = None
    avg7_NEW_FBM_SHIPPING_lte: Optional[int] = None
    avg7_NEW_FBM_SHIPPING_gte: Optional[int] = None
    avg7_PRIME_EXCL_lte: Optional[int] = None
    avg7_PRIME_EXCL_gte: Optional[int] = None
    avg7_RATING_lte: Optional[int] = None
    avg7_RATING_gte: Optional[int] = None
    avg7_REFURBISHED_lte: Optional[int] = None
    avg7_REFURBISHED_gte: Optional[int] = None
    avg7_REFURBISHED_SHIPPING_lte: Optional[int] = None
    avg7_REFURBISHED_SHIPPING_gte: Optional[int] = None
    avg7_RENT_lte: Optional[int] = None
    avg7_RENT_gte: Optional[int] = None
    avg7_SALES_lte: Optional[int] = None
    avg7_SALES_gte: Optional[int] = None
    avg7_TRADE_IN_lte: Optional[int] = None
    avg7_TRADE_IN_gte: Optional[int] = None
    avg7_USED_lte: Optional[int] = None
    avg7_USED_gte: Optional[int] = None
    avg7_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    avg7_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    avg7_USED_GOOD_SHIPPING_lte: Optional[int] = None
    avg7_USED_GOOD_SHIPPING_gte: Optional[int] = None
    avg7_USED_NEW_SHIPPING_lte: Optional[int] = None
    avg7_USED_NEW_SHIPPING_gte: Optional[int] = None
    avg7_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    avg7_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    avg7_WAREHOUSE_lte: Optional[int] = None
    avg7_WAREHOUSE_gte: Optional[int] = None
    avg90_AMAZON_lte: Optional[int] = None
    avg90_AMAZON_gte: Optional[int] = None
    avg90_BUY_BOX_SHIPPING_lte: Optional[int] = None
    avg90_BUY_BOX_SHIPPING_gte: Optional[int] = None
    avg90_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    avg90_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    avg90_COLLECTIBLE_lte: Optional[int] = None
    avg90_COLLECTIBLE_gte: Optional[int] = None
    avg90_COUNT_COLLECTIBLE_lte: Optional[int] = None
    avg90_COUNT_COLLECTIBLE_gte: Optional[int] = None
    avg90_COUNT_NEW_lte: Optional[int] = None
    avg90_COUNT_NEW_gte: Optional[int] = None
    avg90_COUNT_REFURBISHED_lte: Optional[int] = None
    avg90_COUNT_REFURBISHED_gte: Optional[int] = None
    avg90_COUNT_REVIEWS_lte: Optional[int] = None
    avg90_COUNT_REVIEWS_gte: Optional[int] = None
    avg90_COUNT_USED_lte: Optional[int] = None
    avg90_COUNT_USED_gte: Optional[int] = None
    avg90_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    avg90_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    avg90_EBAY_USED_SHIPPING_lte: Optional[int] = None
    avg90_EBAY_USED_SHIPPING_gte: Optional[int] = None
    avg90_LIGHTNING_DEAL_lte: Optional[int] = None
    avg90_LIGHTNING_DEAL_gte: Optional[int] = None
    avg90_LISTPRICE_lte: Optional[int] = None
    avg90_LISTPRICE_gte: Optional[int] = None
    avg90_NEW_lte: Optional[int] = None
    avg90_NEW_gte: Optional[int] = None
    avg90_NEW_FBA_lte: Optional[int] = None
    avg90_NEW_FBA_gte: Optional[int] = None
    avg90_NEW_FBM_SHIPPING_lte: Optional[int] = None
    avg90_NEW_FBM_SHIPPING_gte: Optional[int] = None
    avg90_PRIME_EXCL_lte: Optional[int] = None
    avg90_PRIME_EXCL_gte: Optional[int] = None
    avg90_RATING_lte: Optional[int] = None
    avg90_RATING_gte: Optional[int] = None
    avg90_REFURBISHED_lte: Optional[int] = None
    avg90_REFURBISHED_gte: Optional[int] = None
    avg90_REFURBISHED_SHIPPING_lte: Optional[int] = None
    avg90_REFURBISHED_SHIPPING_gte: Optional[int] = None
    avg90_RENT_lte: Optional[int] = None
    avg90_RENT_gte: Optional[int] = None
    avg90_SALES_lte: Optional[int] = None
    avg90_SALES_gte: Optional[int] = None
    avg90_TRADE_IN_lte: Optional[int] = None
    avg90_TRADE_IN_gte: Optional[int] = None
    avg90_USED_lte: Optional[int] = None
    avg90_USED_gte: Optional[int] = None
    avg90_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    avg90_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    avg90_USED_GOOD_SHIPPING_lte: Optional[int] = None
    avg90_USED_GOOD_SHIPPING_gte: Optional[int] = None
    avg90_USED_NEW_SHIPPING_lte: Optional[int] = None
    avg90_USED_NEW_SHIPPING_gte: Optional[int] = None
    avg90_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    avg90_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    avg90_WAREHOUSE_lte: Optional[int] = None
    avg90_WAREHOUSE_gte: Optional[int] = None
    backInStock_AMAZON: Optional[bool] = None
    backInStock_BUY_BOX_SHIPPING: Optional[bool] = None
    backInStock_BUY_BOX_USED_SHIPPING: Optional[bool] = None
    backInStock_COLLECTIBLE: Optional[bool] = None
    backInStock_COUNT_COLLECTIBLE: Optional[bool] = None
    backInStock_COUNT_NEW: Optional[bool] = None
    backInStock_COUNT_REFURBISHED: Optional[bool] = None
    backInStock_COUNT_REVIEWS: Optional[bool] = None
    backInStock_COUNT_USED: Optional[bool] = None
    backInStock_EBAY_NEW_SHIPPING: Optional[bool] = None
    backInStock_EBAY_USED_SHIPPING: Optional[bool] = None
    backInStock_LIGHTNING_DEAL: Optional[bool] = None
    backInStock_LISTPRICE: Optional[bool] = None
    backInStock_NEW: Optional[bool] = None
    backInStock_NEW_FBA: Optional[bool] = None
    backInStock_NEW_FBM_SHIPPING: Optional[bool] = None
    backInStock_PRIME_EXCL: Optional[bool] = None
    backInStock_RATING: Optional[bool] = None
    backInStock_REFURBISHED: Optional[bool] = None
    backInStock_REFURBISHED_SHIPPING: Optional[bool] = None
    backInStock_RENT: Optional[bool] = None
    backInStock_SALES: Optional[bool] = None
    backInStock_TRADE_IN: Optional[bool] = None
    backInStock_USED: Optional[bool] = None
    backInStock_USED_ACCEPTABLE_SHIPPING: Optional[bool] = None
    backInStock_USED_GOOD_SHIPPING: Optional[bool] = None
    backInStock_USED_NEW_SHIPPING: Optional[bool] = None
    backInStock_USED_VERY_GOOD_SHIPPING: Optional[bool] = None
    backInStock_WAREHOUSE: Optional[bool] = None
    binding: Optional[Union[list[str], str]] = None
    brand: Optional[Union[list[str], str]] = None
    buyBoxIsAmazon: Optional[bool] = None
    buyBoxIsFBA: Optional[bool] = None
    buyBoxIsUnqualified: Optional[bool] = None
    buyBoxSellerId: Optional[Union[list[str], str]] = None
    buyBoxUsedCondition_lte: Optional[int] = None
    buyBoxUsedCondition_gte: Optional[int] = None
    buyBoxUsedIsFBA: Optional[bool] = None
    buyBoxUsedSellerId: Optional[str] = None
    categories_include: Optional[Union[list[int], int]] = None
    categories_exclude: Optional[Union[list[int], int]] = None
    color: Optional[Union[list[str], str]] = None
    couponOneTimeAbsolute_lte: Optional[int] = None
    couponOneTimeAbsolute_gte: Optional[int] = None
    couponOneTimePercent_lte: Optional[int] = None
    couponOneTimePercent_gte: Optional[int] = None
    couponSNSPercent_lte: Optional[int] = None
    couponSNSPercent_gte: Optional[int] = None
    current_AMAZON_lte: Optional[int] = None
    current_AMAZON_gte: Optional[int] = None
    current_BUY_BOX_SHIPPING_lte: Optional[int] = None
    current_BUY_BOX_SHIPPING_gte: Optional[int] = None
    current_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    current_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    current_COLLECTIBLE_lte: Optional[int] = None
    current_COLLECTIBLE_gte: Optional[int] = None
    current_COUNT_COLLECTIBLE_lte: Optional[int] = None
    current_COUNT_COLLECTIBLE_gte: Optional[int] = None
    current_COUNT_NEW_lte: Optional[int] = None
    current_COUNT_NEW_gte: Optional[int] = None
    current_COUNT_REFURBISHED_lte: Optional[int] = None
    current_COUNT_REFURBISHED_gte: Optional[int] = None
    current_COUNT_REVIEWS_lte: Optional[int] = None
    current_COUNT_REVIEWS_gte: Optional[int] = None
    current_COUNT_USED_lte: Optional[int] = None
    current_COUNT_USED_gte: Optional[int] = None
    current_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    current_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    current_EBAY_USED_SHIPPING_lte: Optional[int] = None
    current_EBAY_USED_SHIPPING_gte: Optional[int] = None
    current_LIGHTNING_DEAL_lte: Optional[int] = None
    current_LIGHTNING_DEAL_gte: Optional[int] = None
    current_LISTPRICE_lte: Optional[int] = None
    current_LISTPRICE_gte: Optional[int] = None
    current_NEW_lte: Optional[int] = None
    current_NEW_gte: Optional[int] = None
    current_NEW_FBA_lte: Optional[int] = None
    current_NEW_FBA_gte: Optional[int] = None
    current_NEW_FBM_SHIPPING_lte: Optional[int] = None
    current_NEW_FBM_SHIPPING_gte: Optional[int] = None
    current_PRIME_EXCL_lte: Optional[int] = None
    current_PRIME_EXCL_gte: Optional[int] = None
    current_RATING_lte: Optional[int] = None
    current_RATING_gte: Optional[int] = None
    current_REFURBISHED_lte: Optional[int] = None
    current_REFURBISHED_gte: Optional[int] = None
    current_REFURBISHED_SHIPPING_lte: Optional[int] = None
    current_REFURBISHED_SHIPPING_gte: Optional[int] = None
    current_RENT_lte: Optional[int] = None
    current_RENT_gte: Optional[int] = None
    current_SALES_lte: Optional[int] = None
    current_SALES_gte: Optional[int] = None
    current_TRADE_IN_lte: Optional[int] = None
    current_TRADE_IN_gte: Optional[int] = None
    current_USED_lte: Optional[int] = None
    current_USED_gte: Optional[int] = None
    current_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    current_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    current_USED_GOOD_SHIPPING_lte: Optional[int] = None
    current_USED_GOOD_SHIPPING_gte: Optional[int] = None
    current_USED_NEW_SHIPPING_lte: Optional[int] = None
    current_USED_NEW_SHIPPING_gte: Optional[int] = None
    current_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    current_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    current_WAREHOUSE_lte: Optional[int] = None
    current_WAREHOUSE_gte: Optional[int] = None
    delta1_AMAZON_lte: Optional[int] = None
    delta1_AMAZON_gte: Optional[int] = None
    delta1_BUY_BOX_SHIPPING_lte: Optional[int] = None
    delta1_BUY_BOX_SHIPPING_gte: Optional[int] = None
    delta1_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    delta1_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    delta1_COLLECTIBLE_lte: Optional[int] = None
    delta1_COLLECTIBLE_gte: Optional[int] = None
    delta1_COUNT_COLLECTIBLE_lte: Optional[int] = None
    delta1_COUNT_COLLECTIBLE_gte: Optional[int] = None
    delta1_COUNT_NEW_lte: Optional[int] = None
    delta1_COUNT_NEW_gte: Optional[int] = None
    delta1_COUNT_REFURBISHED_lte: Optional[int] = None
    delta1_COUNT_REFURBISHED_gte: Optional[int] = None
    delta1_COUNT_REVIEWS_lte: Optional[int] = None
    delta1_COUNT_REVIEWS_gte: Optional[int] = None
    delta1_COUNT_USED_lte: Optional[int] = None
    delta1_COUNT_USED_gte: Optional[int] = None
    delta1_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    delta1_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    delta1_EBAY_USED_SHIPPING_lte: Optional[int] = None
    delta1_EBAY_USED_SHIPPING_gte: Optional[int] = None
    delta1_LIGHTNING_DEAL_lte: Optional[int] = None
    delta1_LIGHTNING_DEAL_gte: Optional[int] = None
    delta1_LISTPRICE_lte: Optional[int] = None
    delta1_LISTPRICE_gte: Optional[int] = None
    delta1_NEW_lte: Optional[int] = None
    delta1_NEW_gte: Optional[int] = None
    delta1_NEW_FBA_lte: Optional[int] = None
    delta1_NEW_FBA_gte: Optional[int] = None
    delta1_NEW_FBM_SHIPPING_lte: Optional[int] = None
    delta1_NEW_FBM_SHIPPING_gte: Optional[int] = None
    delta1_PRIME_EXCL_lte: Optional[int] = None
    delta1_PRIME_EXCL_gte: Optional[int] = None
    delta1_RATING_lte: Optional[int] = None
    delta1_RATING_gte: Optional[int] = None
    delta1_REFURBISHED_lte: Optional[int] = None
    delta1_REFURBISHED_gte: Optional[int] = None
    delta1_REFURBISHED_SHIPPING_lte: Optional[int] = None
    delta1_REFURBISHED_SHIPPING_gte: Optional[int] = None
    delta1_RENT_lte: Optional[int] = None
    delta1_RENT_gte: Optional[int] = None
    delta1_SALES_lte: Optional[int] = None
    delta1_SALES_gte: Optional[int] = None
    delta1_TRADE_IN_lte: Optional[int] = None
    delta1_TRADE_IN_gte: Optional[int] = None
    delta1_USED_lte: Optional[int] = None
    delta1_USED_gte: Optional[int] = None
    delta1_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    delta1_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    delta1_USED_GOOD_SHIPPING_lte: Optional[int] = None
    delta1_USED_GOOD_SHIPPING_gte: Optional[int] = None
    delta1_USED_NEW_SHIPPING_lte: Optional[int] = None
    delta1_USED_NEW_SHIPPING_gte: Optional[int] = None
    delta1_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    delta1_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    delta1_WAREHOUSE_lte: Optional[int] = None
    delta1_WAREHOUSE_gte: Optional[int] = None
    delta30_AMAZON_lte: Optional[int] = None
    delta30_AMAZON_gte: Optional[int] = None
    delta30_BUY_BOX_SHIPPING_lte: Optional[int] = None
    delta30_BUY_BOX_SHIPPING_gte: Optional[int] = None
    delta30_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    delta30_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    delta30_COLLECTIBLE_lte: Optional[int] = None
    delta30_COLLECTIBLE_gte: Optional[int] = None
    delta30_COUNT_COLLECTIBLE_lte: Optional[int] = None
    delta30_COUNT_COLLECTIBLE_gte: Optional[int] = None
    delta30_COUNT_NEW_lte: Optional[int] = None
    delta30_COUNT_NEW_gte: Optional[int] = None
    delta30_COUNT_REFURBISHED_lte: Optional[int] = None
    delta30_COUNT_REFURBISHED_gte: Optional[int] = None
    delta30_COUNT_REVIEWS_lte: Optional[int] = None
    delta30_COUNT_REVIEWS_gte: Optional[int] = None
    delta30_COUNT_USED_lte: Optional[int] = None
    delta30_COUNT_USED_gte: Optional[int] = None
    delta30_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    delta30_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    delta30_EBAY_USED_SHIPPING_lte: Optional[int] = None
    delta30_EBAY_USED_SHIPPING_gte: Optional[int] = None
    delta30_LIGHTNING_DEAL_lte: Optional[int] = None
    delta30_LIGHTNING_DEAL_gte: Optional[int] = None
    delta30_LISTPRICE_lte: Optional[int] = None
    delta30_LISTPRICE_gte: Optional[int] = None
    delta30_NEW_lte: Optional[int] = None
    delta30_NEW_gte: Optional[int] = None
    delta30_NEW_FBA_lte: Optional[int] = None
    delta30_NEW_FBA_gte: Optional[int] = None
    delta30_NEW_FBM_SHIPPING_lte: Optional[int] = None
    delta30_NEW_FBM_SHIPPING_gte: Optional[int] = None
    delta30_PRIME_EXCL_lte: Optional[int] = None
    delta30_PRIME_EXCL_gte: Optional[int] = None
    delta30_RATING_lte: Optional[int] = None
    delta30_RATING_gte: Optional[int] = None
    delta30_REFURBISHED_lte: Optional[int] = None
    delta30_REFURBISHED_gte: Optional[int] = None
    delta30_REFURBISHED_SHIPPING_lte: Optional[int] = None
    delta30_REFURBISHED_SHIPPING_gte: Optional[int] = None
    delta30_RENT_lte: Optional[int] = None
    delta30_RENT_gte: Optional[int] = None
    delta30_SALES_lte: Optional[int] = None
    delta30_SALES_gte: Optional[int] = None
    delta30_TRADE_IN_lte: Optional[int] = None
    delta30_TRADE_IN_gte: Optional[int] = None
    delta30_USED_lte: Optional[int] = None
    delta30_USED_gte: Optional[int] = None
    delta30_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    delta30_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    delta30_USED_GOOD_SHIPPING_lte: Optional[int] = None
    delta30_USED_GOOD_SHIPPING_gte: Optional[int] = None
    delta30_USED_NEW_SHIPPING_lte: Optional[int] = None
    delta30_USED_NEW_SHIPPING_gte: Optional[int] = None
    delta30_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    delta30_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    delta30_WAREHOUSE_lte: Optional[int] = None
    delta30_WAREHOUSE_gte: Optional[int] = None
    delta7_AMAZON_lte: Optional[int] = None
    delta7_AMAZON_gte: Optional[int] = None
    delta7_BUY_BOX_SHIPPING_lte: Optional[int] = None
    delta7_BUY_BOX_SHIPPING_gte: Optional[int] = None
    delta7_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    delta7_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    delta7_COLLECTIBLE_lte: Optional[int] = None
    delta7_COLLECTIBLE_gte: Optional[int] = None
    delta7_COUNT_COLLECTIBLE_lte: Optional[int] = None
    delta7_COUNT_COLLECTIBLE_gte: Optional[int] = None
    delta7_COUNT_NEW_lte: Optional[int] = None
    delta7_COUNT_NEW_gte: Optional[int] = None
    delta7_COUNT_REFURBISHED_lte: Optional[int] = None
    delta7_COUNT_REFURBISHED_gte: Optional[int] = None
    delta7_COUNT_REVIEWS_lte: Optional[int] = None
    delta7_COUNT_REVIEWS_gte: Optional[int] = None
    delta7_COUNT_USED_lte: Optional[int] = None
    delta7_COUNT_USED_gte: Optional[int] = None
    delta7_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    delta7_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    delta7_EBAY_USED_SHIPPING_lte: Optional[int] = None
    delta7_EBAY_USED_SHIPPING_gte: Optional[int] = None
    delta7_LIGHTNING_DEAL_lte: Optional[int] = None
    delta7_LIGHTNING_DEAL_gte: Optional[int] = None
    delta7_LISTPRICE_lte: Optional[int] = None
    delta7_LISTPRICE_gte: Optional[int] = None
    delta7_NEW_lte: Optional[int] = None
    delta7_NEW_gte: Optional[int] = None
    delta7_NEW_FBA_lte: Optional[int] = None
    delta7_NEW_FBA_gte: Optional[int] = None
    delta7_NEW_FBM_SHIPPING_lte: Optional[int] = None
    delta7_NEW_FBM_SHIPPING_gte: Optional[int] = None
    delta7_PRIME_EXCL_lte: Optional[int] = None
    delta7_PRIME_EXCL_gte: Optional[int] = None
    delta7_RATING_lte: Optional[int] = None
    delta7_RATING_gte: Optional[int] = None
    delta7_REFURBISHED_lte: Optional[int] = None
    delta7_REFURBISHED_gte: Optional[int] = None
    delta7_REFURBISHED_SHIPPING_lte: Optional[int] = None
    delta7_REFURBISHED_SHIPPING_gte: Optional[int] = None
    delta7_RENT_lte: Optional[int] = None
    delta7_RENT_gte: Optional[int] = None
    delta7_SALES_lte: Optional[int] = None
    delta7_SALES_gte: Optional[int] = None
    delta7_TRADE_IN_lte: Optional[int] = None
    delta7_TRADE_IN_gte: Optional[int] = None
    delta7_USED_lte: Optional[int] = None
    delta7_USED_gte: Optional[int] = None
    delta7_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    delta7_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    delta7_USED_GOOD_SHIPPING_lte: Optional[int] = None
    delta7_USED_GOOD_SHIPPING_gte: Optional[int] = None
    delta7_USED_NEW_SHIPPING_lte: Optional[int] = None
    delta7_USED_NEW_SHIPPING_gte: Optional[int] = None
    delta7_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    delta7_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    delta7_WAREHOUSE_lte: Optional[int] = None
    delta7_WAREHOUSE_gte: Optional[int] = None
    delta90_AMAZON_lte: Optional[int] = None
    delta90_AMAZON_gte: Optional[int] = None
    delta90_BUY_BOX_SHIPPING_lte: Optional[int] = None
    delta90_BUY_BOX_SHIPPING_gte: Optional[int] = None
    delta90_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    delta90_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    delta90_COLLECTIBLE_lte: Optional[int] = None
    delta90_COLLECTIBLE_gte: Optional[int] = None
    delta90_COUNT_COLLECTIBLE_lte: Optional[int] = None
    delta90_COUNT_COLLECTIBLE_gte: Optional[int] = None
    delta90_COUNT_NEW_lte: Optional[int] = None
    delta90_COUNT_NEW_gte: Optional[int] = None
    delta90_COUNT_REFURBISHED_lte: Optional[int] = None
    delta90_COUNT_REFURBISHED_gte: Optional[int] = None
    delta90_COUNT_REVIEWS_lte: Optional[int] = None
    delta90_COUNT_REVIEWS_gte: Optional[int] = None
    delta90_COUNT_USED_lte: Optional[int] = None
    delta90_COUNT_USED_gte: Optional[int] = None
    delta90_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    delta90_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    delta90_EBAY_USED_SHIPPING_lte: Optional[int] = None
    delta90_EBAY_USED_SHIPPING_gte: Optional[int] = None
    delta90_LIGHTNING_DEAL_lte: Optional[int] = None
    delta90_LIGHTNING_DEAL_gte: Optional[int] = None
    delta90_LISTPRICE_lte: Optional[int] = None
    delta90_LISTPRICE_gte: Optional[int] = None
    delta90_NEW_lte: Optional[int] = None
    delta90_NEW_gte: Optional[int] = None
    delta90_NEW_FBA_lte: Optional[int] = None
    delta90_NEW_FBA_gte: Optional[int] = None
    delta90_NEW_FBM_SHIPPING_lte: Optional[int] = None
    delta90_NEW_FBM_SHIPPING_gte: Optional[int] = None
    delta90_PRIME_EXCL_lte: Optional[int] = None
    delta90_PRIME_EXCL_gte: Optional[int] = None
    delta90_RATING_lte: Optional[int] = None
    delta90_RATING_gte: Optional[int] = None
    delta90_REFURBISHED_lte: Optional[int] = None
    delta90_REFURBISHED_gte: Optional[int] = None
    delta90_REFURBISHED_SHIPPING_lte: Optional[int] = None
    delta90_REFURBISHED_SHIPPING_gte: Optional[int] = None
    delta90_RENT_lte: Optional[int] = None
    delta90_RENT_gte: Optional[int] = None
    delta90_SALES_lte: Optional[int] = None
    delta90_SALES_gte: Optional[int] = None
    delta90_TRADE_IN_lte: Optional[int] = None
    delta90_TRADE_IN_gte: Optional[int] = None
    delta90_USED_lte: Optional[int] = None
    delta90_USED_gte: Optional[int] = None
    delta90_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    delta90_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    delta90_USED_GOOD_SHIPPING_lte: Optional[int] = None
    delta90_USED_GOOD_SHIPPING_gte: Optional[int] = None
    delta90_USED_NEW_SHIPPING_lte: Optional[int] = None
    delta90_USED_NEW_SHIPPING_gte: Optional[int] = None
    delta90_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    delta90_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    delta90_WAREHOUSE_lte: Optional[int] = None
    delta90_WAREHOUSE_gte: Optional[int] = None
    deltaLast_AMAZON_lte: Optional[int] = None
    deltaLast_AMAZON_gte: Optional[int] = None
    deltaLast_BUY_BOX_SHIPPING_lte: Optional[int] = None
    deltaLast_BUY_BOX_SHIPPING_gte: Optional[int] = None
    deltaLast_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    deltaLast_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    deltaLast_COLLECTIBLE_lte: Optional[int] = None
    deltaLast_COLLECTIBLE_gte: Optional[int] = None
    deltaLast_COUNT_COLLECTIBLE_lte: Optional[int] = None
    deltaLast_COUNT_COLLECTIBLE_gte: Optional[int] = None
    deltaLast_COUNT_NEW_lte: Optional[int] = None
    deltaLast_COUNT_NEW_gte: Optional[int] = None
    deltaLast_COUNT_REFURBISHED_lte: Optional[int] = None
    deltaLast_COUNT_REFURBISHED_gte: Optional[int] = None
    deltaLast_COUNT_REVIEWS_lte: Optional[int] = None
    deltaLast_COUNT_REVIEWS_gte: Optional[int] = None
    deltaLast_COUNT_USED_lte: Optional[int] = None
    deltaLast_COUNT_USED_gte: Optional[int] = None
    deltaLast_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    deltaLast_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    deltaLast_EBAY_USED_SHIPPING_lte: Optional[int] = None
    deltaLast_EBAY_USED_SHIPPING_gte: Optional[int] = None
    deltaLast_LIGHTNING_DEAL_lte: Optional[int] = None
    deltaLast_LIGHTNING_DEAL_gte: Optional[int] = None
    deltaLast_LISTPRICE_lte: Optional[int] = None
    deltaLast_LISTPRICE_gte: Optional[int] = None
    deltaLast_NEW_lte: Optional[int] = None
    deltaLast_NEW_gte: Optional[int] = None
    deltaLast_NEW_FBA_lte: Optional[int] = None
    deltaLast_NEW_FBA_gte: Optional[int] = None
    deltaLast_NEW_FBM_SHIPPING_lte: Optional[int] = None
    deltaLast_NEW_FBM_SHIPPING_gte: Optional[int] = None
    deltaLast_PRIME_EXCL_lte: Optional[int] = None
    deltaLast_PRIME_EXCL_gte: Optional[int] = None
    deltaLast_RATING_lte: Optional[int] = None
    deltaLast_RATING_gte: Optional[int] = None
    deltaLast_REFURBISHED_lte: Optional[int] = None
    deltaLast_REFURBISHED_gte: Optional[int] = None
    deltaLast_REFURBISHED_SHIPPING_lte: Optional[int] = None
    deltaLast_REFURBISHED_SHIPPING_gte: Optional[int] = None
    deltaLast_RENT_lte: Optional[int] = None
    deltaLast_RENT_gte: Optional[int] = None
    deltaLast_SALES_lte: Optional[int] = None
    deltaLast_SALES_gte: Optional[int] = None
    deltaLast_TRADE_IN_lte: Optional[int] = None
    deltaLast_TRADE_IN_gte: Optional[int] = None
    deltaLast_USED_lte: Optional[int] = None
    deltaLast_USED_gte: Optional[int] = None
    deltaLast_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    deltaLast_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    deltaLast_USED_GOOD_SHIPPING_lte: Optional[int] = None
    deltaLast_USED_GOOD_SHIPPING_gte: Optional[int] = None
    deltaLast_USED_NEW_SHIPPING_lte: Optional[int] = None
    deltaLast_USED_NEW_SHIPPING_gte: Optional[int] = None
    deltaLast_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    deltaLast_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    deltaLast_WAREHOUSE_lte: Optional[int] = None
    deltaLast_WAREHOUSE_gte: Optional[int] = None
    deltaPercent1_AMAZON_lte: Optional[int] = None
    deltaPercent1_AMAZON_gte: Optional[int] = None
    deltaPercent1_BUY_BOX_SHIPPING_lte: Optional[int] = None
    deltaPercent1_BUY_BOX_SHIPPING_gte: Optional[int] = None
    deltaPercent1_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    deltaPercent1_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    deltaPercent1_COLLECTIBLE_lte: Optional[int] = None
    deltaPercent1_COLLECTIBLE_gte: Optional[int] = None
    deltaPercent1_COUNT_COLLECTIBLE_lte: Optional[int] = None
    deltaPercent1_COUNT_COLLECTIBLE_gte: Optional[int] = None
    deltaPercent1_COUNT_NEW_lte: Optional[int] = None
    deltaPercent1_COUNT_NEW_gte: Optional[int] = None
    deltaPercent1_COUNT_REFURBISHED_lte: Optional[int] = None
    deltaPercent1_COUNT_REFURBISHED_gte: Optional[int] = None
    deltaPercent1_COUNT_REVIEWS_lte: Optional[int] = None
    deltaPercent1_COUNT_REVIEWS_gte: Optional[int] = None
    deltaPercent1_COUNT_USED_lte: Optional[int] = None
    deltaPercent1_COUNT_USED_gte: Optional[int] = None
    deltaPercent1_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    deltaPercent1_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    deltaPercent1_EBAY_USED_SHIPPING_lte: Optional[int] = None
    deltaPercent1_EBAY_USED_SHIPPING_gte: Optional[int] = None
    deltaPercent1_LIGHTNING_DEAL_lte: Optional[int] = None
    deltaPercent1_LIGHTNING_DEAL_gte: Optional[int] = None
    deltaPercent1_LISTPRICE_lte: Optional[int] = None
    deltaPercent1_LISTPRICE_gte: Optional[int] = None
    deltaPercent1_NEW_lte: Optional[int] = None
    deltaPercent1_NEW_gte: Optional[int] = None
    deltaPercent1_NEW_FBA_lte: Optional[int] = None
    deltaPercent1_NEW_FBA_gte: Optional[int] = None
    deltaPercent1_NEW_FBM_SHIPPING_lte: Optional[int] = None
    deltaPercent1_NEW_FBM_SHIPPING_gte: Optional[int] = None
    deltaPercent1_PRIME_EXCL_lte: Optional[int] = None
    deltaPercent1_PRIME_EXCL_gte: Optional[int] = None
    deltaPercent1_RATING_lte: Optional[int] = None
    deltaPercent1_RATING_gte: Optional[int] = None
    deltaPercent1_REFURBISHED_lte: Optional[int] = None
    deltaPercent1_REFURBISHED_gte: Optional[int] = None
    deltaPercent1_REFURBISHED_SHIPPING_lte: Optional[int] = None
    deltaPercent1_REFURBISHED_SHIPPING_gte: Optional[int] = None
    deltaPercent1_RENT_lte: Optional[int] = None
    deltaPercent1_RENT_gte: Optional[int] = None
    deltaPercent1_SALES_lte: Optional[int] = None
    deltaPercent1_SALES_gte: Optional[int] = None
    deltaPercent1_TRADE_IN_lte: Optional[int] = None
    deltaPercent1_TRADE_IN_gte: Optional[int] = None
    deltaPercent1_USED_lte: Optional[int] = None
    deltaPercent1_USED_gte: Optional[int] = None
    deltaPercent1_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    deltaPercent1_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    deltaPercent1_USED_GOOD_SHIPPING_lte: Optional[int] = None
    deltaPercent1_USED_GOOD_SHIPPING_gte: Optional[int] = None
    deltaPercent1_USED_NEW_SHIPPING_lte: Optional[int] = None
    deltaPercent1_USED_NEW_SHIPPING_gte: Optional[int] = None
    deltaPercent1_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    deltaPercent1_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    deltaPercent1_WAREHOUSE_lte: Optional[int] = None
    deltaPercent1_WAREHOUSE_gte: Optional[int] = None
    deltaPercent30_AMAZON_lte: Optional[int] = None
    deltaPercent30_AMAZON_gte: Optional[int] = None
    deltaPercent30_BUY_BOX_SHIPPING_lte: Optional[int] = None
    deltaPercent30_BUY_BOX_SHIPPING_gte: Optional[int] = None
    deltaPercent30_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    deltaPercent30_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    deltaPercent30_COLLECTIBLE_lte: Optional[int] = None
    deltaPercent30_COLLECTIBLE_gte: Optional[int] = None
    deltaPercent30_COUNT_COLLECTIBLE_lte: Optional[int] = None
    deltaPercent30_COUNT_COLLECTIBLE_gte: Optional[int] = None
    deltaPercent30_COUNT_NEW_lte: Optional[int] = None
    deltaPercent30_COUNT_NEW_gte: Optional[int] = None
    deltaPercent30_COUNT_REFURBISHED_lte: Optional[int] = None
    deltaPercent30_COUNT_REFURBISHED_gte: Optional[int] = None
    deltaPercent30_COUNT_REVIEWS_lte: Optional[int] = None
    deltaPercent30_COUNT_REVIEWS_gte: Optional[int] = None
    deltaPercent30_COUNT_USED_lte: Optional[int] = None
    deltaPercent30_COUNT_USED_gte: Optional[int] = None
    deltaPercent30_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    deltaPercent30_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    deltaPercent30_EBAY_USED_SHIPPING_lte: Optional[int] = None
    deltaPercent30_EBAY_USED_SHIPPING_gte: Optional[int] = None
    deltaPercent30_LIGHTNING_DEAL_lte: Optional[int] = None
    deltaPercent30_LIGHTNING_DEAL_gte: Optional[int] = None
    deltaPercent30_LISTPRICE_lte: Optional[int] = None
    deltaPercent30_LISTPRICE_gte: Optional[int] = None
    deltaPercent30_NEW_lte: Optional[int] = None
    deltaPercent30_NEW_gte: Optional[int] = None
    deltaPercent30_NEW_FBA_lte: Optional[int] = None
    deltaPercent30_NEW_FBA_gte: Optional[int] = None
    deltaPercent30_NEW_FBM_SHIPPING_lte: Optional[int] = None
    deltaPercent30_NEW_FBM_SHIPPING_gte: Optional[int] = None
    deltaPercent30_PRIME_EXCL_lte: Optional[int] = None
    deltaPercent30_PRIME_EXCL_gte: Optional[int] = None
    deltaPercent30_RATING_lte: Optional[int] = None
    deltaPercent30_RATING_gte: Optional[int] = None
    deltaPercent30_REFURBISHED_lte: Optional[int] = None
    deltaPercent30_REFURBISHED_gte: Optional[int] = None
    deltaPercent30_REFURBISHED_SHIPPING_lte: Optional[int] = None
    deltaPercent30_REFURBISHED_SHIPPING_gte: Optional[int] = None
    deltaPercent30_RENT_lte: Optional[int] = None
    deltaPercent30_RENT_gte: Optional[int] = None
    deltaPercent30_SALES_lte: Optional[int] = None
    deltaPercent30_SALES_gte: Optional[int] = None
    deltaPercent30_TRADE_IN_lte: Optional[int] = None
    deltaPercent30_TRADE_IN_gte: Optional[int] = None
    deltaPercent30_USED_lte: Optional[int] = None
    deltaPercent30_USED_gte: Optional[int] = None
    deltaPercent30_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    deltaPercent30_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    deltaPercent30_USED_GOOD_SHIPPING_lte: Optional[int] = None
    deltaPercent30_USED_GOOD_SHIPPING_gte: Optional[int] = None
    deltaPercent30_USED_NEW_SHIPPING_lte: Optional[int] = None
    deltaPercent30_USED_NEW_SHIPPING_gte: Optional[int] = None
    deltaPercent30_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    deltaPercent30_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    deltaPercent30_WAREHOUSE_lte: Optional[int] = None
    deltaPercent30_WAREHOUSE_gte: Optional[int] = None
    deltaPercent7_AMAZON_lte: Optional[int] = None
    deltaPercent7_AMAZON_gte: Optional[int] = None
    deltaPercent7_BUY_BOX_SHIPPING_lte: Optional[int] = None
    deltaPercent7_BUY_BOX_SHIPPING_gte: Optional[int] = None
    deltaPercent7_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    deltaPercent7_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    deltaPercent7_COLLECTIBLE_lte: Optional[int] = None
    deltaPercent7_COLLECTIBLE_gte: Optional[int] = None
    deltaPercent7_COUNT_COLLECTIBLE_lte: Optional[int] = None
    deltaPercent7_COUNT_COLLECTIBLE_gte: Optional[int] = None
    deltaPercent7_COUNT_NEW_lte: Optional[int] = None
    deltaPercent7_COUNT_NEW_gte: Optional[int] = None
    deltaPercent7_COUNT_REFURBISHED_lte: Optional[int] = None
    deltaPercent7_COUNT_REFURBISHED_gte: Optional[int] = None
    deltaPercent7_COUNT_REVIEWS_lte: Optional[int] = None
    deltaPercent7_COUNT_REVIEWS_gte: Optional[int] = None
    deltaPercent7_COUNT_USED_lte: Optional[int] = None
    deltaPercent7_COUNT_USED_gte: Optional[int] = None
    deltaPercent7_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    deltaPercent7_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    deltaPercent7_EBAY_USED_SHIPPING_lte: Optional[int] = None
    deltaPercent7_EBAY_USED_SHIPPING_gte: Optional[int] = None
    deltaPercent7_LIGHTNING_DEAL_lte: Optional[int] = None
    deltaPercent7_LIGHTNING_DEAL_gte: Optional[int] = None
    deltaPercent7_LISTPRICE_lte: Optional[int] = None
    deltaPercent7_LISTPRICE_gte: Optional[int] = None
    deltaPercent7_NEW_lte: Optional[int] = None
    deltaPercent7_NEW_gte: Optional[int] = None
    deltaPercent7_NEW_FBA_lte: Optional[int] = None
    deltaPercent7_NEW_FBA_gte: Optional[int] = None
    deltaPercent7_NEW_FBM_SHIPPING_lte: Optional[int] = None
    deltaPercent7_NEW_FBM_SHIPPING_gte: Optional[int] = None
    deltaPercent7_PRIME_EXCL_lte: Optional[int] = None
    deltaPercent7_PRIME_EXCL_gte: Optional[int] = None
    deltaPercent7_RATING_lte: Optional[int] = None
    deltaPercent7_RATING_gte: Optional[int] = None
    deltaPercent7_REFURBISHED_lte: Optional[int] = None
    deltaPercent7_REFURBISHED_gte: Optional[int] = None
    deltaPercent7_REFURBISHED_SHIPPING_lte: Optional[int] = None
    deltaPercent7_REFURBISHED_SHIPPING_gte: Optional[int] = None
    deltaPercent7_RENT_lte: Optional[int] = None
    deltaPercent7_RENT_gte: Optional[int] = None
    deltaPercent7_SALES_lte: Optional[int] = None
    deltaPercent7_SALES_gte: Optional[int] = None
    deltaPercent7_TRADE_IN_lte: Optional[int] = None
    deltaPercent7_TRADE_IN_gte: Optional[int] = None
    deltaPercent7_USED_lte: Optional[int] = None
    deltaPercent7_USED_gte: Optional[int] = None
    deltaPercent7_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    deltaPercent7_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    deltaPercent7_USED_GOOD_SHIPPING_lte: Optional[int] = None
    deltaPercent7_USED_GOOD_SHIPPING_gte: Optional[int] = None
    deltaPercent7_USED_NEW_SHIPPING_lte: Optional[int] = None
    deltaPercent7_USED_NEW_SHIPPING_gte: Optional[int] = None
    deltaPercent7_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    deltaPercent7_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    deltaPercent7_WAREHOUSE_lte: Optional[int] = None
    deltaPercent7_WAREHOUSE_gte: Optional[int] = None
    deltaPercent90_AMAZON_lte: Optional[int] = None
    deltaPercent90_AMAZON_gte: Optional[int] = None
    deltaPercent90_BUY_BOX_SHIPPING_lte: Optional[int] = None
    deltaPercent90_BUY_BOX_SHIPPING_gte: Optional[int] = None
    deltaPercent90_BUY_BOX_USED_SHIPPING_lte: Optional[int] = None
    deltaPercent90_BUY_BOX_USED_SHIPPING_gte: Optional[int] = None
    deltaPercent90_COLLECTIBLE_lte: Optional[int] = None
    deltaPercent90_COLLECTIBLE_gte: Optional[int] = None
    deltaPercent90_COUNT_COLLECTIBLE_lte: Optional[int] = None
    deltaPercent90_COUNT_COLLECTIBLE_gte: Optional[int] = None
    deltaPercent90_COUNT_NEW_lte: Optional[int] = None
    deltaPercent90_COUNT_NEW_gte: Optional[int] = None
    deltaPercent90_COUNT_REFURBISHED_lte: Optional[int] = None
    deltaPercent90_COUNT_REFURBISHED_gte: Optional[int] = None
    deltaPercent90_COUNT_REVIEWS_lte: Optional[int] = None
    deltaPercent90_COUNT_REVIEWS_gte: Optional[int] = None
    deltaPercent90_COUNT_USED_lte: Optional[int] = None
    deltaPercent90_COUNT_USED_gte: Optional[int] = None
    deltaPercent90_EBAY_NEW_SHIPPING_lte: Optional[int] = None
    deltaPercent90_EBAY_NEW_SHIPPING_gte: Optional[int] = None
    deltaPercent90_EBAY_USED_SHIPPING_lte: Optional[int] = None
    deltaPercent90_EBAY_USED_SHIPPING_gte: Optional[int] = None
    deltaPercent90_LIGHTNING_DEAL_lte: Optional[int] = None
    deltaPercent90_LIGHTNING_DEAL_gte: Optional[int] = None
    deltaPercent90_LISTPRICE_lte: Optional[int] = None
    deltaPercent90_LISTPRICE_gte: Optional[int] = None
    deltaPercent90_NEW_lte: Optional[int] = None
    deltaPercent90_NEW_gte: Optional[int] = None
    deltaPercent90_NEW_FBA_lte: Optional[int] = None
    deltaPercent90_NEW_FBA_gte: Optional[int] = None
    deltaPercent90_NEW_FBM_SHIPPING_lte: Optional[int] = None
    deltaPercent90_NEW_FBM_SHIPPING_gte: Optional[int] = None
    deltaPercent90_PRIME_EXCL_lte: Optional[int] = None
    deltaPercent90_PRIME_EXCL_gte: Optional[int] = None
    deltaPercent90_RATING_lte: Optional[int] = None
    deltaPercent90_RATING_gte: Optional[int] = None
    deltaPercent90_REFURBISHED_lte: Optional[int] = None
    deltaPercent90_REFURBISHED_gte: Optional[int] = None
    deltaPercent90_REFURBISHED_SHIPPING_lte: Optional[int] = None
    deltaPercent90_REFURBISHED_SHIPPING_gte: Optional[int] = None
    deltaPercent90_RENT_lte: Optional[int] = None
    deltaPercent90_RENT_gte: Optional[int] = None
    deltaPercent90_SALES_lte: Optional[int] = None
    deltaPercent90_SALES_gte: Optional[int] = None
    deltaPercent90_TRADE_IN_lte: Optional[int] = None
    deltaPercent90_TRADE_IN_gte: Optional[int] = None
    deltaPercent90_USED_lte: Optional[int] = None
    deltaPercent90_USED_gte: Optional[int] = None
    deltaPercent90_USED_ACCEPTABLE_SHIPPING_lte: Optional[int] = None
    deltaPercent90_USED_ACCEPTABLE_SHIPPING_gte: Optional[int] = None
    deltaPercent90_USED_GOOD_SHIPPING_lte: Optional[int] = None
    deltaPercent90_USED_GOOD_SHIPPING_gte: Optional[int] = None
    deltaPercent90_USED_NEW_SHIPPING_lte: Optional[int] = None
    deltaPercent90_USED_NEW_SHIPPING_gte: Optional[int] = None
    deltaPercent90_USED_VERY_GOOD_SHIPPING_lte: Optional[int] = None
    deltaPercent90_USED_VERY_GOOD_SHIPPING_gte: Optional[int] = None
    deltaPercent90_WAREHOUSE_lte: Optional[int] = None
    deltaPercent90_WAREHOUSE_gte: Optional[int] = None
    edition: Optional[Union[list[str], str]] = None
    fbaFees_lte: Optional[int] = None
    fbaFees_gte: Optional[int] = None
    format: Optional[Union[list[str], str]] = None
    genre: Optional[Union[list[str], str]] = None
    hasParentASIN: Optional[bool] = None
    hasReviews: Optional[bool] = None
    isAdultProduct: Optional[bool] = None
    isEligibleForSuperSaverShipping: Optional[bool] = None
    isEligibleForTradeIn: Optional[bool] = None
    isHighestOffer: Optional[bool] = None
    isLowestOffer: Optional[bool] = None
    isLowest_AMAZON: Optional[bool] = None
    isLowest_BUY_BOX_SHIPPING: Optional[bool] = None
    isLowest_BUY_BOX_USED_SHIPPING: Optional[bool] = None
    isLowest_COLLECTIBLE: Optional[bool] = None
    isLowest_COUNT_COLLECTIBLE: Optional[bool] = None
    isLowest_COUNT_NEW: Optional[bool] = None
    isLowest_COUNT_REFURBISHED: Optional[bool] = None
    isLowest_COUNT_REVIEWS: Optional[bool] = None
    isLowest_COUNT_USED: Optional[bool] = None
    isLowest_EBAY_NEW_SHIPPING: Optional[bool] = None
    isLowest_EBAY_USED_SHIPPING: Optional[bool] = None
    isLowest_LIGHTNING_DEAL: Optional[bool] = None
    isLowest_LISTPRICE: Optional[bool] = None
    isLowest_NEW: Optional[bool] = None
    isLowest_NEW_FBA: Optional[bool] = None
    isLowest_NEW_FBM_SHIPPING: Optional[bool] = None
    isLowest_PRIME_EXCL: Optional[bool] = None
    isLowest_RATING: Optional[bool] = None
    isLowest_REFURBISHED: Optional[bool] = None
    isLowest_REFURBISHED_SHIPPING: Optional[bool] = None
    isLowest_RENT: Optional[bool] = None
    isLowest_SALES: Optional[bool] = None
    isLowest_TRADE_IN: Optional[bool] = None
    isLowest_USED: Optional[bool] = None
    isLowest_USED_ACCEPTABLE_SHIPPING: Optional[bool] = None
    isLowest_USED_GOOD_SHIPPING: Optional[bool] = None
    isLowest_USED_NEW_SHIPPING: Optional[bool] = None
    isLowest_USED_VERY_GOOD_SHIPPING: Optional[bool] = None
    isLowest_WAREHOUSE: Optional[bool] = None
    isPrimeExclusive: Optional[bool] = None
    isSNS: Optional[bool] = None
    itemDimension_lte: Optional[int] = None
    itemDimension_gte: Optional[int] = None
    itemHeight_lte: Optional[int] = None
    itemHeight_gte: Optional[int] = None
    itemLength_lte: Optional[int] = None
    itemLength_gte: Optional[int] = None
    itemWeight_lte: Optional[int] = None
    itemWeight_gte: Optional[int] = None
    itemWidth_lte: Optional[int] = None
    itemWidth_gte: Optional[int] = None
    label: Optional[Union[list[str], str]] = None
    languages: Optional[Union[list[str], str]] = None
    lastOffersUpdate_lte: Optional[int] = None
    lastOffersUpdate_gte: Optional[int] = None
    lastPriceChange_lte: Optional[int] = None
    lastPriceChange_gte: Optional[int] = None
    lastRatingUpdate_lte: Optional[int] = None
    lastRatingUpdate_gte: Optional[int] = None
    lastUpdate_lte: Optional[int] = None
    lastUpdate_gte: Optional[int] = None
    lightningEnd_lte: Optional[int] = None
    lightningEnd_gte: Optional[int] = None
    lightningStart_lte: Optional[int] = None
    lightningStart_gte: Optional[int] = None
    listedSince_lte: Optional[int] = None
    listedSince_gte: Optional[int] = None
    manufacturer: Optional[Union[list[str], str]] = None
    model: Optional[Union[list[str], str]] = None
    newPriceIsMAP: Optional[bool] = None
    nextUpdate_lte: Optional[int] = None
    nextUpdate_gte: Optional[int] = None
    numberOfItems_lte: Optional[int] = None
    numberOfItems_gte: Optional[int] = None
    numberOfPages_lte: Optional[int] = None
    numberOfPages_gte: Optional[int] = None
    numberOfTrackings_lte: Optional[int] = None
    numberOfTrackings_gte: Optional[int] = None
    offerCountFBA_lte: Optional[int] = None
    offerCountFBA_gte: Optional[int] = None
    offerCountFBM_lte: Optional[int] = None
    offerCountFBM_gte: Optional[int] = None
    outOfStockPercentage90_BB_lte: Optional[int] = None
    outOfStockPercentage90_BB_gte: Optional[int] = None
    outOfStockPercentage90_BB_USED_lte: Optional[int] = None
    outOfStockPercentage90_BB_USED_gte: Optional[int] = None
    outOfStockPercentage90_NEW_lte: Optional[int] = None
    outOfStockPercentage90_NEW_gte: Optional[int] = None
    outOfStockPercentage90_USED_lte: Optional[int] = None
    outOfStockPercentage90_USED_gte: Optional[int] = None
    outOfStockPercentageInInterval_lte: Optional[int] = None
    outOfStockPercentageInInterval_gte: Optional[int] = None
    packageDimension_lte: Optional[int] = None
    packageDimension_gte: Optional[int] = None
    packageHeight_lte: Optional[int] = None
    packageHeight_gte: Optional[int] = None
    packageLength_lte: Optional[int] = None
    packageLength_gte: Optional[int] = None
    packageQuantity_lte: Optional[int] = None
    packageQuantity_gte: Optional[int] = None
    packageWeight_lte: Optional[int] = None
    packageWeight_gte: Optional[int] = None
    packageWidth_lte: Optional[int] = None
    packageWidth_gte: Optional[int] = None
    partNumber: Optional[Union[list[str], str]] = None
    platform: Optional[Union[list[str], str]] = None
    productGroup: Optional[Union[list[str], str]] = None
    productType: Optional[int] = None
    publicationDate_lte: Optional[int] = None
    publicationDate_gte: Optional[int] = None
    publisher: Optional[Union[list[str], str]] = None
    releaseDate_lte: Optional[int] = None
    releaseDate_gte: Optional[int] = None
    rootCategory: Optional[int] = None
    salesRankDrops180_lte: Optional[int] = None
    salesRankDrops180_gte: Optional[int] = None
    salesRankDrops30_lte: Optional[int] = None
    salesRankDrops30_gte: Optional[int] = None
    salesRankDrops365_lte: Optional[int] = None
    salesRankDrops365_gte: Optional[int] = None
    salesRankDrops90_lte: Optional[int] = None
    salesRankDrops90_gte: Optional[int] = None
    salesRankReference: Optional[int] = None
    salesRankTopPct_lte: Optional[int] = None
    salesRankTopPct_gte: Optional[int] = None
    sellerIds: Optional[Union[list[str], str]] = None
    sellerIdsLowestFBA: Optional[Union[list[str], str]] = None
    sellerIdsLowestFBM: Optional[Union[list[str], str]] = None
    size: Optional[Union[list[str], str]] = None
    studio: Optional[Union[list[str], str]] = None
    title: Optional[str] = None
    title_flag: Optional[str] = None
    totalOfferCount_lte: Optional[int] = None
    totalOfferCount_gte: Optional[int] = None
    trackingSince_lte: Optional[int] = None
    trackingSince_gte: Optional[int] = None
    monthlySold_lte: Optional[int] = None
    monthlySold_gte: Optional[int] = None
    buyBoxIsPreorder: Optional[bool] = None
    buyBoxIsBackorder: Optional[bool] = None
    buyBoxIsPrimeExclusive: Optional[bool] = None
    type: Optional[Union[list[str], str]] = None
    warehouseCondition: Optional[int] = None
    singleVariation: Optional[bool] = None
    outOfStockPercentage90_lte: Optional[int] = None
    outOfStockPercentage90_gte: Optional[int] = None
    variationCount_lte: Optional[int] = None
    variationCount_gte: Optional[int] = None
    imageCount_lte: Optional[int] = None
    imageCount_gte: Optional[int] = None
    buyBoxStatsAmazon30_lte: Optional[int] = None
    buyBoxStatsAmazon30_gte: Optional[int] = None
    buyBoxStatsAmazon90_lte: Optional[int] = None
    buyBoxStatsAmazon90_gte: Optional[int] = None
    buyBoxStatsAmazon180_lte: Optional[int] = None
    buyBoxStatsAmazon180_gte: Optional[int] = None
    buyBoxStatsAmazon365_lte: Optional[int] = None
    buyBoxStatsAmazon365_gte: Optional[int] = None
    buyBoxStatsTopSeller30_lte: Optional[int] = None
    buyBoxStatsTopSeller30_gte: Optional[int] = None
    buyBoxStatsTopSeller90_lte: Optional[int] = None
    buyBoxStatsTopSeller90_gte: Optional[int] = None
    buyBoxStatsTopSeller180_lte: Optional[int] = None
    buyBoxStatsTopSeller180_gte: Optional[int] = None
    buyBoxStatsTopSeller365_lte: Optional[int] = None
    buyBoxStatsTopSeller365_gte: Optional[int] = None
    buyBoxStatsSellerCount30_lte: Optional[int] = None
    buyBoxStatsSellerCount30_gte: Optional[int] = None
    buyBoxStatsSellerCount90_lte: Optional[int] = None
    buyBoxStatsSellerCount90_gte: Optional[int] = None
    buyBoxStatsSellerCount180_lte: Optional[int] = None
    buyBoxStatsSellerCount180_gte: Optional[int] = None
    buyBoxStatsSellerCount365_lte: Optional[int] = None
    buyBoxStatsSellerCount365_gte: Optional[int] = None
    isHazMat: Optional[bool] = None
    perPage: Optional[int] = None
