# Types
If you're wondering about the meaning of the `type` or `clothing type` found in `items.dat`, I've got your back.


## Clothing Types
In the game, there are only 8 distinct clothing types. These categories define how clothing items are classified in items.dat. Here's the full list:

| Type | 1      | 2      | 3    | 4    | 5    | 6    | 7    | 8        |
|------|--------|--------|------|------|------|------|------|----------|
| Name | Shirt  | Pants  | Feet | Face | Hand | Back | Hair | Necklace |

Each number corresponds to a specific clothing category, helping the game determine how an item is equipped or displayed.
## Item Types

If you're delving into the world of `items.dat` and need clarity on the various item types, you're in the right place.

Please note that some type numbers are skipped for unknown reasons:
- Type No. 30
- Type No. 48
- Type No. 121
- Type No. 133
- Type No. 137
- Type No. 139

Refer to the table below for detailed information on each item types found in `items.dat`:
> [!NOTE]
> The `flag` field mentioned here isn’t part of `items.dat` itself; it’s something I use to help identify and differentiate certain unordinary items.

| Type | Name                                    | Flag    |
|------|-----------------------------------------|---------|
| 0    | Fist                                    | Special |
| 1    | Wrench                                  | Special |
| 2    | Door                                    |         |
| 3    | Lock                                    |         |
| 4    | Gems                                    | Special |
| 5    | Treasure                                |         |
| 6    | Deadly block                            |         |
| 7    | Trampoline Block                        |         |
| 8    | Consumable                              |         |
| 9    | Entrance                                |         |
| 10   | Sign                                    |         |
| 11   | SFX Block                               |         |
| 12   | Toggleable Animated Block               |         |
| 13   | Main Door                               | Special |
| 14   | Platform                                |         |
| 15   | Bedrock                                 | Special |
| 16   | Pain block (lava)                       |         |
| 17   | Foreground Block                        |         |
| 18   | Background Block                        |         |
| 19   | Seed                                    | Special |
| 20   | Clothes                                 |         |
| 21   | Animated Block                          |         |
| 22   | SFX Wallpaper                           |         |
| 23   | Toggleable Wallpaper                    |         |
| 24   | Bouncy Block                            |         |
| 25   | Pain Block (Spike)                      |         |
| 26   | Portal                                  |         |
| 27   | Checkpoint                              |         |
| 28   | Sheet Music                             |         |
| 29   | Slippery Block                          |         |
| 31   | Toggleable Block                        |         |
| 32   | Chest                                   |         |
| 33   | Mail                                    |         |
| 34   | Bulletin Board                          |         |
| 35   | Event Mystery Block                     |         |
| 36   | Random Block                            |         |
| 37   | Component                               |         |
| 38   | Provider                                |         |
| 39   | Chemical Combiner                       |         |
| 40   | Achievement Block                       |         |
| 41   | Weather Machine                         |         |
| 42   | Scoreboard                              |         |
| 43   | Sungate                                 |         |
| 44   | Profile                                 |         |
| 45   | Toggleable Deadly Block                 |         |
| 46   | Heart Monitor                           |         |
| 47   | Donation Box                            |         |
| 49   | Mannequin                               |         |
| 50   | Camera                                  |         |
| 51   | Magic Egg                               |         |
| 52   | Game Block                              |         |
| 53   | Game Generator                          |         |
| 54   | Xenonite Crystal                        |         |
| 55   | Phone Booth                             |         |
| 56   | Crystal                                 |         |
| 57   | Crime Villain                           |         |
| 58   | Clothing Compactor                      |         |
| 59   | Spotlight                               |         |
| 60   | Pushing Block                           |         |
| 61   | Display Block                           |         |
| 62   | Vending                                 |         |
| 63   | Fishtank Port                           |         |
| 64   | Fish                                    |         |
| 65   | Solar Collector                         |         |
| 66   | Forge                                   |         |
| 67   | Giving Tree                             |         |
| 68   | Giving Tree Stump                       |         |
| 69   | Steam Block                             |         |
| 70   | Steam Vent                              |         |
| 71   | Steam Organ                             |         |
| 72   | Silkworm                                |         |
| 73   | Sewing Machine                          |         |
| 74   | Country Flag                            |         |
| 75   | Lobster Trap                            |         |
| 76   | Painting Easel                          |         |
| 77   | Battle Pet Cage                         |         |
| 78   | Pet Trainer                             |         |
| 79   | Steam Engine                            |         |
| 80   | Lock-bot                                |         |
| 81   | Weather Machine                         |         |
| 82   | Spirit Storage Unit                     |         |
| 83   | Display Shelf                           |         |
| 84   | VIP Entrance                            |         |
| 85   | Challenge Timer                         |         |
| 86   | Challenge Flag                          |         |
| 87   | Fish Mount                              |         |
| 88   | Portrait                                |         |
| 89   | Weather Machine                         |         |
| 90   | Fossil                                  |         |
| 91   | Fossil Prep                             |         |
| 92   | DNA Processor                           |         |
| 93   | Howler                                  |         |
| 94   | Valhowla Treasure                       |         |
| 95   | Chemisynth Processor                    |         |
| 96   | Chemisynth Tank                         |         |
| 97   | Untrade-a-box                           |         |
| 98   | Oven                                    |         |
| 99   | Audio Block                             |         |
| 100  | Geiger Charger                          |         |
| 101  | Adventure Begins                        |         |
| 102  | Tomb Robber                             |         |
| 103  | Balloon-o-matic                         |         |
| 104  | Team Entrance Punch                     |         |
| 105  | Team Entrance Grow                      |         |
| 106  | Team Entrance Build                     |         |
| 107  | Ancestral Totem of Wisdom               |         |
| 108  | Jelly Block                             |         |
| 109  | Training Port                           |         |
| 110  | Fishing Block                           |         |
| 111  | Magplant                                |         |
| 112  | Magplant Remote                         |         |
| 113  | CyBlock Bot                             |         |
| 114  | CyBlock Command                         |         |
| 115  | Lucky Token                             |         |
| 116  | Growscan                                |         |
| 117  | Containment Field Power Node            |         |
| 118  | Spirit Board                            |         |
| 119  | World Architect                         |         |
| 120  | Startopia Block                         |         |
| 122  | Toggleable Multi-Framed Animated Block  |         |
| 123  | Tesseract Manipulator                   |         |
| 124  | Heart of Gaia                           |         |
| 125  | Techno Organic Engine                   |         |
| 126  | Storm Cloud                             |         |
| 127  | Disappear when stepped on               |         |
| 128  | Puddle Block                            |         |
| 129  | Bountiful                               |         |
| 130  | Safe Vault                              |         |
| 131  | Angelic Counting Cloud                  |         |
| 132  | Mining Explosive                        |         |
| 134  | Infinity Weather Machine                |         |
| 135  | Ghost Block                             |         |
| 136  | Acid                                    |         |
| 138  | Waving Inflatable Arm Guy               |         |
| 140  | Pineapple Guzzler                       |         |
| 141  | Kranken Block                           |         |
| 142  | Friends Entrance                        |         |

