# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.accounts_api import AccountsApi


class TestAccountsApi(unittest.TestCase):
    """AccountsApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.accounts_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_add_account(self, m) -> None:
        """Test case for add_account

        Add an account
        """
        path = urljoin("https://api.accounting.sh", "/accounts")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.accounts_api.add_account(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_delete_account(self, m) -> None:
        """Test case for delete_account

        Delete an account
        """
        path = urljoin("https://api.accounting.sh", "/accounts/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("DELETE", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.accounts_api.delete_account(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_account(self, m) -> None:
        """Test case for get_account

        Get an account
        """
        path = urljoin("https://api.accounting.sh", "/accounts/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.accounts_api.get_account(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_accounts(self, m) -> None:
        """Test case for list_accounts

        List company's accounts
        """
        path = urljoin("https://api.accounting.sh", "/accounts")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.accounts_api.list_accounts(
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_account(self, m) -> None:
        """Test case for update_account

        Update an account
        """
        path = urljoin("https://api.accounting.sh", "/accounts/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.accounts_api.update_account(
                "uuid_example",
                {},
            )
            is not None
        )


if __name__ == "__main__":
    unittest.main()
