# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.invoices_api import InvoicesApi


class TestInvoicesApi(unittest.TestCase):
    """InvoicesApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.invoices_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_add_invoice(self, m) -> None:
        """Test case for add_invoice

        Add an invoice
        """
        path = urljoin("https://api.accounting.sh", "/incomes/invoices")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.invoices_api.add_invoice(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_add_invoice_payment(self, m) -> None:
        """Test case for add_invoice_payment

        Add an invoice payment
        """
        path = urljoin("https://api.accounting.sh", "/incomes/invoices/{uuid}/payments")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.invoices_api.add_invoice_payment(
                "uuid_example",
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_delete_invoice(self, m) -> None:
        """Test case for delete_invoice

        Delete an invoice
        """
        path = urljoin("https://api.accounting.sh", "/incomes/invoices/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("DELETE", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.invoices_api.delete_invoice(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_invoice(self, m) -> None:
        """Test case for get_invoice

        Get an invoice
        """
        path = urljoin("https://api.accounting.sh", "/incomes/invoices/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.invoices_api.get_invoice(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_invoice_document(self, m) -> None:
        """Test case for get_invoice_document

        Get an invoice in PDF
        """
        path = urljoin("https://api.accounting.sh", "/incomes/invoices/{uuid}/document")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.invoices_api.get_invoice_document(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_invoices(self, m) -> None:
        """Test case for list_invoices

        List company's invoices
        """
        path = urljoin("https://api.accounting.sh", "/incomes/invoices")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.invoices_api.list_invoices(
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_unpaid_invoices(self, m) -> None:
        """Test case for list_unpaid_invoices

        List company's unpaid invoices
        """
        path = urljoin("https://api.accounting.sh", "/incomes/invoices/unpaid")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert accounting.invoices_api.list_unpaid_invoices() is not None

    @requests_mock.Mocker()
    def test_update_invoice(self, m) -> None:
        """Test case for update_invoice

        Update an invoice
        """
        path = urljoin("https://api.accounting.sh", "/incomes/invoices/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.invoices_api.update_invoice(
                "uuid_example",
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_invoice_payment(self, m) -> None:
        """Test case for update_invoice_payment

        Update an invoice payment
        """
        path = urljoin(
            "https://api.accounting.sh", "/incomes/invoices/{uuid}/payments/{payment}"
        )
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        path = path.replace("{" + "payment" + "}", "payment_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.invoices_api.update_invoice_payment(
                "uuid_example",
                "payment_example",
                {},
            )
            is not None
        )


if __name__ == "__main__":
    unittest.main()
