# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.notification_types_api import NotificationTypesApi


class TestNotificationTypesApi(unittest.TestCase):
    """NotificationTypesApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.notification_types_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_add_notification_type(self, m) -> None:
        """Test case for add_notification_type

        Add a notification type
        """
        path = urljoin("https://api.accounting.sh", "/notifications/types")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.notification_types_api.add_notification_type(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_delete_notification_type(self, m) -> None:
        """Test case for delete_notification_type

        Delete a notification type
        """
        path = urljoin("https://api.accounting.sh", "/notifications/types/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("DELETE", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.notification_types_api.delete_notification_type(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_notification_type(self, m) -> None:
        """Test case for get_notification_type

        Get a notification type
        """
        path = urljoin("https://api.accounting.sh", "/notifications/types/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.notification_types_api.get_notification_type(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_notification_types(self, m) -> None:
        """Test case for list_notification_types

        List company's notification types
        """
        path = urljoin("https://api.accounting.sh", "/notifications/types")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.notification_types_api.list_notification_types(
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_notification_type(self, m) -> None:
        """Test case for update_notification_type

        Update a notification type
        """
        path = urljoin("https://api.accounting.sh", "/notifications/types/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.notification_types_api.update_notification_type(
                "uuid_example",
                {},
            )
            is not None
        )


if __name__ == "__main__":
    unittest.main()
