# daily

## metadata

| property      | value                                                                               |
|---------------|-------------------------------------------------------------------------------------|
| name          | daily                                                                               |
| original name | daily                                                                               |
| url           | [here](https://www.ncei.noaa.gov/data/global-historical-climatology-network-daily/) |

## datasets

### data

#### metadata

| property      | value                                                                                                                                                                                                   |
|---------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| name          | data                                                                                                                                                                                                    |
| original name | data                                                                                                                                                                                                    |
| description   | Historical daily weather data from the Global Historical Climatology Network (GHCN) ([details](https://www.ncei.noaa.gov/data/global-historical-climatology-network-daily/doc/GHCND_documentation.pdf)) |
| access        | [here](https://www.ncei.noaa.gov/data/global-historical-climatology-network-daily/)                                                                                                                     |

#### parameters

| name                                               | original name | description                                                                                                                     | unit type     | unit | constraints |
|----------------------------------------------------|---------------|---------------------------------------------------------------------------------------------------------------------------------|---------------|------|-------------|
| cloud_cover_total_midnight_to_midnight             | acmc          | Average cloudiness midnight to midnight from 30-second ceilometer data (percent)                                                | fraction      | %    | >=0,<=100   |
| cloud_cover_total_midnight_to_midnight_manual      | acmh          | Average cloudiness midnight to midnight from manual observation (percent)                                                       | fraction      | %    | >=0,<=100   |
| cloud_cover_total_sunrise_to_sunset                | acsc          | Average cloudiness sunrise to sunset from 30-second ceilometer data (percent)                                                   | fraction      | %    | >=0,<=100   |
| cloud_cover_total_sunrise_to_sunset_manual         | acsh          | Average cloudiness sunrise to sunset from manual observation (percent)                                                          | fraction      | %    | >=0,<=100   |
| count_days_multiday_evaporation                    | daev          | Number of days included in the multiday evaporation total (MDEV)                                                                | dimensionless | -    | >=0         |
| count_days_multiday_precipitation                  | dapr          | Number of days included in the multiday precipitation total (MDPR)                                                              | dimensionless | -    | >=0         |
| count_days_multiday_precipitation_height_gt_0mm    | dwpr          | Number of days with non-zero precipitation included in multiday precipitation total (MDPR)                                      | dimensionless | -    | >=0         |
| count_days_multiday_snow_depth_new                 | dasf          | Number of days included in the multiday snowfall total (MDSF)                                                                   | dimensionless | -    | >=0         |
| count_days_multiday_temperature_air_max_2m         | datx          | Number of days included in the multiday maximum temperature (MDTX)                                                              | dimensionless | -    | >=0         |
| count_days_multiday_temperature_air_min_2m         | datn          | Number of days included in the multiday minimum temperature (MDTN)                                                              | dimensionless | -    | >=0         |
| count_days_multiday_wind_movement                  | dawm          | Number of days included in the multiday wind movement (MDWM)                                                                    | dimensionless | -    | >=0         |
| distance_river_gauge_height                        | gaht          | Difference between river and gauge height (cm or inches as per user preference)                                                 | length_short  | cm   | >=0         |
| evaporation_height                                 | evap          | Evaporation of water from evaporation pan (mm or inches as per user preference, or hundredths of inches on Daily Form pdf file) | precipitation | mm   | >=0         |
| evaporation_height_multiday                        | mdev          | Multiday evaporation total (mm or inches as per user preference; use with DAEV)                                                 | precipitation | mm   | >=0         |
| frozen_ground_layer_base                           | frgb          | Base of frozen ground layer (cm or inches as per user preference)                                                               | length_short  | cm   | >=0         |
| frozen_ground_layer_thickness                      | frth          | Thickness of frozen ground layer (cm or inches as per user preference)                                                          | length_short  | cm   | >=0         |
| frozen_ground_layer_top                            | frgt          | Top of frozen ground layer (cm or inches as per user preference)                                                                | length_short  | cm   | >=0         |
| ice_on_water_thickness                             | thic          | Thickness of ice on water (inches or mm as per user preference)                                                                 | length_short  | mm   | >=0         |
| precipitation_height                               | prcp          | Precipitation (mm or inches as per user preference, inches to hundredths on Daily Form pdf file)                                | precipitation | mm   | >=0         |
| precipitation_height_multiday                      | mdpr          | Multiday precipitation total (mm or inches as per user preference; use with DAPR and DWPR, if available)                        | precipitation | mm   | >=0         |
| snow_depth                                         | snwd          | Snow depth (mm or inches as per user preference, inches on Daily Form pdf file)                                                 | precipitation | mm   | >=0         |
| snow_depth_new                                     | snow          | Snowfall (mm or inches as per user preference, inches to tenths on Daily Form pdf file)                                         | precipitation | mm   | >=0         |
| snow_depth_new_multiday                            | mdsf          | Multiday snowfall total (mm or inches as per user preference)                                                                   | precipitation | mm   | >=0         |
| sunshine_duration                                  | tsun          | Daily total sunshine (minutes)                                                                                                  | time          | min  | >=0         |
| sunshine_duration_relative                         | psun          | Daily percent of possible sunshine (percent)                                                                                    | fraction      | %    | >=0,<=100   |
| temperature_air_2m                                 | tobs          | Temperature at the time of observation  (Fahrenheit or Celsius as per user preference)                                          | temperature   | °C   | -           |
| temperature_air_max_2m                             | tmax          | Maximum  temperature  (Fahrenheit  or  Celsius  as per  user  preference, Fahrenheit  to  tenths on Daily Form pdf file         | temperature   | °C   | -           |
| temperature_air_max_2m_multiday                    | mdtx          | Multiday maximum temperature (Fahrenheit or Celsius as per user preference ; use with DATX)                                     | temperature   | °C   | -           |
| temperature_air_mean_2m                            | tmin          | mean temperature calculated from tmean = (temperature_air_max_2m + temperature_air_min_2m) / 2                                  | temperature   | °C   | -           |
| temperature_air_min_2m                             | tmin          | Minimum  temperature  (Fahrenheit  or  Celsius  as per  user  preference, Fahrenheit  to  tenths  on Daily Form pdf file        | temperature   | °C   | -           |
| temperature_air_min_2m_multiday                    | mdtn          | Multiday minimum temperature (Fahrenheit or Celsius as per user preference ; use with DATN)                                     | temperature   | °C   | -           |
| temperature_soil_max_bare_ground_0_05m             | sx31          | Maximum soil temperature of bare_ground ground at 5cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_max_bare_ground_0_1m              | sx32          | Maximum soil temperature of bare_ground ground at 10cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_bare_ground_0_2m              | sx33          | Maximum soil temperature of bare_ground ground at 20cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_bare_ground_0_5m              | sx34          | Maximum soil temperature of bare_ground ground at 50cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_bare_ground_1m                | sx35          | Maximum soil temperature of bare_ground ground at 100cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_max_bare_ground_1_5m              | sx36          | Maximum soil temperature of bare_ground ground at 150cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_max_bare_ground_1_8m              | sx37          | Maximum soil temperature of bare_ground ground at 180cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_min_bare_ground_0_05m             | sn31          | Minimum soil temperature of bare_ground ground at 5cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_min_bare_ground_0_1m              | sn32          | Minimum soil temperature of bare_ground ground at 10cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_bare_ground_0_2m              | sn33          | Minimum soil temperature of bare_ground ground at 20cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_bare_ground_0_5m              | sn34          | Minimum soil temperature of bare_ground ground at 50cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_bare_ground_1m                | sn35          | Minimum soil temperature of bare_ground ground at 100cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_min_bare_ground_1_5m              | sn36          | Minimum soil temperature of bare_ground ground at 150cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_min_bare_ground_1_8m              | sn37          | Minimum soil temperature of bare_ground ground at 180cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_max_bare_muck_0_05m               | sx81          | Maximum soil temperature of bare_muck ground at 5cm depth                                                                       | temperature   | °C   | -           |
| temperature_soil_max_bare_muck_0_1m                | sx82          | Maximum soil temperature of bare_muck ground at 10cm depth                                                                      | temperature   | °C   | -           |
| temperature_soil_max_bare_muck_0_2m                | sx83          | Maximum soil temperature of bare_muck ground at 20cm depth                                                                      | temperature   | °C   | -           |
| temperature_soil_max_bare_muck_0_5m                | sx84          | Maximum soil temperature of bare_muck ground at 50cm depth                                                                      | temperature   | °C   | -           |
| temperature_soil_max_bare_muck_1m                  | sx85          | Maximum soil temperature of bare_muck ground at 100cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_max_bare_muck_1_5m                | sx86          | Maximum soil temperature of bare_muck ground at 150cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_max_bare_muck_1_8m                | sx87          | Maximum soil temperature of bare_muck ground at 180cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_min_bare_muck_0_05m               | sn81          | Minimum soil temperature of bare_muck ground at 5cm depth                                                                       | temperature   | °C   | -           |
| temperature_soil_min_bare_muck_0_1m                | sn82          | Minimum soil temperature of bare_muck ground at 10cm depth                                                                      | temperature   | °C   | -           |
| temperature_soil_min_bare_muck_0_2m                | sn83          | Minimum soil temperature of bare_muck ground at 20cm depth                                                                      | temperature   | °C   | -           |
| temperature_soil_min_bare_muck_0_5m                | sn84          | Minimum soil temperature of bare_muck ground at 50cm depth                                                                      | temperature   | °C   | -           |
| temperature_soil_min_bare_muck_1m                  | sn85          | Minimum soil temperature of bare_muck ground at 100cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_min_bare_muck_1_5m                | sn86          | Minimum soil temperature of bare_muck ground at 150cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_min_bare_muck_1_8m                | sn87          | Minimum soil temperature of bare_muck ground at 180cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_max_brome_grass_0_05m             | sx41          | Maximum soil temperature of brome_grass ground at 5cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_max_brome_grass_0_1m              | sx42          | Maximum soil temperature of brome_grass ground at 10cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_brome_grass_0_2m              | sx43          | Maximum soil temperature of brome_grass ground at 20cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_brome_grass_0_5m              | sx44          | Maximum soil temperature of brome_grass ground at 50cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_brome_grass_1m                | sx45          | Maximum soil temperature of brome_grass ground at 100cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_max_brome_grass_1_5m              | sx46          | Maximum soil temperature of brome_grass ground at 150cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_max_brome_grass_1_8m              | sx47          | Maximum soil temperature of brome_grass ground at 180cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_min_brome_grass_0_05m             | sn41          | Minimum soil temperature of brome_grass ground at 5cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_min_brome_grass_0_1m              | sn42          | Minimum soil temperature of brome_grass ground at 10cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_brome_grass_0_2m              | sn43          | Minimum soil temperature of brome_grass ground at 20cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_brome_grass_0_5m              | sn44          | Minimum soil temperature of brome_grass ground at 50cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_brome_grass_1m                | sn45          | Minimum soil temperature of brome_grass ground at 100cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_min_brome_grass_1_5m              | sn46          | Minimum soil temperature of brome_grass ground at 150cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_min_brome_grass_1_8m              | sn47          | Minimum soil temperature of brome_grass ground at 180cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_max_fallow_0_05m                  | sx21          | Maximum soil temperature of fallow ground at 5cm depth                                                                          | temperature   | °C   | -           |
| temperature_soil_max_fallow_0_1m                   | sx22          | Maximum soil temperature of fallow ground at 10cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_max_fallow_0_2m                   | sx23          | Maximum soil temperature of fallow ground at 20cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_max_fallow_0_5m                   | sx24          | Maximum soil temperature of fallow ground at 50cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_max_fallow_1m                     | sx25          | Maximum soil temperature of fallow ground at 100cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_max_fallow_1_5m                   | sx26          | Maximum soil temperature of fallow ground at 150cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_max_fallow_1_8m                   | sx27          | Maximum soil temperature of fallow ground at 180cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_min_fallow_0_05m                  | sn21          | Minimum soil temperature of fallow ground at 5cm depth                                                                          | temperature   | °C   | -           |
| temperature_soil_min_fallow_0_1m                   | sn22          | Minimum soil temperature of fallow ground at 10cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_min_fallow_0_2m                   | sn23          | Minimum soil temperature of fallow ground at 20cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_min_fallow_0_5m                   | sn24          | Minimum soil temperature of fallow ground at 50cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_min_fallow_1m                     | sn25          | Minimum soil temperature of fallow ground at 100cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_min_fallow_1_5m                   | sn26          | Minimum soil temperature of fallow ground at 150cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_min_fallow_1_8m                   | sn27          | Minimum soil temperature of fallow ground at 180cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_max_grass_0_05m                   | sx11          | Maximum soil temperature of grass ground at 5cm depth                                                                           | temperature   | °C   | -           |
| temperature_soil_max_grass_0_1m                    | sx12          | Maximum soil temperature of grass ground at 10cm depth                                                                          | temperature   | °C   | -           |
| temperature_soil_max_grass_0_2m                    | sx13          | Maximum soil temperature of grass ground at 20cm depth                                                                          | temperature   | °C   | -           |
| temperature_soil_max_grass_0_5m                    | sx14          | Maximum soil temperature of grass ground at 50cm depth                                                                          | temperature   | °C   | -           |
| temperature_soil_max_grass_1m                      | sx15          | Maximum soil temperature of grass ground at 100cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_max_grass_1_5m                    | sx16          | Maximum soil temperature of grass ground at 150cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_max_grass_1_8m                    | sx17          | Maximum soil temperature of grass ground at 180cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_min_grass_0_05m                   | sn11          | Minimum soil temperature of grass ground at 5cm depth                                                                           | temperature   | °C   | -           |
| temperature_soil_min_grass_0_1m                    | sn12          | Minimum soil temperature of grass ground at 10cm depth                                                                          | temperature   | °C   | -           |
| temperature_soil_min_grass_0_2m                    | sn13          | Minimum soil temperature of grass ground at 20cm depth                                                                          | temperature   | °C   | -           |
| temperature_soil_min_grass_0_5m                    | sn14          | Minimum soil temperature of grass ground at 50cm depth                                                                          | temperature   | °C   | -           |
| temperature_soil_min_grass_1m                      | sn15          | Minimum soil temperature of grass ground at 100cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_min_grass_1_5m                    | sn16          | Minimum soil temperature of grass ground at 150cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_min_grass_1_8m                    | sn17          | Minimum soil temperature of grass ground at 180cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_max_grass_muck_0_05m              | sx71          | Maximum soil temperature of grass_muck ground at 5cm depth                                                                      | temperature   | °C   | -           |
| temperature_soil_max_grass_muck_0_1m               | sx72          | Maximum soil temperature of grass_muck ground at 10cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_max_grass_muck_0_2m               | sx73          | Maximum soil temperature of grass_muck ground at 20cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_max_grass_muck_0_5m               | sx74          | Maximum soil temperature of grass_muck ground at 50cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_max_grass_muck_1m                 | sx75          | Maximum soil temperature of grass_muck ground at 100cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_grass_muck_1_5m               | sx76          | Maximum soil temperature of grass_muck ground at 150cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_grass_muck_1_8m               | sx77          | Maximum soil temperature of grass_muck ground at 180cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_grass_muck_0_05m              | sn71          | Minimum soil temperature of grass_muck ground at 5cm depth                                                                      | temperature   | °C   | -           |
| temperature_soil_min_grass_muck_0_1m               | sn72          | Minimum soil temperature of grass_muck ground at 10cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_min_grass_muck_0_2m               | sn73          | Minimum soil temperature of grass_muck ground at 20cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_min_grass_muck_0_5m               | sn74          | Minimum soil temperature of grass_muck ground at 50cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_min_grass_muck_1m                 | sn75          | Minimum soil temperature of grass_muck ground at 100cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_grass_muck_1_5m               | sn76          | Minimum soil temperature of grass_muck ground at 150cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_grass_muck_1_8m               | sn77          | Minimum soil temperature of grass_muck ground at 180cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_sod_0_05m                     | sx51          | Maximum soil temperature of sod ground at 5cm depth                                                                             | temperature   | °C   | -           |
| temperature_soil_max_sod_0_1m                      | sx52          | Maximum soil temperature of sod ground at 10cm depth                                                                            | temperature   | °C   | -           |
| temperature_soil_max_sod_0_2m                      | sx53          | Maximum soil temperature of sod ground at 20cm depth                                                                            | temperature   | °C   | -           |
| temperature_soil_max_sod_0_5m                      | sx54          | Maximum soil temperature of sod ground at 50cm depth                                                                            | temperature   | °C   | -           |
| temperature_soil_max_sod_1m                        | sx55          | Maximum soil temperature of sod ground at 100cm depth                                                                           | temperature   | °C   | -           |
| temperature_soil_max_sod_1_5m                      | sx56          | Maximum soil temperature of sod ground at 150cm depth                                                                           | temperature   | °C   | -           |
| temperature_soil_max_sod_1_8m                      | sx57          | Maximum soil temperature of sod ground at 180cm depth                                                                           | temperature   | °C   | -           |
| temperature_soil_min_sod_0_05m                     | sn51          | Minimum soil temperature of sod ground at 5cm depth                                                                             | temperature   | °C   | -           |
| temperature_soil_min_sod_0_1m                      | sn52          | Minimum soil temperature of sod ground at 10cm depth                                                                            | temperature   | °C   | -           |
| temperature_soil_min_sod_0_2m                      | sn53          | Minimum soil temperature of sod ground at 20cm depth                                                                            | temperature   | °C   | -           |
| temperature_soil_min_sod_0_5m                      | sn54          | Minimum soil temperature of sod ground at 50cm depth                                                                            | temperature   | °C   | -           |
| temperature_soil_min_sod_1m                        | sn55          | Minimum soil temperature of sod ground at 100cm depth                                                                           | temperature   | °C   | -           |
| temperature_soil_min_sod_1_5m                      | sn56          | Minimum soil temperature of sod ground at 150cm depth                                                                           | temperature   | °C   | -           |
| temperature_soil_min_sod_1_8m                      | sn57          | Minimum soil temperature of sod ground at 180cm depth                                                                           | temperature   | °C   | -           |
| temperature_soil_max_straw_mulch_0_05m             | sx61          | Maximum soil temperature of straw_mulch ground at 5cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_max_straw_mulch_0_1m              | sx62          | Maximum soil temperature of straw_mulch ground at 10cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_straw_mulch_0_2m              | sx63          | Maximum soil temperature of straw_mulch ground at 20cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_straw_mulch_0_5m              | sx64          | Maximum soil temperature of straw_mulch ground at 50cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_max_straw_mulch_1m                | sx65          | Maximum soil temperature of straw_mulch ground at 100cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_max_straw_mulch_1_5m              | sx66          | Maximum soil temperature of straw_mulch ground at 150cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_max_straw_mulch_1_8m              | sx67          | Maximum soil temperature of straw_mulch ground at 180cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_min_straw_mulch_0_05m             | sn61          | Minimum soil temperature of straw_mulch ground at 5cm depth                                                                     | temperature   | °C   | -           |
| temperature_soil_min_straw_mulch_0_1m              | sn62          | Minimum soil temperature of straw_mulch ground at 10cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_straw_mulch_0_2m              | sn63          | Minimum soil temperature of straw_mulch ground at 20cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_straw_mulch_0_5m              | sn64          | Minimum soil temperature of straw_mulch ground at 50cm depth                                                                    | temperature   | °C   | -           |
| temperature_soil_min_straw_mulch_1m                | sn65          | Minimum soil temperature of straw_mulch ground at 100cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_min_straw_mulch_1_5m              | sn66          | Minimum soil temperature of straw_mulch ground at 150cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_min_straw_mulch_1_8m              | sn67          | Minimum soil temperature of straw_mulch ground at 180cm depth                                                                   | temperature   | °C   | -           |
| temperature_soil_max_unknown_0_05m                 | sx01          | Maximum soil temperature of unknown ground at 5cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_max_unknown_0_1m                  | sx02          | Maximum soil temperature of unknown ground at 10cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_max_unknown_0_2m                  | sx03          | Maximum soil temperature of unknown ground at 20cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_max_unknown_0_5m                  | sx04          | Maximum soil temperature of unknown ground at 50cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_max_unknown_1m                    | sx05          | Maximum soil temperature of unknown ground at 100cm depth                                                                       | temperature   | °C   | -           |
| temperature_soil_max_unknown_1_5m                  | sx06          | Maximum soil temperature of unknown ground at 150cm depth                                                                       | temperature   | °C   | -           |
| temperature_soil_max_unknown_1_8m                  | sx07          | Maximum soil temperature of unknown ground at 180cm depth                                                                       | temperature   | °C   | -           |
| temperature_soil_min_unknown_0_05m                 | sn01          | Minimum soil temperature of unknown ground at 5cm depth                                                                         | temperature   | °C   | -           |
| temperature_soil_min_unknown_0_1m                  | sn02          | Minimum soil temperature of unknown ground at 10cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_min_unknown_0_2m                  | sn03          | Minimum soil temperature of unknown ground at 20cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_min_unknown_0_5m                  | sn04          | Minimum soil temperature of unknown ground at 50cm depth                                                                        | temperature   | °C   | -           |
| temperature_soil_min_unknown_1m                    | sn05          | Minimum soil temperature of unknown ground at 100cm depth                                                                       | temperature   | °C   | -           |
| temperature_soil_min_unknown_1_5m                  | sn06          | Minimum soil temperature of unknown ground at 150cm depth                                                                       | temperature   | °C   | -           |
| temperature_soil_min_unknown_1_8m                  | sn07          | Minimum soil temperature of unknown ground at 180cm depth                                                                       | temperature   | °C   | -           |
| temperature_water_evaporation_pan_max              | mxpn          | Daily maximum temperature of water in an evaporation pan  (Fahrenheit or Celsius as per user preference)                        | temperature   | °C   | -           |
| temperature_water_evaporation_pan_min              | mnpn          | Daily minimum temperature of water in an evaporation pan (Fahrenheit or Celsius as per user preference)                         | temperature   | °C   | -           |
| water_equivalent_snow_depth                        | wesd          | Water equivalent of snow on the ground (inches or mm as per user preference)                                                    | precipitation | mm   | >=0         |
| water_equivalent_snow_depth_new                    | wesf          | Water equivalent of snowfall (inches or mm as per user preference)                                                              | precipitation | mm   | >=0         |
| weather_type_blowing_drifting_snow                 | wt09          | Blowing or drifting snow                                                                                                        | dimensionless | -    | -           |
| weather_type_blowing_spray                         | wt12          | Blowing spray                                                                                                                   | dimensionless | -    | -           |
| weather_type_drizzle                               | wt14          | Drizzle                                                                                                                         | dimensionless | -    | -           |
| weather_type_dust_ash_sand                         | wt07          | Dust, volcanic ash, blowing dust, blowing sand, or blowing obstruction                                                          | dimensionless | -    | -           |
| weather_type_fog                                   | wt01          | Fog, ice fog, or freezing fog (may include heavy fog)                                                                           | dimensionless | -    | -           |
| weather_type_freezing_drizzle                      | wt15          | Freezing drizzle                                                                                                                | dimensionless | -    | -           |
| weather_type_freezing_rain                         | wt17          | Freezing rain                                                                                                                   | dimensionless | -    | -           |
| weather_type_glaze_rime                            | wt06          | Glaze or rime                                                                                                                   | dimensionless | -    | -           |
| weather_type_ground_fog                            | wt21          | Ground fog                                                                                                                      | dimensionless | -    | -           |
| weather_type_hail                                  | wt05          | Hail (may include small hail)                                                                                                   | dimensionless | -    | -           |
| weather_type_heavy_fog                             | wt02          | Heavy fog or heaving freezing fog (not always distinguished from fog)                                                           | dimensionless | -    | -           |
| weather_type_high_damaging_winds                   | wt11          | High or damaging winds                                                                                                          | dimensionless | -    | -           |
| weather_type_ice_fog_freezing_fog                  | wt22          | Ice fog or freezing fog                                                                                                         | dimensionless | -    | -           |
| weather_type_ice_sleet_snow_hail                   | wt04          | Ice pellets, sleet, snow pellets, or small hail                                                                                 | dimensionless | -    | -           |
| weather_type_mist                                  | wt13          | Mist                                                                                                                            | dimensionless | -    | -           |
| weather_type_precipitation_unknown_source          | wt19          | Unknown source of precipitation                                                                                                 | dimensionless | -    | -           |
| weather_type_rain                                  | wt16          | Rain (may include freezing rain, drizzle, and freezing drizzle)                                                                 | dimensionless | -    | -           |
| weather_type_smoke_haze                            | wt08          | Smoke or haze                                                                                                                   | dimensionless | -    | -           |
| weather_type_snow_pellets_snow_grains_ice_crystals | wt18          | Snow, snow pellets, snow grains, or ice crystals                                                                                | dimensionless | -    | -           |
| weather_type_thunder                               | wt03          | Thunder                                                                                                                         | dimensionless | -    | -           |
| weather_type_tornado_waterspout                    | wt10          | Tornado, waterspout, or funnel cloud                                                                                            | dimensionless | -    | -           |
| weather_type_vicinity_dust_ash_sand                | wv07          | Ash, dust, sand, or other blowing obstruction in the Vicinity                                                                   | dimensionless | -    | -           |
| weather_type_vicinity_fog_any                      | wv01          | Fog, ice fog, or freezing fog (may include heavy fog) in the Vicinity                                                           | dimensionless | -    | -           |
| weather_type_vicinity_rain_snow_shower             | wv20          | Rain or snow shower in the Vicinity                                                                                             | dimensionless | -    | -           |
| weather_type_vicinity_snow_ice_crystals            | wv18          | Snow or ice crystals in the Vicinity                                                                                            | dimensionless | -    | -           |
| weather_type_vicinity_thunder                      | wv03          | Thunder in the Vicinity                                                                                                         | dimensionless | -    | -           |
| wind_direction_gust_max                            | wdfg          | Direction of peak wind gust (degrees)                                                                                           | angle         | °    | >=0,<=360   |
| wind_direction_gust_max_1mile                      | wsfm          | Fastest mile wind direction (degrees)                                                                                           | angle         | °    | >=0,<=360   |
| wind_direction_gust_max_1min                       | wdf1          | Direction of fastest 1-minute wind (degrees)                                                                                    | angle         | °    | >=0,<=360   |
| wind_direction_gust_max_2min                       | wdf2          | Direction of fastest 2-minute wind (degrees)                                                                                    | angle         | °    | >=0,<=360   |
| wind_direction_gust_max_5sec                       | wdf5          | Direction of fastest 5-second wind (degrees)                                                                                    | angle         | °    | >=0,<=360   |
| wind_direction_gust_max_instant                    | wdfi          | Direction of highest instantaneous wind (degrees)                                                                               | angle         | °    | >=0,<=360   |
| wind_gust_max                                      | wsfg          | Peak guest wind speed (miles per hour or  meters per second as per user preference)                                             | speed         | m/s  | >=0         |
| wind_gust_max_1mile                                | wsfm          | Fastest mile wind speed (miles per hour or  meters per second as per user preference)                                           | speed         | m/s  | >=0         |
| wind_gust_max_instant                              | wsfi          | Highest instantaneous wind speed (miles per hour or  meters per second as per user preference)                                  | speed         | m/s  | >=0         |
| wind_gust_max_1min                                 | wsf1          | Fastest 1-minute wind speed (miles per hour or  meters per second as per user preference)                                       | speed         | m/s  | >=0         |
| wind_gust_max_2min                                 | wsf2          | Fastest 2-minute wind speed (miles per hour or  meters per second as per user preference)                                       | speed         | m/s  | >=0         |
| wind_gust_max_5sec                                 | wsf5          | Fastest 5-second wind speed (miles per hour or  meters per second as per user preference)                                       | speed         | m/s  | >=0         |
| wind_movement_24h                                  | wdmv          | 24-hour wind movement (km or miles as per user preference, miles on Daily Form pdf file)                                        | length_long   | km   | >=0         |
| wind_movement_multiday                             | mdwm          | Multiday wind movement (miles or km as per user preference)                                                                     | length_long   | km   | >=0         |
| wind_speed                                         | awnd          | Average daily wind speed (meters per second or miles per hour as per user preference)                                           | speed         | m/s  | >=0         |
