# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustAccessApplicationArgs', 'ZeroTrustAccessApplication']

@pulumi.input_type
class ZeroTrustAccessApplicationArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_authenticate_via_warp: Optional[pulumi.Input[bool]] = None,
                 allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_launcher_logo_url: Optional[pulumi.Input[str]] = None,
                 app_launcher_visible: Optional[pulumi.Input[bool]] = None,
                 auto_redirect_to_identity: Optional[pulumi.Input[bool]] = None,
                 bg_color: Optional[pulumi.Input[str]] = None,
                 cors_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationCorsHeaderArgs']]]] = None,
                 custom_deny_message: Optional[pulumi.Input[str]] = None,
                 custom_deny_url: Optional[pulumi.Input[str]] = None,
                 custom_non_identity_deny_url: Optional[pulumi.Input[str]] = None,
                 custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 enable_binding_cookie: Optional[pulumi.Input[bool]] = None,
                 footer_links: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]] = None,
                 header_bg_color: Optional[pulumi.Input[str]] = None,
                 http_only_cookie_attribute: Optional[pulumi.Input[bool]] = None,
                 landing_page_design: Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']] = None,
                 logo_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options_preflight_bypass: Optional[pulumi.Input[bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 saas_app: Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[str]] = None,
                 scim_config: Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']] = None,
                 self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_auth401_redirect: Optional[pulumi.Input[bool]] = None,
                 session_duration: Optional[pulumi.Input[str]] = None,
                 skip_app_launcher_login_page: Optional[pulumi.Input[bool]] = None,
                 skip_interstitial: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ZeroTrustAccessApplication resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`.
        :param pulumi.Input[bool] allow_authenticate_via_warp: When set to true, users can authenticate to this application using their WARP session. When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_idps: The identity providers selected for the application.
        :param pulumi.Input[str] app_launcher_logo_url: The logo URL of the app launcher.
        :param pulumi.Input[bool] app_launcher_visible: Option to show/hide applications in App Launcher. Defaults to `true`.
        :param pulumi.Input[bool] auto_redirect_to_identity: Option to skip identity provider selection if only one is configured in `allowed_idps`. Defaults to `false`.
        :param pulumi.Input[str] bg_color: The background color of the app launcher.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationCorsHeaderArgs']]] cors_headers: CORS configuration for the Access Application. See below for reference structure.
        :param pulumi.Input[str] custom_deny_message: Option that returns a custom error message when a user is denied access to the application.
        :param pulumi.Input[str] custom_deny_url: Option that redirects to a custom URL when a user is denied access to the application via identity based rules.
        :param pulumi.Input[str] custom_non_identity_deny_url: Option that redirects to a custom URL when a user is denied access to the application via non identity rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_pages: The custom pages selected for the application.
        :param pulumi.Input[str] domain: The primary hostname and path that Access will secure. If the app is visible in the App Launcher dashboard, this is the domain that will be displayed.
        :param pulumi.Input[bool] enable_binding_cookie: Option to provide increased security against compromised authorization tokens and CSRF attacks by requiring an additional "binding" cookie on requests. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]] footer_links: The footer links of the app launcher.
        :param pulumi.Input[str] header_bg_color: The background color of the header bar in the app launcher.
        :param pulumi.Input[bool] http_only_cookie_attribute: Option to add the `HttpOnly` cookie flag to access tokens.
        :param pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs'] landing_page_design: The landing page design of the app launcher.
        :param pulumi.Input[str] logo_url: Image URL for the logo shown in the app launcher dashboard.
        :param pulumi.Input[str] name: Friendly name of the Access Application.
        :param pulumi.Input[bool] options_preflight_bypass: Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The policies associated with the application, in ascending order of precedence. Warning: Do not use this field while you still have this application ID referenced as `application_id` in any `AccessPolicy` resource, as it can result in an inconsistent state.
        :param pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs'] saas_app: SaaS configuration for the Access Application.
        :param pulumi.Input[str] same_site_cookie_attribute: Defines the same-site cookie setting for access tokens. Available values: `none`, `lax`, `strict`.
        :param pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs'] scim_config: Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] self_hosted_domains: List of domains that access will secure. Only present for self_hosted, vnc, and ssh applications. Always includes the value set as `domain`.
        :param pulumi.Input[bool] service_auth401_redirect: Option to return a 401 status code in service authentication rules on failed requests. Defaults to `false`.
        :param pulumi.Input[str] session_duration: How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`. Defaults to `24h`.
        :param pulumi.Input[bool] skip_app_launcher_login_page: Option to skip the App Launcher landing page. Defaults to `false`.
        :param pulumi.Input[bool] skip_interstitial: Option to skip the authorization interstitial when using the CLI. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The itags associated with the application.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]] target_criterias: The payload for an infrastructure application which defines the port, protocol, and target attributes. Only applicable to Infrastructure Applications, in which case this field is required.
        :param pulumi.Input[str] type: The application type. Available values: `app_launcher`, `bookmark`, `biso`, `dash_sso`, `saas`, `self_hosted`, `ssh`, `vnc`, `warp`, `infrastructure`. Defaults to `self_hosted`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_authenticate_via_warp is not None:
            pulumi.set(__self__, "allow_authenticate_via_warp", allow_authenticate_via_warp)
        if allowed_idps is not None:
            pulumi.set(__self__, "allowed_idps", allowed_idps)
        if app_launcher_logo_url is not None:
            pulumi.set(__self__, "app_launcher_logo_url", app_launcher_logo_url)
        if app_launcher_visible is not None:
            pulumi.set(__self__, "app_launcher_visible", app_launcher_visible)
        if auto_redirect_to_identity is not None:
            pulumi.set(__self__, "auto_redirect_to_identity", auto_redirect_to_identity)
        if bg_color is not None:
            pulumi.set(__self__, "bg_color", bg_color)
        if cors_headers is not None:
            pulumi.set(__self__, "cors_headers", cors_headers)
        if custom_deny_message is not None:
            pulumi.set(__self__, "custom_deny_message", custom_deny_message)
        if custom_deny_url is not None:
            pulumi.set(__self__, "custom_deny_url", custom_deny_url)
        if custom_non_identity_deny_url is not None:
            pulumi.set(__self__, "custom_non_identity_deny_url", custom_non_identity_deny_url)
        if custom_pages is not None:
            pulumi.set(__self__, "custom_pages", custom_pages)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enable_binding_cookie is not None:
            pulumi.set(__self__, "enable_binding_cookie", enable_binding_cookie)
        if footer_links is not None:
            pulumi.set(__self__, "footer_links", footer_links)
        if header_bg_color is not None:
            pulumi.set(__self__, "header_bg_color", header_bg_color)
        if http_only_cookie_attribute is not None:
            pulumi.set(__self__, "http_only_cookie_attribute", http_only_cookie_attribute)
        if landing_page_design is not None:
            pulumi.set(__self__, "landing_page_design", landing_page_design)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options_preflight_bypass is not None:
            pulumi.set(__self__, "options_preflight_bypass", options_preflight_bypass)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if saas_app is not None:
            pulumi.set(__self__, "saas_app", saas_app)
        if same_site_cookie_attribute is not None:
            pulumi.set(__self__, "same_site_cookie_attribute", same_site_cookie_attribute)
        if scim_config is not None:
            pulumi.set(__self__, "scim_config", scim_config)
        if self_hosted_domains is not None:
            pulumi.set(__self__, "self_hosted_domains", self_hosted_domains)
        if service_auth401_redirect is not None:
            pulumi.set(__self__, "service_auth401_redirect", service_auth401_redirect)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if skip_app_launcher_login_page is not None:
            pulumi.set(__self__, "skip_app_launcher_login_page", skip_app_launcher_login_page)
        if skip_interstitial is not None:
            pulumi.set(__self__, "skip_interstitial", skip_interstitial)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_criterias is not None:
            pulumi.set(__self__, "target_criterias", target_criterias)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. Conflicts with `zone_id`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowAuthenticateViaWarp")
    def allow_authenticate_via_warp(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, users can authenticate to this application using their WARP session. When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        """
        return pulumi.get(self, "allow_authenticate_via_warp")

    @allow_authenticate_via_warp.setter
    def allow_authenticate_via_warp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_authenticate_via_warp", value)

    @property
    @pulumi.getter(name="allowedIdps")
    def allowed_idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The identity providers selected for the application.
        """
        return pulumi.get(self, "allowed_idps")

    @allowed_idps.setter
    def allowed_idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_idps", value)

    @property
    @pulumi.getter(name="appLauncherLogoUrl")
    def app_launcher_logo_url(self) -> Optional[pulumi.Input[str]]:
        """
        The logo URL of the app launcher.
        """
        return pulumi.get(self, "app_launcher_logo_url")

    @app_launcher_logo_url.setter
    def app_launcher_logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_launcher_logo_url", value)

    @property
    @pulumi.getter(name="appLauncherVisible")
    def app_launcher_visible(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to show/hide applications in App Launcher. Defaults to `true`.
        """
        return pulumi.get(self, "app_launcher_visible")

    @app_launcher_visible.setter
    def app_launcher_visible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "app_launcher_visible", value)

    @property
    @pulumi.getter(name="autoRedirectToIdentity")
    def auto_redirect_to_identity(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to skip identity provider selection if only one is configured in `allowed_idps`. Defaults to `false`.
        """
        return pulumi.get(self, "auto_redirect_to_identity")

    @auto_redirect_to_identity.setter
    def auto_redirect_to_identity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_redirect_to_identity", value)

    @property
    @pulumi.getter(name="bgColor")
    def bg_color(self) -> Optional[pulumi.Input[str]]:
        """
        The background color of the app launcher.
        """
        return pulumi.get(self, "bg_color")

    @bg_color.setter
    def bg_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bg_color", value)

    @property
    @pulumi.getter(name="corsHeaders")
    def cors_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationCorsHeaderArgs']]]]:
        """
        CORS configuration for the Access Application. See below for reference structure.
        """
        return pulumi.get(self, "cors_headers")

    @cors_headers.setter
    def cors_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationCorsHeaderArgs']]]]):
        pulumi.set(self, "cors_headers", value)

    @property
    @pulumi.getter(name="customDenyMessage")
    def custom_deny_message(self) -> Optional[pulumi.Input[str]]:
        """
        Option that returns a custom error message when a user is denied access to the application.
        """
        return pulumi.get(self, "custom_deny_message")

    @custom_deny_message.setter
    def custom_deny_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_deny_message", value)

    @property
    @pulumi.getter(name="customDenyUrl")
    def custom_deny_url(self) -> Optional[pulumi.Input[str]]:
        """
        Option that redirects to a custom URL when a user is denied access to the application via identity based rules.
        """
        return pulumi.get(self, "custom_deny_url")

    @custom_deny_url.setter
    def custom_deny_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_deny_url", value)

    @property
    @pulumi.getter(name="customNonIdentityDenyUrl")
    def custom_non_identity_deny_url(self) -> Optional[pulumi.Input[str]]:
        """
        Option that redirects to a custom URL when a user is denied access to the application via non identity rules.
        """
        return pulumi.get(self, "custom_non_identity_deny_url")

    @custom_non_identity_deny_url.setter
    def custom_non_identity_deny_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_non_identity_deny_url", value)

    @property
    @pulumi.getter(name="customPages")
    def custom_pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The custom pages selected for the application.
        """
        return pulumi.get(self, "custom_pages")

    @custom_pages.setter
    def custom_pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_pages", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The primary hostname and path that Access will secure. If the app is visible in the App Launcher dashboard, this is the domain that will be displayed.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="enableBindingCookie")
    def enable_binding_cookie(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to provide increased security against compromised authorization tokens and CSRF attacks by requiring an additional "binding" cookie on requests. Defaults to `false`.
        """
        return pulumi.get(self, "enable_binding_cookie")

    @enable_binding_cookie.setter
    def enable_binding_cookie(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_binding_cookie", value)

    @property
    @pulumi.getter(name="footerLinks")
    def footer_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]]:
        """
        The footer links of the app launcher.
        """
        return pulumi.get(self, "footer_links")

    @footer_links.setter
    def footer_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]]):
        pulumi.set(self, "footer_links", value)

    @property
    @pulumi.getter(name="headerBgColor")
    def header_bg_color(self) -> Optional[pulumi.Input[str]]:
        """
        The background color of the header bar in the app launcher.
        """
        return pulumi.get(self, "header_bg_color")

    @header_bg_color.setter
    def header_bg_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_bg_color", value)

    @property
    @pulumi.getter(name="httpOnlyCookieAttribute")
    def http_only_cookie_attribute(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to add the `HttpOnly` cookie flag to access tokens.
        """
        return pulumi.get(self, "http_only_cookie_attribute")

    @http_only_cookie_attribute.setter
    def http_only_cookie_attribute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_only_cookie_attribute", value)

    @property
    @pulumi.getter(name="landingPageDesign")
    def landing_page_design(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']]:
        """
        The landing page design of the app launcher.
        """
        return pulumi.get(self, "landing_page_design")

    @landing_page_design.setter
    def landing_page_design(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']]):
        pulumi.set(self, "landing_page_design", value)

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[str]]:
        """
        Image URL for the logo shown in the app launcher dashboard.
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the Access Application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optionsPreflightBypass")
    def options_preflight_bypass(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set. Defaults to `false`.
        """
        return pulumi.get(self, "options_preflight_bypass")

    @options_preflight_bypass.setter
    def options_preflight_bypass(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "options_preflight_bypass", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The policies associated with the application, in ascending order of precedence. Warning: Do not use this field while you still have this application ID referenced as `application_id` in any `AccessPolicy` resource, as it can result in an inconsistent state.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="saasApp")
    def saas_app(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']]:
        """
        SaaS configuration for the Access Application.
        """
        return pulumi.get(self, "saas_app")

    @saas_app.setter
    def saas_app(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']]):
        pulumi.set(self, "saas_app", value)

    @property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the same-site cookie setting for access tokens. Available values: `none`, `lax`, `strict`.
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @same_site_cookie_attribute.setter
    def same_site_cookie_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "same_site_cookie_attribute", value)

    @property
    @pulumi.getter(name="scimConfig")
    def scim_config(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']]:
        """
        Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        """
        return pulumi.get(self, "scim_config")

    @scim_config.setter
    def scim_config(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']]):
        pulumi.set(self, "scim_config", value)

    @property
    @pulumi.getter(name="selfHostedDomains")
    def self_hosted_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of domains that access will secure. Only present for self_hosted, vnc, and ssh applications. Always includes the value set as `domain`.
        """
        return pulumi.get(self, "self_hosted_domains")

    @self_hosted_domains.setter
    def self_hosted_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "self_hosted_domains", value)

    @property
    @pulumi.getter(name="serviceAuth401Redirect")
    def service_auth401_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to return a 401 status code in service authentication rules on failed requests. Defaults to `false`.
        """
        return pulumi.get(self, "service_auth401_redirect")

    @service_auth401_redirect.setter
    def service_auth401_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "service_auth401_redirect", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[str]]:
        """
        How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`. Defaults to `24h`.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="skipAppLauncherLoginPage")
    def skip_app_launcher_login_page(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to skip the App Launcher landing page. Defaults to `false`.
        """
        return pulumi.get(self, "skip_app_launcher_login_page")

    @skip_app_launcher_login_page.setter
    def skip_app_launcher_login_page(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_app_launcher_login_page", value)

    @property
    @pulumi.getter(name="skipInterstitial")
    def skip_interstitial(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to skip the authorization interstitial when using the CLI. Defaults to `false`.
        """
        return pulumi.get(self, "skip_interstitial")

    @skip_interstitial.setter
    def skip_interstitial(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_interstitial", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The itags associated with the application.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetCriterias")
    def target_criterias(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]]:
        """
        The payload for an infrastructure application which defines the port, protocol, and target attributes. Only applicable to Infrastructure Applications, in which case this field is required.
        """
        return pulumi.get(self, "target_criterias")

    @target_criterias.setter
    def target_criterias(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]]):
        pulumi.set(self, "target_criterias", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The application type. Available values: `app_launcher`, `bookmark`, `biso`, `dash_sso`, `saas`, `self_hosted`, `ssh`, `vnc`, `warp`, `infrastructure`. Defaults to `self_hosted`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ZeroTrustAccessApplicationState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_authenticate_via_warp: Optional[pulumi.Input[bool]] = None,
                 allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_launcher_logo_url: Optional[pulumi.Input[str]] = None,
                 app_launcher_visible: Optional[pulumi.Input[bool]] = None,
                 aud: Optional[pulumi.Input[str]] = None,
                 auto_redirect_to_identity: Optional[pulumi.Input[bool]] = None,
                 bg_color: Optional[pulumi.Input[str]] = None,
                 cors_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationCorsHeaderArgs']]]] = None,
                 custom_deny_message: Optional[pulumi.Input[str]] = None,
                 custom_deny_url: Optional[pulumi.Input[str]] = None,
                 custom_non_identity_deny_url: Optional[pulumi.Input[str]] = None,
                 custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 enable_binding_cookie: Optional[pulumi.Input[bool]] = None,
                 footer_links: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]] = None,
                 header_bg_color: Optional[pulumi.Input[str]] = None,
                 http_only_cookie_attribute: Optional[pulumi.Input[bool]] = None,
                 landing_page_design: Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']] = None,
                 logo_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options_preflight_bypass: Optional[pulumi.Input[bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 saas_app: Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[str]] = None,
                 scim_config: Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']] = None,
                 self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_auth401_redirect: Optional[pulumi.Input[bool]] = None,
                 session_duration: Optional[pulumi.Input[str]] = None,
                 skip_app_launcher_login_page: Optional[pulumi.Input[bool]] = None,
                 skip_interstitial: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustAccessApplication resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`.
        :param pulumi.Input[bool] allow_authenticate_via_warp: When set to true, users can authenticate to this application using their WARP session. When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_idps: The identity providers selected for the application.
        :param pulumi.Input[str] app_launcher_logo_url: The logo URL of the app launcher.
        :param pulumi.Input[bool] app_launcher_visible: Option to show/hide applications in App Launcher. Defaults to `true`.
        :param pulumi.Input[str] aud: Application Audience (AUD) Tag of the application.
        :param pulumi.Input[bool] auto_redirect_to_identity: Option to skip identity provider selection if only one is configured in `allowed_idps`. Defaults to `false`.
        :param pulumi.Input[str] bg_color: The background color of the app launcher.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationCorsHeaderArgs']]] cors_headers: CORS configuration for the Access Application. See below for reference structure.
        :param pulumi.Input[str] custom_deny_message: Option that returns a custom error message when a user is denied access to the application.
        :param pulumi.Input[str] custom_deny_url: Option that redirects to a custom URL when a user is denied access to the application via identity based rules.
        :param pulumi.Input[str] custom_non_identity_deny_url: Option that redirects to a custom URL when a user is denied access to the application via non identity rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_pages: The custom pages selected for the application.
        :param pulumi.Input[str] domain: The primary hostname and path that Access will secure. If the app is visible in the App Launcher dashboard, this is the domain that will be displayed.
        :param pulumi.Input[bool] enable_binding_cookie: Option to provide increased security against compromised authorization tokens and CSRF attacks by requiring an additional "binding" cookie on requests. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]] footer_links: The footer links of the app launcher.
        :param pulumi.Input[str] header_bg_color: The background color of the header bar in the app launcher.
        :param pulumi.Input[bool] http_only_cookie_attribute: Option to add the `HttpOnly` cookie flag to access tokens.
        :param pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs'] landing_page_design: The landing page design of the app launcher.
        :param pulumi.Input[str] logo_url: Image URL for the logo shown in the app launcher dashboard.
        :param pulumi.Input[str] name: Friendly name of the Access Application.
        :param pulumi.Input[bool] options_preflight_bypass: Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The policies associated with the application, in ascending order of precedence. Warning: Do not use this field while you still have this application ID referenced as `application_id` in any `AccessPolicy` resource, as it can result in an inconsistent state.
        :param pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs'] saas_app: SaaS configuration for the Access Application.
        :param pulumi.Input[str] same_site_cookie_attribute: Defines the same-site cookie setting for access tokens. Available values: `none`, `lax`, `strict`.
        :param pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs'] scim_config: Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] self_hosted_domains: List of domains that access will secure. Only present for self_hosted, vnc, and ssh applications. Always includes the value set as `domain`.
        :param pulumi.Input[bool] service_auth401_redirect: Option to return a 401 status code in service authentication rules on failed requests. Defaults to `false`.
        :param pulumi.Input[str] session_duration: How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`. Defaults to `24h`.
        :param pulumi.Input[bool] skip_app_launcher_login_page: Option to skip the App Launcher landing page. Defaults to `false`.
        :param pulumi.Input[bool] skip_interstitial: Option to skip the authorization interstitial when using the CLI. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The itags associated with the application.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]] target_criterias: The payload for an infrastructure application which defines the port, protocol, and target attributes. Only applicable to Infrastructure Applications, in which case this field is required.
        :param pulumi.Input[str] type: The application type. Available values: `app_launcher`, `bookmark`, `biso`, `dash_sso`, `saas`, `self_hosted`, `ssh`, `vnc`, `warp`, `infrastructure`. Defaults to `self_hosted`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_authenticate_via_warp is not None:
            pulumi.set(__self__, "allow_authenticate_via_warp", allow_authenticate_via_warp)
        if allowed_idps is not None:
            pulumi.set(__self__, "allowed_idps", allowed_idps)
        if app_launcher_logo_url is not None:
            pulumi.set(__self__, "app_launcher_logo_url", app_launcher_logo_url)
        if app_launcher_visible is not None:
            pulumi.set(__self__, "app_launcher_visible", app_launcher_visible)
        if aud is not None:
            pulumi.set(__self__, "aud", aud)
        if auto_redirect_to_identity is not None:
            pulumi.set(__self__, "auto_redirect_to_identity", auto_redirect_to_identity)
        if bg_color is not None:
            pulumi.set(__self__, "bg_color", bg_color)
        if cors_headers is not None:
            pulumi.set(__self__, "cors_headers", cors_headers)
        if custom_deny_message is not None:
            pulumi.set(__self__, "custom_deny_message", custom_deny_message)
        if custom_deny_url is not None:
            pulumi.set(__self__, "custom_deny_url", custom_deny_url)
        if custom_non_identity_deny_url is not None:
            pulumi.set(__self__, "custom_non_identity_deny_url", custom_non_identity_deny_url)
        if custom_pages is not None:
            pulumi.set(__self__, "custom_pages", custom_pages)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enable_binding_cookie is not None:
            pulumi.set(__self__, "enable_binding_cookie", enable_binding_cookie)
        if footer_links is not None:
            pulumi.set(__self__, "footer_links", footer_links)
        if header_bg_color is not None:
            pulumi.set(__self__, "header_bg_color", header_bg_color)
        if http_only_cookie_attribute is not None:
            pulumi.set(__self__, "http_only_cookie_attribute", http_only_cookie_attribute)
        if landing_page_design is not None:
            pulumi.set(__self__, "landing_page_design", landing_page_design)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options_preflight_bypass is not None:
            pulumi.set(__self__, "options_preflight_bypass", options_preflight_bypass)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if saas_app is not None:
            pulumi.set(__self__, "saas_app", saas_app)
        if same_site_cookie_attribute is not None:
            pulumi.set(__self__, "same_site_cookie_attribute", same_site_cookie_attribute)
        if scim_config is not None:
            pulumi.set(__self__, "scim_config", scim_config)
        if self_hosted_domains is not None:
            pulumi.set(__self__, "self_hosted_domains", self_hosted_domains)
        if service_auth401_redirect is not None:
            pulumi.set(__self__, "service_auth401_redirect", service_auth401_redirect)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if skip_app_launcher_login_page is not None:
            pulumi.set(__self__, "skip_app_launcher_login_page", skip_app_launcher_login_page)
        if skip_interstitial is not None:
            pulumi.set(__self__, "skip_interstitial", skip_interstitial)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_criterias is not None:
            pulumi.set(__self__, "target_criterias", target_criterias)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. Conflicts with `zone_id`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowAuthenticateViaWarp")
    def allow_authenticate_via_warp(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, users can authenticate to this application using their WARP session. When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        """
        return pulumi.get(self, "allow_authenticate_via_warp")

    @allow_authenticate_via_warp.setter
    def allow_authenticate_via_warp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_authenticate_via_warp", value)

    @property
    @pulumi.getter(name="allowedIdps")
    def allowed_idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The identity providers selected for the application.
        """
        return pulumi.get(self, "allowed_idps")

    @allowed_idps.setter
    def allowed_idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_idps", value)

    @property
    @pulumi.getter(name="appLauncherLogoUrl")
    def app_launcher_logo_url(self) -> Optional[pulumi.Input[str]]:
        """
        The logo URL of the app launcher.
        """
        return pulumi.get(self, "app_launcher_logo_url")

    @app_launcher_logo_url.setter
    def app_launcher_logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_launcher_logo_url", value)

    @property
    @pulumi.getter(name="appLauncherVisible")
    def app_launcher_visible(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to show/hide applications in App Launcher. Defaults to `true`.
        """
        return pulumi.get(self, "app_launcher_visible")

    @app_launcher_visible.setter
    def app_launcher_visible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "app_launcher_visible", value)

    @property
    @pulumi.getter
    def aud(self) -> Optional[pulumi.Input[str]]:
        """
        Application Audience (AUD) Tag of the application.
        """
        return pulumi.get(self, "aud")

    @aud.setter
    def aud(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aud", value)

    @property
    @pulumi.getter(name="autoRedirectToIdentity")
    def auto_redirect_to_identity(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to skip identity provider selection if only one is configured in `allowed_idps`. Defaults to `false`.
        """
        return pulumi.get(self, "auto_redirect_to_identity")

    @auto_redirect_to_identity.setter
    def auto_redirect_to_identity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_redirect_to_identity", value)

    @property
    @pulumi.getter(name="bgColor")
    def bg_color(self) -> Optional[pulumi.Input[str]]:
        """
        The background color of the app launcher.
        """
        return pulumi.get(self, "bg_color")

    @bg_color.setter
    def bg_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bg_color", value)

    @property
    @pulumi.getter(name="corsHeaders")
    def cors_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationCorsHeaderArgs']]]]:
        """
        CORS configuration for the Access Application. See below for reference structure.
        """
        return pulumi.get(self, "cors_headers")

    @cors_headers.setter
    def cors_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationCorsHeaderArgs']]]]):
        pulumi.set(self, "cors_headers", value)

    @property
    @pulumi.getter(name="customDenyMessage")
    def custom_deny_message(self) -> Optional[pulumi.Input[str]]:
        """
        Option that returns a custom error message when a user is denied access to the application.
        """
        return pulumi.get(self, "custom_deny_message")

    @custom_deny_message.setter
    def custom_deny_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_deny_message", value)

    @property
    @pulumi.getter(name="customDenyUrl")
    def custom_deny_url(self) -> Optional[pulumi.Input[str]]:
        """
        Option that redirects to a custom URL when a user is denied access to the application via identity based rules.
        """
        return pulumi.get(self, "custom_deny_url")

    @custom_deny_url.setter
    def custom_deny_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_deny_url", value)

    @property
    @pulumi.getter(name="customNonIdentityDenyUrl")
    def custom_non_identity_deny_url(self) -> Optional[pulumi.Input[str]]:
        """
        Option that redirects to a custom URL when a user is denied access to the application via non identity rules.
        """
        return pulumi.get(self, "custom_non_identity_deny_url")

    @custom_non_identity_deny_url.setter
    def custom_non_identity_deny_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_non_identity_deny_url", value)

    @property
    @pulumi.getter(name="customPages")
    def custom_pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The custom pages selected for the application.
        """
        return pulumi.get(self, "custom_pages")

    @custom_pages.setter
    def custom_pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_pages", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The primary hostname and path that Access will secure. If the app is visible in the App Launcher dashboard, this is the domain that will be displayed.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="enableBindingCookie")
    def enable_binding_cookie(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to provide increased security against compromised authorization tokens and CSRF attacks by requiring an additional "binding" cookie on requests. Defaults to `false`.
        """
        return pulumi.get(self, "enable_binding_cookie")

    @enable_binding_cookie.setter
    def enable_binding_cookie(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_binding_cookie", value)

    @property
    @pulumi.getter(name="footerLinks")
    def footer_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]]:
        """
        The footer links of the app launcher.
        """
        return pulumi.get(self, "footer_links")

    @footer_links.setter
    def footer_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]]):
        pulumi.set(self, "footer_links", value)

    @property
    @pulumi.getter(name="headerBgColor")
    def header_bg_color(self) -> Optional[pulumi.Input[str]]:
        """
        The background color of the header bar in the app launcher.
        """
        return pulumi.get(self, "header_bg_color")

    @header_bg_color.setter
    def header_bg_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_bg_color", value)

    @property
    @pulumi.getter(name="httpOnlyCookieAttribute")
    def http_only_cookie_attribute(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to add the `HttpOnly` cookie flag to access tokens.
        """
        return pulumi.get(self, "http_only_cookie_attribute")

    @http_only_cookie_attribute.setter
    def http_only_cookie_attribute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_only_cookie_attribute", value)

    @property
    @pulumi.getter(name="landingPageDesign")
    def landing_page_design(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']]:
        """
        The landing page design of the app launcher.
        """
        return pulumi.get(self, "landing_page_design")

    @landing_page_design.setter
    def landing_page_design(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']]):
        pulumi.set(self, "landing_page_design", value)

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[str]]:
        """
        Image URL for the logo shown in the app launcher dashboard.
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the Access Application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optionsPreflightBypass")
    def options_preflight_bypass(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set. Defaults to `false`.
        """
        return pulumi.get(self, "options_preflight_bypass")

    @options_preflight_bypass.setter
    def options_preflight_bypass(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "options_preflight_bypass", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The policies associated with the application, in ascending order of precedence. Warning: Do not use this field while you still have this application ID referenced as `application_id` in any `AccessPolicy` resource, as it can result in an inconsistent state.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="saasApp")
    def saas_app(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']]:
        """
        SaaS configuration for the Access Application.
        """
        return pulumi.get(self, "saas_app")

    @saas_app.setter
    def saas_app(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']]):
        pulumi.set(self, "saas_app", value)

    @property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the same-site cookie setting for access tokens. Available values: `none`, `lax`, `strict`.
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @same_site_cookie_attribute.setter
    def same_site_cookie_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "same_site_cookie_attribute", value)

    @property
    @pulumi.getter(name="scimConfig")
    def scim_config(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']]:
        """
        Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        """
        return pulumi.get(self, "scim_config")

    @scim_config.setter
    def scim_config(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']]):
        pulumi.set(self, "scim_config", value)

    @property
    @pulumi.getter(name="selfHostedDomains")
    def self_hosted_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of domains that access will secure. Only present for self_hosted, vnc, and ssh applications. Always includes the value set as `domain`.
        """
        return pulumi.get(self, "self_hosted_domains")

    @self_hosted_domains.setter
    def self_hosted_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "self_hosted_domains", value)

    @property
    @pulumi.getter(name="serviceAuth401Redirect")
    def service_auth401_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to return a 401 status code in service authentication rules on failed requests. Defaults to `false`.
        """
        return pulumi.get(self, "service_auth401_redirect")

    @service_auth401_redirect.setter
    def service_auth401_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "service_auth401_redirect", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[str]]:
        """
        How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`. Defaults to `24h`.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="skipAppLauncherLoginPage")
    def skip_app_launcher_login_page(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to skip the App Launcher landing page. Defaults to `false`.
        """
        return pulumi.get(self, "skip_app_launcher_login_page")

    @skip_app_launcher_login_page.setter
    def skip_app_launcher_login_page(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_app_launcher_login_page", value)

    @property
    @pulumi.getter(name="skipInterstitial")
    def skip_interstitial(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to skip the authorization interstitial when using the CLI. Defaults to `false`.
        """
        return pulumi.get(self, "skip_interstitial")

    @skip_interstitial.setter
    def skip_interstitial(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_interstitial", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The itags associated with the application.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetCriterias")
    def target_criterias(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]]:
        """
        The payload for an infrastructure application which defines the port, protocol, and target attributes. Only applicable to Infrastructure Applications, in which case this field is required.
        """
        return pulumi.get(self, "target_criterias")

    @target_criterias.setter
    def target_criterias(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]]):
        pulumi.set(self, "target_criterias", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The application type. Available values: `app_launcher`, `bookmark`, `biso`, `dash_sso`, `saas`, `self_hosted`, `ssh`, `vnc`, `warp`, `infrastructure`. Defaults to `self_hosted`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class ZeroTrustAccessApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_authenticate_via_warp: Optional[pulumi.Input[bool]] = None,
                 allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_launcher_logo_url: Optional[pulumi.Input[str]] = None,
                 app_launcher_visible: Optional[pulumi.Input[bool]] = None,
                 auto_redirect_to_identity: Optional[pulumi.Input[bool]] = None,
                 bg_color: Optional[pulumi.Input[str]] = None,
                 cors_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationCorsHeaderArgs', 'ZeroTrustAccessApplicationCorsHeaderArgsDict']]]]] = None,
                 custom_deny_message: Optional[pulumi.Input[str]] = None,
                 custom_deny_url: Optional[pulumi.Input[str]] = None,
                 custom_non_identity_deny_url: Optional[pulumi.Input[str]] = None,
                 custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 enable_binding_cookie: Optional[pulumi.Input[bool]] = None,
                 footer_links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]]] = None,
                 header_bg_color: Optional[pulumi.Input[str]] = None,
                 http_only_cookie_attribute: Optional[pulumi.Input[bool]] = None,
                 landing_page_design: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']]] = None,
                 logo_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options_preflight_bypass: Optional[pulumi.Input[bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 saas_app: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationSaasAppArgs', 'ZeroTrustAccessApplicationSaasAppArgsDict']]] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[str]] = None,
                 scim_config: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']]] = None,
                 self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_auth401_redirect: Optional[pulumi.Input[bool]] = None,
                 session_duration: Optional[pulumi.Input[str]] = None,
                 skip_app_launcher_login_page: Optional[pulumi.Input[bool]] = None,
                 skip_interstitial: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationTargetCriteriaArgs', 'ZeroTrustAccessApplicationTargetCriteriaArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Access Application resource. Access
        Applications are used to restrict access to a whole application using an
        authorisation gateway managed by Cloudflare.

        > It's required that an `account_id` or `zone_id` is provided and in
           most cases using either is fine. However, if you're using a scoped
           access token, you must provide the argument that matches the token's
           scope. For example, an access token that is scoped to the "example.com"
           zone needs to use the `zone_id` argument.

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessApplication:ZeroTrustAccessApplication example <account_id>/<application_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`.
        :param pulumi.Input[bool] allow_authenticate_via_warp: When set to true, users can authenticate to this application using their WARP session. When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_idps: The identity providers selected for the application.
        :param pulumi.Input[str] app_launcher_logo_url: The logo URL of the app launcher.
        :param pulumi.Input[bool] app_launcher_visible: Option to show/hide applications in App Launcher. Defaults to `true`.
        :param pulumi.Input[bool] auto_redirect_to_identity: Option to skip identity provider selection if only one is configured in `allowed_idps`. Defaults to `false`.
        :param pulumi.Input[str] bg_color: The background color of the app launcher.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationCorsHeaderArgs', 'ZeroTrustAccessApplicationCorsHeaderArgsDict']]]] cors_headers: CORS configuration for the Access Application. See below for reference structure.
        :param pulumi.Input[str] custom_deny_message: Option that returns a custom error message when a user is denied access to the application.
        :param pulumi.Input[str] custom_deny_url: Option that redirects to a custom URL when a user is denied access to the application via identity based rules.
        :param pulumi.Input[str] custom_non_identity_deny_url: Option that redirects to a custom URL when a user is denied access to the application via non identity rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_pages: The custom pages selected for the application.
        :param pulumi.Input[str] domain: The primary hostname and path that Access will secure. If the app is visible in the App Launcher dashboard, this is the domain that will be displayed.
        :param pulumi.Input[bool] enable_binding_cookie: Option to provide increased security against compromised authorization tokens and CSRF attacks by requiring an additional "binding" cookie on requests. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]] footer_links: The footer links of the app launcher.
        :param pulumi.Input[str] header_bg_color: The background color of the header bar in the app launcher.
        :param pulumi.Input[bool] http_only_cookie_attribute: Option to add the `HttpOnly` cookie flag to access tokens.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']] landing_page_design: The landing page design of the app launcher.
        :param pulumi.Input[str] logo_url: Image URL for the logo shown in the app launcher dashboard.
        :param pulumi.Input[str] name: Friendly name of the Access Application.
        :param pulumi.Input[bool] options_preflight_bypass: Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The policies associated with the application, in ascending order of precedence. Warning: Do not use this field while you still have this application ID referenced as `application_id` in any `AccessPolicy` resource, as it can result in an inconsistent state.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationSaasAppArgs', 'ZeroTrustAccessApplicationSaasAppArgsDict']] saas_app: SaaS configuration for the Access Application.
        :param pulumi.Input[str] same_site_cookie_attribute: Defines the same-site cookie setting for access tokens. Available values: `none`, `lax`, `strict`.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']] scim_config: Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] self_hosted_domains: List of domains that access will secure. Only present for self_hosted, vnc, and ssh applications. Always includes the value set as `domain`.
        :param pulumi.Input[bool] service_auth401_redirect: Option to return a 401 status code in service authentication rules on failed requests. Defaults to `false`.
        :param pulumi.Input[str] session_duration: How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`. Defaults to `24h`.
        :param pulumi.Input[bool] skip_app_launcher_login_page: Option to skip the App Launcher landing page. Defaults to `false`.
        :param pulumi.Input[bool] skip_interstitial: Option to skip the authorization interstitial when using the CLI. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The itags associated with the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationTargetCriteriaArgs', 'ZeroTrustAccessApplicationTargetCriteriaArgsDict']]]] target_criterias: The payload for an infrastructure application which defines the port, protocol, and target attributes. Only applicable to Infrastructure Applications, in which case this field is required.
        :param pulumi.Input[str] type: The application type. Available values: `app_launcher`, `bookmark`, `biso`, `dash_sso`, `saas`, `self_hosted`, `ssh`, `vnc`, `warp`, `infrastructure`. Defaults to `self_hosted`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ZeroTrustAccessApplicationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Access Application resource. Access
        Applications are used to restrict access to a whole application using an
        authorisation gateway managed by Cloudflare.

        > It's required that an `account_id` or `zone_id` is provided and in
           most cases using either is fine. However, if you're using a scoped
           access token, you must provide the argument that matches the token's
           scope. For example, an access token that is scoped to the "example.com"
           zone needs to use the `zone_id` argument.

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessApplication:ZeroTrustAccessApplication example <account_id>/<application_id>
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustAccessApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustAccessApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_authenticate_via_warp: Optional[pulumi.Input[bool]] = None,
                 allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_launcher_logo_url: Optional[pulumi.Input[str]] = None,
                 app_launcher_visible: Optional[pulumi.Input[bool]] = None,
                 auto_redirect_to_identity: Optional[pulumi.Input[bool]] = None,
                 bg_color: Optional[pulumi.Input[str]] = None,
                 cors_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationCorsHeaderArgs', 'ZeroTrustAccessApplicationCorsHeaderArgsDict']]]]] = None,
                 custom_deny_message: Optional[pulumi.Input[str]] = None,
                 custom_deny_url: Optional[pulumi.Input[str]] = None,
                 custom_non_identity_deny_url: Optional[pulumi.Input[str]] = None,
                 custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 enable_binding_cookie: Optional[pulumi.Input[bool]] = None,
                 footer_links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]]] = None,
                 header_bg_color: Optional[pulumi.Input[str]] = None,
                 http_only_cookie_attribute: Optional[pulumi.Input[bool]] = None,
                 landing_page_design: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']]] = None,
                 logo_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options_preflight_bypass: Optional[pulumi.Input[bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 saas_app: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationSaasAppArgs', 'ZeroTrustAccessApplicationSaasAppArgsDict']]] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[str]] = None,
                 scim_config: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']]] = None,
                 self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_auth401_redirect: Optional[pulumi.Input[bool]] = None,
                 session_duration: Optional[pulumi.Input[str]] = None,
                 skip_app_launcher_login_page: Optional[pulumi.Input[bool]] = None,
                 skip_interstitial: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationTargetCriteriaArgs', 'ZeroTrustAccessApplicationTargetCriteriaArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustAccessApplicationArgs.__new__(ZeroTrustAccessApplicationArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["allow_authenticate_via_warp"] = allow_authenticate_via_warp
            __props__.__dict__["allowed_idps"] = allowed_idps
            __props__.__dict__["app_launcher_logo_url"] = app_launcher_logo_url
            __props__.__dict__["app_launcher_visible"] = app_launcher_visible
            __props__.__dict__["auto_redirect_to_identity"] = auto_redirect_to_identity
            __props__.__dict__["bg_color"] = bg_color
            __props__.__dict__["cors_headers"] = cors_headers
            __props__.__dict__["custom_deny_message"] = custom_deny_message
            __props__.__dict__["custom_deny_url"] = custom_deny_url
            __props__.__dict__["custom_non_identity_deny_url"] = custom_non_identity_deny_url
            __props__.__dict__["custom_pages"] = custom_pages
            __props__.__dict__["domain"] = domain
            __props__.__dict__["enable_binding_cookie"] = enable_binding_cookie
            __props__.__dict__["footer_links"] = footer_links
            __props__.__dict__["header_bg_color"] = header_bg_color
            __props__.__dict__["http_only_cookie_attribute"] = http_only_cookie_attribute
            __props__.__dict__["landing_page_design"] = landing_page_design
            __props__.__dict__["logo_url"] = logo_url
            __props__.__dict__["name"] = name
            __props__.__dict__["options_preflight_bypass"] = options_preflight_bypass
            __props__.__dict__["policies"] = policies
            __props__.__dict__["saas_app"] = saas_app
            __props__.__dict__["same_site_cookie_attribute"] = same_site_cookie_attribute
            __props__.__dict__["scim_config"] = scim_config
            __props__.__dict__["self_hosted_domains"] = self_hosted_domains
            __props__.__dict__["service_auth401_redirect"] = service_auth401_redirect
            __props__.__dict__["session_duration"] = session_duration
            __props__.__dict__["skip_app_launcher_login_page"] = skip_app_launcher_login_page
            __props__.__dict__["skip_interstitial"] = skip_interstitial
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_criterias"] = target_criterias
            __props__.__dict__["type"] = type
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["aud"] = None
        super(ZeroTrustAccessApplication, __self__).__init__(
            'cloudflare:index/zeroTrustAccessApplication:ZeroTrustAccessApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            allow_authenticate_via_warp: Optional[pulumi.Input[bool]] = None,
            allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            app_launcher_logo_url: Optional[pulumi.Input[str]] = None,
            app_launcher_visible: Optional[pulumi.Input[bool]] = None,
            aud: Optional[pulumi.Input[str]] = None,
            auto_redirect_to_identity: Optional[pulumi.Input[bool]] = None,
            bg_color: Optional[pulumi.Input[str]] = None,
            cors_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationCorsHeaderArgs', 'ZeroTrustAccessApplicationCorsHeaderArgsDict']]]]] = None,
            custom_deny_message: Optional[pulumi.Input[str]] = None,
            custom_deny_url: Optional[pulumi.Input[str]] = None,
            custom_non_identity_deny_url: Optional[pulumi.Input[str]] = None,
            custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            enable_binding_cookie: Optional[pulumi.Input[bool]] = None,
            footer_links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]]] = None,
            header_bg_color: Optional[pulumi.Input[str]] = None,
            http_only_cookie_attribute: Optional[pulumi.Input[bool]] = None,
            landing_page_design: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']]] = None,
            logo_url: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options_preflight_bypass: Optional[pulumi.Input[bool]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            saas_app: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationSaasAppArgs', 'ZeroTrustAccessApplicationSaasAppArgsDict']]] = None,
            same_site_cookie_attribute: Optional[pulumi.Input[str]] = None,
            scim_config: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']]] = None,
            self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_auth401_redirect: Optional[pulumi.Input[bool]] = None,
            session_duration: Optional[pulumi.Input[str]] = None,
            skip_app_launcher_login_page: Optional[pulumi.Input[bool]] = None,
            skip_interstitial: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationTargetCriteriaArgs', 'ZeroTrustAccessApplicationTargetCriteriaArgsDict']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'ZeroTrustAccessApplication':
        """
        Get an existing ZeroTrustAccessApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`.
        :param pulumi.Input[bool] allow_authenticate_via_warp: When set to true, users can authenticate to this application using their WARP session. When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_idps: The identity providers selected for the application.
        :param pulumi.Input[str] app_launcher_logo_url: The logo URL of the app launcher.
        :param pulumi.Input[bool] app_launcher_visible: Option to show/hide applications in App Launcher. Defaults to `true`.
        :param pulumi.Input[str] aud: Application Audience (AUD) Tag of the application.
        :param pulumi.Input[bool] auto_redirect_to_identity: Option to skip identity provider selection if only one is configured in `allowed_idps`. Defaults to `false`.
        :param pulumi.Input[str] bg_color: The background color of the app launcher.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationCorsHeaderArgs', 'ZeroTrustAccessApplicationCorsHeaderArgsDict']]]] cors_headers: CORS configuration for the Access Application. See below for reference structure.
        :param pulumi.Input[str] custom_deny_message: Option that returns a custom error message when a user is denied access to the application.
        :param pulumi.Input[str] custom_deny_url: Option that redirects to a custom URL when a user is denied access to the application via identity based rules.
        :param pulumi.Input[str] custom_non_identity_deny_url: Option that redirects to a custom URL when a user is denied access to the application via non identity rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_pages: The custom pages selected for the application.
        :param pulumi.Input[str] domain: The primary hostname and path that Access will secure. If the app is visible in the App Launcher dashboard, this is the domain that will be displayed.
        :param pulumi.Input[bool] enable_binding_cookie: Option to provide increased security against compromised authorization tokens and CSRF attacks by requiring an additional "binding" cookie on requests. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]] footer_links: The footer links of the app launcher.
        :param pulumi.Input[str] header_bg_color: The background color of the header bar in the app launcher.
        :param pulumi.Input[bool] http_only_cookie_attribute: Option to add the `HttpOnly` cookie flag to access tokens.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']] landing_page_design: The landing page design of the app launcher.
        :param pulumi.Input[str] logo_url: Image URL for the logo shown in the app launcher dashboard.
        :param pulumi.Input[str] name: Friendly name of the Access Application.
        :param pulumi.Input[bool] options_preflight_bypass: Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The policies associated with the application, in ascending order of precedence. Warning: Do not use this field while you still have this application ID referenced as `application_id` in any `AccessPolicy` resource, as it can result in an inconsistent state.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationSaasAppArgs', 'ZeroTrustAccessApplicationSaasAppArgsDict']] saas_app: SaaS configuration for the Access Application.
        :param pulumi.Input[str] same_site_cookie_attribute: Defines the same-site cookie setting for access tokens. Available values: `none`, `lax`, `strict`.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']] scim_config: Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] self_hosted_domains: List of domains that access will secure. Only present for self_hosted, vnc, and ssh applications. Always includes the value set as `domain`.
        :param pulumi.Input[bool] service_auth401_redirect: Option to return a 401 status code in service authentication rules on failed requests. Defaults to `false`.
        :param pulumi.Input[str] session_duration: How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`. Defaults to `24h`.
        :param pulumi.Input[bool] skip_app_launcher_login_page: Option to skip the App Launcher landing page. Defaults to `false`.
        :param pulumi.Input[bool] skip_interstitial: Option to skip the authorization interstitial when using the CLI. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The itags associated with the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationTargetCriteriaArgs', 'ZeroTrustAccessApplicationTargetCriteriaArgsDict']]]] target_criterias: The payload for an infrastructure application which defines the port, protocol, and target attributes. Only applicable to Infrastructure Applications, in which case this field is required.
        :param pulumi.Input[str] type: The application type. Available values: `app_launcher`, `bookmark`, `biso`, `dash_sso`, `saas`, `self_hosted`, `ssh`, `vnc`, `warp`, `infrastructure`. Defaults to `self_hosted`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustAccessApplicationState.__new__(_ZeroTrustAccessApplicationState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allow_authenticate_via_warp"] = allow_authenticate_via_warp
        __props__.__dict__["allowed_idps"] = allowed_idps
        __props__.__dict__["app_launcher_logo_url"] = app_launcher_logo_url
        __props__.__dict__["app_launcher_visible"] = app_launcher_visible
        __props__.__dict__["aud"] = aud
        __props__.__dict__["auto_redirect_to_identity"] = auto_redirect_to_identity
        __props__.__dict__["bg_color"] = bg_color
        __props__.__dict__["cors_headers"] = cors_headers
        __props__.__dict__["custom_deny_message"] = custom_deny_message
        __props__.__dict__["custom_deny_url"] = custom_deny_url
        __props__.__dict__["custom_non_identity_deny_url"] = custom_non_identity_deny_url
        __props__.__dict__["custom_pages"] = custom_pages
        __props__.__dict__["domain"] = domain
        __props__.__dict__["enable_binding_cookie"] = enable_binding_cookie
        __props__.__dict__["footer_links"] = footer_links
        __props__.__dict__["header_bg_color"] = header_bg_color
        __props__.__dict__["http_only_cookie_attribute"] = http_only_cookie_attribute
        __props__.__dict__["landing_page_design"] = landing_page_design
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["name"] = name
        __props__.__dict__["options_preflight_bypass"] = options_preflight_bypass
        __props__.__dict__["policies"] = policies
        __props__.__dict__["saas_app"] = saas_app
        __props__.__dict__["same_site_cookie_attribute"] = same_site_cookie_attribute
        __props__.__dict__["scim_config"] = scim_config
        __props__.__dict__["self_hosted_domains"] = self_hosted_domains
        __props__.__dict__["service_auth401_redirect"] = service_auth401_redirect
        __props__.__dict__["session_duration"] = session_duration
        __props__.__dict__["skip_app_launcher_login_page"] = skip_app_launcher_login_page
        __props__.__dict__["skip_interstitial"] = skip_interstitial
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_criterias"] = target_criterias
        __props__.__dict__["type"] = type
        __props__.__dict__["zone_id"] = zone_id
        return ZeroTrustAccessApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource. Conflicts with `zone_id`.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="allowAuthenticateViaWarp")
    def allow_authenticate_via_warp(self) -> pulumi.Output[Optional[bool]]:
        """
        When set to true, users can authenticate to this application using their WARP session. When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        """
        return pulumi.get(self, "allow_authenticate_via_warp")

    @property
    @pulumi.getter(name="allowedIdps")
    def allowed_idps(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The identity providers selected for the application.
        """
        return pulumi.get(self, "allowed_idps")

    @property
    @pulumi.getter(name="appLauncherLogoUrl")
    def app_launcher_logo_url(self) -> pulumi.Output[Optional[str]]:
        """
        The logo URL of the app launcher.
        """
        return pulumi.get(self, "app_launcher_logo_url")

    @property
    @pulumi.getter(name="appLauncherVisible")
    def app_launcher_visible(self) -> pulumi.Output[Optional[bool]]:
        """
        Option to show/hide applications in App Launcher. Defaults to `true`.
        """
        return pulumi.get(self, "app_launcher_visible")

    @property
    @pulumi.getter
    def aud(self) -> pulumi.Output[str]:
        """
        Application Audience (AUD) Tag of the application.
        """
        return pulumi.get(self, "aud")

    @property
    @pulumi.getter(name="autoRedirectToIdentity")
    def auto_redirect_to_identity(self) -> pulumi.Output[Optional[bool]]:
        """
        Option to skip identity provider selection if only one is configured in `allowed_idps`. Defaults to `false`.
        """
        return pulumi.get(self, "auto_redirect_to_identity")

    @property
    @pulumi.getter(name="bgColor")
    def bg_color(self) -> pulumi.Output[Optional[str]]:
        """
        The background color of the app launcher.
        """
        return pulumi.get(self, "bg_color")

    @property
    @pulumi.getter(name="corsHeaders")
    def cors_headers(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessApplicationCorsHeader']]]:
        """
        CORS configuration for the Access Application. See below for reference structure.
        """
        return pulumi.get(self, "cors_headers")

    @property
    @pulumi.getter(name="customDenyMessage")
    def custom_deny_message(self) -> pulumi.Output[Optional[str]]:
        """
        Option that returns a custom error message when a user is denied access to the application.
        """
        return pulumi.get(self, "custom_deny_message")

    @property
    @pulumi.getter(name="customDenyUrl")
    def custom_deny_url(self) -> pulumi.Output[Optional[str]]:
        """
        Option that redirects to a custom URL when a user is denied access to the application via identity based rules.
        """
        return pulumi.get(self, "custom_deny_url")

    @property
    @pulumi.getter(name="customNonIdentityDenyUrl")
    def custom_non_identity_deny_url(self) -> pulumi.Output[Optional[str]]:
        """
        Option that redirects to a custom URL when a user is denied access to the application via non identity rules.
        """
        return pulumi.get(self, "custom_non_identity_deny_url")

    @property
    @pulumi.getter(name="customPages")
    def custom_pages(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The custom pages selected for the application.
        """
        return pulumi.get(self, "custom_pages")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The primary hostname and path that Access will secure. If the app is visible in the App Launcher dashboard, this is the domain that will be displayed.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="enableBindingCookie")
    def enable_binding_cookie(self) -> pulumi.Output[Optional[bool]]:
        """
        Option to provide increased security against compromised authorization tokens and CSRF attacks by requiring an additional "binding" cookie on requests. Defaults to `false`.
        """
        return pulumi.get(self, "enable_binding_cookie")

    @property
    @pulumi.getter(name="footerLinks")
    def footer_links(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessApplicationFooterLink']]]:
        """
        The footer links of the app launcher.
        """
        return pulumi.get(self, "footer_links")

    @property
    @pulumi.getter(name="headerBgColor")
    def header_bg_color(self) -> pulumi.Output[Optional[str]]:
        """
        The background color of the header bar in the app launcher.
        """
        return pulumi.get(self, "header_bg_color")

    @property
    @pulumi.getter(name="httpOnlyCookieAttribute")
    def http_only_cookie_attribute(self) -> pulumi.Output[Optional[bool]]:
        """
        Option to add the `HttpOnly` cookie flag to access tokens.
        """
        return pulumi.get(self, "http_only_cookie_attribute")

    @property
    @pulumi.getter(name="landingPageDesign")
    def landing_page_design(self) -> pulumi.Output[Optional['outputs.ZeroTrustAccessApplicationLandingPageDesign']]:
        """
        The landing page design of the app launcher.
        """
        return pulumi.get(self, "landing_page_design")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[Optional[str]]:
        """
        Image URL for the logo shown in the app launcher dashboard.
        """
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Friendly name of the Access Application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="optionsPreflightBypass")
    def options_preflight_bypass(self) -> pulumi.Output[Optional[bool]]:
        """
        Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set. Defaults to `false`.
        """
        return pulumi.get(self, "options_preflight_bypass")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The policies associated with the application, in ascending order of precedence. Warning: Do not use this field while you still have this application ID referenced as `application_id` in any `AccessPolicy` resource, as it can result in an inconsistent state.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="saasApp")
    def saas_app(self) -> pulumi.Output[Optional['outputs.ZeroTrustAccessApplicationSaasApp']]:
        """
        SaaS configuration for the Access Application.
        """
        return pulumi.get(self, "saas_app")

    @property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        Defines the same-site cookie setting for access tokens. Available values: `none`, `lax`, `strict`.
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @property
    @pulumi.getter(name="scimConfig")
    def scim_config(self) -> pulumi.Output[Optional['outputs.ZeroTrustAccessApplicationScimConfig']]:
        """
        Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        """
        return pulumi.get(self, "scim_config")

    @property
    @pulumi.getter(name="selfHostedDomains")
    def self_hosted_domains(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of domains that access will secure. Only present for self_hosted, vnc, and ssh applications. Always includes the value set as `domain`.
        """
        return pulumi.get(self, "self_hosted_domains")

    @property
    @pulumi.getter(name="serviceAuth401Redirect")
    def service_auth401_redirect(self) -> pulumi.Output[Optional[bool]]:
        """
        Option to return a 401 status code in service authentication rules on failed requests. Defaults to `false`.
        """
        return pulumi.get(self, "service_auth401_redirect")

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[Optional[str]]:
        """
        How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`. Defaults to `24h`.
        """
        return pulumi.get(self, "session_duration")

    @property
    @pulumi.getter(name="skipAppLauncherLoginPage")
    def skip_app_launcher_login_page(self) -> pulumi.Output[Optional[bool]]:
        """
        Option to skip the App Launcher landing page. Defaults to `false`.
        """
        return pulumi.get(self, "skip_app_launcher_login_page")

    @property
    @pulumi.getter(name="skipInterstitial")
    def skip_interstitial(self) -> pulumi.Output[Optional[bool]]:
        """
        Option to skip the authorization interstitial when using the CLI. Defaults to `false`.
        """
        return pulumi.get(self, "skip_interstitial")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The itags associated with the application.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetCriterias")
    def target_criterias(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessApplicationTargetCriteria']]]:
        """
        The payload for an infrastructure application which defines the port, protocol, and target attributes. Only applicable to Infrastructure Applications, in which case this field is required.
        """
        return pulumi.get(self, "target_criterias")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The application type. Available values: `app_launcher`, `bookmark`, `biso`, `dash_sso`, `saas`, `self_hosted`, `ssh`, `vnc`, `warp`, `infrastructure`. Defaults to `self_hosted`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        return pulumi.get(self, "zone_id")

