# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustDevicePostureRuleArgs', 'ZeroTrustDevicePostureRule']

@pulumi.input_type
class ZeroTrustDevicePostureRuleArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleInputArgs']]]] = None,
                 matches: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleMatchArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ZeroTrustDevicePostureRule resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] type: The device posture rule type. Available values: `serial_number`, `file`, `application`, `gateway`, `warp`, `domain_joined`, `os_version`, `disk_encryption`, `firewall`, `client_certificate`, `client_certificate_v2`, `workspace_one`, `unique_client_id`, `crowdstrike_s2s`, `sentinelone`, `kolide`, `tanium_s2s`, `intune`, `sentinelone_s2s`, `custom_s2s`.
        :param pulumi.Input[str] expiration: Expire posture results after the specified amount of time. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleInputArgs']]] inputs: Required for all rule types except `warp`, `gateway`, and `tanium`.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleMatchArgs']]] matches: The conditions that the client must match to run the rule.
        :param pulumi.Input[str] name: Name of the device posture rule.
        :param pulumi.Input[str] schedule: Tells the client when to run the device posture check. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The device posture rule type. Available values: `serial_number`, `file`, `application`, `gateway`, `warp`, `domain_joined`, `os_version`, `disk_encryption`, `firewall`, `client_certificate`, `client_certificate_v2`, `workspace_one`, `unique_client_id`, `crowdstrike_s2s`, `sentinelone`, `kolide`, `tanium_s2s`, `intune`, `sentinelone_s2s`, `custom_s2s`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[str]]:
        """
        Expire posture results after the specified amount of time. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleInputArgs']]]]:
        """
        Required for all rule types except `warp`, `gateway`, and `tanium`.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleInputArgs']]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleMatchArgs']]]]:
        """
        The conditions that the client must match to run the rule.
        """
        return pulumi.get(self, "matches")

    @matches.setter
    def matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleMatchArgs']]]]):
        pulumi.set(self, "matches", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the device posture rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Tells the client when to run the device posture check. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class _ZeroTrustDevicePostureRuleState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleInputArgs']]]] = None,
                 matches: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleMatchArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustDevicePostureRule resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] expiration: Expire posture results after the specified amount of time. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleInputArgs']]] inputs: Required for all rule types except `warp`, `gateway`, and `tanium`.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleMatchArgs']]] matches: The conditions that the client must match to run the rule.
        :param pulumi.Input[str] name: Name of the device posture rule.
        :param pulumi.Input[str] schedule: Tells the client when to run the device posture check. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        :param pulumi.Input[str] type: The device posture rule type. Available values: `serial_number`, `file`, `application`, `gateway`, `warp`, `domain_joined`, `os_version`, `disk_encryption`, `firewall`, `client_certificate`, `client_certificate_v2`, `workspace_one`, `unique_client_id`, `crowdstrike_s2s`, `sentinelone`, `kolide`, `tanium_s2s`, `intune`, `sentinelone_s2s`, `custom_s2s`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[str]]:
        """
        Expire posture results after the specified amount of time. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleInputArgs']]]]:
        """
        Required for all rule types except `warp`, `gateway`, and `tanium`.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleInputArgs']]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleMatchArgs']]]]:
        """
        The conditions that the client must match to run the rule.
        """
        return pulumi.get(self, "matches")

    @matches.setter
    def matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDevicePostureRuleMatchArgs']]]]):
        pulumi.set(self, "matches", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the device posture rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Tells the client when to run the device posture check. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The device posture rule type. Available values: `serial_number`, `file`, `application`, `gateway`, `warp`, `domain_joined`, `os_version`, `disk_encryption`, `firewall`, `client_certificate`, `client_certificate_v2`, `workspace_one`, `unique_client_id`, `crowdstrike_s2s`, `sentinelone`, `kolide`, `tanium_s2s`, `intune`, `sentinelone_s2s`, `custom_s2s`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class ZeroTrustDevicePostureRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleInputArgs', 'ZeroTrustDevicePostureRuleInputArgsDict']]]]] = None,
                 matches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleMatchArgs', 'ZeroTrustDevicePostureRuleMatchArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Device Posture Rule resource. Device posture rules configure security policies for device posture checks.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        eaxmple = cloudflare.ZeroTrustDevicePostureRule("eaxmple",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="Corporate devices posture rule",
            type="os_version",
            description="Device posture rule for corporate devices.",
            schedule="24h",
            expiration="24h",
            matches=[{
                "platform": "linux",
            }],
            inputs=[{
                "id": corporate_devices["id"],
                "version": "1.0.0",
                "operator": "<",
                "os_distro_name": "ubuntu",
                "os_distro_revision": "1.0.0",
                "os_version_extra": "(a)",
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDevicePostureRule:ZeroTrustDevicePostureRule example <account_id>/<device_posture_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] expiration: Expire posture results after the specified amount of time. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleInputArgs', 'ZeroTrustDevicePostureRuleInputArgsDict']]]] inputs: Required for all rule types except `warp`, `gateway`, and `tanium`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleMatchArgs', 'ZeroTrustDevicePostureRuleMatchArgsDict']]]] matches: The conditions that the client must match to run the rule.
        :param pulumi.Input[str] name: Name of the device posture rule.
        :param pulumi.Input[str] schedule: Tells the client when to run the device posture check. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        :param pulumi.Input[str] type: The device posture rule type. Available values: `serial_number`, `file`, `application`, `gateway`, `warp`, `domain_joined`, `os_version`, `disk_encryption`, `firewall`, `client_certificate`, `client_certificate_v2`, `workspace_one`, `unique_client_id`, `crowdstrike_s2s`, `sentinelone`, `kolide`, `tanium_s2s`, `intune`, `sentinelone_s2s`, `custom_s2s`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustDevicePostureRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Device Posture Rule resource. Device posture rules configure security policies for device posture checks.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        eaxmple = cloudflare.ZeroTrustDevicePostureRule("eaxmple",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="Corporate devices posture rule",
            type="os_version",
            description="Device posture rule for corporate devices.",
            schedule="24h",
            expiration="24h",
            matches=[{
                "platform": "linux",
            }],
            inputs=[{
                "id": corporate_devices["id"],
                "version": "1.0.0",
                "operator": "<",
                "os_distro_name": "ubuntu",
                "os_distro_revision": "1.0.0",
                "os_version_extra": "(a)",
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDevicePostureRule:ZeroTrustDevicePostureRule example <account_id>/<device_posture_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustDevicePostureRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustDevicePostureRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleInputArgs', 'ZeroTrustDevicePostureRuleInputArgsDict']]]]] = None,
                 matches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleMatchArgs', 'ZeroTrustDevicePostureRuleMatchArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustDevicePostureRuleArgs.__new__(ZeroTrustDevicePostureRuleArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["description"] = description
            __props__.__dict__["expiration"] = expiration
            __props__.__dict__["inputs"] = inputs
            __props__.__dict__["matches"] = matches
            __props__.__dict__["name"] = name
            __props__.__dict__["schedule"] = schedule
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(ZeroTrustDevicePostureRule, __self__).__init__(
            'cloudflare:index/zeroTrustDevicePostureRule:ZeroTrustDevicePostureRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            expiration: Optional[pulumi.Input[str]] = None,
            inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleInputArgs', 'ZeroTrustDevicePostureRuleInputArgsDict']]]]] = None,
            matches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleMatchArgs', 'ZeroTrustDevicePostureRuleMatchArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            schedule: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'ZeroTrustDevicePostureRule':
        """
        Get an existing ZeroTrustDevicePostureRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] expiration: Expire posture results after the specified amount of time. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleInputArgs', 'ZeroTrustDevicePostureRuleInputArgsDict']]]] inputs: Required for all rule types except `warp`, `gateway`, and `tanium`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDevicePostureRuleMatchArgs', 'ZeroTrustDevicePostureRuleMatchArgsDict']]]] matches: The conditions that the client must match to run the rule.
        :param pulumi.Input[str] name: Name of the device posture rule.
        :param pulumi.Input[str] schedule: Tells the client when to run the device posture check. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        :param pulumi.Input[str] type: The device posture rule type. Available values: `serial_number`, `file`, `application`, `gateway`, `warp`, `domain_joined`, `os_version`, `disk_encryption`, `firewall`, `client_certificate`, `client_certificate_v2`, `workspace_one`, `unique_client_id`, `crowdstrike_s2s`, `sentinelone`, `kolide`, `tanium_s2s`, `intune`, `sentinelone_s2s`, `custom_s2s`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustDevicePostureRuleState.__new__(_ZeroTrustDevicePostureRuleState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["description"] = description
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["inputs"] = inputs
        __props__.__dict__["matches"] = matches
        __props__.__dict__["name"] = name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["type"] = type
        return ZeroTrustDevicePostureRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[Optional[str]]:
        """
        Expire posture results after the specified amount of time. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def inputs(self) -> pulumi.Output[Sequence['outputs.ZeroTrustDevicePostureRuleInput']]:
        """
        Required for all rule types except `warp`, `gateway`, and `tanium`.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def matches(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustDevicePostureRuleMatch']]]:
        """
        The conditions that the client must match to run the rule.
        """
        return pulumi.get(self, "matches")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the device posture rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional[str]]:
        """
        Tells the client when to run the device posture check. Must be in the format `1h` or `30m`. Valid units are `h` and `m`.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The device posture rule type. Available values: `serial_number`, `file`, `application`, `gateway`, `warp`, `domain_joined`, `os_version`, `disk_encryption`, `firewall`, `client_certificate`, `client_certificate_v2`, `workspace_one`, `unique_client_id`, `crowdstrike_s2s`, `sentinelone`, `kolide`, `tanium_s2s`, `intune`, `sentinelone_s2s`, `custom_s2s`.
        """
        return pulumi.get(self, "type")

