# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZoneArgs', 'Zone']

@pulumi.input_type
class ZoneArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 zone: pulumi.Input[str],
                 jump_start: Optional[pulumi.Input[bool]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Zone resource.
        :param pulumi.Input[str] account_id: Account ID to manage the zone resource in.
        :param pulumi.Input[str] zone: The DNS zone name which will be added. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[bool] jump_start: Whether to scan for DNS records on creation. Ignored after zone is created.
        :param pulumi.Input[bool] paused: Whether this zone is paused (traffic bypasses Cloudflare). Defaults to `false`.
        :param pulumi.Input[str] plan: The name of the commercial plan to apply to the zone. Available values: `free`, `lite`, `pro`, `pro_plus`, `business`, `enterprise`, `partners_free`, `partners_pro`, `partners_business`, `partners_enterprise`.
        :param pulumi.Input[str] type: A full zone implies that DNS is hosted with Cloudflare. A partial zone is typically a partner-hosted zone or a CNAME setup. Available values: `full`, `partial`, `secondary`. Defaults to `full`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vanity_name_servers: List of Vanity Nameservers (if set).
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "zone", zone)
        if jump_start is not None:
            pulumi.set(__self__, "jump_start", jump_start)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vanity_name_servers is not None:
            pulumi.set(__self__, "vanity_name_servers", vanity_name_servers)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        Account ID to manage the zone resource in.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[str]:
        """
        The DNS zone name which will be added. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter(name="jumpStart")
    def jump_start(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to scan for DNS records on creation. Ignored after zone is created.
        """
        return pulumi.get(self, "jump_start")

    @jump_start.setter
    def jump_start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jump_start", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this zone is paused (traffic bypasses Cloudflare). Defaults to `false`.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the commercial plan to apply to the zone. Available values: `free`, `lite`, `pro`, `pro_plus`, `business`, `enterprise`, `partners_free`, `partners_pro`, `partners_business`, `partners_enterprise`.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        A full zone implies that DNS is hosted with Cloudflare. A partial zone is typically a partner-hosted zone or a CNAME setup. Available values: `full`, `partial`, `secondary`. Defaults to `full`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vanityNameServers")
    def vanity_name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Vanity Nameservers (if set).
        """
        return pulumi.get(self, "vanity_name_servers")

    @vanity_name_servers.setter
    def vanity_name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vanity_name_servers", value)


@pulumi.input_type
class _ZoneState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 jump_start: Optional[pulumi.Input[bool]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 verification_key: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Zone resources.
        :param pulumi.Input[str] account_id: Account ID to manage the zone resource in.
        :param pulumi.Input[bool] jump_start: Whether to scan for DNS records on creation. Ignored after zone is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] name_servers: Cloudflare-assigned name servers. This is only populated for zones that use Cloudflare DNS.
        :param pulumi.Input[bool] paused: Whether this zone is paused (traffic bypasses Cloudflare). Defaults to `false`.
        :param pulumi.Input[str] plan: The name of the commercial plan to apply to the zone. Available values: `free`, `lite`, `pro`, `pro_plus`, `business`, `enterprise`, `partners_free`, `partners_pro`, `partners_business`, `partners_enterprise`.
        :param pulumi.Input[str] status: Status of the zone. Available values: `active`, `pending`, `initializing`, `moved`, `deleted`, `deactivated`.
        :param pulumi.Input[str] type: A full zone implies that DNS is hosted with Cloudflare. A partial zone is typically a partner-hosted zone or a CNAME setup. Available values: `full`, `partial`, `secondary`. Defaults to `full`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vanity_name_servers: List of Vanity Nameservers (if set).
        :param pulumi.Input[str] verification_key: Contains the TXT record value to validate domain ownership. This is only populated for zones of type `partial`.
        :param pulumi.Input[str] zone: The DNS zone name which will be added. **Modifying this attribute will force creation of a new resource.**
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if jump_start is not None:
            pulumi.set(__self__, "jump_start", jump_start)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vanity_name_servers is not None:
            pulumi.set(__self__, "vanity_name_servers", vanity_name_servers)
        if verification_key is not None:
            pulumi.set(__self__, "verification_key", verification_key)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Account ID to manage the zone resource in.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="jumpStart")
    def jump_start(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to scan for DNS records on creation. Ignored after zone is created.
        """
        return pulumi.get(self, "jump_start")

    @jump_start.setter
    def jump_start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jump_start", value)

    @property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]:
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]):
        pulumi.set(self, "meta", value)

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Cloudflare-assigned name servers. This is only populated for zones that use Cloudflare DNS.
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "name_servers", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this zone is paused (traffic bypasses Cloudflare). Defaults to `false`.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the commercial plan to apply to the zone. Available values: `free`, `lite`, `pro`, `pro_plus`, `business`, `enterprise`, `partners_free`, `partners_pro`, `partners_business`, `partners_enterprise`.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the zone. Available values: `active`, `pending`, `initializing`, `moved`, `deleted`, `deactivated`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        A full zone implies that DNS is hosted with Cloudflare. A partial zone is typically a partner-hosted zone or a CNAME setup. Available values: `full`, `partial`, `secondary`. Defaults to `full`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vanityNameServers")
    def vanity_name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Vanity Nameservers (if set).
        """
        return pulumi.get(self, "vanity_name_servers")

    @vanity_name_servers.setter
    def vanity_name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vanity_name_servers", value)

    @property
    @pulumi.getter(name="verificationKey")
    def verification_key(self) -> Optional[pulumi.Input[str]]:
        """
        Contains the TXT record value to validate domain ownership. This is only populated for zones of type `partial`.
        """
        return pulumi.get(self, "verification_key")

    @verification_key.setter
    def verification_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verification_key", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS zone name which will be added. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Zone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 jump_start: Optional[pulumi.Input[bool]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Zone resource. Zone is the basic resource for
        working with Cloudflare and is roughly equivalent to a domain name
        that the user purchases.

        > If you are attempting to sign up a subdomain of a zone you must first have Subdomain Support entitlement for your account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.Zone("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            zone="example.com")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zone:Zone example <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account ID to manage the zone resource in.
        :param pulumi.Input[bool] jump_start: Whether to scan for DNS records on creation. Ignored after zone is created.
        :param pulumi.Input[bool] paused: Whether this zone is paused (traffic bypasses Cloudflare). Defaults to `false`.
        :param pulumi.Input[str] plan: The name of the commercial plan to apply to the zone. Available values: `free`, `lite`, `pro`, `pro_plus`, `business`, `enterprise`, `partners_free`, `partners_pro`, `partners_business`, `partners_enterprise`.
        :param pulumi.Input[str] type: A full zone implies that DNS is hosted with Cloudflare. A partial zone is typically a partner-hosted zone or a CNAME setup. Available values: `full`, `partial`, `secondary`. Defaults to `full`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vanity_name_servers: List of Vanity Nameservers (if set).
        :param pulumi.Input[str] zone: The DNS zone name which will be added. **Modifying this attribute will force creation of a new resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Zone resource. Zone is the basic resource for
        working with Cloudflare and is roughly equivalent to a domain name
        that the user purchases.

        > If you are attempting to sign up a subdomain of a zone you must first have Subdomain Support entitlement for your account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.Zone("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            zone="example.com")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zone:Zone example <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param ZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 jump_start: Optional[pulumi.Input[bool]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneArgs.__new__(ZoneArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["jump_start"] = jump_start
            __props__.__dict__["paused"] = paused
            __props__.__dict__["plan"] = plan
            __props__.__dict__["type"] = type
            __props__.__dict__["vanity_name_servers"] = vanity_name_servers
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["meta"] = None
            __props__.__dict__["name_servers"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["verification_key"] = None
        super(Zone, __self__).__init__(
            'cloudflare:index/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            jump_start: Optional[pulumi.Input[bool]] = None,
            meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
            name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            paused: Optional[pulumi.Input[bool]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vanity_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            verification_key: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Zone':
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account ID to manage the zone resource in.
        :param pulumi.Input[bool] jump_start: Whether to scan for DNS records on creation. Ignored after zone is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] name_servers: Cloudflare-assigned name servers. This is only populated for zones that use Cloudflare DNS.
        :param pulumi.Input[bool] paused: Whether this zone is paused (traffic bypasses Cloudflare). Defaults to `false`.
        :param pulumi.Input[str] plan: The name of the commercial plan to apply to the zone. Available values: `free`, `lite`, `pro`, `pro_plus`, `business`, `enterprise`, `partners_free`, `partners_pro`, `partners_business`, `partners_enterprise`.
        :param pulumi.Input[str] status: Status of the zone. Available values: `active`, `pending`, `initializing`, `moved`, `deleted`, `deactivated`.
        :param pulumi.Input[str] type: A full zone implies that DNS is hosted with Cloudflare. A partial zone is typically a partner-hosted zone or a CNAME setup. Available values: `full`, `partial`, `secondary`. Defaults to `full`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vanity_name_servers: List of Vanity Nameservers (if set).
        :param pulumi.Input[str] verification_key: Contains the TXT record value to validate domain ownership. This is only populated for zones of type `partial`.
        :param pulumi.Input[str] zone: The DNS zone name which will be added. **Modifying this attribute will force creation of a new resource.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneState.__new__(_ZoneState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["jump_start"] = jump_start
        __props__.__dict__["meta"] = meta
        __props__.__dict__["name_servers"] = name_servers
        __props__.__dict__["paused"] = paused
        __props__.__dict__["plan"] = plan
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["vanity_name_servers"] = vanity_name_servers
        __props__.__dict__["verification_key"] = verification_key
        __props__.__dict__["zone"] = zone
        return Zone(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        Account ID to manage the zone resource in.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="jumpStart")
    def jump_start(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to scan for DNS records on creation. Ignored after zone is created.
        """
        return pulumi.get(self, "jump_start")

    @property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Mapping[str, bool]]:
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        Cloudflare-assigned name servers. This is only populated for zones that use Cloudflare DNS.
        """
        return pulumi.get(self, "name_servers")

    @property
    @pulumi.getter
    def paused(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether this zone is paused (traffic bypasses Cloudflare). Defaults to `false`.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[str]:
        """
        The name of the commercial plan to apply to the zone. Available values: `free`, `lite`, `pro`, `pro_plus`, `business`, `enterprise`, `partners_free`, `partners_pro`, `partners_business`, `partners_enterprise`.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the zone. Available values: `active`, `pending`, `initializing`, `moved`, `deleted`, `deactivated`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        A full zone implies that DNS is hosted with Cloudflare. A partial zone is typically a partner-hosted zone or a CNAME setup. Available values: `full`, `partial`, `secondary`. Defaults to `full`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vanityNameServers")
    def vanity_name_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        List of Vanity Nameservers (if set).
        """
        return pulumi.get(self, "vanity_name_servers")

    @property
    @pulumi.getter(name="verificationKey")
    def verification_key(self) -> pulumi.Output[str]:
        """
        Contains the TXT record value to validate domain ownership. This is only populated for zones of type `partial`.
        """
        return pulumi.get(self, "verification_key")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The DNS zone name which will be added. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone")

