# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZoneHoldArgs', 'ZoneHold']

@pulumi.input_type
class ZoneHoldArgs:
    def __init__(__self__, *,
                 hold: pulumi.Input[bool],
                 zone_id: pulumi.Input[str],
                 hold_after: Optional[pulumi.Input[str]] = None,
                 include_subdomains: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ZoneHold resource.
        :param pulumi.Input[bool] hold: Enablement status of the zone hold.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        :param pulumi.Input[str] hold_after: The RFC3339 compatible timestamp when to automatically re-enable the zone hold.
        :param pulumi.Input[bool] include_subdomains: Whether to extend to block any subdomain of the given zone.
        """
        pulumi.set(__self__, "hold", hold)
        pulumi.set(__self__, "zone_id", zone_id)
        if hold_after is not None:
            pulumi.set(__self__, "hold_after", hold_after)
        if include_subdomains is not None:
            pulumi.set(__self__, "include_subdomains", include_subdomains)

    @property
    @pulumi.getter
    def hold(self) -> pulumi.Input[bool]:
        """
        Enablement status of the zone hold.
        """
        return pulumi.get(self, "hold")

    @hold.setter
    def hold(self, value: pulumi.Input[bool]):
        pulumi.set(self, "hold", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="holdAfter")
    def hold_after(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC3339 compatible timestamp when to automatically re-enable the zone hold.
        """
        return pulumi.get(self, "hold_after")

    @hold_after.setter
    def hold_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hold_after", value)

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to extend to block any subdomain of the given zone.
        """
        return pulumi.get(self, "include_subdomains")

    @include_subdomains.setter
    def include_subdomains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_subdomains", value)


@pulumi.input_type
class _ZoneHoldState:
    def __init__(__self__, *,
                 hold: Optional[pulumi.Input[bool]] = None,
                 hold_after: Optional[pulumi.Input[str]] = None,
                 include_subdomains: Optional[pulumi.Input[bool]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ZoneHold resources.
        :param pulumi.Input[bool] hold: Enablement status of the zone hold.
        :param pulumi.Input[str] hold_after: The RFC3339 compatible timestamp when to automatically re-enable the zone hold.
        :param pulumi.Input[bool] include_subdomains: Whether to extend to block any subdomain of the given zone.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        if hold is not None:
            pulumi.set(__self__, "hold", hold)
        if hold_after is not None:
            pulumi.set(__self__, "hold_after", hold_after)
        if include_subdomains is not None:
            pulumi.set(__self__, "include_subdomains", include_subdomains)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def hold(self) -> Optional[pulumi.Input[bool]]:
        """
        Enablement status of the zone hold.
        """
        return pulumi.get(self, "hold")

    @hold.setter
    def hold(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hold", value)

    @property
    @pulumi.getter(name="holdAfter")
    def hold_after(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC3339 compatible timestamp when to automatically re-enable the zone hold.
        """
        return pulumi.get(self, "hold_after")

    @hold_after.setter
    def hold_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hold_after", value)

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to extend to block any subdomain of the given zone.
        """
        return pulumi.get(self, "include_subdomains")

    @include_subdomains.setter
    def include_subdomains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_subdomains", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class ZoneHold(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hold: Optional[pulumi.Input[bool]] = None,
                 hold_after: Optional[pulumi.Input[str]] = None,
                 include_subdomains: Optional[pulumi.Input[bool]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Zone Hold resource that prevents adding
        the hostname to another account for use.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.ZoneHold("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            hold=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zoneHold:ZoneHold example <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] hold: Enablement status of the zone hold.
        :param pulumi.Input[str] hold_after: The RFC3339 compatible timestamp when to automatically re-enable the zone hold.
        :param pulumi.Input[bool] include_subdomains: Whether to extend to block any subdomain of the given zone.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneHoldArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Zone Hold resource that prevents adding
        the hostname to another account for use.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.ZoneHold("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            hold=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zoneHold:ZoneHold example <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param ZoneHoldArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneHoldArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hold: Optional[pulumi.Input[bool]] = None,
                 hold_after: Optional[pulumi.Input[str]] = None,
                 include_subdomains: Optional[pulumi.Input[bool]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneHoldArgs.__new__(ZoneHoldArgs)

            if hold is None and not opts.urn:
                raise TypeError("Missing required property 'hold'")
            __props__.__dict__["hold"] = hold
            __props__.__dict__["hold_after"] = hold_after
            __props__.__dict__["include_subdomains"] = include_subdomains
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(ZoneHold, __self__).__init__(
            'cloudflare:index/zoneHold:ZoneHold',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            hold: Optional[pulumi.Input[bool]] = None,
            hold_after: Optional[pulumi.Input[str]] = None,
            include_subdomains: Optional[pulumi.Input[bool]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'ZoneHold':
        """
        Get an existing ZoneHold resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] hold: Enablement status of the zone hold.
        :param pulumi.Input[str] hold_after: The RFC3339 compatible timestamp when to automatically re-enable the zone hold.
        :param pulumi.Input[bool] include_subdomains: Whether to extend to block any subdomain of the given zone.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneHoldState.__new__(_ZoneHoldState)

        __props__.__dict__["hold"] = hold
        __props__.__dict__["hold_after"] = hold_after
        __props__.__dict__["include_subdomains"] = include_subdomains
        __props__.__dict__["zone_id"] = zone_id
        return ZoneHold(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def hold(self) -> pulumi.Output[bool]:
        """
        Enablement status of the zone hold.
        """
        return pulumi.get(self, "hold")

    @property
    @pulumi.getter(name="holdAfter")
    def hold_after(self) -> pulumi.Output[str]:
        """
        The RFC3339 compatible timestamp when to automatically re-enable the zone hold.
        """
        return pulumi.get(self, "hold_after")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to extend to block any subdomain of the given zone.
        """
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

