"""
Unified agent runtime API (LangChain-powered).

This module provides a stable import path `evenage.core.agent.Agent`
that wraps the existing BaseAgent from agent_base.

Lightweight local mode can use the in-process registry for delegation.
Distributed mode should wire through message bus in runner/worker.
"""

from __future__ import annotations

from typing import Dict

from .agent_base import BaseAgent as Agent  # Re-export for compatibility


# Minimal in-process registry for lightweight mode
_AGENT_REGISTRY: Dict[str, Agent] = {}


def register(name: str, agent: Agent) -> None:
    _AGENT_REGISTRY[name] = agent


def get(name: str) -> Agent | None:
    return _AGENT_REGISTRY.get(name)


def list_agents() -> list[str]:
    return list(_AGENT_REGISTRY.keys())


__all__ = ["Agent", "register", "get", "list_agents"]
