"""
Unified backend factory (shim) for the new module layout.

Exposes BackendFactory and helpers to construct backends from the
JSON runtime config (.evenage/config.json) or environment defaults.
"""

from __future__ import annotations

from .config import EvenAgeConfig, BackendFactory as _BackendFactory, load_runtime_config


class BackendFactory(_BackendFactory):
    """Shim that reuses the existing implementation.

    You can construct with an EvenAgeConfig or use from_runtime() to
    auto-detect configuration.
    """

    @classmethod
    def from_runtime(cls) -> "BackendFactory":
        cfg = load_runtime_config()
        return cls(cfg)


__all__ = ["BackendFactory", "EvenAgeConfig", "load_runtime_config"]
