"""
Code-first infrastructure connectors for EvenAge.

This package exposes small, explicit connect_* helpers to wire
backends in code without relying on environment-only factories.

All helpers return concrete instances from evenage.core.* so it
remains fully compatible with the current implementation.
"""
from __future__ import annotations

from dataclasses import dataclass
from typing import Any


@dataclass
class Infra:
    """Bundle of connected infrastructure services."""
    bus: Any
    database: Any
    vector: Any | None
    llm: Any | None
    storage: Any | None
    cache: Any | None
