"""
Database connector helpers.

Provides connect_database() to construct the core DatabaseService
with an explicit URL.
"""
from __future__ import annotations

from typing import Any


def connect_database(database_url: str) -> Any:
    """Create and return a DatabaseService for the given URL."""
    # Moved to unified backends module
    from evenage.core.backends.database import DatabaseService

    db = DatabaseService(database_url)
    # Ensure tables exist
    try:
        db.create_tables()
    except Exception:
        # Safe to ignore if already created
        pass
    return db
