"""
Storage connector helpers.

Provides connect_storage() to construct a MinIOStorage (or InMemory fallback)
from explicit parameters.
"""
from __future__ import annotations

from typing import Any


def connect_storage(
    *,
    endpoint: str | None,
    access_key: str | None,
    secret_key: str | None,
    secure: bool = False,
    fallback_inmemory: bool = True,
) -> Any:
    """Create a storage backend.

    If endpoint is None and fallback_inmemory=True, returns InMemoryStorage.
    """
    # Use unified backends module
    from evenage.core.backends.storage import InMemoryStorage, MinIOStorage

    if endpoint:
        return MinIOStorage(
            endpoint=endpoint,
            access_key=access_key or "",
            secret_key=secret_key or "",
            secure=secure,
        )
    if fallback_inmemory:
        return InMemoryStorage()
    raise ValueError("No storage endpoint provided and fallback disabled")
