"""
Core модуль XMLRiver Pro API
"""

from .async_base_client import AsyncBaseClient
from .exceptions import (
    XMLRiverError,
    AuthenticationError,
    RateLimitError,
    NoResultsError,
    NetworkError,
    ValidationError,
    InsufficientFundsError,
    ServiceUnavailableError,
    APIError,
    raise_xmlriver_error,
    get_error_message,
)
from .types import (
    SearchType,
    TimeFilter,
    DeviceType,
    OSType,
    SearchResult,
    SearchResponse,
    NewsResult,
    ImageResult,
    MapResult,
    AdResult,
    AdsResponse,
    OneBoxDocument,
    KnowledgeGraph,
    RelatedSearch,
    SearchsterResult,
    WordstatKeyword,
    WordstatResponse,
    WordstatHistoryPoint,
    WordstatHistoryResponse,
    Coords,
    SearchParams,
)

__all__ = [
    # Base client
    "AsyncBaseClient",
    # Exceptions
    "XMLRiverError",
    "AuthenticationError",
    "RateLimitError",
    "NoResultsError",
    "NetworkError",
    "ValidationError",
    "InsufficientFundsError",
    "ServiceUnavailableError",
    "APIError",
    "raise_xmlriver_error",
    "get_error_message",
    # Types
    "SearchType",
    "TimeFilter",
    "DeviceType",
    "OSType",
    "SearchResult",
    "SearchResponse",
    "NewsResult",
    "ImageResult",
    "MapResult",
    "AdResult",
    "AdsResponse",
    "OneBoxDocument",
    "KnowledgeGraph",
    "RelatedSearch",
    "SearchsterResult",
    "WordstatKeyword",
    "WordstatResponse",
    "WordstatHistoryPoint",
    "WordstatHistoryResponse",
    "Coords",
    "SearchParams",
]
