"""
Встроенные географические данные для XMLRiver Pro (полный набор)
"""

from typing import Dict, List, Optional
from dataclasses import dataclass


@dataclass
class YandexRegion:
    """Регион Yandex"""

    id: int
    name: str
    parent_id: int
    country_code: str = ""


@dataclass
class GoogleLanguage:
    """Язык Google"""

    code: str
    name: str


@dataclass
class GoogleDomain:
    """Домен Google"""

    code: str
    name: str
    country: str = ""


@dataclass
class City:
    """Город"""

    id: int
    name: str
    canonical_name: str
    parent_id: int
    country_code: str
    target_type: str
    status: str


# Встроенные регионы Yandex (полный набор)
YANDEX_REGIONS = {
    225: YandexRegion(225, "Россия", 0, ""),
    3: YandexRegion(3, "Центр", 225, ""),
    1: YandexRegion(1, "Москва и область", 3, ""),
    213: YandexRegion(213, "Москва", 1, ""),
    216: YandexRegion(216, "Зеленоград", 213, ""),
    20674: YandexRegion(20674, "Троицк", 213, ""),
    21624: YandexRegion(21624, "Щербинка", 213, ""),
    10716: YandexRegion(10716, "Балашиха", 1, ""),
    10717: YandexRegion(10717, "Бронницы", 1, ""),
    98580: YandexRegion(98580, "Волоколамский район", 1, ""),
    10721: YandexRegion(10721, "Волоколамск", 98580, ""),
    98581: YandexRegion(98581, "Воскресенский район", 1, ""),
    10722: YandexRegion(10722, "Воскресенск", 98581, ""),
    21735: YandexRegion(21735, "Дзержинский", 1, ""),
    98582: YandexRegion(98582, "Дмитровский район", 1, ""),
    10723: YandexRegion(10723, "Дмитров", 98582, ""),
    214: YandexRegion(214, "Долгопрудный", 1, ""),
    10725: YandexRegion(10725, "Домодедово", 1, ""),
    215: YandexRegion(215, "Дубна", 1, ""),
    98584: YandexRegion(98584, "Егорьевск (городской округ)", 1, ""),
    10727: YandexRegion(10727, "Егорьевск", 98584, ""),
    20571: YandexRegion(20571, "Жуковский", 1, ""),
    98585: YandexRegion(98585, "Зарайск (городской округ)", 1, ""),
    10728: YandexRegion(10728, "Зарайск", 98585, ""),
    10729: YandexRegion(10729, "Звенигород", 1, ""),
    21623: YandexRegion(21623, "Ивантеевка", 1, ""),
    98586: YandexRegion(98586, "Истра (городской округ)", 1, ""),
    21627: YandexRegion(21627, "Дедовск", 98586, ""),
    10731: YandexRegion(10731, "Истра", 98586, ""),
    98587: YandexRegion(98587, "Кашира (городской округ)", 1, ""),
    10732: YandexRegion(10732, "Кашира", 98587, ""),
    98588: YandexRegion(98588, "Клин (городской округ)", 1, ""),
    10733: YandexRegion(10733, "Клин", 98588, ""),
    10734: YandexRegion(10734, "Коломна", 1, ""),
    20728: YandexRegion(20728, "Королёв", 1, ""),
    100471: YandexRegion(100471, "Красноармейск", 1, ""),
    98590: YandexRegion(98590, "Красногорск (городской округ)", 1, ""),
    10735: YandexRegion(10735, "Красногорск", 98590, ""),
    21745: YandexRegion(21745, "Нахабино", 98590, ""),
    21647: YandexRegion(21647, "Краснознаменск", 1, ""),
    98591: YandexRegion(98591, "Ленинский район", 1, ""),
    10719: YandexRegion(10719, "Видное", 98591, ""),
    21641: YandexRegion(21641, "Лобня", 1, ""),
    21635: YandexRegion(21635, "Лосино-Петровский", 1, ""),
    98593: YandexRegion(98593, "Луховицы (городской округ)", 1, ""),
    10737: YandexRegion(10737, "Луховицы", 98593, ""),
    21630: YandexRegion(21630, "Лыткарино", 1, ""),
    98594: YandexRegion(98594, "Люберцы (городской округ)", 1, ""),
    10738: YandexRegion(10738, "Люберцы", 98594, ""),
    98595: YandexRegion(98595, "Можайский район", 1, ""),
    10739: YandexRegion(10739, "Можайск", 98595, ""),
    98596: YandexRegion(98596, "Мытищи (городской округ)", 1, ""),
    10740: YandexRegion(10740, "Мытищи", 98596, ""),
    98597: YandexRegion(98597, "Наро-Фоминский городской округ", 1, ""),
    10715: YandexRegion(10715, "Апрелевка", 98597, ""),
    10741: YandexRegion(10741, "Наро-Фоминск", 98597, ""),
    98598: YandexRegion(98598, "Ногинский район", 1, ""),
    10742: YandexRegion(10742, "Ногинск", 98598, ""),
    21656: YandexRegion(21656, "Старая Купавна", 98598, ""),
    21642: YandexRegion(21642, "Электроугли", 98598, ""),
    98599: YandexRegion(98599, "Одинцовский район", 1, ""),
    21646: YandexRegion(21646, "Голицыно", 98599, ""),
    21625: YandexRegion(21625, "Кубинка", 98599, ""),
    10743: YandexRegion(10743, "Одинцово", 98599, ""),
    10745: YandexRegion(10745, "Орехово-Зуево", 1, ""),
    98602: YandexRegion(98602, "Павловский Посад (городской округ)", 1, ""),
    10746: YandexRegion(10746, "Павловский Посад", 98602, ""),
    10747: YandexRegion(10747, "Подольск", 1, ""),
    20576: YandexRegion(20576, "Протвино", 1, ""),
    98604: YandexRegion(98604, "Пушкинский район", 1, ""),
    10748: YandexRegion(10748, "Пушкино", 98604, ""),
    217: YandexRegion(217, "Пущино", 1, ""),
    98605: YandexRegion(98605, "Раменский район", 1, ""),
    10750: YandexRegion(10750, "Раменское", 98605, ""),
    21621: YandexRegion(21621, "Реутов", 1, ""),
    98606: YandexRegion(98606, "Рузский городской округ", 1, ""),
    10751: YandexRegion(10751, "Руза", 98606, ""),
    98608: YandexRegion(98608, "Сергиево-Посадский район", 1, ""),
    10752: YandexRegion(10752, "Сергиев Посад", 98608, ""),
    21645: YandexRegion(21645, "Хотьково", 98608, ""),
    10754: YandexRegion(10754, "Серпухов", 1, ""),
    98611: YandexRegion(98611, "Солнечногорский район", 1, ""),
    10755: YandexRegion(10755, "Солнечногорск", 98611, ""),
    98607: YandexRegion(98607, "Ступино (городской округ)", 1, ""),
    10756: YandexRegion(10756, "Ступино", 98607, ""),
    21619: YandexRegion(21619, "Фрязино", 1, ""),
    10758: YandexRegion(10758, "Химки", 1, ""),
    219: YandexRegion(219, "Черноголовка", 1, ""),
    98614: YandexRegion(98614, "Чехов (городской округ)", 1, ""),
    10761: YandexRegion(10761, "Чехов", 98614, ""),
    98615: YandexRegion(98615, "Шатура (городской округ)", 1, ""),
    10762: YandexRegion(10762, "Шатура", 98615, ""),
    98617: YandexRegion(98617, "Щёлковский район", 1, ""),
    10765: YandexRegion(10765, "Щелково", 98617, ""),
    20523: YandexRegion(20523, "Электросталь", 1, ""),
    10645: YandexRegion(10645, "Белгородская область", 3, ""),
    98697: YandexRegion(98697, "Алексеевский район", 10645, ""),
    20192: YandexRegion(20192, "Алексеевка", 98697, ""),
    4: YandexRegion(4, "Белгород", 10645, ""),
    10646: YandexRegion(10646, "Губкин", 10645, ""),
    10649: YandexRegion(10649, "Старый Оскол", 10645, ""),
    98716: YandexRegion(98716, "Шебекинский район", 10645, ""),
    20196: YandexRegion(20196, "Шебекино", 98716, ""),
    98717: YandexRegion(98717, "Яковлевский район", 10645, ""),
    20587: YandexRegion(20587, "Строитель", 98717, ""),
    10650: YandexRegion(10650, "Брянская область", 3, ""),
    191: YandexRegion(191, "Брянск", 10650, ""),
    10653: YandexRegion(10653, "Клинцы", 10650, ""),
    10658: YandexRegion(10658, "Владимирская область", 3, ""),
    98745: YandexRegion(98745, "Александровский район", 10658, ""),
    10656: YandexRegion(10656, "Александров", 98745, ""),
    192: YandexRegion(192, "Владимир", 10658, ""),
    10661: YandexRegion(10661, "Гусь-Хрустальный", 10658, ""),
    98750: YandexRegion(98750, "Киржачский район", 10658, ""),
    10663: YandexRegion(10663, "Киржач", 98750, ""),
    10664: YandexRegion(10664, "Ковров", 10658, ""),
    10668: YandexRegion(10668, "Муром", 10658, ""),
    98755: YandexRegion(98755, "Петушинский район", 10658, ""),
    37129: YandexRegion(37129, "Покров", 98755, ""),
    10672: YandexRegion(10672, "Воронежская область", 3, ""),
    193: YandexRegion(193, "Воронеж", 10672, ""),
    98787: YandexRegion(98787, "Россошанский район", 10672, ""),
    10681: YandexRegion(10681, "Россошь", 98787, ""),
    10687: YandexRegion(10687, "Ивановская область", 3, ""),
    5: YandexRegion(5, "Иваново", 10687, ""),
    10689: YandexRegion(10689, "Кинешма", 10687, ""),
    10691: YandexRegion(10691, "Шуя", 10687, ""),
    10693: YandexRegion(10693, "Калужская область", 3, ""),
    6: YandexRegion(6, "Калуга", 10693, ""),
    98826: YandexRegion(98826, "Малоярославецкий район", 10693, ""),
    10697: YandexRegion(10697, "Малоярославец", 98826, ""),
    967: YandexRegion(967, "Обнинск", 10693, ""),
    10699: YandexRegion(10699, "Костромская область", 3, ""),
    7: YandexRegion(7, "Кострома", 10699, ""),
    10705: YandexRegion(10705, "Курская область", 3, ""),
    10710: YandexRegion(10710, "Железногорск", 10705, ""),
    8: YandexRegion(8, "Курск", 10705, ""),
    20707: YandexRegion(20707, "Курчатов", 10705, ""),
    10712: YandexRegion(10712, "Липецкая область", 3, ""),
    10713: YandexRegion(10713, "Елец", 10712, ""),
    9: YandexRegion(9, "Липецк", 10712, ""),
    10772: YandexRegion(10772, "Орловская область", 3, ""),
    10: YandexRegion(10, "Орёл", 10772, ""),
    10776: YandexRegion(10776, "Рязанская область", 3, ""),
    10773: YandexRegion(10773, "Касимов", 10776, ""),
    11: YandexRegion(11, "Рязань", 10776, ""),
    10795: YandexRegion(10795, "Смоленская область", 3, ""),
    98958: YandexRegion(98958, "Вяземский район", 10795, ""),
    10782: YandexRegion(10782, "Вязьма", 98958, ""),
    98959: YandexRegion(98959, "Гагаринский район", 10795, ""),
    10783: YandexRegion(10783, "Гагарин", 98959, ""),
    12: YandexRegion(12, "Смоленск", 10795, ""),
    98981: YandexRegion(98981, "Ярцевский район", 10795, ""),
    10801: YandexRegion(10801, "Ярцево", 98981, ""),
    10802: YandexRegion(10802, "Тамбовская область", 3, ""),
    10803: YandexRegion(10803, "Мичуринск", 10802, ""),
    13: YandexRegion(13, "Тамбов", 10802, ""),
    10819: YandexRegion(10819, "Тверская область", 3, ""),
    99008: YandexRegion(99008, "Бологовский район", 10819, ""),
    10805: YandexRegion(10805, "Бологое", 99008, ""),
    10807: YandexRegion(10807, "Вышний Волочёк", 10819, ""),
    10811: YandexRegion(10811, "Кимры", 10819, ""),
    99019: YandexRegion(99019, "Конаковский район", 10819, ""),
    10812: YandexRegion(10812, "Конаково", 99019, ""),
    10820: YandexRegion(10820, "Ржев", 10819, ""),
    14: YandexRegion(14, "Тверь", 10819, ""),
    99039: YandexRegion(99039, "Удомельский район", 10819, ""),
    10824: YandexRegion(10824, "Удомля", 99039, ""),
    10832: YandexRegion(10832, "Тульская область", 3, ""),
    99044: YandexRegion(99044, "Богородицкий район", 10832, ""),
    20667: YandexRegion(20667, "Богородицк", 99044, ""),
    10828: YandexRegion(10828, "Ефремов", 10832, ""),
    10830: YandexRegion(10830, "Новомосковск", 10832, ""),
    15: YandexRegion(15, "Тула", 10832, ""),
    10841: YandexRegion(10841, "Ярославская область", 3, ""),
    10837: YandexRegion(10837, "Переславль-Залесский", 10841, ""),
    10839: YandexRegion(10839, "Рыбинск", 10841, ""),
    99078: YandexRegion(99078, "Тутаевский район", 10841, ""),
    21154: YandexRegion(21154, "Тутаев", 99078, ""),
    99079: YandexRegion(99079, "Угличский район", 10841, ""),
    10840: YandexRegion(10840, "Углич", 99079, ""),
    16: YandexRegion(16, "Ярославль", 10841, ""),
    17: YandexRegion(17, "Северо-Запад", 225, ""),
    10174: YandexRegion(10174, "Санкт-Петербург и Ленинградская область", 17, ""),
    98620: YandexRegion(98620, "Волховский район", 10174, ""),
    10864: YandexRegion(10864, "Волхов", 98620, ""),
    98621: YandexRegion(98621, "Всеволожский район", 10174, ""),
    10865: YandexRegion(10865, "Всеволожск", 98621, ""),
    98622: YandexRegion(98622, "Выборгский район", 10174, ""),
    969: YandexRegion(969, "Выборг", 98622, ""),
    98623: YandexRegion(98623, "Гатчинский район", 10174, ""),
    10867: YandexRegion(10867, "Гатчина", 98623, ""),
    98624: YandexRegion(98624, "Кингисеппский район", 10174, ""),
    10870: YandexRegion(10870, "Кингисепп", 98624, ""),
    98625: YandexRegion(98625, "Киришский район", 10174, ""),
    10871: YandexRegion(10871, "Кириши", 98625, ""),
    98626: YandexRegion(98626, "Кировский район", 10174, ""),
    10872: YandexRegion(10872, "Кировск", 98626, ""),
    98629: YandexRegion(98629, "Лужский район", 10174, ""),
    10876: YandexRegion(10876, "Луга", 98629, ""),
    98630: YandexRegion(98630, "Подпорожский район", 10174, ""),
    10881: YandexRegion(10881, "Подпорожье", 98630, ""),
    98631: YandexRegion(98631, "Приозерский район", 10174, ""),
    10883: YandexRegion(10883, "Приозерск", 98631, ""),
    2: YandexRegion(2, "Санкт-Петербург", 10174, ""),
    20293: YandexRegion(20293, "Колпинский район", 2, ""),
    26081: YandexRegion(26081, "Колпино", 20293, ""),
    20297: YandexRegion(20297, "Пушкинский район", 2, ""),
    10884: YandexRegion(10884, "Пушкин", 20297, ""),
    98632: YandexRegion(98632, "Сланцевский район", 10174, ""),
    10888: YandexRegion(10888, "Сланцы", 98632, ""),
    10891: YandexRegion(10891, "Сосновый Бор", 10174, ""),
    98633: YandexRegion(98633, "Тихвинский район", 10174, ""),
    10892: YandexRegion(10892, "Тихвин", 98633, ""),
    98634: YandexRegion(98634, "Тосненский район", 10174, ""),
    10893: YandexRegion(10893, "Тосно", 98634, ""),
    10842: YandexRegion(10842, "Архангельская область", 17, ""),
    20: YandexRegion(20, "Архангельск", 10842, ""),
    10846: YandexRegion(10846, "Котлас", 10842, ""),
    10849: YandexRegion(10849, "Северодвинск", 10842, ""),
    10853: YandexRegion(10853, "Вологодская область", 17, ""),
    21: YandexRegion(21, "Вологда", 10853, ""),
    968: YandexRegion(968, "Череповец", 10853, ""),
    10857: YandexRegion(10857, "Калининградская область", 17, ""),
    22: YandexRegion(22, "Калининград", 10857, ""),
    10860: YandexRegion(10860, "Советск", 10857, ""),
    10897: YandexRegion(10897, "Мурманская область", 17, ""),
    10894: YandexRegion(10894, "Апатиты", 10897, ""),
    101749: YandexRegion(101749, "Кандалакшский район", 10897, ""),
    10895: YandexRegion(10895, "Кандалакша", 101749, ""),
    10896: YandexRegion(10896, "Мончегорск", 10897, ""),
    23: YandexRegion(23, "Мурманск", 10897, ""),
    20155: YandexRegion(20155, "Оленегорск", 10897, ""),
    10176: YandexRegion(10176, "Ненецкий автономный округ", 17, ""),
    10902: YandexRegion(10902, "Нарьян-Мар", 10176, ""),
    10904: YandexRegion(10904, "Новгородская область", 17, ""),
    99146: YandexRegion(99146, "Боровичский район", 10904, ""),
    10906: YandexRegion(10906, "Боровичи", 99146, ""),
    24: YandexRegion(24, "Великий Новгород", 10904, ""),
    99161: YandexRegion(99161, "Старорусский район", 10904, ""),
    10923: YandexRegion(10923, "Старая Русса", 99161, ""),
    10926: YandexRegion(10926, "Псковская область", 17, ""),
    10928: YandexRegion(10928, "Великие Луки", 10926, ""),
    25: YandexRegion(25, "Псков", 10926, ""),
    10933: YandexRegion(10933, "Республика Карелия", 17, ""),
    99193: YandexRegion(99193, "Кондопожский район", 10933, ""),
    10934: YandexRegion(10934, "Кондопога", 99193, ""),
    10935: YandexRegion(10935, "Костомукша", 10933, ""),
    18: YandexRegion(18, "Петрозаводск", 10933, ""),
    99203: YandexRegion(99203, "Сегежский район", 10933, ""),
    10936: YandexRegion(10936, "Сегежа", 99203, ""),
    110934: YandexRegion(110934, "Сортавальский район", 10933, ""),
    10937: YandexRegion(10937, "Сортавала", 110934, ""),
    10939: YandexRegion(10939, "Республика Коми", 17, ""),
    10940: YandexRegion(10940, "Воркута", 10939, ""),
    10941: YandexRegion(10941, "Инта", 10939, ""),
    99210: YandexRegion(99210, "Район Печора", 10939, ""),
    10942: YandexRegion(10942, "Печора", 99210, ""),
    19: YandexRegion(19, "Сыктывкар", 10939, ""),
    10944: YandexRegion(10944, "Усинск", 10939, ""),
    10945: YandexRegion(10945, "Ухта", 10939, ""),
    40: YandexRegion(40, "Поволжье", 225, ""),
    11070: YandexRegion(11070, "Кировская область", 40, ""),
    20020: YandexRegion(20020, "Вятские Поляны", 11070, ""),
    46: YandexRegion(46, "Киров", 11070, ""),
    11071: YandexRegion(11071, "Кирово-Чепецк", 11070, ""),
    11079: YandexRegion(11079, "Нижегородская область", 40, ""),
    11080: YandexRegion(11080, "Арзамас", 11079, ""),
    20040: YandexRegion(20040, "Выкса", 11079, ""),
    972: YandexRegion(972, "Дзержинск", 11079, ""),
    99555: YandexRegion(99555, "Кстовский район", 11079, ""),
    20044: YandexRegion(20044, "Кстово", 99555, ""),
    47: YandexRegion(47, "Нижний Новгород", 11079, ""),
    99560: YandexRegion(99560, "Павловский район", 11079, ""),
    11082: YandexRegion(11082, "Павлово", 99560, ""),
    11083: YandexRegion(11083, "Саров", 11079, ""),
    11084: YandexRegion(11084, "Оренбургская область", 40, ""),
    11086: YandexRegion(11086, "Бузулук", 11084, ""),
    11087: YandexRegion(11087, "Гай", 11084, ""),
    11090: YandexRegion(11090, "Новотроицк", 11084, ""),
    48: YandexRegion(48, "Оренбург", 11084, ""),
    11091: YandexRegion(11091, "Орск", 11084, ""),
    11095: YandexRegion(11095, "Пензенская область", 40, ""),
    11101: YandexRegion(11101, "Кузнецк", 11095, ""),
    49: YandexRegion(49, "Пенза", 11095, ""),
    11108: YandexRegion(11108, "Пермский край", 40, ""),
    20237: YandexRegion(20237, "Березники", 11108, ""),
    20244: YandexRegion(20244, "Лысьва", 11108, ""),
    50: YandexRegion(50, "Пермь", 11108, ""),
    11110: YandexRegion(11110, "Соликамск", 11108, ""),
    110916: YandexRegion(110916, "Чайковский район", 11108, ""),
    20243: YandexRegion(20243, "Чайковский", 110916, ""),
    11111: YandexRegion(11111, "Республика Башкортостан", 40, ""),
    99675: YandexRegion(99675, "Белебеевский район", 11111, ""),
    20714: YandexRegion(20714, "Белебей", 99675, ""),
    99677: YandexRegion(99677, "Белорецкий район", 11111, ""),
    20259: YandexRegion(20259, "Белорецк", 99677, ""),
    99694: YandexRegion(99694, "Ишимбайский район", 11111, ""),
    20718: YandexRegion(20718, "Ишимбай", 99694, ""),
    11113: YandexRegion(11113, "Кумертау", 11111, ""),
    99703: YandexRegion(99703, "Мелеузовский район", 11111, ""),
    20715: YandexRegion(20715, "Мелеуз", 99703, ""),
    11114: YandexRegion(11114, "Нефтекамск", 11111, ""),
    20235: YandexRegion(20235, "Октябрьский", 11111, ""),
    11115: YandexRegion(11115, "Салават", 11111, ""),
    20716: YandexRegion(20716, "Сибай", 11111, ""),
    11116: YandexRegion(11116, "Стерлитамак", 11111, ""),
    99712: YandexRegion(99712, "Туймазинский район", 11111, ""),
    20717: YandexRegion(20717, "Туймазы", 99712, ""),
    172: YandexRegion(172, "Уфа", 11111, ""),
    99714: YandexRegion(99714, "Учалинский район", 11111, ""),
    20680: YandexRegion(20680, "Учалы", 99714, ""),
    11077: YandexRegion(11077, "Республика Марий Эл", 40, ""),
    20721: YandexRegion(20721, "Волжск", 11077, ""),
    41: YandexRegion(41, "Йошкар-Ола", 11077, ""),
    11117: YandexRegion(11117, "Республика Мордовия", 40, ""),
    99737: YandexRegion(99737, "Рузаевский район", 11117, ""),
    20010: YandexRegion(20010, "Рузаевка", 99737, ""),
    42: YandexRegion(42, "Саранск", 11117, ""),
    11119: YandexRegion(11119, "Республика Татарстан", 40, ""),
    11121: YandexRegion(11121, "Альметьевск", 11119, ""),
    11122: YandexRegion(11122, "Бугульма", 11119, ""),
    43: YandexRegion(43, "Казань", 11119, ""),
    236: YandexRegion(236, "Набережные Челны", 11119, ""),
    11127: YandexRegion(11127, "Нижнекамск", 11119, ""),
    11131: YandexRegion(11131, "Самарская область", 40, ""),
    11132: YandexRegion(11132, "Жигулёвск", 11131, ""),
    51: YandexRegion(51, "Самара", 11131, ""),
    11139: YandexRegion(11139, "Сызрань", 11131, ""),
    240: YandexRegion(240, "Тольятти", 11131, ""),
    11146: YandexRegion(11146, "Саратовская область", 40, ""),
    99817: YandexRegion(99817, "Балаковский район", 11146, ""),
    11143: YandexRegion(11143, "Балаково", 99817, ""),
    99818: YandexRegion(99818, "Балашовский район", 11146, ""),
    11144: YandexRegion(11144, "Балашов", 99818, ""),
    194: YandexRegion(194, "Саратов", 11146, ""),
    99850: YandexRegion(99850, "Энгельсский район", 11146, ""),
    11147: YandexRegion(11147, "Энгельс", 99850, ""),
    11148: YandexRegion(11148, "Удмуртская Республика", 40, ""),
    11149: YandexRegion(11149, "Воткинск", 11148, ""),
    11150: YandexRegion(11150, "Глазов", 11148, ""),
    44: YandexRegion(44, "Ижевск", 11148, ""),
    11152: YandexRegion(11152, "Сарапул", 11148, ""),
    11153: YandexRegion(11153, "Ульяновская область", 40, ""),
    11155: YandexRegion(11155, "Димитровград", 11153, ""),
    195: YandexRegion(195, "Ульяновск", 11153, ""),
    11156: YandexRegion(11156, "Чувашская Республика", 40, ""),
    37133: YandexRegion(37133, "Новочебоксарск", 11156, ""),
    45: YandexRegion(45, "Чебоксары", 11156, ""),
    20078: YandexRegion(20078, "Шумерля", 11156, ""),
    26: YandexRegion(26, "Юг", 225, ""),
    10946: YandexRegion(10946, "Астраханская область", 26, ""),
    37: YandexRegion(37, "Астрахань", 10946, ""),
    99221: YandexRegion(99221, "Ахтубинский район", 10946, ""),
    20167: YandexRegion(20167, "Ахтубинск", 99221, ""),
    10950: YandexRegion(10950, "Волгоградская область", 26, ""),
    38: YandexRegion(38, "Волгоград", 10950, ""),
    10951: YandexRegion(10951, "Волжский", 10950, ""),
    10959: YandexRegion(10959, "Камышин", 10950, ""),
    10965: YandexRegion(10965, "Михайловка", 10950, ""),
    10981: YandexRegion(10981, "Урюпинск", 10950, ""),
    10995: YandexRegion(10995, "Краснодарский край", 26, ""),
    1107: YandexRegion(1107, "Анапа", 10995, ""),
    10987: YandexRegion(10987, "Армавир", 10995, ""),
    99269: YandexRegion(99269, "Белореченский район", 10995, ""),
    10988: YandexRegion(10988, "Белореченск", 99269, ""),
    10990: YandexRegion(10990, "Геленджик", 10995, ""),
    99274: YandexRegion(99274, "Ейский район", 10995, ""),
    10993: YandexRegion(10993, "Ейск", 99274, ""),
    99275: YandexRegion(99275, "Кавказский район", 10995, ""),
    10996: YandexRegion(10996, "Кропоткин", 99275, ""),
    35: YandexRegion(35, "Краснодар", 10995, ""),
    99281: YandexRegion(99281, "Крымский район", 10995, ""),
    10997: YandexRegion(10997, "Крымск", 99281, ""),
    970: YandexRegion(970, "Новороссийск", 10995, ""),
    99293: YandexRegion(99293, "Славянский район", 10995, ""),
    20704: YandexRegion(20704, "Славянск-на-Кубани", 99293, ""),
    239: YandexRegion(239, "Сочи", 10995, ""),
    99297: YandexRegion(99297, "Тимашевский район", 10995, ""),
    21141: YandexRegion(21141, "Тимашевск", 99297, ""),
    99298: YandexRegion(99298, "Тихорецкий район", 10995, ""),
    11002: YandexRegion(11002, "Тихорецк", 99298, ""),
    99299: YandexRegion(99299, "Туапсинский район", 10995, ""),
    1058: YandexRegion(1058, "Туапсе", 99299, ""),
    11004: YandexRegion(11004, "Республика Адыгея", 26, ""),
    1093: YandexRegion(1093, "Майкоп", 11004, ""),
    11015: YandexRegion(11015, "Республика Калмыкия", 26, ""),
    1094: YandexRegion(1094, "Элиста", 11015, ""),
    11029: YandexRegion(11029, "Ростовская область", 26, ""),
    11030: YandexRegion(11030, "Азов", 11029, ""),
    99411: YandexRegion(99411, "Белокалитвинский район", 11029, ""),
    11034: YandexRegion(11034, "Белая Калитва", 99411, ""),
    11036: YandexRegion(11036, "Волгодонск", 11029, ""),
    11043: YandexRegion(11043, "Каменск-Шахтинский", 11029, ""),
    238: YandexRegion(238, "Новочеркасск", 11029, ""),
    39: YandexRegion(39, "Ростов-на-Дону", 11029, ""),
    971: YandexRegion(971, "Таганрог", 11029, ""),
    11053: YandexRegion(11053, "Шахты", 11029, ""),
    59: YandexRegion(59, "Сибирь", 225, ""),
    11235: YandexRegion(11235, "Алтайский край", 59, ""),
    197: YandexRegion(197, "Барнаул", 11235, ""),
    975: YandexRegion(975, "Бийск", 11235, ""),
    11240: YandexRegion(11240, "Заринск", 11235, ""),
    11251: YandexRegion(11251, "Рубцовск", 11235, ""),
    11266: YandexRegion(11266, "Иркутская область", 59, ""),
    11256: YandexRegion(11256, "Ангарск", 11266, ""),
    976: YandexRegion(976, "Братск", 11266, ""),
    63: YandexRegion(63, "Иркутск", 11266, ""),
    100109: YandexRegion(100109, "Нижнеудинский район", 11266, ""),
    11268: YandexRegion(11268, "Нижнеудинск", 100109, ""),
    100112: YandexRegion(100112, "Тайшетский район", 11266, ""),
    11270: YandexRegion(11270, "Тайшет", 100112, ""),
    11271: YandexRegion(11271, "Тулун", 11266, ""),
    11272: YandexRegion(11272, "Усолье-Сибирское", 11266, ""),
    11273: YandexRegion(11273, "Усть-Илимск", 11266, ""),
    100116: YandexRegion(100116, "Усть-Кутский район", 11266, ""),
    20097: YandexRegion(20097, "Усть-Кут", 100116, ""),
    11274: YandexRegion(11274, "Черемхово", 11266, ""),
    11282: YandexRegion(11282, "Кемеровская область", 59, ""),
    11276: YandexRegion(11276, "Анжеро-Судженск", 11282, ""),
    11277: YandexRegion(11277, "Белово", 11282, ""),
    64: YandexRegion(64, "Кемерово", 11282, ""),
    11283: YandexRegion(11283, "Киселёвск", 11282, ""),
    11285: YandexRegion(11285, "Ленинск-Кузнецкий", 11282, ""),
    11287: YandexRegion(11287, "Междуреченск", 11282, ""),
    11288: YandexRegion(11288, "Мыски", 11282, ""),
    237: YandexRegion(237, "Новокузнецк", 11282, ""),
    11292: YandexRegion(11292, "Полысаево", 11282, ""),
    11291: YandexRegion(11291, "Прокопьевск", 11282, ""),
    11299: YandexRegion(11299, "Юрга", 11282, ""),
    11309: YandexRegion(11309, "Красноярский край", 59, ""),
    11302: YandexRegion(11302, "Ачинск", 11309, ""),
    20086: YandexRegion(20086, "Железногорск", 11309, ""),
    20088: YandexRegion(20088, "Зеленогорск", 11309, ""),
    62: YandexRegion(62, "Красноярск", 11309, ""),
    11310: YandexRegion(11310, "Минусинск", 11309, ""),
    11311: YandexRegion(11311, "Норильск", 11309, ""),
    11316: YandexRegion(11316, "Новосибирская область", 59, ""),
    20100: YandexRegion(20100, "Искитим", 11316, ""),
    65: YandexRegion(65, "Новосибирск", 11316, ""),
    11318: YandexRegion(11318, "Омская область", 59, ""),
    66: YandexRegion(66, "Омск", 11318, ""),
    10231: YandexRegion(10231, "Республика Алтай", 59, ""),
    11319: YandexRegion(11319, "Горно-Алтайск", 10231, ""),
    10233: YandexRegion(10233, "Республика Тыва", 59, ""),
    11340: YandexRegion(11340, "Республика Хакасия", 59, ""),
    1095: YandexRegion(1095, "Абакан", 11340, ""),
    11353: YandexRegion(11353, "Томская область", 59, ""),
    11351: YandexRegion(11351, "Северск", 11353, ""),
    11352: YandexRegion(11352, "Стрежевой", 11353, ""),
    67: YandexRegion(67, "Томск", 11353, ""),
    73: YandexRegion(73, "Дальний Восток", 225, ""),
    11375: YandexRegion(11375, "Амурская область", 73, ""),
    11374: YandexRegion(11374, "Белогорск", 11375, ""),
    77: YandexRegion(77, "Благовещенск", 11375, ""),
    11387: YandexRegion(11387, "Свободный", 11375, ""),
    11391: YandexRegion(11391, "Тында", 11375, ""),
    10243: YandexRegion(10243, "Еврейская автономная область", 73, ""),
    21949: YandexRegion(21949, "Забайкальский край", 73, ""),
    68: YandexRegion(68, "Чита", 21949, ""),
    11398: YandexRegion(11398, "Камчатский край", 73, ""),
    78: YandexRegion(78, "Петропавловск-Камчатский", 11398, ""),
    11403: YandexRegion(11403, "Магаданская область", 73, ""),
    79: YandexRegion(79, "Магадан", 11403, ""),
    11409: YandexRegion(11409, "Приморский край", 73, ""),
    11405: YandexRegion(11405, "Арсеньев", 11409, ""),
    11406: YandexRegion(11406, "Артём", 11409, ""),
    75: YandexRegion(75, "Владивосток", 11409, ""),
    11411: YandexRegion(11411, "Дальнегорск", 11409, ""),
    974: YandexRegion(974, "Находка", 11409, ""),
    11426: YandexRegion(11426, "Уссурийск", 11409, ""),
    11330: YandexRegion(11330, "Республика Бурятия", 73, ""),
    11327: YandexRegion(11327, "Северобайкальск", 11330, ""),
    198: YandexRegion(198, "Улан-Удэ", 11330, ""),
    11443: YandexRegion(11443, "Республика Саха (Якутия)", 73, ""),
    101987: YandexRegion(101987, "Нерюнгринский район", 11443, ""),
    11437: YandexRegion(11437, "Нерюнгри", 101987, ""),
    74: YandexRegion(74, "Якутск", 11443, ""),
    11450: YandexRegion(11450, "Сахалинская область", 73, ""),
    80: YandexRegion(80, "Южно-Сахалинск", 11450, ""),
    11457: YandexRegion(11457, "Хабаровский край", 73, ""),
    100398: YandexRegion(100398, "Амурский район", 11457, ""),
    11451: YandexRegion(11451, "Амурск", 100398, ""),
    11453: YandexRegion(11453, "Комсомольск-на-Амуре", 11457, ""),
    76: YandexRegion(76, "Хабаровск", 11457, ""),
    10251: YandexRegion(10251, "Чукотский автономный округ", 73, ""),
    977: YandexRegion(977, "Республика Крым", 225, ""),
    11471: YandexRegion(11471, "Алушта", 977, ""),
    28892: YandexRegion(28892, "Армянск", 977, ""),
    24696: YandexRegion(24696, "Бахчисарайский район", 977, ""),
    27217: YandexRegion(27217, "Бахчисарай", 24696, ""),
    27555: YandexRegion(27555, "Джанкой", 977, ""),
    11463: YandexRegion(11463, "Евпатория", 977, ""),
    11464: YandexRegion(11464, "Керчь", 977, ""),
    27693: YandexRegion(27693, "Красноперекопск", 977, ""),
    24702: YandexRegion(24702, "Ленинский район", 977, ""),
    28786: YandexRegion(28786, "Щёлкино", 24702, ""),
    20556: YandexRegion(20556, "Саки", 977, ""),
    959: YandexRegion(959, "Севастополь", 977, ""),
    146: YandexRegion(146, "Симферополь", 977, ""),
    11472: YandexRegion(11472, "Судак", 977, ""),
    11469: YandexRegion(11469, "Феодосия", 977, ""),
    11470: YandexRegion(11470, "Ялта", 977, ""),
    102444: YandexRegion(102444, "Северный Кавказ", 225, ""),
    11013: YandexRegion(11013, "Кабардино-Балкарская Республика", 102444, ""),
    30: YandexRegion(30, "Нальчик", 11013, ""),
    11020: YandexRegion(11020, "Карачаево-Черкесская Республика", 102444, ""),
    1104: YandexRegion(1104, "Черкесск", 11020, ""),
    11010: YandexRegion(11010, "Республика Дагестан", 102444, ""),
    11006: YandexRegion(11006, "Буйнакск", 11010, ""),
    11007: YandexRegion(11007, "Дербент", 11010, ""),
    21521: YandexRegion(21521, "Избербаш", 11010, ""),
    11008: YandexRegion(11008, "Каспийск", 11010, ""),
    11009: YandexRegion(11009, "Кизляр", 11010, ""),
    28: YandexRegion(28, "Махачкала", 11010, ""),
    11011: YandexRegion(11011, "Хасавюрт", 11010, ""),
    11012: YandexRegion(11012, "Республика Ингушетия", 102444, ""),
    1092: YandexRegion(1092, "Назрань", 11012, ""),
    11021: YandexRegion(11021, "Республика Северная Осетия — Алания", 102444, ""),
    33: YandexRegion(33, "Владикавказ", 11021, ""),
    11069: YandexRegion(11069, "Ставропольский край", 102444, ""),
    99456: YandexRegion(99456, "Будённовский район", 11069, ""),
    11055: YandexRegion(11055, "Будённовск", 99456, ""),
    11056: YandexRegion(11056, "Георгиевск", 11069, ""),
    11057: YandexRegion(11057, "Ессентуки", 11069, ""),
    11062: YandexRegion(11062, "Кисловодск", 11069, ""),
    11063: YandexRegion(11063, "Минеральные Воды", 11069, ""),
    11064: YandexRegion(11064, "Невинномысск", 11069, ""),
    11067: YandexRegion(11067, "Пятигорск", 11069, ""),
    36: YandexRegion(36, "Ставрополь", 11069, ""),
    11024: YandexRegion(11024, "Чеченская Республика", 102444, ""),
    1106: YandexRegion(1106, "Грозный", 11024, ""),
    52: YandexRegion(52, "Урал", 225, ""),
    11158: YandexRegion(11158, "Курганская область", 52, ""),
    53: YandexRegion(53, "Курган", 11158, ""),
    11159: YandexRegion(11159, "Шадринск", 11158, ""),
    11162: YandexRegion(11162, "Свердловская область", 52, ""),
    11160: YandexRegion(11160, "Асбест", 11162, ""),
    29397: YandexRegion(29397, "Берёзовский", 11162, ""),
    20720: YandexRegion(20720, "Верхняя Пышма", 11162, ""),
    11161: YandexRegion(11161, "Верхняя Салда", 11162, ""),
    54: YandexRegion(54, "Екатеринбург", 11162, ""),
    11164: YandexRegion(11164, "Каменск-Уральский", 11162, ""),
    20234: YandexRegion(20234, "Качканар", 11162, ""),
    11165: YandexRegion(11165, "Краснотурьинск", 11162, ""),
    20691: YandexRegion(20691, "Красноуфимск", 11162, ""),
    11166: YandexRegion(11166, "Кушва", 11162, ""),
    11167: YandexRegion(11167, "Лесной", 11162, ""),
    20654: YandexRegion(20654, "Невьянск", 11162, ""),
    11168: YandexRegion(11168, "Нижний Тагил", 11162, ""),
    11169: YandexRegion(11169, "Нижняя Тура", 11162, ""),
    11170: YandexRegion(11170, "Новоуральск", 11162, ""),
    11171: YandexRegion(11171, "Первоуральск", 11162, ""),
    21726: YandexRegion(21726, "Полевской", 11162, ""),
    20224: YandexRegion(20224, "Ревда", 11162, ""),
    20684: YandexRegion(20684, "Реж", 11162, ""),
    20672: YandexRegion(20672, "Североуральск", 11162, ""),
    11172: YandexRegion(11172, "Серов", 11162, ""),
    11176: YandexRegion(11176, "Тюменская область", 52, ""),
    11173: YandexRegion(11173, "Ишим", 11176, ""),
    11175: YandexRegion(11175, "Тобольск", 11176, ""),
    55: YandexRegion(55, "Тюмень", 11176, ""),
    11178: YandexRegion(11178, "Ялуторовск", 11176, ""),
    11193: YandexRegion(11193, "Ханты-Мансийский автономный округ - Югра", 52, ""),
    11180: YandexRegion(11180, "Когалым", 11193, ""),
    11181: YandexRegion(11181, "Лангепас", 11193, ""),
    11182: YandexRegion(11182, "Мегион", 11193, ""),
    11184: YandexRegion(11184, "Нефтеюганск", 11193, ""),
    1091: YandexRegion(1091, "Нижневартовск", 11193, ""),
    11186: YandexRegion(11186, "Нягань", 11193, ""),
    11188: YandexRegion(11188, "Пыть-Ях", 11193, ""),
    11189: YandexRegion(11189, "Радужный", 11193, ""),
    973: YandexRegion(973, "Сургут", 11193, ""),
    11192: YandexRegion(11192, "Урай", 11193, ""),
    57: YandexRegion(57, "Ханты-Мансийск", 11193, ""),
    11177: YandexRegion(11177, "Югорск", 11193, ""),
    11225: YandexRegion(11225, "Челябинская область", 52, ""),
    11200: YandexRegion(11200, "Верхний Уфалей", 11225, ""),
    11202: YandexRegion(11202, "Златоуст", 11225, ""),
    11207: YandexRegion(11207, "Копейск", 11225, ""),
    235: YandexRegion(235, "Магнитогорск", 11225, ""),
    11212: YandexRegion(11212, "Миасс", 11225, ""),
    11214: YandexRegion(11214, "Озёрск", 11225, ""),
    100020: YandexRegion(100020, "Саткинский район", 11225, ""),
    11217: YandexRegion(11217, "Сатка", 100020, ""),
    11218: YandexRegion(11218, "Снежинск", 11225, ""),
    11220: YandexRegion(11220, "Троицк", 11225, ""),
    11223: YandexRegion(11223, "Усть-Катав", 11225, ""),
    56: YandexRegion(56, "Челябинск", 11225, ""),
    11232: YandexRegion(11232, "Ямало-Ненецкий автономный округ", 52, ""),
    11228: YandexRegion(11228, "Губкинский", 11232, ""),
    100028: YandexRegion(100028, "Надымский район", 11232, ""),
    11229: YandexRegion(11229, "Надым", 100028, ""),
    11230: YandexRegion(11230, "Новый Уренгой", 11232, ""),
    11231: YandexRegion(11231, "Ноябрьск", 11232, ""),
    58: YandexRegion(58, "Салехард", 11232, ""),
    166: YandexRegion(166, "СНГ (исключая Россию)", 0, ""),
    29386: YandexRegion(29386, "Абхазия", 166, ""),
    167: YandexRegion(167, "Азербайджан", 166, ""),
    168: YandexRegion(168, "Армения", 166, ""),
    149: YandexRegion(149, "Беларусь", 166, ""),
    29632: YandexRegion(29632, "Брест и область", 149, ""),
    21015: YandexRegion(21015, "Барановичи", 29632, ""),
    153: YandexRegion(153, "Брест", 29632, ""),
    102089: YandexRegion(102089, "Кобринский район", 29632, ""),
    26010: YandexRegion(26010, "Кобрин", 102089, ""),
    21510: YandexRegion(21510, "Пинск", 29632, ""),
    29633: YandexRegion(29633, "Витебск и область", 149, ""),
    154: YandexRegion(154, "Витебск", 29633, ""),
    26030: YandexRegion(26030, "Новополоцк", 29633, ""),
    102187: YandexRegion(102187, "Оршанский район", 29633, ""),
    10276: YandexRegion(10276, "Орша", 102187, ""),
    102188: YandexRegion(102188, "Полоцкий район", 29633, ""),
    10275: YandexRegion(10275, "Полоцк", 102188, ""),
    29631: YandexRegion(29631, "Гомель и область", 149, ""),
    155: YandexRegion(155, "Гомель", 29631, ""),
    102103: YandexRegion(102103, "Жлобинский район", 29631, ""),
    26966: YandexRegion(26966, "Жлобин", 102103, ""),
    102104: YandexRegion(102104, "Калинковичский район", 29631, ""),
    102235: YandexRegion(102235, "Калинковичи", 102104, ""),
    102108: YandexRegion(102108, "Мозырский район", 29631, ""),
    21274: YandexRegion(21274, "Мозырь", 102108, ""),
    102112: YandexRegion(102112, "Речицкий район", 29631, ""),
    26008: YandexRegion(26008, "Речица", 102112, ""),
    102113: YandexRegion(102113, "Рогачёвский район", 29631, ""),
    26027: YandexRegion(26027, "Рогачёв", 102113, ""),
    102114: YandexRegion(102114, "Светлогорский район", 29631, ""),
    26004: YandexRegion(26004, "Светлогорск", 102114, ""),
    29634: YandexRegion(29634, "Гродно и область", 149, ""),
    102118: YandexRegion(102118, "Волковысский район", 29634, ""),
    26923: YandexRegion(26923, "Волковыск", 102118, ""),
    10274: YandexRegion(10274, "Гродно", 29634, ""),
    102125: YandexRegion(102125, "Лидский район", 29634, ""),
    21144: YandexRegion(21144, "Лида", 102125, ""),
    102127: YandexRegion(102127, "Новогрудский район", 29634, ""),
    26836: YandexRegion(26836, "Новогрудок", 102127, ""),
    102131: YandexRegion(102131, "Слонимский район", 29634, ""),
    26005: YandexRegion(26005, "Слоним", 102131, ""),
    102132: YandexRegion(102132, "Сморгонский район", 29634, ""),
    26017: YandexRegion(26017, "Сморгонь", 102132, ""),
    29630: YandexRegion(29630, "Минск и область", 149, ""),
    102156: YandexRegion(102156, "Борисовский район", 29630, ""),
    21193: YandexRegion(21193, "Борисов", 102156, ""),
    26034: YandexRegion(26034, "Жодино", 29630, ""),
    157: YandexRegion(157, "Минск", 29630, ""),
    102165: YandexRegion(102165, "Молодечненский район", 29630, ""),
    26001: YandexRegion(26001, "Молодечно", 102165, ""),
    102169: YandexRegion(102169, "Слуцкий район", 29630, ""),
    26951: YandexRegion(26951, "Слуцк", 102169, ""),
    102170: YandexRegion(102170, "Солигорский район", 29630, ""),
    26003: YandexRegion(26003, "Солигорск", 102170, ""),
    29629: YandexRegion(29629, "Могилёв и область", 149, ""),
    20729: YandexRegion(20729, "Бобруйск", 29629, ""),
    102138: YandexRegion(102138, "Горецкий район", 29629, ""),
    26774: YandexRegion(26774, "Горки", 102138, ""),
    158: YandexRegion(158, "Могилёв", 29629, ""),
    102149: YandexRegion(102149, "Осиповичский район", 29629, ""),
    26012: YandexRegion(26012, "Осиповичи", 102149, ""),
    159: YandexRegion(159, "Казахстан", 166, ""),
    29414: YandexRegion(29414, "Актау и Мангистауская область", 159, ""),
    29404: YandexRegion(29404, "Актобе и область", 159, ""),
    29406: YandexRegion(29406, "Алматы и область", 159, ""),
    162: YandexRegion(162, "Алматы", 29406, ""),
    10303: YandexRegion(10303, "Талдыкорган", 29406, ""),
    29403: YandexRegion(29403, "Астана и Акмолинская область", 159, ""),
    163: YandexRegion(163, "Астана", 29403, ""),
    20809: YandexRegion(20809, "Кокшетау", 29403, ""),
    29407: YandexRegion(29407, "Атырау и область", 159, ""),
    29408: YandexRegion(29408, "Восточно-Казахстанская область", 159, ""),
    165: YandexRegion(165, "Семей", 29408, ""),
    10306: YandexRegion(10306, "Усть-Каменогорск", 29408, ""),
    29410: YandexRegion(29410, "Западно-Казахстанская область", 159, ""),
    29411: YandexRegion(29411, "Караганда и область", 159, ""),
    29412: YandexRegion(29412, "Костанай и область", 159, ""),
    29413: YandexRegion(29413, "Кызылорда и область", 159, ""),
    29415: YandexRegion(29415, "Павлодар и область", 159, ""),
    29416: YandexRegion(29416, "Северо-Казахстанская область", 159, ""),
    29409: YandexRegion(29409, "Тараз и Жамбылская область", 159, ""),
    29417: YandexRegion(29417, "Южно-Казахстанская область", 159, ""),
    207: YandexRegion(207, "Киргизия", 166, ""),
    208: YandexRegion(208, "Молдова", 166, ""),
    209: YandexRegion(209, "Таджикистан", 166, ""),
    170: YandexRegion(170, "Туркменистан", 166, ""),
    171: YandexRegion(171, "Узбекистан", 166, ""),
    187: YandexRegion(187, "Украина", 166, ""),
    20545: YandexRegion(20545, "Винница и область", 187, ""),
    963: YandexRegion(963, "Винница", 20545, ""),
    20537: YandexRegion(20537, "Днепр и область", 187, ""),
    141: YandexRegion(141, "Днепр", 20537, ""),
    21775: YandexRegion(21775, "Каменское", 20537, ""),
    10347: YandexRegion(10347, "Кривой Рог", 20537, ""),
    21773: YandexRegion(21773, "Никополь", 20537, ""),
    28401: YandexRegion(28401, "Павлоград", 20537, ""),
    20536: YandexRegion(20536, "Донецк и область", 187, ""),
    21774: YandexRegion(21774, "Горловка", 20536, ""),
    142: YandexRegion(142, "Донецк", 20536, ""),
    20554: YandexRegion(20554, "Краматорск", 20536, ""),
    24876: YandexRegion(24876, "Макеевка", 20536, ""),
    10366: YandexRegion(10366, "Мариуполь", 20536, ""),
    20547: YandexRegion(20547, "Житомир и область", 187, ""),
    20539: YandexRegion(20539, "Запорожье и область", 187, ""),
    960: YandexRegion(960, "Запорожье", 20539, ""),
    20532: YandexRegion(20532, "Ивано-Франковск и область", 187, ""),
    20544: YandexRegion(20544, "Киев и область", 187, ""),
    10369: YandexRegion(10369, "Белая Церковь", 20544, ""),
    143: YandexRegion(143, "Киев", 20544, ""),
    20548: YandexRegion(20548, "Кропивницкий и Кировоградская область", 187, ""),
    20540: YandexRegion(20540, "Луганск и область", 187, ""),
    24885: YandexRegion(24885, "Алчевск", 20540, ""),
    222: YandexRegion(222, "Луганск", 20540, ""),
    24893: YandexRegion(24893, "Северодонецк", 20540, ""),
    20550: YandexRegion(20550, "Луцк и Волынская область", 187, ""),
    20529: YandexRegion(20529, "Львов и область", 187, ""),
    144: YandexRegion(144, "Львов", 20529, ""),
    20543: YandexRegion(20543, "Николаев и область", 187, ""),
    148: YandexRegion(148, "Николаев", 20543, ""),
    20541: YandexRegion(20541, "Одесса и область", 187, ""),
    145: YandexRegion(145, "Одесса", 20541, ""),
    20549: YandexRegion(20549, "Полтава и область", 187, ""),
    21609: YandexRegion(21609, "Кременчуг", 20549, ""),
    964: YandexRegion(964, "Полтава", 20549, ""),
    20534: YandexRegion(20534, "Ровно и область", 187, ""),
    20552: YandexRegion(20552, "Сумы и область", 187, ""),
    965: YandexRegion(965, "Сумы", 20552, ""),
    20531: YandexRegion(20531, "Тернополь и область", 187, ""),
    20530: YandexRegion(20530, "Ужгород и Закарпатская область", 187, ""),
    20538: YandexRegion(20538, "Харьков и область", 187, ""),
    147: YandexRegion(147, "Харьков", 20538, ""),
    20542: YandexRegion(20542, "Херсон и область", 187, ""),
    962: YandexRegion(962, "Херсон", 20542, ""),
    20535: YandexRegion(20535, "Хмельницкий и область", 187, ""),
    961: YandexRegion(961, "Хмельницкий", 20535, ""),
    20546: YandexRegion(20546, "Черкассы и область", 187, ""),
    20551: YandexRegion(20551, "Чернигов и область", 187, ""),
    29053: YandexRegion(29053, "Нежин", 20551, ""),
    20533: YandexRegion(20533, "Черновцы и область", 187, ""),
    111: YandexRegion(111, "Европа", 0, ""),
    113: YandexRegion(113, "Австрия", 111, ""),
    114: YandexRegion(114, "Бельгия", 111, ""),
    115: YandexRegion(115, "Болгария", 111, ""),
    102: YandexRegion(102, "Великобритания", 111, ""),
    116: YandexRegion(116, "Венгрия", 111, ""),
    96: YandexRegion(96, "Германия", 111, ""),
    246: YandexRegion(246, "Греция", 111, ""),
    203: YandexRegion(203, "Дания", 111, ""),
    204: YandexRegion(204, "Испания", 111, ""),
    205: YandexRegion(205, "Италия", 111, ""),
    20574: YandexRegion(20574, "Кипр", 111, ""),
    206: YandexRegion(206, "Латвия", 111, ""),
    117: YandexRegion(117, "Литва", 111, ""),
    118: YandexRegion(118, "Нидерланды", 111, ""),
    119: YandexRegion(119, "Норвегия", 111, ""),
    120: YandexRegion(120, "Польша", 111, ""),
    10074: YandexRegion(10074, "Португалия", 111, ""),
    10077: YandexRegion(10077, "Румыния", 111, ""),
    180: YandexRegion(180, "Сербия", 111, ""),
    121: YandexRegion(121, "Словакия", 111, ""),
    122: YandexRegion(122, "Словения", 111, ""),
    983: YandexRegion(983, "Турция", 111, ""),
    103668: YandexRegion(103668, "Провинция Агры", 983, ""),
    103669: YandexRegion(103669, "Провинция Адана", 983, ""),
    103670: YandexRegion(103670, "Провинция Адыяман", 983, ""),
    103671: YandexRegion(103671, "Провинция Айдын", 983, ""),
    103672: YandexRegion(103672, "Провинция Аксарай", 983, ""),
    103673: YandexRegion(103673, "Провинция Амасья", 983, ""),
    103674: YandexRegion(103674, "Провинция Анкара", 983, ""),
    103675: YandexRegion(103675, "Провинция Анталья", 983, ""),
    103676: YandexRegion(103676, "Провинция Ардахан", 983, ""),
    103677: YandexRegion(103677, "Провинция Артвин", 983, ""),
    103678: YandexRegion(103678, "Провинция Афьонкарахисар", 983, ""),
    103679: YandexRegion(103679, "Провинция Байбурт", 983, ""),
    103680: YandexRegion(103680, "Провинция Балыкесир", 983, ""),
    103681: YandexRegion(103681, "Провинция Бартын", 983, ""),
    103682: YandexRegion(103682, "Провинция Батман", 983, ""),
    103683: YandexRegion(103683, "Провинция Биледжик", 983, ""),
    103684: YandexRegion(103684, "Провинция Бингёль", 983, ""),
    103685: YandexRegion(103685, "Провинция Битлис", 983, ""),
    103686: YandexRegion(103686, "Провинция Болу", 983, ""),
    103687: YandexRegion(103687, "Провинция Бурдур", 983, ""),
    103688: YandexRegion(103688, "Провинция Бурса", 983, ""),
    103689: YandexRegion(103689, "Провинция Ван", 983, ""),
    103690: YandexRegion(103690, "Провинция Газиантеп", 983, ""),
    103691: YandexRegion(103691, "Провинция Гиресун", 983, ""),
    103692: YandexRegion(103692, "Провинция Гюмюшхане", 983, ""),
    103693: YandexRegion(103693, "Провинция Денизли", 983, ""),
    103694: YandexRegion(103694, "Провинция Диярбакыр", 983, ""),
    103695: YandexRegion(103695, "Провинция Дюздже", 983, ""),
    103696: YandexRegion(103696, "Провинция Зонгулдак", 983, ""),
    103697: YandexRegion(103697, "Провинция Измир", 983, ""),
    103698: YandexRegion(103698, "Провинция Йозгат", 983, ""),
    103699: YandexRegion(103699, "Провинция Кайсери", 983, ""),
    103700: YandexRegion(103700, "Провинция Карабюк", 983, ""),
    103701: YandexRegion(103701, "Провинция Караман", 983, ""),
    103702: YandexRegion(103702, "Провинция Карс", 983, ""),
    103703: YandexRegion(103703, "Провинция Кастамону", 983, ""),
    103704: YandexRegion(103704, "Провинция Кахраманмараш", 983, ""),
    103705: YandexRegion(103705, "Провинция Килис", 983, ""),
    103706: YandexRegion(103706, "Провинция Коджаэли", 983, ""),
    103707: YandexRegion(103707, "Провинция Конья", 983, ""),
    103708: YandexRegion(103708, "Провинция Кыркларели", 983, ""),
    103709: YandexRegion(103709, "Провинция Кыршехир", 983, ""),
    103710: YandexRegion(103710, "Провинция Кырыккале", 983, ""),
    103711: YandexRegion(103711, "Провинция Кютахья", 983, ""),
    103712: YandexRegion(103712, "Провинция Малатья", 983, ""),
    103713: YandexRegion(103713, "Провинция Маниса", 983, ""),
    103714: YandexRegion(103714, "Провинция Мардин", 983, ""),
    103715: YandexRegion(103715, "Провинция Мерсин", 983, ""),
    103716: YandexRegion(103716, "Провинция Мугла", 983, ""),
    103717: YandexRegion(103717, "Провинция Муш", 983, ""),
    103718: YandexRegion(103718, "Провинция Невшехир", 983, ""),
    103719: YandexRegion(103719, "Провинция Нигде", 983, ""),
    103720: YandexRegion(103720, "Провинция Орду", 983, ""),
    103721: YandexRegion(103721, "Провинция Османие", 983, ""),
    103722: YandexRegion(103722, "Провинция Ризе", 983, ""),
    103723: YandexRegion(103723, "Провинция Сакарья", 983, ""),
    103724: YandexRegion(103724, "Провинция Самсун", 983, ""),
    103725: YandexRegion(103725, "Провинция Сивас", 983, ""),
    103726: YandexRegion(103726, "Провинция Сиирт", 983, ""),
    103727: YandexRegion(103727, "Провинция Синоп", 983, ""),
    103728: YandexRegion(103728, "Провинция Стамбул", 983, ""),
    103729: YandexRegion(103729, "Провинция Текирдаг", 983, ""),
    103730: YandexRegion(103730, "Провинция Токат", 983, ""),
    103731: YandexRegion(103731, "Провинция Трабзон", 983, ""),
    103732: YandexRegion(103732, "Провинция Тунджели", 983, ""),
    103733: YandexRegion(103733, "Провинция Ушак", 983, ""),
    103734: YandexRegion(103734, "Провинция Хаккяри", 983, ""),
    103735: YandexRegion(103735, "Провинция Хатай", 983, ""),
    103736: YandexRegion(103736, "Провинция Чанаккале", 983, ""),
    103737: YandexRegion(103737, "Провинция Чанкыры", 983, ""),
    103738: YandexRegion(103738, "Провинция Чорум", 983, ""),
    103739: YandexRegion(103739, "Провинция Шанлыурфа", 983, ""),
    103740: YandexRegion(103740, "Провинция Ширнак", 983, ""),
    103741: YandexRegion(103741, "Провинция Ыгдыр", 983, ""),
    103742: YandexRegion(103742, "Провинция Ыспарта", 983, ""),
    103743: YandexRegion(103743, "Провинция Эдирне", 983, ""),
    103744: YandexRegion(103744, "Провинция Элязыг", 983, ""),
    103745: YandexRegion(103745, "Провинция Эрзинджан", 983, ""),
    103746: YandexRegion(103746, "Провинция Эрзурум", 983, ""),
    103747: YandexRegion(103747, "Провинция Эскишехир", 983, ""),
    103748: YandexRegion(103748, "Провинция Ялова", 983, ""),
    123: YandexRegion(123, "Финляндия", 111, ""),
    124: YandexRegion(124, "Франция", 111, ""),
    10083: YandexRegion(10083, "Хорватия", 111, ""),
    21610: YandexRegion(21610, "Черногория", 111, ""),
    125: YandexRegion(125, "Чехия", 111, ""),
    126: YandexRegion(126, "Швейцария", 111, ""),
    127: YandexRegion(127, "Швеция", 111, ""),
    179: YandexRegion(179, "Эстония", 111, ""),
    183: YandexRegion(183, "Азия", 0, ""),
    169: YandexRegion(169, "Грузия", 183, ""),
    181: YandexRegion(181, "Израиль", 183, ""),
    994: YandexRegion(994, "Индия", 183, ""),
    20975: YandexRegion(20975, "Камбоджа", 183, ""),
    134: YandexRegion(134, "Китай", 183, ""),
    210: YandexRegion(210, "Объединённые Арабские Эмираты", 183, ""),
    995: YandexRegion(995, "Таиланд", 183, ""),
    135: YandexRegion(135, "Южная Корея", 183, ""),
    137: YandexRegion(137, "Япония", 183, ""),
    241: YandexRegion(241, "Африка", 0, ""),
    1056: YandexRegion(1056, "Египет", 241, ""),
    10002: YandexRegion(10002, "Северная Америка", 0, ""),
    95: YandexRegion(95, "Канада", 10002, ""),
    84: YandexRegion(84, "США", 10002, ""),
    10003: YandexRegion(10003, "Южная Америка", 0, ""),
    93: YandexRegion(93, "Аргентина", 10003, ""),
    94: YandexRegion(94, "Бразилия", 10003, ""),
    138: YandexRegion(138, "Австралия и Океания", 0, ""),
    211: YandexRegion(211, "Австралия", 138, ""),
    139: YandexRegion(139, "Новая Зеландия", 138, ""),
}


# Встроенные языки Google
GOOGLE_LANGUAGES = {
    "af": GoogleLanguage("af", "Afrikaans"),
    "sq": GoogleLanguage("sq", "Albanian"),
    "sm": GoogleLanguage("sm", "Amharic"),
    "ar": GoogleLanguage("ar", "Arabic"),
    "hy": GoogleLanguage("hy", "Armenian"),
    "az": GoogleLanguage("az", "Azerbaijani"),
    "eu": GoogleLanguage("eu", "Basque"),
    "be": GoogleLanguage("be", "Belarusian"),
    "bn": GoogleLanguage("bn", "Bengali"),
    "bh": GoogleLanguage("bh", "Bihari"),
    "bs": GoogleLanguage("bs", "Bosnian"),
    "bg": GoogleLanguage("bg", "Bulgarian"),
    "ca": GoogleLanguage("ca", "Catalan"),
    "hr": GoogleLanguage("hr", "Croatian"),
    "cs": GoogleLanguage("cs", "Czech"),
    "da": GoogleLanguage("da", "Danish"),
    "nl": GoogleLanguage("nl", "Dutch"),
    "en": GoogleLanguage("en", "English"),
    "eo": GoogleLanguage("eo", "Esperanto"),
    "et": GoogleLanguage("et", "Estonian"),
    "fo": GoogleLanguage("fo", "Faroese"),
    "tl": GoogleLanguage("tl", "Filipino"),
    "fi": GoogleLanguage("fi", "Finnish"),
    "fr": GoogleLanguage("fr", "French"),
    "fy": GoogleLanguage("fy", "Frisian"),
    "gl": GoogleLanguage("gl", "Galician"),
    "ka": GoogleLanguage("ka", "Georgian"),
    "de": GoogleLanguage("de", "German"),
    "el": GoogleLanguage("el", "Greek"),
    "gu": GoogleLanguage("gu", "Gujarati"),
    "iw": GoogleLanguage("iw", "Hebrew"),
    "hi": GoogleLanguage("hi", "Hindi"),
    "hu": GoogleLanguage("hu", "Hungarian"),
    "is": GoogleLanguage("is", "Icelandic"),
    "id": GoogleLanguage("id", "Indonesian"),
    "ia": GoogleLanguage("ia", "Interlingua"),
    "ga": GoogleLanguage("ga", "Irish"),
    "it": GoogleLanguage("it", "Italian"),
    "ja": GoogleLanguage("ja", "Japanese"),
    "jw": GoogleLanguage("jw", "Javanese"),
    "kn": GoogleLanguage("kn", "Kannada"),
    "ko": GoogleLanguage("ko", "Korean"),
    "la": GoogleLanguage("la", "Latin"),
    "lv": GoogleLanguage("lv", "Latvian"),
    "lt": GoogleLanguage("lt", "Lithuanian"),
    "mk": GoogleLanguage("mk", "Macedonian"),
    "ms": GoogleLanguage("ms", "Malay"),
    "ml": GoogleLanguage("ml", "Malayam"),
    "mt": GoogleLanguage("mt", "Maltese"),
    "mr": GoogleLanguage("mr", "Marathi"),
    "ne": GoogleLanguage("ne", "Nepali"),
    "no": GoogleLanguage("no", "Norwegian"),
    "oc": GoogleLanguage("oc", "Occitan"),
    "fa": GoogleLanguage("fa", "Persian"),
    "pl": GoogleLanguage("pl", "Polish"),
    "pt": GoogleLanguage("pt", "Portuguese"),
    "pt-BR": GoogleLanguage("pt-BR", "Portuguese (Brazil)"),
    "pt-PT": GoogleLanguage("pt-PT", "Portuguese (Portugal)"),
    "pa": GoogleLanguage("pa", "Punjabi"),
    "ro": GoogleLanguage("ro", "Romanian"),
    "ru": GoogleLanguage("ru", "Russian"),
    "gd": GoogleLanguage("gd", "Scots Gaelic"),
    "sr": GoogleLanguage("sr", "Serbian"),
    "si": GoogleLanguage("si", "Sinhalese"),
    "sk": GoogleLanguage("sk", "Slovak"),
    "sl": GoogleLanguage("sl", "Slovenian"),
    "es": GoogleLanguage("es", "Spanish"),
    "es-419": GoogleLanguage("es-419", "Spanish (Latin America)"),
    "su": GoogleLanguage("su", "Sudanese"),
    "sw": GoogleLanguage("sw", "Swahili"),
    "sv": GoogleLanguage("sv", "Swedish"),
    "ta": GoogleLanguage("ta", "Tamil"),
    "te": GoogleLanguage("te", "Telugu"),
    "th": GoogleLanguage("th", "Thai"),
    "ti": GoogleLanguage("ti", "Tigrinya"),
    "tr": GoogleLanguage("tr", "Turkish"),
    "uk": GoogleLanguage("uk", "Ukrainian"),
    "ur": GoogleLanguage("ur", "Urdu"),
    "uz": GoogleLanguage("uz", "Uzbek"),
    "vi": GoogleLanguage("vi", "Vietnamese"),
    "cy": GoogleLanguage("cy", "Welsh"),
    "xh": GoogleLanguage("xh", "Xhosa"),
    "zu": GoogleLanguage("zu", "Zulu"),
    "kk": GoogleLanguage("kk", "Казахский"),
    "zh-HK": GoogleLanguage("zh-HK", "Китайский (Гонконг)"),
    "zh-CN": GoogleLanguage("zh-CN", "Китайский (КНР)"),
    "zh-TW": GoogleLanguage("zh-TW", "Китайский (Тайвань)"),
}


# Встроенные домены Google
GOOGLE_DOMAINS = {
    "com": GoogleDomain("com", "Global", "Global"),
    "ru": GoogleDomain("ru", "Russia", "Russia"),
    "ua": GoogleDomain("ua", "Ukraine", "Ukraine"),
    "by": GoogleDomain("by", "Belarus", "Belarus"),
    "kz": GoogleDomain("kz", "Kazakhstan", "Kazakhstan"),
    "us": GoogleDomain("us", "United States", "United States"),
    "uk": GoogleDomain("uk", "United Kingdom", "United Kingdom"),
    "de": GoogleDomain("de", "Germany", "Germany"),
    "fr": GoogleDomain("fr", "France", "France"),
    "es": GoogleDomain("es", "Spain", "Spain"),
    "it": GoogleDomain("it", "Italy", "Italy"),
    "pl": GoogleDomain("pl", "Poland", "Poland"),
    "tr": GoogleDomain("tr", "Turkey", "Turkey"),
    "com.tr": GoogleDomain("com.tr", "Turkey", "Turkey"),
    "ca": GoogleDomain("ca", "Canada", "Canada"),
    "au": GoogleDomain("au", "Australia", "Australia"),
    "jp": GoogleDomain("jp", "Japan", "Japan"),
    "cn": GoogleDomain("cn", "China", "China"),
    "in": GoogleDomain("in", "India", "India"),
    "br": GoogleDomain("br", "Brazil", "Brazil"),
    "mx": GoogleDomain("mx", "Mexico", "Mexico"),
    "ar": GoogleDomain("ar", "Argentina", "Argentina"),
    "cl": GoogleDomain("cl", "Chile", "Chile"),
    "co": GoogleDomain("co", "Colombia", "Colombia"),
    "pe": GoogleDomain("pe", "Peru", "Peru"),
    "ve": GoogleDomain("ve", "Venezuela", "Venezuela"),
    "za": GoogleDomain("za", "South Africa", "South Africa"),
    "eg": GoogleDomain("eg", "Egypt", "Egypt"),
    "ng": GoogleDomain("ng", "Nigeria", "Nigeria"),
    "ke": GoogleDomain("ke", "Kenya", "Kenya"),
    "ma": GoogleDomain("ma", "Morocco", "Morocco"),
    "dz": GoogleDomain("dz", "Algeria", "Algeria"),
    "tn": GoogleDomain("tn", "Tunisia", "Tunisia"),
    "ly": GoogleDomain("ly", "Libya", "Libya"),
    "sd": GoogleDomain("sd", "Sudan", "Sudan"),
    "et": GoogleDomain("et", "Ethiopia", "Ethiopia"),
    "ug": GoogleDomain("ug", "Uganda", "Uganda"),
    "tz": GoogleDomain("tz", "Tanzania", "Tanzania"),
    "gh": GoogleDomain("gh", "Ghana", "Ghana"),
    "ci": GoogleDomain("ci", "Ivory Coast", "Ivory Coast"),
    "sn": GoogleDomain("sn", "Senegal", "Senegal"),
    "ml": GoogleDomain("ml", "Mali", "Mali"),
    "bf": GoogleDomain("bf", "Burkina Faso", "Burkina Faso"),
    "ne": GoogleDomain("ne", "Niger", "Niger"),
    "td": GoogleDomain("td", "Chad", "Chad"),
    "cm": GoogleDomain("cm", "Cameroon", "Cameroon"),
    "cf": GoogleDomain("cf", "Central African Republic", "Central African Republic"),
    "cd": GoogleDomain(
        "cd",
        "Democratic Republic of the Congo",
        "Democratic Republic of the Congo",
    ),
    "cg": GoogleDomain("cg", "Republic of the Congo", "Republic of the Congo"),
    "ga": GoogleDomain("ga", "Gabon", "Gabon"),
    "gq": GoogleDomain("gq", "Equatorial Guinea", "Equatorial Guinea"),
    "st": GoogleDomain("st", "São Tomé and Príncipe", "São Tomé and Príncipe"),
    "ao": GoogleDomain("ao", "Angola", "Angola"),
    "zm": GoogleDomain("zm", "Zambia", "Zambia"),
    "zw": GoogleDomain("zw", "Zimbabwe", "Zimbabwe"),
    "bw": GoogleDomain("bw", "Botswana", "Botswana"),
    "na": GoogleDomain("na", "Namibia", "Namibia"),
    "sz": GoogleDomain("sz", "Swaziland", "Swaziland"),
    "ls": GoogleDomain("ls", "Lesotho", "Lesotho"),
    "mg": GoogleDomain("mg", "Madagascar", "Madagascar"),
    "mu": GoogleDomain("mu", "Mauritius", "Mauritius"),
    "sc": GoogleDomain("sc", "Seychelles", "Seychelles"),
    "km": GoogleDomain("km", "Comoros", "Comoros"),
    "dj": GoogleDomain("dj", "Djibouti", "Djibouti"),
    "so": GoogleDomain("so", "Somalia", "Somalia"),
    "er": GoogleDomain("er", "Eritrea", "Eritrea"),
    "ss": GoogleDomain("ss", "South Sudan", "South Sudan"),
    "rw": GoogleDomain("rw", "Rwanda", "Rwanda"),
    "bi": GoogleDomain("bi", "Burundi", "Burundi"),
    "mw": GoogleDomain("mw", "Malawi", "Malawi"),
    "mz": GoogleDomain("mz", "Mozambique", "Mozambique"),
}


# Встроенные города (полный набор)
CITIES = {
    2000001: City(2000001, "Россия", "Россия,RU", 0, "RU", "City", "Active"),
    2000002: City(2000002, "Центр", "Центр,RU", 225, "RU", "City", "Active"),
    2000003: City(
        2000003,
        "Москва и область",
        "Москва и область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000004: City(2000004, "Москва", "Москва,RU", 1, "RU", "City", "Active"),
    2000005: City(2000005, "Зеленоград", "Зеленоград,RU", 213, "RU", "City", "Active"),
    2000006: City(2000006, "Троицк", "Троицк,RU", 213, "RU", "City", "Active"),
    2000007: City(2000007, "Щербинка", "Щербинка,RU", 213, "RU", "City", "Active"),
    2000008: City(2000008, "Балашиха", "Балашиха,RU", 1, "RU", "City", "Active"),
    2000009: City(2000009, "Бронницы", "Бронницы,RU", 1, "RU", "City", "Active"),
    2000010: City(
        2000010,
        "Волоколамский район",
        "Волоколамский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000011: City(
        2000011, "Волоколамск", "Волоколамск,RU", 98580, "RU", "City", "Active"
    ),
    2000012: City(
        2000012,
        "Воскресенский район",
        "Воскресенский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000013: City(
        2000013, "Воскресенск", "Воскресенск,RU", 98581, "RU", "City", "Active"
    ),
    2000014: City(2000014, "Дзержинский", "Дзержинский,RU", 1, "RU", "City", "Active"),
    2000015: City(
        2000015,
        "Дмитровский район",
        "Дмитровский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000016: City(2000016, "Дмитров", "Дмитров,RU", 98582, "RU", "City", "Active"),
    2000017: City(
        2000017, "Долгопрудный", "Долгопрудный,RU", 1, "RU", "City", "Active"
    ),
    2000018: City(2000018, "Домодедово", "Домодедово,RU", 1, "RU", "City", "Active"),
    2000019: City(2000019, "Дубна", "Дубна,RU", 1, "RU", "City", "Active"),
    2000020: City(
        2000020,
        "Егорьевск (городской округ)",
        "Егорьевск (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000021: City(2000021, "Егорьевск", "Егорьевск,RU", 98584, "RU", "City", "Active"),
    2000022: City(2000022, "Жуковский", "Жуковский,RU", 1, "RU", "City", "Active"),
    2000023: City(
        2000023,
        "Зарайск (городской округ)",
        "Зарайск (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000024: City(2000024, "Зарайск", "Зарайск,RU", 98585, "RU", "City", "Active"),
    2000025: City(2000025, "Звенигород", "Звенигород,RU", 1, "RU", "City", "Active"),
    2000026: City(2000026, "Ивантеевка", "Ивантеевка,RU", 1, "RU", "City", "Active"),
    2000027: City(
        2000027,
        "Истра (городской округ)",
        "Истра (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000028: City(2000028, "Дедовск", "Дедовск,RU", 98586, "RU", "City", "Active"),
    2000029: City(2000029, "Истра", "Истра,RU", 98586, "RU", "City", "Active"),
    2000030: City(
        2000030,
        "Кашира (городской округ)",
        "Кашира (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000031: City(2000031, "Кашира", "Кашира,RU", 98587, "RU", "City", "Active"),
    2000032: City(
        2000032,
        "Клин (городской округ)",
        "Клин (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000033: City(2000033, "Клин", "Клин,RU", 98588, "RU", "City", "Active"),
    2000034: City(2000034, "Коломна", "Коломна,RU", 1, "RU", "City", "Active"),
    2000035: City(2000035, "Королёв", "Королёв,RU", 1, "RU", "City", "Active"),
    2000036: City(
        2000036, "Красноармейск", "Красноармейск,RU", 1, "RU", "City", "Active"
    ),
    2000037: City(
        2000037,
        "Красногорск (городской округ)",
        "Красногорск (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000038: City(
        2000038, "Красногорск", "Красногорск,RU", 98590, "RU", "City", "Active"
    ),
    2000039: City(2000039, "Нахабино", "Нахабино,RU", 98590, "RU", "City", "Active"),
    2000040: City(
        2000040,
        "Краснознаменск",
        "Краснознаменск,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000041: City(
        2000041,
        "Ленинский район",
        "Ленинский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000042: City(2000042, "Видное", "Видное,RU", 98591, "RU", "City", "Active"),
    2000043: City(2000043, "Лобня", "Лобня,RU", 1, "RU", "City", "Active"),
    2000044: City(
        2000044,
        "Лосино-Петровский",
        "Лосино-Петровский,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000045: City(
        2000045,
        "Луховицы (городской округ)",
        "Луховицы (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000046: City(2000046, "Луховицы", "Луховицы,RU", 98593, "RU", "City", "Active"),
    2000047: City(2000047, "Лыткарино", "Лыткарино,RU", 1, "RU", "City", "Active"),
    2000048: City(
        2000048,
        "Люберцы (городской округ)",
        "Люберцы (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000049: City(2000049, "Люберцы", "Люберцы,RU", 98594, "RU", "City", "Active"),
    2000050: City(
        2000050,
        "Можайский район",
        "Можайский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000051: City(2000051, "Можайск", "Можайск,RU", 98595, "RU", "City", "Active"),
    2000052: City(
        2000052,
        "Мытищи (городской округ)",
        "Мытищи (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000053: City(2000053, "Мытищи", "Мытищи,RU", 98596, "RU", "City", "Active"),
    2000054: City(
        2000054,
        "Наро-Фоминский городской округ",
        "Наро-Фоминский городской округ,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000055: City(2000055, "Апрелевка", "Апрелевка,RU", 98597, "RU", "City", "Active"),
    2000056: City(
        2000056,
        "Наро-Фоминск",
        "Наро-Фоминск,RU",
        98597,
        "RU",
        "City",
        "Active",
    ),
    2000057: City(
        2000057,
        "Ногинский район",
        "Ногинский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000058: City(2000058, "Ногинск", "Ногинск,RU", 98598, "RU", "City", "Active"),
    2000059: City(
        2000059,
        "Старая Купавна",
        "Старая Купавна,RU",
        98598,
        "RU",
        "City",
        "Active",
    ),
    2000060: City(
        2000060, "Электроугли", "Электроугли,RU", 98598, "RU", "City", "Active"
    ),
    2000061: City(
        2000061,
        "Одинцовский район",
        "Одинцовский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000062: City(2000062, "Голицыно", "Голицыно,RU", 98599, "RU", "City", "Active"),
    2000063: City(2000063, "Кубинка", "Кубинка,RU", 98599, "RU", "City", "Active"),
    2000064: City(2000064, "Одинцово", "Одинцово,RU", 98599, "RU", "City", "Active"),
    2000065: City(
        2000065, "Орехово-Зуево", "Орехово-Зуево,RU", 1, "RU", "City", "Active"
    ),
    2000066: City(
        2000066,
        "Павловский Посад (городской округ)",
        "Павловский Посад (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000067: City(
        2000067,
        "Павловский Посад",
        "Павловский Посад,RU",
        98602,
        "RU",
        "City",
        "Active",
    ),
    2000068: City(2000068, "Подольск", "Подольск,RU", 1, "RU", "City", "Active"),
    2000069: City(2000069, "Протвино", "Протвино,RU", 1, "RU", "City", "Active"),
    2000070: City(
        2000070,
        "Пушкинский район",
        "Пушкинский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000071: City(2000071, "Пушкино", "Пушкино,RU", 98604, "RU", "City", "Active"),
    2000072: City(2000072, "Пущино", "Пущино,RU", 1, "RU", "City", "Active"),
    2000073: City(
        2000073,
        "Раменский район",
        "Раменский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000074: City(2000074, "Раменское", "Раменское,RU", 98605, "RU", "City", "Active"),
    2000075: City(2000075, "Реутов", "Реутов,RU", 1, "RU", "City", "Active"),
    2000076: City(
        2000076,
        "Рузский городской округ",
        "Рузский городской округ,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000077: City(2000077, "Руза", "Руза,RU", 98606, "RU", "City", "Active"),
    2000078: City(
        2000078,
        "Сергиево-Посадский район",
        "Сергиево-Посадский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000079: City(
        2000079,
        "Сергиев Посад",
        "Сергиев Посад,RU",
        98608,
        "RU",
        "City",
        "Active",
    ),
    2000080: City(2000080, "Хотьково", "Хотьково,RU", 98608, "RU", "City", "Active"),
    2000081: City(2000081, "Серпухов", "Серпухов,RU", 1, "RU", "City", "Active"),
    2000082: City(
        2000082,
        "Солнечногорский район",
        "Солнечногорский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000083: City(
        2000083,
        "Солнечногорск",
        "Солнечногорск,RU",
        98611,
        "RU",
        "City",
        "Active",
    ),
    2000084: City(
        2000084,
        "Ступино (городской округ)",
        "Ступино (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000085: City(2000085, "Ступино", "Ступино,RU", 98607, "RU", "City", "Active"),
    2000086: City(2000086, "Фрязино", "Фрязино,RU", 1, "RU", "City", "Active"),
    2000087: City(2000087, "Химки", "Химки,RU", 1, "RU", "City", "Active"),
    2000088: City(
        2000088, "Черноголовка", "Черноголовка,RU", 1, "RU", "City", "Active"
    ),
    2000089: City(
        2000089,
        "Чехов (городской округ)",
        "Чехов (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000090: City(2000090, "Чехов", "Чехов,RU", 98614, "RU", "City", "Active"),
    2000091: City(
        2000091,
        "Шатура (городской округ)",
        "Шатура (городской округ),RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000092: City(2000092, "Шатура", "Шатура,RU", 98615, "RU", "City", "Active"),
    2000093: City(
        2000093,
        "Щёлковский район",
        "Щёлковский район,RU",
        1,
        "RU",
        "City",
        "Active",
    ),
    2000094: City(2000094, "Щелково", "Щелково,RU", 98617, "RU", "City", "Active"),
    2000095: City(
        2000095, "Электросталь", "Электросталь,RU", 1, "RU", "City", "Active"
    ),
    2000096: City(
        2000096,
        "Белгородская область",
        "Белгородская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000097: City(
        2000097,
        "Алексеевский район",
        "Алексеевский район,RU",
        10645,
        "RU",
        "City",
        "Active",
    ),
    2000098: City(
        2000098, "Алексеевка", "Алексеевка,RU", 98697, "RU", "City", "Active"
    ),
    2000099: City(2000099, "Белгород", "Белгород,RU", 10645, "RU", "City", "Active"),
    2000100: City(2000100, "Губкин", "Губкин,RU", 10645, "RU", "City", "Active"),
    2000101: City(
        2000101,
        "Старый Оскол",
        "Старый Оскол,RU",
        10645,
        "RU",
        "City",
        "Active",
    ),
    2000102: City(
        2000102,
        "Шебекинский район",
        "Шебекинский район,RU",
        10645,
        "RU",
        "City",
        "Active",
    ),
    2000103: City(2000103, "Шебекино", "Шебекино,RU", 98716, "RU", "City", "Active"),
    2000104: City(
        2000104,
        "Яковлевский район",
        "Яковлевский район,RU",
        10645,
        "RU",
        "City",
        "Active",
    ),
    2000105: City(2000105, "Строитель", "Строитель,RU", 98717, "RU", "City", "Active"),
    2000106: City(
        2000106,
        "Брянская область",
        "Брянская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000107: City(2000107, "Брянск", "Брянск,RU", 10650, "RU", "City", "Active"),
    2000108: City(2000108, "Клинцы", "Клинцы,RU", 10650, "RU", "City", "Active"),
    2000109: City(
        2000109,
        "Владимирская область",
        "Владимирская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000110: City(
        2000110,
        "Александровский район",
        "Александровский район,RU",
        10658,
        "RU",
        "City",
        "Active",
    ),
    2000111: City(
        2000111, "Александров", "Александров,RU", 98745, "RU", "City", "Active"
    ),
    2000112: City(2000112, "Владимир", "Владимир,RU", 10658, "RU", "City", "Active"),
    2000113: City(
        2000113,
        "Гусь-Хрустальный",
        "Гусь-Хрустальный,RU",
        10658,
        "RU",
        "City",
        "Active",
    ),
    2000114: City(
        2000114,
        "Киржачский район",
        "Киржачский район,RU",
        10658,
        "RU",
        "City",
        "Active",
    ),
    2000115: City(2000115, "Киржач", "Киржач,RU", 98750, "RU", "City", "Active"),
    2000116: City(2000116, "Ковров", "Ковров,RU", 10658, "RU", "City", "Active"),
    2000117: City(2000117, "Муром", "Муром,RU", 10658, "RU", "City", "Active"),
    2000118: City(
        2000118,
        "Петушинский район",
        "Петушинский район,RU",
        10658,
        "RU",
        "City",
        "Active",
    ),
    2000119: City(2000119, "Покров", "Покров,RU", 98755, "RU", "City", "Active"),
    2000120: City(
        2000120,
        "Воронежская область",
        "Воронежская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000121: City(2000121, "Воронеж", "Воронеж,RU", 10672, "RU", "City", "Active"),
    2000122: City(
        2000122,
        "Россошанский район",
        "Россошанский район,RU",
        10672,
        "RU",
        "City",
        "Active",
    ),
    2000123: City(2000123, "Россошь", "Россошь,RU", 98787, "RU", "City", "Active"),
    2000124: City(
        2000124,
        "Ивановская область",
        "Ивановская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000125: City(2000125, "Иваново", "Иваново,RU", 10687, "RU", "City", "Active"),
    2000126: City(2000126, "Кинешма", "Кинешма,RU", 10687, "RU", "City", "Active"),
    2000127: City(2000127, "Шуя", "Шуя,RU", 10687, "RU", "City", "Active"),
    2000128: City(
        2000128,
        "Калужская область",
        "Калужская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000129: City(2000129, "Калуга", "Калуга,RU", 10693, "RU", "City", "Active"),
    2000130: City(
        2000130,
        "Малоярославецкий район",
        "Малоярославецкий район,RU",
        10693,
        "RU",
        "City",
        "Active",
    ),
    2000131: City(
        2000131,
        "Малоярославец",
        "Малоярославец,RU",
        98826,
        "RU",
        "City",
        "Active",
    ),
    2000132: City(2000132, "Обнинск", "Обнинск,RU", 10693, "RU", "City", "Active"),
    2000133: City(
        2000133,
        "Костромская область",
        "Костромская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000134: City(2000134, "Кострома", "Кострома,RU", 10699, "RU", "City", "Active"),
    2000135: City(
        2000135,
        "Курская область",
        "Курская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000136: City(
        2000136,
        "Железногорск",
        "Железногорск,RU",
        10705,
        "RU",
        "City",
        "Active",
    ),
    2000137: City(2000137, "Курск", "Курск,RU", 10705, "RU", "City", "Active"),
    2000138: City(2000138, "Курчатов", "Курчатов,RU", 10705, "RU", "City", "Active"),
    2000139: City(
        2000139,
        "Липецкая область",
        "Липецкая область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000140: City(2000140, "Елец", "Елец,RU", 10712, "RU", "City", "Active"),
    2000141: City(2000141, "Липецк", "Липецк,RU", 10712, "RU", "City", "Active"),
    2000142: City(
        2000142,
        "Орловская область",
        "Орловская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000143: City(2000143, "Орёл", "Орёл,RU", 10772, "RU", "City", "Active"),
    2000144: City(
        2000144,
        "Рязанская область",
        "Рязанская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000145: City(2000145, "Касимов", "Касимов,RU", 10776, "RU", "City", "Active"),
    2000146: City(2000146, "Рязань", "Рязань,RU", 10776, "RU", "City", "Active"),
    2000147: City(
        2000147,
        "Смоленская область",
        "Смоленская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000148: City(
        2000148,
        "Вяземский район",
        "Вяземский район,RU",
        10795,
        "RU",
        "City",
        "Active",
    ),
    2000149: City(2000149, "Вязьма", "Вязьма,RU", 98958, "RU", "City", "Active"),
    2000150: City(
        2000150,
        "Гагаринский район",
        "Гагаринский район,RU",
        10795,
        "RU",
        "City",
        "Active",
    ),
    2000151: City(2000151, "Гагарин", "Гагарин,RU", 98959, "RU", "City", "Active"),
    2000152: City(2000152, "Смоленск", "Смоленск,RU", 10795, "RU", "City", "Active"),
    2000153: City(
        2000153,
        "Ярцевский район",
        "Ярцевский район,RU",
        10795,
        "RU",
        "City",
        "Active",
    ),
    2000154: City(2000154, "Ярцево", "Ярцево,RU", 98981, "RU", "City", "Active"),
    2000155: City(
        2000155,
        "Тамбовская область",
        "Тамбовская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000156: City(2000156, "Мичуринск", "Мичуринск,RU", 10802, "RU", "City", "Active"),
    2000157: City(2000157, "Тамбов", "Тамбов,RU", 10802, "RU", "City", "Active"),
    2000158: City(
        2000158,
        "Тверская область",
        "Тверская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000159: City(
        2000159,
        "Бологовский район",
        "Бологовский район,RU",
        10819,
        "RU",
        "City",
        "Active",
    ),
    2000160: City(2000160, "Бологое", "Бологое,RU", 99008, "RU", "City", "Active"),
    2000161: City(
        2000161,
        "Вышний Волочёк",
        "Вышний Волочёк,RU",
        10819,
        "RU",
        "City",
        "Active",
    ),
    2000162: City(2000162, "Кимры", "Кимры,RU", 10819, "RU", "City", "Active"),
    2000163: City(
        2000163,
        "Конаковский район",
        "Конаковский район,RU",
        10819,
        "RU",
        "City",
        "Active",
    ),
    2000164: City(2000164, "Конаково", "Конаково,RU", 99019, "RU", "City", "Active"),
    2000165: City(2000165, "Ржев", "Ржев,RU", 10819, "RU", "City", "Active"),
    2000166: City(2000166, "Тверь", "Тверь,RU", 10819, "RU", "City", "Active"),
    2000167: City(
        2000167,
        "Удомельский район",
        "Удомельский район,RU",
        10819,
        "RU",
        "City",
        "Active",
    ),
    2000168: City(2000168, "Удомля", "Удомля,RU", 99039, "RU", "City", "Active"),
    2000169: City(
        2000169,
        "Тульская область",
        "Тульская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000170: City(
        2000170,
        "Богородицкий район",
        "Богородицкий район,RU",
        10832,
        "RU",
        "City",
        "Active",
    ),
    2000171: City(
        2000171, "Богородицк", "Богородицк,RU", 99044, "RU", "City", "Active"
    ),
    2000172: City(2000172, "Ефремов", "Ефремов,RU", 10832, "RU", "City", "Active"),
    2000173: City(
        2000173,
        "Новомосковск",
        "Новомосковск,RU",
        10832,
        "RU",
        "City",
        "Active",
    ),
    2000174: City(2000174, "Тула", "Тула,RU", 10832, "RU", "City", "Active"),
    2000175: City(
        2000175,
        "Ярославская область",
        "Ярославская область,RU",
        3,
        "RU",
        "City",
        "Active",
    ),
    2000176: City(
        2000176,
        "Переславль-Залесский",
        "Переславль-Залесский,RU",
        10841,
        "RU",
        "City",
        "Active",
    ),
    2000177: City(2000177, "Рыбинск", "Рыбинск,RU", 10841, "RU", "City", "Active"),
    2000178: City(
        2000178,
        "Тутаевский район",
        "Тутаевский район,RU",
        10841,
        "RU",
        "City",
        "Active",
    ),
    2000179: City(2000179, "Тутаев", "Тутаев,RU", 99078, "RU", "City", "Active"),
    2000180: City(
        2000180,
        "Угличский район",
        "Угличский район,RU",
        10841,
        "RU",
        "City",
        "Active",
    ),
    2000181: City(2000181, "Углич", "Углич,RU", 99079, "RU", "City", "Active"),
    2000182: City(2000182, "Ярославль", "Ярославль,RU", 10841, "RU", "City", "Active"),
    2000183: City(
        2000183, "Северо-Запад", "Северо-Запад,RU", 225, "RU", "City", "Active"
    ),
    2000184: City(
        2000184,
        "Санкт-Петербург и Ленинградская область",
        "Санкт-Петербург и Ленинградская область,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000185: City(
        2000185,
        "Волховский район",
        "Волховский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000186: City(2000186, "Волхов", "Волхов,RU", 98620, "RU", "City", "Active"),
    2000187: City(
        2000187,
        "Всеволожский район",
        "Всеволожский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000188: City(
        2000188, "Всеволожск", "Всеволожск,RU", 98621, "RU", "City", "Active"
    ),
    2000189: City(
        2000189,
        "Выборгский район",
        "Выборгский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000190: City(2000190, "Выборг", "Выборг,RU", 98622, "RU", "City", "Active"),
    2000191: City(
        2000191,
        "Гатчинский район",
        "Гатчинский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000192: City(2000192, "Гатчина", "Гатчина,RU", 98623, "RU", "City", "Active"),
    2000193: City(
        2000193,
        "Кингисеппский район",
        "Кингисеппский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000194: City(2000194, "Кингисепп", "Кингисепп,RU", 98624, "RU", "City", "Active"),
    2000195: City(
        2000195,
        "Киришский район",
        "Киришский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000196: City(2000196, "Кириши", "Кириши,RU", 98625, "RU", "City", "Active"),
    2000197: City(
        2000197,
        "Кировский район",
        "Кировский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000198: City(2000198, "Кировск", "Кировск,RU", 98626, "RU", "City", "Active"),
    2000199: City(
        2000199,
        "Лужский район",
        "Лужский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000200: City(2000200, "Луга", "Луга,RU", 98629, "RU", "City", "Active"),
    2000201: City(
        2000201,
        "Подпорожский район",
        "Подпорожский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000202: City(
        2000202, "Подпорожье", "Подпорожье,RU", 98630, "RU", "City", "Active"
    ),
    2000203: City(
        2000203,
        "Приозерский район",
        "Приозерский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000204: City(2000204, "Приозерск", "Приозерск,RU", 98631, "RU", "City", "Active"),
    2000205: City(
        2000205,
        "Санкт-Петербург",
        "Санкт-Петербург,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000206: City(
        2000206,
        "Колпинский район",
        "Колпинский район,RU",
        2,
        "RU",
        "City",
        "Active",
    ),
    2000207: City(2000207, "Колпино", "Колпино,RU", 20293, "RU", "City", "Active"),
    2000208: City(
        2000208,
        "Пушкинский район",
        "Пушкинский район,RU",
        2,
        "RU",
        "City",
        "Active",
    ),
    2000209: City(2000209, "Пушкин", "Пушкин,RU", 20297, "RU", "City", "Active"),
    2000210: City(
        2000210,
        "Сланцевский район",
        "Сланцевский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000211: City(2000211, "Сланцы", "Сланцы,RU", 98632, "RU", "City", "Active"),
    2000212: City(
        2000212,
        "Сосновый Бор",
        "Сосновый Бор,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000213: City(
        2000213,
        "Тихвинский район",
        "Тихвинский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000214: City(2000214, "Тихвин", "Тихвин,RU", 98633, "RU", "City", "Active"),
    2000215: City(
        2000215,
        "Тосненский район",
        "Тосненский район,RU",
        10174,
        "RU",
        "City",
        "Active",
    ),
    2000216: City(2000216, "Тосно", "Тосно,RU", 98634, "RU", "City", "Active"),
    2000217: City(
        2000217,
        "Архангельская область",
        "Архангельская область,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000218: City(
        2000218, "Архангельск", "Архангельск,RU", 10842, "RU", "City", "Active"
    ),
    2000219: City(2000219, "Котлас", "Котлас,RU", 10842, "RU", "City", "Active"),
    2000220: City(
        2000220,
        "Северодвинск",
        "Северодвинск,RU",
        10842,
        "RU",
        "City",
        "Active",
    ),
    2000221: City(
        2000221,
        "Вологодская область",
        "Вологодская область,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000222: City(2000222, "Вологда", "Вологда,RU", 10853, "RU", "City", "Active"),
    2000223: City(2000223, "Череповец", "Череповец,RU", 10853, "RU", "City", "Active"),
    2000224: City(
        2000224,
        "Калининградская область",
        "Калининградская область,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000225: City(
        2000225, "Калининград", "Калининград,RU", 10857, "RU", "City", "Active"
    ),
    2000226: City(2000226, "Советск", "Советск,RU", 10857, "RU", "City", "Active"),
    2000227: City(
        2000227,
        "Мурманская область",
        "Мурманская область,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000228: City(2000228, "Апатиты", "Апатиты,RU", 10897, "RU", "City", "Active"),
    2000229: City(
        2000229,
        "Кандалакшский район",
        "Кандалакшский район,RU",
        10897,
        "RU",
        "City",
        "Active",
    ),
    2000230: City(
        2000230, "Кандалакша", "Кандалакша,RU", 101749, "RU", "City", "Active"
    ),
    2000231: City(
        2000231, "Мончегорск", "Мончегорск,RU", 10897, "RU", "City", "Active"
    ),
    2000232: City(2000232, "Мурманск", "Мурманск,RU", 10897, "RU", "City", "Active"),
    2000233: City(
        2000233, "Оленегорск", "Оленегорск,RU", 10897, "RU", "City", "Active"
    ),
    2000234: City(
        2000234,
        "Ненецкий автономный округ",
        "Ненецкий автономный округ,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000235: City(
        2000235, "Нарьян-Мар", "Нарьян-Мар,RU", 10176, "RU", "City", "Active"
    ),
    2000236: City(
        2000236,
        "Новгородская область",
        "Новгородская область,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000237: City(
        2000237,
        "Боровичский район",
        "Боровичский район,RU",
        10904,
        "RU",
        "City",
        "Active",
    ),
    2000238: City(2000238, "Боровичи", "Боровичи,RU", 99146, "RU", "City", "Active"),
    2000239: City(
        2000239,
        "Великий Новгород",
        "Великий Новгород,RU",
        10904,
        "RU",
        "City",
        "Active",
    ),
    2000240: City(
        2000240,
        "Старорусский район",
        "Старорусский район,RU",
        10904,
        "RU",
        "City",
        "Active",
    ),
    2000241: City(
        2000241,
        "Старая Русса",
        "Старая Русса,RU",
        99161,
        "RU",
        "City",
        "Active",
    ),
    2000242: City(
        2000242,
        "Псковская область",
        "Псковская область,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000243: City(
        2000243,
        "Великие Луки",
        "Великие Луки,RU",
        10926,
        "RU",
        "City",
        "Active",
    ),
    2000244: City(2000244, "Псков", "Псков,RU", 10926, "RU", "City", "Active"),
    2000245: City(
        2000245,
        "Республика Карелия",
        "Республика Карелия,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000246: City(
        2000246,
        "Кондопожский район",
        "Кондопожский район,RU",
        10933,
        "RU",
        "City",
        "Active",
    ),
    2000247: City(2000247, "Кондопога", "Кондопога,RU", 99193, "RU", "City", "Active"),
    2000248: City(
        2000248, "Костомукша", "Костомукша,RU", 10933, "RU", "City", "Active"
    ),
    2000249: City(
        2000249,
        "Петрозаводск",
        "Петрозаводск,RU",
        10933,
        "RU",
        "City",
        "Active",
    ),
    2000250: City(
        2000250,
        "Сегежский район",
        "Сегежский район,RU",
        10933,
        "RU",
        "City",
        "Active",
    ),
    2000251: City(2000251, "Сегежа", "Сегежа,RU", 99203, "RU", "City", "Active"),
    2000252: City(
        2000252,
        "Сортавальский район",
        "Сортавальский район,RU",
        10933,
        "RU",
        "City",
        "Active",
    ),
    2000253: City(2000253, "Сортавала", "Сортавала,RU", 110934, "RU", "City", "Active"),
    2000254: City(
        2000254,
        "Республика Коми",
        "Республика Коми,RU",
        17,
        "RU",
        "City",
        "Active",
    ),
    2000255: City(2000255, "Воркута", "Воркута,RU", 10939, "RU", "City", "Active"),
    2000256: City(2000256, "Инта", "Инта,RU", 10939, "RU", "City", "Active"),
    2000257: City(
        2000257,
        "Район Печора",
        "Район Печора,RU",
        10939,
        "RU",
        "City",
        "Active",
    ),
    2000258: City(2000258, "Печора", "Печора,RU", 99210, "RU", "City", "Active"),
    2000259: City(2000259, "Сыктывкар", "Сыктывкар,RU", 10939, "RU", "City", "Active"),
    2000260: City(2000260, "Усинск", "Усинск,RU", 10939, "RU", "City", "Active"),
    2000261: City(2000261, "Ухта", "Ухта,RU", 10939, "RU", "City", "Active"),
    2000262: City(2000262, "Поволжье", "Поволжье,RU", 225, "RU", "City", "Active"),
    2000263: City(
        2000263,
        "Кировская область",
        "Кировская область,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000264: City(
        2000264,
        "Вятские Поляны",
        "Вятские Поляны,RU",
        11070,
        "RU",
        "City",
        "Active",
    ),
    2000265: City(2000265, "Киров", "Киров,RU", 11070, "RU", "City", "Active"),
    2000266: City(
        2000266,
        "Кирово-Чепецк",
        "Кирово-Чепецк,RU",
        11070,
        "RU",
        "City",
        "Active",
    ),
    2000267: City(
        2000267,
        "Нижегородская область",
        "Нижегородская область,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000268: City(2000268, "Арзамас", "Арзамас,RU", 11079, "RU", "City", "Active"),
    2000269: City(2000269, "Выкса", "Выкса,RU", 11079, "RU", "City", "Active"),
    2000270: City(2000270, "Дзержинск", "Дзержинск,RU", 11079, "RU", "City", "Active"),
    2000271: City(
        2000271,
        "Кстовский район",
        "Кстовский район,RU",
        11079,
        "RU",
        "City",
        "Active",
    ),
    2000272: City(2000272, "Кстово", "Кстово,RU", 99555, "RU", "City", "Active"),
    2000273: City(
        2000273,
        "Нижний Новгород",
        "Нижний Новгород,RU",
        11079,
        "RU",
        "City",
        "Active",
    ),
    2000274: City(
        2000274,
        "Павловский район",
        "Павловский район,RU",
        11079,
        "RU",
        "City",
        "Active",
    ),
    2000275: City(2000275, "Павлово", "Павлово,RU", 99560, "RU", "City", "Active"),
    2000276: City(2000276, "Саров", "Саров,RU", 11079, "RU", "City", "Active"),
    2000277: City(
        2000277,
        "Оренбургская область",
        "Оренбургская область,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000278: City(2000278, "Бузулук", "Бузулук,RU", 11084, "RU", "City", "Active"),
    2000279: City(2000279, "Гай", "Гай,RU", 11084, "RU", "City", "Active"),
    2000280: City(
        2000280, "Новотроицк", "Новотроицк,RU", 11084, "RU", "City", "Active"
    ),
    2000281: City(2000281, "Оренбург", "Оренбург,RU", 11084, "RU", "City", "Active"),
    2000282: City(2000282, "Орск", "Орск,RU", 11084, "RU", "City", "Active"),
    2000283: City(
        2000283,
        "Пензенская область",
        "Пензенская область,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000284: City(2000284, "Кузнецк", "Кузнецк,RU", 11095, "RU", "City", "Active"),
    2000285: City(2000285, "Пенза", "Пенза,RU", 11095, "RU", "City", "Active"),
    2000286: City(
        2000286,
        "Пермский край",
        "Пермский край,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000287: City(2000287, "Березники", "Березники,RU", 11108, "RU", "City", "Active"),
    2000288: City(2000288, "Лысьва", "Лысьва,RU", 11108, "RU", "City", "Active"),
    2000289: City(2000289, "Пермь", "Пермь,RU", 11108, "RU", "City", "Active"),
    2000290: City(2000290, "Соликамск", "Соликамск,RU", 11108, "RU", "City", "Active"),
    2000291: City(
        2000291,
        "Чайковский район",
        "Чайковский район,RU",
        11108,
        "RU",
        "City",
        "Active",
    ),
    2000292: City(
        2000292, "Чайковский", "Чайковский,RU", 110916, "RU", "City", "Active"
    ),
    2000293: City(
        2000293,
        "Республика Башкортостан",
        "Республика Башкортостан,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000294: City(
        2000294,
        "Белебеевский район",
        "Белебеевский район,RU",
        11111,
        "RU",
        "City",
        "Active",
    ),
    2000295: City(2000295, "Белебей", "Белебей,RU", 99675, "RU", "City", "Active"),
    2000296: City(
        2000296,
        "Белорецкий район",
        "Белорецкий район,RU",
        11111,
        "RU",
        "City",
        "Active",
    ),
    2000297: City(2000297, "Белорецк", "Белорецк,RU", 99677, "RU", "City", "Active"),
    2000298: City(
        2000298,
        "Ишимбайский район",
        "Ишимбайский район,RU",
        11111,
        "RU",
        "City",
        "Active",
    ),
    2000299: City(2000299, "Ишимбай", "Ишимбай,RU", 99694, "RU", "City", "Active"),
    2000300: City(2000300, "Кумертау", "Кумертау,RU", 11111, "RU", "City", "Active"),
    2000301: City(
        2000301,
        "Мелеузовский район",
        "Мелеузовский район,RU",
        11111,
        "RU",
        "City",
        "Active",
    ),
    2000302: City(2000302, "Мелеуз", "Мелеуз,RU", 99703, "RU", "City", "Active"),
    2000303: City(
        2000303, "Нефтекамск", "Нефтекамск,RU", 11111, "RU", "City", "Active"
    ),
    2000304: City(
        2000304, "Октябрьский", "Октябрьский,RU", 11111, "RU", "City", "Active"
    ),
    2000305: City(2000305, "Салават", "Салават,RU", 11111, "RU", "City", "Active"),
    2000306: City(2000306, "Сибай", "Сибай,RU", 11111, "RU", "City", "Active"),
    2000307: City(
        2000307, "Стерлитамак", "Стерлитамак,RU", 11111, "RU", "City", "Active"
    ),
    2000308: City(
        2000308,
        "Туймазинский район",
        "Туймазинский район,RU",
        11111,
        "RU",
        "City",
        "Active",
    ),
    2000309: City(2000309, "Туймазы", "Туймазы,RU", 99712, "RU", "City", "Active"),
    2000310: City(2000310, "Уфа", "Уфа,RU", 11111, "RU", "City", "Active"),
    2000311: City(
        2000311,
        "Учалинский район",
        "Учалинский район,RU",
        11111,
        "RU",
        "City",
        "Active",
    ),
    2000312: City(2000312, "Учалы", "Учалы,RU", 99714, "RU", "City", "Active"),
    2000313: City(
        2000313,
        "Республика Марий Эл",
        "Республика Марий Эл,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000314: City(2000314, "Волжск", "Волжск,RU", 11077, "RU", "City", "Active"),
    2000315: City(
        2000315, "Йошкар-Ола", "Йошкар-Ола,RU", 11077, "RU", "City", "Active"
    ),
    2000316: City(
        2000316,
        "Республика Мордовия",
        "Республика Мордовия,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000317: City(
        2000317,
        "Рузаевский район",
        "Рузаевский район,RU",
        11117,
        "RU",
        "City",
        "Active",
    ),
    2000318: City(2000318, "Рузаевка", "Рузаевка,RU", 99737, "RU", "City", "Active"),
    2000319: City(2000319, "Саранск", "Саранск,RU", 11117, "RU", "City", "Active"),
    2000320: City(
        2000320,
        "Республика Татарстан",
        "Республика Татарстан,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000321: City(
        2000321, "Альметьевск", "Альметьевск,RU", 11119, "RU", "City", "Active"
    ),
    2000322: City(2000322, "Бугульма", "Бугульма,RU", 11119, "RU", "City", "Active"),
    2000323: City(2000323, "Казань", "Казань,RU", 11119, "RU", "City", "Active"),
    2000324: City(
        2000324,
        "Набережные Челны",
        "Набережные Челны,RU",
        11119,
        "RU",
        "City",
        "Active",
    ),
    2000325: City(
        2000325, "Нижнекамск", "Нижнекамск,RU", 11119, "RU", "City", "Active"
    ),
    2000326: City(
        2000326,
        "Самарская область",
        "Самарская область,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000327: City(2000327, "Жигулёвск", "Жигулёвск,RU", 11131, "RU", "City", "Active"),
    2000328: City(2000328, "Самара", "Самара,RU", 11131, "RU", "City", "Active"),
    2000329: City(2000329, "Сызрань", "Сызрань,RU", 11131, "RU", "City", "Active"),
    2000330: City(2000330, "Тольятти", "Тольятти,RU", 11131, "RU", "City", "Active"),
    2000331: City(
        2000331,
        "Саратовская область",
        "Саратовская область,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000332: City(
        2000332,
        "Балаковский район",
        "Балаковский район,RU",
        11146,
        "RU",
        "City",
        "Active",
    ),
    2000333: City(2000333, "Балаково", "Балаково,RU", 99817, "RU", "City", "Active"),
    2000334: City(
        2000334,
        "Балашовский район",
        "Балашовский район,RU",
        11146,
        "RU",
        "City",
        "Active",
    ),
    2000335: City(2000335, "Балашов", "Балашов,RU", 99818, "RU", "City", "Active"),
    2000336: City(2000336, "Саратов", "Саратов,RU", 11146, "RU", "City", "Active"),
    2000337: City(
        2000337,
        "Энгельсский район",
        "Энгельсский район,RU",
        11146,
        "RU",
        "City",
        "Active",
    ),
    2000338: City(2000338, "Энгельс", "Энгельс,RU", 99850, "RU", "City", "Active"),
    2000339: City(
        2000339,
        "Удмуртская Республика",
        "Удмуртская Республика,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000340: City(2000340, "Воткинск", "Воткинск,RU", 11148, "RU", "City", "Active"),
    2000341: City(2000341, "Глазов", "Глазов,RU", 11148, "RU", "City", "Active"),
    2000342: City(2000342, "Ижевск", "Ижевск,RU", 11148, "RU", "City", "Active"),
    2000343: City(2000343, "Сарапул", "Сарапул,RU", 11148, "RU", "City", "Active"),
    2000344: City(
        2000344,
        "Ульяновская область",
        "Ульяновская область,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000345: City(
        2000345,
        "Димитровград",
        "Димитровград,RU",
        11153,
        "RU",
        "City",
        "Active",
    ),
    2000346: City(2000346, "Ульяновск", "Ульяновск,RU", 11153, "RU", "City", "Active"),
    2000347: City(
        2000347,
        "Чувашская Республика",
        "Чувашская Республика,RU",
        40,
        "RU",
        "City",
        "Active",
    ),
    2000348: City(
        2000348,
        "Новочебоксарск",
        "Новочебоксарск,RU",
        11156,
        "RU",
        "City",
        "Active",
    ),
    2000349: City(2000349, "Чебоксары", "Чебоксары,RU", 11156, "RU", "City", "Active"),
    2000350: City(2000350, "Шумерля", "Шумерля,RU", 11156, "RU", "City", "Active"),
    2000351: City(2000351, "Юг", "Юг,RU", 225, "RU", "City", "Active"),
    2000352: City(
        2000352,
        "Астраханская область",
        "Астраханская область,RU",
        26,
        "RU",
        "City",
        "Active",
    ),
    2000353: City(2000353, "Астрахань", "Астрахань,RU", 10946, "RU", "City", "Active"),
    2000354: City(
        2000354,
        "Ахтубинский район",
        "Ахтубинский район,RU",
        10946,
        "RU",
        "City",
        "Active",
    ),
    2000355: City(2000355, "Ахтубинск", "Ахтубинск,RU", 99221, "RU", "City", "Active"),
    2000356: City(
        2000356,
        "Волгоградская область",
        "Волгоградская область,RU",
        26,
        "RU",
        "City",
        "Active",
    ),
    2000357: City(2000357, "Волгоград", "Волгоград,RU", 10950, "RU", "City", "Active"),
    2000358: City(2000358, "Волжский", "Волжский,RU", 10950, "RU", "City", "Active"),
    2000359: City(2000359, "Камышин", "Камышин,RU", 10950, "RU", "City", "Active"),
    2000360: City(
        2000360, "Михайловка", "Михайловка,RU", 10950, "RU", "City", "Active"
    ),
    2000361: City(2000361, "Урюпинск", "Урюпинск,RU", 10950, "RU", "City", "Active"),
    2000362: City(
        2000362,
        "Краснодарский край",
        "Краснодарский край,RU",
        26,
        "RU",
        "City",
        "Active",
    ),
    2000363: City(2000363, "Анапа", "Анапа,RU", 10995, "RU", "City", "Active"),
    2000364: City(2000364, "Армавир", "Армавир,RU", 10995, "RU", "City", "Active"),
    2000365: City(
        2000365,
        "Белореченский район",
        "Белореченский район,RU",
        10995,
        "RU",
        "City",
        "Active",
    ),
    2000366: City(
        2000366, "Белореченск", "Белореченск,RU", 99269, "RU", "City", "Active"
    ),
    2000367: City(2000367, "Геленджик", "Геленджик,RU", 10995, "RU", "City", "Active"),
    2000368: City(
        2000368,
        "Ейский район",
        "Ейский район,RU",
        10995,
        "RU",
        "City",
        "Active",
    ),
    2000369: City(2000369, "Ейск", "Ейск,RU", 99274, "RU", "City", "Active"),
    2000370: City(
        2000370,
        "Кавказский район",
        "Кавказский район,RU",
        10995,
        "RU",
        "City",
        "Active",
    ),
    2000371: City(2000371, "Кропоткин", "Кропоткин,RU", 99275, "RU", "City", "Active"),
    2000372: City(2000372, "Краснодар", "Краснодар,RU", 10995, "RU", "City", "Active"),
    2000373: City(
        2000373,
        "Крымский район",
        "Крымский район,RU",
        10995,
        "RU",
        "City",
        "Active",
    ),
    2000374: City(2000374, "Крымск", "Крымск,RU", 99281, "RU", "City", "Active"),
    2000375: City(
        2000375,
        "Новороссийск",
        "Новороссийск,RU",
        10995,
        "RU",
        "City",
        "Active",
    ),
    2000376: City(
        2000376,
        "Славянский район",
        "Славянский район,RU",
        10995,
        "RU",
        "City",
        "Active",
    ),
    2000377: City(
        2000377,
        "Славянск-на-Кубани",
        "Славянск-на-Кубани,RU",
        99293,
        "RU",
        "City",
        "Active",
    ),
    2000378: City(2000378, "Сочи", "Сочи,RU", 10995, "RU", "City", "Active"),
    2000379: City(
        2000379,
        "Тимашевский район",
        "Тимашевский район,RU",
        10995,
        "RU",
        "City",
        "Active",
    ),
    2000380: City(2000380, "Тимашевск", "Тимашевск,RU", 99297, "RU", "City", "Active"),
    2000381: City(
        2000381,
        "Тихорецкий район",
        "Тихорецкий район,RU",
        10995,
        "RU",
        "City",
        "Active",
    ),
    2000382: City(2000382, "Тихорецк", "Тихорецк,RU", 99298, "RU", "City", "Active"),
    2000383: City(
        2000383,
        "Туапсинский район",
        "Туапсинский район,RU",
        10995,
        "RU",
        "City",
        "Active",
    ),
    2000384: City(2000384, "Туапсе", "Туапсе,RU", 99299, "RU", "City", "Active"),
    2000385: City(
        2000385,
        "Республика Адыгея",
        "Республика Адыгея,RU",
        26,
        "RU",
        "City",
        "Active",
    ),
    2000386: City(2000386, "Майкоп", "Майкоп,RU", 11004, "RU", "City", "Active"),
    2000387: City(
        2000387,
        "Республика Калмыкия",
        "Республика Калмыкия,RU",
        26,
        "RU",
        "City",
        "Active",
    ),
    2000388: City(2000388, "Элиста", "Элиста,RU", 11015, "RU", "City", "Active"),
    2000389: City(
        2000389,
        "Ростовская область",
        "Ростовская область,RU",
        26,
        "RU",
        "City",
        "Active",
    ),
    2000390: City(2000390, "Азов", "Азов,RU", 11029, "RU", "City", "Active"),
    2000391: City(
        2000391,
        "Белокалитвинский район",
        "Белокалитвинский район,RU",
        11029,
        "RU",
        "City",
        "Active",
    ),
    2000392: City(
        2000392,
        "Белая Калитва",
        "Белая Калитва,RU",
        99411,
        "RU",
        "City",
        "Active",
    ),
    2000393: City(
        2000393, "Волгодонск", "Волгодонск,RU", 11029, "RU", "City", "Active"
    ),
    2000394: City(
        2000394,
        "Каменск-Шахтинский",
        "Каменск-Шахтинский,RU",
        11029,
        "RU",
        "City",
        "Active",
    ),
    2000395: City(
        2000395,
        "Новочеркасск",
        "Новочеркасск,RU",
        11029,
        "RU",
        "City",
        "Active",
    ),
    2000396: City(
        2000396,
        "Ростов-на-Дону",
        "Ростов-на-Дону,RU",
        11029,
        "RU",
        "City",
        "Active",
    ),
    2000397: City(2000397, "Таганрог", "Таганрог,RU", 11029, "RU", "City", "Active"),
    2000398: City(2000398, "Шахты", "Шахты,RU", 11029, "RU", "City", "Active"),
    2000399: City(2000399, "Сибирь", "Сибирь,RU", 225, "RU", "City", "Active"),
    2000400: City(
        2000400,
        "Алтайский край",
        "Алтайский край,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000401: City(2000401, "Барнаул", "Барнаул,RU", 11235, "RU", "City", "Active"),
    2000402: City(2000402, "Бийск", "Бийск,RU", 11235, "RU", "City", "Active"),
    2000403: City(2000403, "Заринск", "Заринск,RU", 11235, "RU", "City", "Active"),
    2000404: City(2000404, "Рубцовск", "Рубцовск,RU", 11235, "RU", "City", "Active"),
    2000405: City(
        2000405,
        "Иркутская область",
        "Иркутская область,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000406: City(2000406, "Ангарск", "Ангарск,RU", 11266, "RU", "City", "Active"),
    2000407: City(2000407, "Братск", "Братск,RU", 11266, "RU", "City", "Active"),
    2000408: City(2000408, "Иркутск", "Иркутск,RU", 11266, "RU", "City", "Active"),
    2000409: City(
        2000409,
        "Нижнеудинский район",
        "Нижнеудинский район,RU",
        11266,
        "RU",
        "City",
        "Active",
    ),
    2000410: City(
        2000410,
        "Нижнеудинск",
        "Нижнеудинск,RU",
        100109,
        "RU",
        "City",
        "Active",
    ),
    2000411: City(
        2000411,
        "Тайшетский район",
        "Тайшетский район,RU",
        11266,
        "RU",
        "City",
        "Active",
    ),
    2000412: City(2000412, "Тайшет", "Тайшет,RU", 100112, "RU", "City", "Active"),
    2000413: City(2000413, "Тулун", "Тулун,RU", 11266, "RU", "City", "Active"),
    2000414: City(
        2000414,
        "Усолье-Сибирское",
        "Усолье-Сибирское,RU",
        11266,
        "RU",
        "City",
        "Active",
    ),
    2000415: City(
        2000415, "Усть-Илимск", "Усть-Илимск,RU", 11266, "RU", "City", "Active"
    ),
    2000416: City(
        2000416,
        "Усть-Кутский район",
        "Усть-Кутский район,RU",
        11266,
        "RU",
        "City",
        "Active",
    ),
    2000417: City(2000417, "Усть-Кут", "Усть-Кут,RU", 100116, "RU", "City", "Active"),
    2000418: City(2000418, "Черемхово", "Черемхово,RU", 11266, "RU", "City", "Active"),
    2000419: City(
        2000419,
        "Кемеровская область",
        "Кемеровская область,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000420: City(
        2000420,
        "Анжеро-Судженск",
        "Анжеро-Судженск,RU",
        11282,
        "RU",
        "City",
        "Active",
    ),
    2000421: City(2000421, "Белово", "Белово,RU", 11282, "RU", "City", "Active"),
    2000422: City(2000422, "Кемерово", "Кемерово,RU", 11282, "RU", "City", "Active"),
    2000423: City(2000423, "Киселёвск", "Киселёвск,RU", 11282, "RU", "City", "Active"),
    2000424: City(
        2000424,
        "Ленинск-Кузнецкий",
        "Ленинск-Кузнецкий,RU",
        11282,
        "RU",
        "City",
        "Active",
    ),
    2000425: City(
        2000425,
        "Междуреченск",
        "Междуреченск,RU",
        11282,
        "RU",
        "City",
        "Active",
    ),
    2000426: City(2000426, "Мыски", "Мыски,RU", 11282, "RU", "City", "Active"),
    2000427: City(
        2000427, "Новокузнецк", "Новокузнецк,RU", 11282, "RU", "City", "Active"
    ),
    2000428: City(2000428, "Полысаево", "Полысаево,RU", 11282, "RU", "City", "Active"),
    2000429: City(
        2000429, "Прокопьевск", "Прокопьевск,RU", 11282, "RU", "City", "Active"
    ),
    2000430: City(2000430, "Юрга", "Юрга,RU", 11282, "RU", "City", "Active"),
    2000431: City(
        2000431,
        "Красноярский край",
        "Красноярский край,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000432: City(2000432, "Ачинск", "Ачинск,RU", 11309, "RU", "City", "Active"),
    2000433: City(
        2000433,
        "Железногорск",
        "Железногорск,RU",
        11309,
        "RU",
        "City",
        "Active",
    ),
    2000434: City(
        2000434, "Зеленогорск", "Зеленогорск,RU", 11309, "RU", "City", "Active"
    ),
    2000435: City(
        2000435, "Красноярск", "Красноярск,RU", 11309, "RU", "City", "Active"
    ),
    2000436: City(2000436, "Минусинск", "Минусинск,RU", 11309, "RU", "City", "Active"),
    2000437: City(2000437, "Норильск", "Норильск,RU", 11309, "RU", "City", "Active"),
    2000438: City(
        2000438,
        "Новосибирская область",
        "Новосибирская область,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000439: City(2000439, "Искитим", "Искитим,RU", 11316, "RU", "City", "Active"),
    2000440: City(
        2000440, "Новосибирск", "Новосибирск,RU", 11316, "RU", "City", "Active"
    ),
    2000441: City(
        2000441,
        "Омская область",
        "Омская область,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000442: City(2000442, "Омск", "Омск,RU", 11318, "RU", "City", "Active"),
    2000443: City(
        2000443,
        "Республика Алтай",
        "Республика Алтай,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000444: City(
        2000444,
        "Горно-Алтайск",
        "Горно-Алтайск,RU",
        10231,
        "RU",
        "City",
        "Active",
    ),
    2000445: City(
        2000445,
        "Республика Тыва",
        "Республика Тыва,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000446: City(
        2000446,
        "Республика Хакасия",
        "Республика Хакасия,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000447: City(2000447, "Абакан", "Абакан,RU", 11340, "RU", "City", "Active"),
    2000448: City(
        2000448,
        "Томская область",
        "Томская область,RU",
        59,
        "RU",
        "City",
        "Active",
    ),
    2000449: City(2000449, "Северск", "Северск,RU", 11353, "RU", "City", "Active"),
    2000450: City(2000450, "Стрежевой", "Стрежевой,RU", 11353, "RU", "City", "Active"),
    2000451: City(2000451, "Томск", "Томск,RU", 11353, "RU", "City", "Active"),
    2000452: City(
        2000452,
        "Дальний Восток",
        "Дальний Восток,RU",
        225,
        "RU",
        "City",
        "Active",
    ),
    2000453: City(
        2000453,
        "Амурская область",
        "Амурская область,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000454: City(2000454, "Белогорск", "Белогорск,RU", 11375, "RU", "City", "Active"),
    2000455: City(
        2000455,
        "Благовещенск",
        "Благовещенск,RU",
        11375,
        "RU",
        "City",
        "Active",
    ),
    2000456: City(2000456, "Свободный", "Свободный,RU", 11375, "RU", "City", "Active"),
    2000457: City(2000457, "Тында", "Тында,RU", 11375, "RU", "City", "Active"),
    2000458: City(
        2000458,
        "Еврейская автономная область",
        "Еврейская автономная область,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000459: City(
        2000459,
        "Забайкальский край",
        "Забайкальский край,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000460: City(2000460, "Чита", "Чита,RU", 21949, "RU", "City", "Active"),
    2000461: City(
        2000461,
        "Камчатский край",
        "Камчатский край,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000462: City(
        2000462,
        "Петропавловск-Камчатский",
        "Петропавловск-Камчатский,RU",
        11398,
        "RU",
        "City",
        "Active",
    ),
    2000463: City(
        2000463,
        "Магаданская область",
        "Магаданская область,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000464: City(2000464, "Магадан", "Магадан,RU", 11403, "RU", "City", "Active"),
    2000465: City(
        2000465,
        "Приморский край",
        "Приморский край,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000466: City(2000466, "Арсеньев", "Арсеньев,RU", 11409, "RU", "City", "Active"),
    2000467: City(2000467, "Артём", "Артём,RU", 11409, "RU", "City", "Active"),
    2000468: City(
        2000468, "Владивосток", "Владивосток,RU", 11409, "RU", "City", "Active"
    ),
    2000469: City(
        2000469, "Дальнегорск", "Дальнегорск,RU", 11409, "RU", "City", "Active"
    ),
    2000470: City(2000470, "Находка", "Находка,RU", 11409, "RU", "City", "Active"),
    2000471: City(2000471, "Уссурийск", "Уссурийск,RU", 11409, "RU", "City", "Active"),
    2000472: City(
        2000472,
        "Республика Бурятия",
        "Республика Бурятия,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000473: City(
        2000473,
        "Северобайкальск",
        "Северобайкальск,RU",
        11330,
        "RU",
        "City",
        "Active",
    ),
    2000474: City(2000474, "Улан-Удэ", "Улан-Удэ,RU", 11330, "RU", "City", "Active"),
    2000475: City(
        2000475,
        "Республика Саха (Якутия)",
        "Республика Саха (Якутия),RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000476: City(
        2000476,
        "Нерюнгринский район",
        "Нерюнгринский район,RU",
        11443,
        "RU",
        "City",
        "Active",
    ),
    2000477: City(2000477, "Нерюнгри", "Нерюнгри,RU", 101987, "RU", "City", "Active"),
    2000478: City(2000478, "Якутск", "Якутск,RU", 11443, "RU", "City", "Active"),
    2000479: City(
        2000479,
        "Сахалинская область",
        "Сахалинская область,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000480: City(
        2000480,
        "Южно-Сахалинск",
        "Южно-Сахалинск,RU",
        11450,
        "RU",
        "City",
        "Active",
    ),
    2000481: City(
        2000481,
        "Хабаровский край",
        "Хабаровский край,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000482: City(
        2000482,
        "Амурский район",
        "Амурский район,RU",
        11457,
        "RU",
        "City",
        "Active",
    ),
    2000483: City(2000483, "Амурск", "Амурск,RU", 100398, "RU", "City", "Active"),
    2000484: City(
        2000484,
        "Комсомольск-на-Амуре",
        "Комсомольск-на-Амуре,RU",
        11457,
        "RU",
        "City",
        "Active",
    ),
    2000485: City(2000485, "Хабаровск", "Хабаровск,RU", 11457, "RU", "City", "Active"),
    2000486: City(
        2000486,
        "Чукотский автономный округ",
        "Чукотский автономный округ,RU",
        73,
        "RU",
        "City",
        "Active",
    ),
    2000487: City(
        2000487,
        "Республика Крым",
        "Республика Крым,RU",
        225,
        "RU",
        "City",
        "Active",
    ),
    2000488: City(2000488, "Алушта", "Алушта,RU", 977, "RU", "City", "Active"),
    2000489: City(2000489, "Армянск", "Армянск,RU", 977, "RU", "City", "Active"),
    2000490: City(
        2000490,
        "Бахчисарайский район",
        "Бахчисарайский район,RU",
        977,
        "RU",
        "City",
        "Active",
    ),
    2000491: City(
        2000491, "Бахчисарай", "Бахчисарай,RU", 24696, "RU", "City", "Active"
    ),
    2000492: City(2000492, "Джанкой", "Джанкой,RU", 977, "RU", "City", "Active"),
    2000493: City(2000493, "Евпатория", "Евпатория,RU", 977, "RU", "City", "Active"),
    2000494: City(2000494, "Керчь", "Керчь,RU", 977, "RU", "City", "Active"),
    2000495: City(
        2000495,
        "Красноперекопск",
        "Красноперекопск,RU",
        977,
        "RU",
        "City",
        "Active",
    ),
    2000496: City(
        2000496,
        "Ленинский район",
        "Ленинский район,RU",
        977,
        "RU",
        "City",
        "Active",
    ),
    2000497: City(2000497, "Щёлкино", "Щёлкино,RU", 24702, "RU", "City", "Active"),
    2000498: City(2000498, "Саки", "Саки,RU", 977, "RU", "City", "Active"),
    2000499: City(
        2000499, "Севастополь", "Севастополь,RU", 977, "RU", "City", "Active"
    ),
    2000500: City(
        2000500, "Симферополь", "Симферополь,RU", 977, "RU", "City", "Active"
    ),
    2000501: City(2000501, "Судак", "Судак,RU", 977, "RU", "City", "Active"),
    2000502: City(2000502, "Феодосия", "Феодосия,RU", 977, "RU", "City", "Active"),
    2000503: City(2000503, "Ялта", "Ялта,RU", 977, "RU", "City", "Active"),
    2000504: City(
        2000504,
        "Северный Кавказ",
        "Северный Кавказ,RU",
        225,
        "RU",
        "City",
        "Active",
    ),
    2000505: City(
        2000505,
        "Кабардино-Балкарская Республика",
        "Кабардино-Балкарская Республика,RU",
        102444,
        "RU",
        "City",
        "Active",
    ),
    2000506: City(2000506, "Нальчик", "Нальчик,RU", 11013, "RU", "City", "Active"),
    2000507: City(
        2000507,
        "Карачаево-Черкесская Республика",
        "Карачаево-Черкесская Республика,RU",
        102444,
        "RU",
        "City",
        "Active",
    ),
    2000508: City(2000508, "Черкесск", "Черкесск,RU", 11020, "RU", "City", "Active"),
    2000509: City(
        2000509,
        "Республика Дагестан",
        "Республика Дагестан,RU",
        102444,
        "RU",
        "City",
        "Active",
    ),
    2000510: City(2000510, "Буйнакск", "Буйнакск,RU", 11010, "RU", "City", "Active"),
    2000511: City(2000511, "Дербент", "Дербент,RU", 11010, "RU", "City", "Active"),
    2000512: City(2000512, "Избербаш", "Избербаш,RU", 11010, "RU", "City", "Active"),
    2000513: City(2000513, "Каспийск", "Каспийск,RU", 11010, "RU", "City", "Active"),
    2000514: City(2000514, "Кизляр", "Кизляр,RU", 11010, "RU", "City", "Active"),
    2000515: City(2000515, "Махачкала", "Махачкала,RU", 11010, "RU", "City", "Active"),
    2000516: City(2000516, "Хасавюрт", "Хасавюрт,RU", 11010, "RU", "City", "Active"),
    2000517: City(
        2000517,
        "Республика Ингушетия",
        "Республика Ингушетия,RU",
        102444,
        "RU",
        "City",
        "Active",
    ),
    2000518: City(2000518, "Назрань", "Назрань,RU", 11012, "RU", "City", "Active"),
    2000519: City(
        2000519,
        "Республика Северная Осетия — Алания",
        "Республика Северная Осетия — Алания,RU",
        102444,
        "RU",
        "City",
        "Active",
    ),
    2000520: City(
        2000520, "Владикавказ", "Владикавказ,RU", 11021, "RU", "City", "Active"
    ),
    2000521: City(
        2000521,
        "Ставропольский край",
        "Ставропольский край,RU",
        102444,
        "RU",
        "City",
        "Active",
    ),
    2000522: City(
        2000522,
        "Будённовский район",
        "Будённовский район,RU",
        11069,
        "RU",
        "City",
        "Active",
    ),
    2000523: City(
        2000523, "Будённовск", "Будённовск,RU", 99456, "RU", "City", "Active"
    ),
    2000524: City(
        2000524, "Георгиевск", "Георгиевск,RU", 11069, "RU", "City", "Active"
    ),
    2000525: City(2000525, "Ессентуки", "Ессентуки,RU", 11069, "RU", "City", "Active"),
    2000526: City(
        2000526, "Кисловодск", "Кисловодск,RU", 11069, "RU", "City", "Active"
    ),
    2000527: City(
        2000527,
        "Минеральные Воды",
        "Минеральные Воды,RU",
        11069,
        "RU",
        "City",
        "Active",
    ),
    2000528: City(
        2000528,
        "Невинномысск",
        "Невинномысск,RU",
        11069,
        "RU",
        "City",
        "Active",
    ),
    2000529: City(2000529, "Пятигорск", "Пятигорск,RU", 11069, "RU", "City", "Active"),
    2000530: City(
        2000530, "Ставрополь", "Ставрополь,RU", 11069, "RU", "City", "Active"
    ),
    2000531: City(
        2000531,
        "Чеченская Республика",
        "Чеченская Республика,RU",
        102444,
        "RU",
        "City",
        "Active",
    ),
    2000532: City(2000532, "Грозный", "Грозный,RU", 11024, "RU", "City", "Active"),
    2000533: City(2000533, "Урал", "Урал,RU", 225, "RU", "City", "Active"),
    2000534: City(
        2000534,
        "Курганская область",
        "Курганская область,RU",
        52,
        "RU",
        "City",
        "Active",
    ),
    2000535: City(2000535, "Курган", "Курган,RU", 11158, "RU", "City", "Active"),
    2000536: City(2000536, "Шадринск", "Шадринск,RU", 11158, "RU", "City", "Active"),
    2000537: City(
        2000537,
        "Свердловская область",
        "Свердловская область,RU",
        52,
        "RU",
        "City",
        "Active",
    ),
    2000538: City(2000538, "Асбест", "Асбест,RU", 11162, "RU", "City", "Active"),
    2000539: City(
        2000539, "Берёзовский", "Берёзовский,RU", 11162, "RU", "City", "Active"
    ),
    2000540: City(
        2000540,
        "Верхняя Пышма",
        "Верхняя Пышма,RU",
        11162,
        "RU",
        "City",
        "Active",
    ),
    2000541: City(
        2000541,
        "Верхняя Салда",
        "Верхняя Салда,RU",
        11162,
        "RU",
        "City",
        "Active",
    ),
    2000542: City(
        2000542,
        "Екатеринбург",
        "Екатеринбург,RU",
        11162,
        "RU",
        "City",
        "Active",
    ),
    2000543: City(
        2000543,
        "Каменск-Уральский",
        "Каменск-Уральский,RU",
        11162,
        "RU",
        "City",
        "Active",
    ),
    2000544: City(2000544, "Качканар", "Качканар,RU", 11162, "RU", "City", "Active"),
    2000545: City(
        2000545,
        "Краснотурьинск",
        "Краснотурьинск,RU",
        11162,
        "RU",
        "City",
        "Active",
    ),
    2000546: City(
        2000546,
        "Красноуфимск",
        "Красноуфимск,RU",
        11162,
        "RU",
        "City",
        "Active",
    ),
    2000547: City(2000547, "Кушва", "Кушва,RU", 11162, "RU", "City", "Active"),
    2000548: City(2000548, "Лесной", "Лесной,RU", 11162, "RU", "City", "Active"),
    2000549: City(2000549, "Невьянск", "Невьянск,RU", 11162, "RU", "City", "Active"),
    2000550: City(
        2000550,
        "Нижний Тагил",
        "Нижний Тагил,RU",
        11162,
        "RU",
        "City",
        "Active",
    ),
    2000551: City(
        2000551, "Нижняя Тура", "Нижняя Тура,RU", 11162, "RU", "City", "Active"
    ),
    2000552: City(
        2000552, "Новоуральск", "Новоуральск,RU", 11162, "RU", "City", "Active"
    ),
    2000553: City(
        2000553,
        "Первоуральск",
        "Первоуральск,RU",
        11162,
        "RU",
        "City",
        "Active",
    ),
    2000554: City(2000554, "Полевской", "Полевской,RU", 11162, "RU", "City", "Active"),
    2000555: City(2000555, "Ревда", "Ревда,RU", 11162, "RU", "City", "Active"),
    2000556: City(2000556, "Реж", "Реж,RU", 11162, "RU", "City", "Active"),
    2000557: City(
        2000557,
        "Североуральск",
        "Североуральск,RU",
        11162,
        "RU",
        "City",
        "Active",
    ),
    2000558: City(2000558, "Серов", "Серов,RU", 11162, "RU", "City", "Active"),
    2000559: City(
        2000559,
        "Тюменская область",
        "Тюменская область,RU",
        52,
        "RU",
        "City",
        "Active",
    ),
    2000560: City(2000560, "Ишим", "Ишим,RU", 11176, "RU", "City", "Active"),
    2000561: City(2000561, "Тобольск", "Тобольск,RU", 11176, "RU", "City", "Active"),
    2000562: City(2000562, "Тюмень", "Тюмень,RU", 11176, "RU", "City", "Active"),
    2000563: City(
        2000563, "Ялуторовск", "Ялуторовск,RU", 11176, "RU", "City", "Active"
    ),
    2000564: City(
        2000564,
        "Ханты-Мансийский автономный округ - Югра",
        "Ханты-Мансийский автономный округ - Югра,RU",
        52,
        "RU",
        "City",
        "Active",
    ),
    2000565: City(2000565, "Когалым", "Когалым,RU", 11193, "RU", "City", "Active"),
    2000566: City(2000566, "Лангепас", "Лангепас,RU", 11193, "RU", "City", "Active"),
    2000567: City(2000567, "Мегион", "Мегион,RU", 11193, "RU", "City", "Active"),
    2000568: City(
        2000568, "Нефтеюганск", "Нефтеюганск,RU", 11193, "RU", "City", "Active"
    ),
    2000569: City(
        2000569,
        "Нижневартовск",
        "Нижневартовск,RU",
        11193,
        "RU",
        "City",
        "Active",
    ),
    2000570: City(2000570, "Нягань", "Нягань,RU", 11193, "RU", "City", "Active"),
    2000571: City(2000571, "Пыть-Ях", "Пыть-Ях,RU", 11193, "RU", "City", "Active"),
    2000572: City(2000572, "Радужный", "Радужный,RU", 11193, "RU", "City", "Active"),
    2000573: City(2000573, "Сургут", "Сургут,RU", 11193, "RU", "City", "Active"),
    2000574: City(2000574, "Урай", "Урай,RU", 11193, "RU", "City", "Active"),
    2000575: City(
        2000575,
        "Ханты-Мансийск",
        "Ханты-Мансийск,RU",
        11193,
        "RU",
        "City",
        "Active",
    ),
    2000576: City(2000576, "Югорск", "Югорск,RU", 11193, "RU", "City", "Active"),
    2000577: City(
        2000577,
        "Челябинская область",
        "Челябинская область,RU",
        52,
        "RU",
        "City",
        "Active",
    ),
    2000578: City(
        2000578,
        "Верхний Уфалей",
        "Верхний Уфалей,RU",
        11225,
        "RU",
        "City",
        "Active",
    ),
    2000579: City(2000579, "Златоуст", "Златоуст,RU", 11225, "RU", "City", "Active"),
    2000580: City(2000580, "Копейск", "Копейск,RU", 11225, "RU", "City", "Active"),
    2000581: City(
        2000581,
        "Магнитогорск",
        "Магнитогорск,RU",
        11225,
        "RU",
        "City",
        "Active",
    ),
    2000582: City(2000582, "Миасс", "Миасс,RU", 11225, "RU", "City", "Active"),
    2000583: City(2000583, "Озёрск", "Озёрск,RU", 11225, "RU", "City", "Active"),
    2000584: City(
        2000584,
        "Саткинский район",
        "Саткинский район,RU",
        11225,
        "RU",
        "City",
        "Active",
    ),
    2000585: City(2000585, "Сатка", "Сатка,RU", 100020, "RU", "City", "Active"),
    2000586: City(2000586, "Снежинск", "Снежинск,RU", 11225, "RU", "City", "Active"),
    2000587: City(2000587, "Троицк", "Троицк,RU", 11225, "RU", "City", "Active"),
    2000588: City(
        2000588, "Усть-Катав", "Усть-Катав,RU", 11225, "RU", "City", "Active"
    ),
    2000589: City(2000589, "Челябинск", "Челябинск,RU", 11225, "RU", "City", "Active"),
    2000590: City(
        2000590,
        "Ямало-Ненецкий автономный округ",
        "Ямало-Ненецкий автономный округ,RU",
        52,
        "RU",
        "City",
        "Active",
    ),
    2000591: City(
        2000591, "Губкинский", "Губкинский,RU", 11232, "RU", "City", "Active"
    ),
    2000592: City(
        2000592,
        "Надымский район",
        "Надымский район,RU",
        11232,
        "RU",
        "City",
        "Active",
    ),
    2000593: City(2000593, "Надым", "Надым,RU", 100028, "RU", "City", "Active"),
    2000594: City(
        2000594,
        "Новый Уренгой",
        "Новый Уренгой,RU",
        11232,
        "RU",
        "City",
        "Active",
    ),
    2000595: City(2000595, "Ноябрьск", "Ноябрьск,RU", 11232, "RU", "City", "Active"),
    2000596: City(2000596, "Салехард", "Салехард,RU", 11232, "RU", "City", "Active"),
    2000597: City(
        2000597,
        "СНГ (исключая Россию)",
        "СНГ (исключая Россию),RU",
        0,
        "RU",
        "City",
        "Active",
    ),
    2000598: City(2000598, "Абхазия", "Абхазия,RU", 166, "RU", "City", "Active"),
    2000599: City(
        2000599, "Азербайджан", "Азербайджан,RU", 166, "RU", "City", "Active"
    ),
    2000600: City(2000600, "Армения", "Армения,RU", 166, "RU", "City", "Active"),
    2000601: City(2000601, "Беларусь", "Беларусь,RU", 166, "RU", "City", "Active"),
    2000602: City(
        2000602,
        "Брест и область",
        "Брест и область,RU",
        149,
        "RU",
        "City",
        "Active",
    ),
    2000603: City(
        2000603, "Барановичи", "Барановичи,RU", 29632, "RU", "City", "Active"
    ),
    2000604: City(2000604, "Брест", "Брест,RU", 29632, "RU", "City", "Active"),
    2000605: City(
        2000605,
        "Кобринский район",
        "Кобринский район,RU",
        29632,
        "RU",
        "City",
        "Active",
    ),
    2000606: City(2000606, "Кобрин", "Кобрин,RU", 102089, "RU", "City", "Active"),
    2000607: City(2000607, "Пинск", "Пинск,RU", 29632, "RU", "City", "Active"),
    2000608: City(
        2000608,
        "Витебск и область",
        "Витебск и область,RU",
        149,
        "RU",
        "City",
        "Active",
    ),
    2000609: City(2000609, "Витебск", "Витебск,RU", 29633, "RU", "City", "Active"),
    2000610: City(
        2000610, "Новополоцк", "Новополоцк,RU", 29633, "RU", "City", "Active"
    ),
    2000611: City(
        2000611,
        "Оршанский район",
        "Оршанский район,RU",
        29633,
        "RU",
        "City",
        "Active",
    ),
    2000612: City(2000612, "Орша", "Орша,RU", 102187, "RU", "City", "Active"),
    2000613: City(
        2000613,
        "Полоцкий район",
        "Полоцкий район,RU",
        29633,
        "RU",
        "City",
        "Active",
    ),
    2000614: City(2000614, "Полоцк", "Полоцк,RU", 102188, "RU", "City", "Active"),
    2000615: City(
        2000615,
        "Гомель и область",
        "Гомель и область,RU",
        149,
        "RU",
        "City",
        "Active",
    ),
    2000616: City(2000616, "Гомель", "Гомель,RU", 29631, "RU", "City", "Active"),
    2000617: City(
        2000617,
        "Жлобинский район",
        "Жлобинский район,RU",
        29631,
        "RU",
        "City",
        "Active",
    ),
    2000618: City(2000618, "Жлобин", "Жлобин,RU", 102103, "RU", "City", "Active"),
    2000619: City(
        2000619,
        "Калинковичский район",
        "Калинковичский район,RU",
        29631,
        "RU",
        "City",
        "Active",
    ),
    2000620: City(
        2000620,
        "Калинковичи",
        "Калинковичи,RU",
        102104,
        "RU",
        "City",
        "Active",
    ),
    2000621: City(
        2000621,
        "Мозырский район",
        "Мозырский район,RU",
        29631,
        "RU",
        "City",
        "Active",
    ),
    2000622: City(2000622, "Мозырь", "Мозырь,RU", 102108, "RU", "City", "Active"),
    2000623: City(
        2000623,
        "Речицкий район",
        "Речицкий район,RU",
        29631,
        "RU",
        "City",
        "Active",
    ),
    2000624: City(2000624, "Речица", "Речица,RU", 102112, "RU", "City", "Active"),
    2000625: City(
        2000625,
        "Рогачёвский район",
        "Рогачёвский район,RU",
        29631,
        "RU",
        "City",
        "Active",
    ),
    2000626: City(2000626, "Рогачёв", "Рогачёв,RU", 102113, "RU", "City", "Active"),
    2000627: City(
        2000627,
        "Светлогорский район",
        "Светлогорский район,RU",
        29631,
        "RU",
        "City",
        "Active",
    ),
    2000628: City(
        2000628,
        "Светлогорск",
        "Светлогорск,RU",
        102114,
        "RU",
        "City",
        "Active",
    ),
    2000629: City(
        2000629,
        "Гродно и область",
        "Гродно и область,RU",
        149,
        "RU",
        "City",
        "Active",
    ),
    2000630: City(
        2000630,
        "Волковысский район",
        "Волковысский район,RU",
        29634,
        "RU",
        "City",
        "Active",
    ),
    2000631: City(2000631, "Волковыск", "Волковыск,RU", 102118, "RU", "City", "Active"),
    2000632: City(2000632, "Гродно", "Гродно,RU", 29634, "RU", "City", "Active"),
    2000633: City(
        2000633,
        "Лидский район",
        "Лидский район,RU",
        29634,
        "RU",
        "City",
        "Active",
    ),
    2000634: City(2000634, "Лида", "Лида,RU", 102125, "RU", "City", "Active"),
    2000635: City(
        2000635,
        "Новогрудский район",
        "Новогрудский район,RU",
        29634,
        "RU",
        "City",
        "Active",
    ),
    2000636: City(
        2000636, "Новогрудок", "Новогрудок,RU", 102127, "RU", "City", "Active"
    ),
    2000637: City(
        2000637,
        "Слонимский район",
        "Слонимский район,RU",
        29634,
        "RU",
        "City",
        "Active",
    ),
    2000638: City(2000638, "Слоним", "Слоним,RU", 102131, "RU", "City", "Active"),
    2000639: City(
        2000639,
        "Сморгонский район",
        "Сморгонский район,RU",
        29634,
        "RU",
        "City",
        "Active",
    ),
    2000640: City(2000640, "Сморгонь", "Сморгонь,RU", 102132, "RU", "City", "Active"),
    2000641: City(
        2000641,
        "Минск и область",
        "Минск и область,RU",
        149,
        "RU",
        "City",
        "Active",
    ),
    2000642: City(
        2000642,
        "Борисовский район",
        "Борисовский район,RU",
        29630,
        "RU",
        "City",
        "Active",
    ),
    2000643: City(2000643, "Борисов", "Борисов,RU", 102156, "RU", "City", "Active"),
    2000644: City(2000644, "Жодино", "Жодино,RU", 29630, "RU", "City", "Active"),
    2000645: City(2000645, "Минск", "Минск,RU", 29630, "RU", "City", "Active"),
    2000646: City(
        2000646,
        "Молодечненский район",
        "Молодечненский район,RU",
        29630,
        "RU",
        "City",
        "Active",
    ),
    2000647: City(2000647, "Молодечно", "Молодечно,RU", 102165, "RU", "City", "Active"),
    2000648: City(
        2000648,
        "Слуцкий район",
        "Слуцкий район,RU",
        29630,
        "RU",
        "City",
        "Active",
    ),
    2000649: City(2000649, "Слуцк", "Слуцк,RU", 102169, "RU", "City", "Active"),
    2000650: City(
        2000650,
        "Солигорский район",
        "Солигорский район,RU",
        29630,
        "RU",
        "City",
        "Active",
    ),
    2000651: City(2000651, "Солигорск", "Солигорск,RU", 102170, "RU", "City", "Active"),
    2000652: City(
        2000652,
        "Могилёв и область",
        "Могилёв и область,RU",
        149,
        "RU",
        "City",
        "Active",
    ),
    2000653: City(2000653, "Бобруйск", "Бобруйск,RU", 29629, "RU", "City", "Active"),
    2000654: City(
        2000654,
        "Горецкий район",
        "Горецкий район,RU",
        29629,
        "RU",
        "City",
        "Active",
    ),
    2000655: City(2000655, "Горки", "Горки,RU", 102138, "RU", "City", "Active"),
    2000656: City(2000656, "Могилёв", "Могилёв,RU", 29629, "RU", "City", "Active"),
    2000657: City(
        2000657,
        "Осиповичский район",
        "Осиповичский район,RU",
        29629,
        "RU",
        "City",
        "Active",
    ),
    2000658: City(2000658, "Осиповичи", "Осиповичи,RU", 102149, "RU", "City", "Active"),
    2000659: City(2000659, "Казахстан", "Казахстан,RU", 166, "RU", "City", "Active"),
    2000660: City(
        2000660,
        "Актау и Мангистауская область",
        "Актау и Мангистауская область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000661: City(
        2000661,
        "Актобе и область",
        "Актобе и область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000662: City(
        2000662,
        "Алматы и область",
        "Алматы и область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000663: City(2000663, "Алматы", "Алматы,RU", 29406, "RU", "City", "Active"),
    2000664: City(
        2000664, "Талдыкорган", "Талдыкорган,RU", 29406, "RU", "City", "Active"
    ),
    2000665: City(
        2000665,
        "Астана и Акмолинская область",
        "Астана и Акмолинская область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000666: City(2000666, "Астана", "Астана,RU", 29403, "RU", "City", "Active"),
    2000667: City(2000667, "Кокшетау", "Кокшетау,RU", 29403, "RU", "City", "Active"),
    2000668: City(
        2000668,
        "Атырау и область",
        "Атырау и область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000669: City(
        2000669,
        "Восточно-Казахстанская область",
        "Восточно-Казахстанская область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000670: City(2000670, "Семей", "Семей,RU", 29408, "RU", "City", "Active"),
    2000671: City(
        2000671,
        "Усть-Каменогорск",
        "Усть-Каменогорск,RU",
        29408,
        "RU",
        "City",
        "Active",
    ),
    2000672: City(
        2000672,
        "Западно-Казахстанская область",
        "Западно-Казахстанская область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000673: City(
        2000673,
        "Караганда и область",
        "Караганда и область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000674: City(
        2000674,
        "Костанай и область",
        "Костанай и область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000675: City(
        2000675,
        "Кызылорда и область",
        "Кызылорда и область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000676: City(
        2000676,
        "Павлодар и область",
        "Павлодар и область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000677: City(
        2000677,
        "Северо-Казахстанская область",
        "Северо-Казахстанская область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000678: City(
        2000678,
        "Тараз и Жамбылская область",
        "Тараз и Жамбылская область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000679: City(
        2000679,
        "Южно-Казахстанская область",
        "Южно-Казахстанская область,RU",
        159,
        "RU",
        "City",
        "Active",
    ),
    2000680: City(2000680, "Киргизия", "Киргизия,RU", 166, "RU", "City", "Active"),
    2000681: City(2000681, "Молдова", "Молдова,RU", 166, "RU", "City", "Active"),
    2000682: City(
        2000682, "Таджикистан", "Таджикистан,RU", 166, "RU", "City", "Active"
    ),
    2000683: City(
        2000683, "Туркменистан", "Туркменистан,RU", 166, "RU", "City", "Active"
    ),
    2000684: City(2000684, "Узбекистан", "Узбекистан,RU", 166, "RU", "City", "Active"),
    2000685: City(2000685, "Украина", "Украина,RU", 166, "RU", "City", "Active"),
    2000686: City(
        2000686,
        "Винница и область",
        "Винница и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000687: City(2000687, "Винница", "Винница,RU", 20545, "RU", "City", "Active"),
    2000688: City(
        2000688,
        "Днепр и область",
        "Днепр и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000689: City(2000689, "Днепр", "Днепр,RU", 20537, "RU", "City", "Active"),
    2000690: City(2000690, "Каменское", "Каменское,RU", 20537, "RU", "City", "Active"),
    2000691: City(
        2000691, "Кривой Рог", "Кривой Рог,RU", 20537, "RU", "City", "Active"
    ),
    2000692: City(2000692, "Никополь", "Никополь,RU", 20537, "RU", "City", "Active"),
    2000693: City(2000693, "Павлоград", "Павлоград,RU", 20537, "RU", "City", "Active"),
    2000694: City(
        2000694,
        "Донецк и область",
        "Донецк и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000695: City(2000695, "Горловка", "Горловка,RU", 20536, "RU", "City", "Active"),
    2000696: City(2000696, "Донецк", "Донецк,RU", 20536, "RU", "City", "Active"),
    2000697: City(
        2000697, "Краматорск", "Краматорск,RU", 20536, "RU", "City", "Active"
    ),
    2000698: City(2000698, "Макеевка", "Макеевка,RU", 20536, "RU", "City", "Active"),
    2000699: City(2000699, "Мариуполь", "Мариуполь,RU", 20536, "RU", "City", "Active"),
    2000700: City(
        2000700,
        "Житомир и область",
        "Житомир и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000701: City(
        2000701,
        "Запорожье и область",
        "Запорожье и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000702: City(2000702, "Запорожье", "Запорожье,RU", 20539, "RU", "City", "Active"),
    2000703: City(
        2000703,
        "Ивано-Франковск и область",
        "Ивано-Франковск и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000704: City(
        2000704,
        "Киев и область",
        "Киев и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000705: City(
        2000705,
        "Белая Церковь",
        "Белая Церковь,RU",
        20544,
        "RU",
        "City",
        "Active",
    ),
    2000706: City(2000706, "Киев", "Киев,RU", 20544, "RU", "City", "Active"),
    2000707: City(
        2000707,
        "Кропивницкий и Кировоградская область",
        "Кропивницкий и Кировоградская область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000708: City(
        2000708,
        "Луганск и область",
        "Луганск и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000709: City(2000709, "Алчевск", "Алчевск,RU", 20540, "RU", "City", "Active"),
    2000710: City(2000710, "Луганск", "Луганск,RU", 20540, "RU", "City", "Active"),
    2000711: City(
        2000711,
        "Северодонецк",
        "Северодонецк,RU",
        20540,
        "RU",
        "City",
        "Active",
    ),
    2000712: City(
        2000712,
        "Луцк и Волынская область",
        "Луцк и Волынская область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000713: City(
        2000713,
        "Львов и область",
        "Львов и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000714: City(2000714, "Львов", "Львов,RU", 20529, "RU", "City", "Active"),
    2000715: City(
        2000715,
        "Николаев и область",
        "Николаев и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000716: City(2000716, "Николаев", "Николаев,RU", 20543, "RU", "City", "Active"),
    2000717: City(
        2000717,
        "Одесса и область",
        "Одесса и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000718: City(2000718, "Одесса", "Одесса,RU", 20541, "RU", "City", "Active"),
    2000719: City(
        2000719,
        "Полтава и область",
        "Полтава и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000720: City(2000720, "Кременчуг", "Кременчуг,RU", 20549, "RU", "City", "Active"),
    2000721: City(2000721, "Полтава", "Полтава,RU", 20549, "RU", "City", "Active"),
    2000722: City(
        2000722,
        "Ровно и область",
        "Ровно и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000723: City(
        2000723,
        "Сумы и область",
        "Сумы и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000724: City(2000724, "Сумы", "Сумы,RU", 20552, "RU", "City", "Active"),
    2000725: City(
        2000725,
        "Тернополь и область",
        "Тернополь и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000726: City(
        2000726,
        "Ужгород и Закарпатская область",
        "Ужгород и Закарпатская область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000727: City(
        2000727,
        "Харьков и область",
        "Харьков и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000728: City(2000728, "Харьков", "Харьков,RU", 20538, "RU", "City", "Active"),
    2000729: City(
        2000729,
        "Херсон и область",
        "Херсон и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000730: City(2000730, "Херсон", "Херсон,RU", 20542, "RU", "City", "Active"),
    2000731: City(
        2000731,
        "Хмельницкий и область",
        "Хмельницкий и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000732: City(
        2000732, "Хмельницкий", "Хмельницкий,RU", 20535, "RU", "City", "Active"
    ),
    2000733: City(
        2000733,
        "Черкассы и область",
        "Черкассы и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000734: City(
        2000734,
        "Чернигов и область",
        "Чернигов и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000735: City(2000735, "Нежин", "Нежин,RU", 20551, "RU", "City", "Active"),
    2000736: City(
        2000736,
        "Черновцы и область",
        "Черновцы и область,RU",
        187,
        "RU",
        "City",
        "Active",
    ),
    2000737: City(2000737, "Европа", "Европа,RU", 0, "RU", "City", "Active"),
    2000738: City(2000738, "Австрия", "Австрия,RU", 111, "RU", "City", "Active"),
    2000739: City(2000739, "Бельгия", "Бельгия,RU", 111, "RU", "City", "Active"),
    2000740: City(2000740, "Болгария", "Болгария,RU", 111, "RU", "City", "Active"),
    2000741: City(
        2000741,
        "Великобритания",
        "Великобритания,RU",
        111,
        "RU",
        "City",
        "Active",
    ),
    2000742: City(2000742, "Венгрия", "Венгрия,RU", 111, "RU", "City", "Active"),
    2000743: City(2000743, "Германия", "Германия,RU", 111, "RU", "City", "Active"),
    2000744: City(2000744, "Греция", "Греция,RU", 111, "RU", "City", "Active"),
    2000745: City(2000745, "Дания", "Дания,RU", 111, "RU", "City", "Active"),
    2000746: City(2000746, "Испания", "Испания,RU", 111, "RU", "City", "Active"),
    2000747: City(2000747, "Италия", "Италия,RU", 111, "RU", "City", "Active"),
    2000748: City(2000748, "Кипр", "Кипр,RU", 111, "RU", "City", "Active"),
    2000749: City(2000749, "Латвия", "Латвия,RU", 111, "RU", "City", "Active"),
    2000750: City(2000750, "Литва", "Литва,RU", 111, "RU", "City", "Active"),
    2000751: City(2000751, "Нидерланды", "Нидерланды,RU", 111, "RU", "City", "Active"),
    2000752: City(2000752, "Норвегия", "Норвегия,RU", 111, "RU", "City", "Active"),
    2000753: City(2000753, "Польша", "Польша,RU", 111, "RU", "City", "Active"),
    2000754: City(2000754, "Португалия", "Португалия,RU", 111, "RU", "City", "Active"),
    2000755: City(2000755, "Румыния", "Румыния,RU", 111, "RU", "City", "Active"),
    2000756: City(2000756, "Сербия", "Сербия,RU", 111, "RU", "City", "Active"),
    2000757: City(2000757, "Словакия", "Словакия,RU", 111, "RU", "City", "Active"),
    2000758: City(2000758, "Словения", "Словения,RU", 111, "RU", "City", "Active"),
    2000759: City(2000759, "Турция", "Турция,RU", 111, "RU", "City", "Active"),
    2000760: City(
        2000760,
        "Провинция Агры",
        "Провинция Агры,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000761: City(
        2000761,
        "Провинция Адана",
        "Провинция Адана,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000762: City(
        2000762,
        "Провинция Адыяман",
        "Провинция Адыяман,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000763: City(
        2000763,
        "Провинция Айдын",
        "Провинция Айдын,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000764: City(
        2000764,
        "Провинция Аксарай",
        "Провинция Аксарай,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000765: City(
        2000765,
        "Провинция Амасья",
        "Провинция Амасья,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000766: City(
        2000766,
        "Провинция Анкара",
        "Провинция Анкара,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000767: City(
        2000767,
        "Провинция Анталья",
        "Провинция Анталья,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000768: City(
        2000768,
        "Провинция Ардахан",
        "Провинция Ардахан,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000769: City(
        2000769,
        "Провинция Артвин",
        "Провинция Артвин,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000770: City(
        2000770,
        "Провинция Афьонкарахисар",
        "Провинция Афьонкарахисар,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000771: City(
        2000771,
        "Провинция Байбурт",
        "Провинция Байбурт,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000772: City(
        2000772,
        "Провинция Балыкесир",
        "Провинция Балыкесир,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000773: City(
        2000773,
        "Провинция Бартын",
        "Провинция Бартын,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000774: City(
        2000774,
        "Провинция Батман",
        "Провинция Батман,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000775: City(
        2000775,
        "Провинция Биледжик",
        "Провинция Биледжик,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000776: City(
        2000776,
        "Провинция Бингёль",
        "Провинция Бингёль,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000777: City(
        2000777,
        "Провинция Битлис",
        "Провинция Битлис,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000778: City(
        2000778,
        "Провинция Болу",
        "Провинция Болу,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000779: City(
        2000779,
        "Провинция Бурдур",
        "Провинция Бурдур,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000780: City(
        2000780,
        "Провинция Бурса",
        "Провинция Бурса,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000781: City(
        2000781,
        "Провинция Ван",
        "Провинция Ван,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000782: City(
        2000782,
        "Провинция Газиантеп",
        "Провинция Газиантеп,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000783: City(
        2000783,
        "Провинция Гиресун",
        "Провинция Гиресун,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000784: City(
        2000784,
        "Провинция Гюмюшхане",
        "Провинция Гюмюшхане,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000785: City(
        2000785,
        "Провинция Денизли",
        "Провинция Денизли,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000786: City(
        2000786,
        "Провинция Диярбакыр",
        "Провинция Диярбакыр,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000787: City(
        2000787,
        "Провинция Дюздже",
        "Провинция Дюздже,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000788: City(
        2000788,
        "Провинция Зонгулдак",
        "Провинция Зонгулдак,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000789: City(
        2000789,
        "Провинция Измир",
        "Провинция Измир,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000790: City(
        2000790,
        "Провинция Йозгат",
        "Провинция Йозгат,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000791: City(
        2000791,
        "Провинция Кайсери",
        "Провинция Кайсери,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000792: City(
        2000792,
        "Провинция Карабюк",
        "Провинция Карабюк,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000793: City(
        2000793,
        "Провинция Караман",
        "Провинция Караман,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000794: City(
        2000794,
        "Провинция Карс",
        "Провинция Карс,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000795: City(
        2000795,
        "Провинция Кастамону",
        "Провинция Кастамону,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000796: City(
        2000796,
        "Провинция Кахраманмараш",
        "Провинция Кахраманмараш,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000797: City(
        2000797,
        "Провинция Килис",
        "Провинция Килис,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000798: City(
        2000798,
        "Провинция Коджаэли",
        "Провинция Коджаэли,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000799: City(
        2000799,
        "Провинция Конья",
        "Провинция Конья,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000800: City(
        2000800,
        "Провинция Кыркларели",
        "Провинция Кыркларели,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000801: City(
        2000801,
        "Провинция Кыршехир",
        "Провинция Кыршехир,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000802: City(
        2000802,
        "Провинция Кырыккале",
        "Провинция Кырыккале,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000803: City(
        2000803,
        "Провинция Кютахья",
        "Провинция Кютахья,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000804: City(
        2000804,
        "Провинция Малатья",
        "Провинция Малатья,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000805: City(
        2000805,
        "Провинция Маниса",
        "Провинция Маниса,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000806: City(
        2000806,
        "Провинция Мардин",
        "Провинция Мардин,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000807: City(
        2000807,
        "Провинция Мерсин",
        "Провинция Мерсин,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000808: City(
        2000808,
        "Провинция Мугла",
        "Провинция Мугла,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000809: City(
        2000809,
        "Провинция Муш",
        "Провинция Муш,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000810: City(
        2000810,
        "Провинция Невшехир",
        "Провинция Невшехир,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000811: City(
        2000811,
        "Провинция Нигде",
        "Провинция Нигде,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000812: City(
        2000812,
        "Провинция Орду",
        "Провинция Орду,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000813: City(
        2000813,
        "Провинция Османие",
        "Провинция Османие,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000814: City(
        2000814,
        "Провинция Ризе",
        "Провинция Ризе,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000815: City(
        2000815,
        "Провинция Сакарья",
        "Провинция Сакарья,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000816: City(
        2000816,
        "Провинция Самсун",
        "Провинция Самсун,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000817: City(
        2000817,
        "Провинция Сивас",
        "Провинция Сивас,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000818: City(
        2000818,
        "Провинция Сиирт",
        "Провинция Сиирт,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000819: City(
        2000819,
        "Провинция Синоп",
        "Провинция Синоп,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000820: City(
        2000820,
        "Провинция Стамбул",
        "Провинция Стамбул,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000821: City(
        2000821,
        "Провинция Текирдаг",
        "Провинция Текирдаг,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000822: City(
        2000822,
        "Провинция Токат",
        "Провинция Токат,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000823: City(
        2000823,
        "Провинция Трабзон",
        "Провинция Трабзон,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000824: City(
        2000824,
        "Провинция Тунджели",
        "Провинция Тунджели,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000825: City(
        2000825,
        "Провинция Ушак",
        "Провинция Ушак,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000826: City(
        2000826,
        "Провинция Хаккяри",
        "Провинция Хаккяри,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000827: City(
        2000827,
        "Провинция Хатай",
        "Провинция Хатай,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000828: City(
        2000828,
        "Провинция Чанаккале",
        "Провинция Чанаккале,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000829: City(
        2000829,
        "Провинция Чанкыры",
        "Провинция Чанкыры,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000830: City(
        2000830,
        "Провинция Чорум",
        "Провинция Чорум,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000831: City(
        2000831,
        "Провинция Шанлыурфа",
        "Провинция Шанлыурфа,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000832: City(
        2000832,
        "Провинция Ширнак",
        "Провинция Ширнак,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000833: City(
        2000833,
        "Провинция Ыгдыр",
        "Провинция Ыгдыр,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000834: City(
        2000834,
        "Провинция Ыспарта",
        "Провинция Ыспарта,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000835: City(
        2000835,
        "Провинция Эдирне",
        "Провинция Эдирне,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000836: City(
        2000836,
        "Провинция Элязыг",
        "Провинция Элязыг,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000837: City(
        2000837,
        "Провинция Эрзинджан",
        "Провинция Эрзинджан,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000838: City(
        2000838,
        "Провинция Эрзурум",
        "Провинция Эрзурум,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000839: City(
        2000839,
        "Провинция Эскишехир",
        "Провинция Эскишехир,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000840: City(
        2000840,
        "Провинция Ялова",
        "Провинция Ялова,RU",
        983,
        "RU",
        "City",
        "Active",
    ),
    2000841: City(2000841, "Финляндия", "Финляндия,RU", 111, "RU", "City", "Active"),
    2000842: City(2000842, "Франция", "Франция,RU", 111, "RU", "City", "Active"),
    2000843: City(2000843, "Хорватия", "Хорватия,RU", 111, "RU", "City", "Active"),
    2000844: City(2000844, "Черногория", "Черногория,RU", 111, "RU", "City", "Active"),
    2000845: City(2000845, "Чехия", "Чехия,RU", 111, "RU", "City", "Active"),
    2000846: City(2000846, "Швейцария", "Швейцария,RU", 111, "RU", "City", "Active"),
    2000847: City(2000847, "Швеция", "Швеция,RU", 111, "RU", "City", "Active"),
    2000848: City(2000848, "Эстония", "Эстония,RU", 111, "RU", "City", "Active"),
    2000849: City(2000849, "Азия", "Азия,RU", 0, "RU", "City", "Active"),
    2000850: City(2000850, "Грузия", "Грузия,RU", 183, "RU", "City", "Active"),
    2000851: City(2000851, "Израиль", "Израиль,RU", 183, "RU", "City", "Active"),
    2000852: City(2000852, "Индия", "Индия,RU", 183, "RU", "City", "Active"),
    2000853: City(2000853, "Камбоджа", "Камбоджа,RU", 183, "RU", "City", "Active"),
    2000854: City(2000854, "Китай", "Китай,RU", 183, "RU", "City", "Active"),
    2000855: City(
        2000855,
        "Объединённые Арабские Эмираты",
        "Объединённые Арабские Эмираты,RU",
        183,
        "RU",
        "City",
        "Active",
    ),
    2000856: City(2000856, "Таиланд", "Таиланд,RU", 183, "RU", "City", "Active"),
    2000857: City(
        2000857, "Южная Корея", "Южная Корея,RU", 183, "RU", "City", "Active"
    ),
    2000858: City(2000858, "Япония", "Япония,RU", 183, "RU", "City", "Active"),
    2000859: City(2000859, "Африка", "Африка,RU", 0, "RU", "City", "Active"),
    2000860: City(2000860, "Египет", "Египет,RU", 241, "RU", "City", "Active"),
    2000861: City(
        2000861,
        "Северная Америка",
        "Северная Америка,RU",
        0,
        "RU",
        "City",
        "Active",
    ),
    2000862: City(2000862, "Канада", "Канада,RU", 10002, "RU", "City", "Active"),
    2000863: City(2000863, "США", "США,RU", 10002, "RU", "City", "Active"),
    2000864: City(
        2000864, "Южная Америка", "Южная Америка,RU", 0, "RU", "City", "Active"
    ),
    2000865: City(2000865, "Аргентина", "Аргентина,RU", 10003, "RU", "City", "Active"),
    2000866: City(2000866, "Бразилия", "Бразилия,RU", 10003, "RU", "City", "Active"),
    2000867: City(
        2000867,
        "Австралия и Океания",
        "Австралия и Океания,RU",
        0,
        "RU",
        "City",
        "Active",
    ),
    2000868: City(2000868, "Австралия", "Австралия,RU", 138, "RU", "City", "Active"),
    2000869: City(
        2000869,
        "Новая Зеландия",
        "Новая Зеландия,RU",
        138,
        "RU",
        "City",
        "Active",
    ),
}


class BuiltinGeoDataManager:
    """Менеджер встроенных географических данных"""

    def __init__(self) -> None:
        self._yandex_regions = YANDEX_REGIONS
        self._google_languages = GOOGLE_LANGUAGES
        self._google_domains = GOOGLE_DOMAINS
        self._cities = CITIES

    # Yandex регионы
    def get_yandex_region(self, region_id: int) -> Optional[YandexRegion]:
        """Получить регион Yandex по ID"""
        return self._yandex_regions.get(region_id)

    def find_yandex_regions(self, name: str, exact: bool = False) -> List[YandexRegion]:
        """Найти регионы Yandex по названию"""
        results = []
        name_lower = name.lower()

        for region in self._yandex_regions.values():
            if exact:
                if region.name.lower() == name_lower:
                    results.append(region)
            else:
                if name_lower in region.name.lower():
                    results.append(region)

        return results

    def get_yandex_regions_by_parent(self, parent_id: int) -> List[YandexRegion]:
        """Получить все регионы с указанным родительским ID"""
        return [
            region
            for region in self._yandex_regions.values()
            if region.parent_id == parent_id
        ]

    def get_yandex_region_hierarchy(self, region_id: int) -> List[YandexRegion]:
        """Получить иерархию региона (от корня до указанного региона)"""
        hierarchy: List[YandexRegion] = []
        current_id = region_id

        while current_id != 0:
            region = self._yandex_regions.get(current_id)
            if not region:
                break
            hierarchy.insert(0, region)
            current_id = region.parent_id

        return hierarchy

    # Google языки
    def get_google_language(self, language_code: str) -> Optional[GoogleLanguage]:
        """Получить язык Google по коду"""
        return self._google_languages.get(language_code.lower())

    def find_google_languages(
        self, name: str, exact: bool = False
    ) -> List[GoogleLanguage]:
        """Найти языки Google по названию"""
        results = []
        name_lower = name.lower()

        for language in self._google_languages.values():
            if exact:
                if language.name.lower() == name_lower:
                    results.append(language)
            else:
                if name_lower in language.name.lower():
                    results.append(language)

        return results

    def get_all_google_languages(self) -> List[GoogleLanguage]:
        """Получить все языки Google"""
        return list(self._google_languages.values())

    # Google домены
    def get_google_domain(self, domain_code: str) -> Optional[GoogleDomain]:
        """Получить домен Google по коду"""
        return self._google_domains.get(domain_code.lower())

    def find_google_domains(self, name: str, exact: bool = False) -> List[GoogleDomain]:
        """Найти домены Google по названию"""
        results = []
        name_lower = name.lower()

        for domain in self._google_domains.values():
            if exact:
                if domain.name.lower() == name_lower:
                    results.append(domain)
            else:
                if name_lower in domain.name.lower():
                    results.append(domain)

        return results

    def get_all_google_domains(self) -> List[GoogleDomain]:
        """Получить все домены Google"""
        return list(self._google_domains.values())

    # Города
    def get_city(self, city_id: int) -> Optional[City]:
        """Получить город по ID"""
        return self._cities.get(city_id)

    def find_cities(
        self,
        name: str,
        country_code: Optional[str] = None,
        exact: bool = False,
    ) -> List[City]:
        """Найти города по названию"""
        results: List[City] = []
        name_lower = name.lower()

        for city in self._cities.values():
            if city.status != "Active":
                continue

            if country_code and city.country_code != country_code:
                continue

            if exact:
                if city.name.lower() == name_lower:
                    results.append(city)
            else:
                if name_lower in city.name.lower():
                    results.append(city)

        return results

    def get_cities_by_country(self, country_code: str) -> List[City]:
        """Получить все города страны"""
        return [
            city
            for city in self._cities.values()
            if city.country_code == country_code and city.status == "Active"
        ]

    # Универсальные методы
    def search_place(self, name: str, search_type: str = "all") -> Dict[str, List]:
        """Универсальный поиск места"""
        results: Dict[str, List] = {
            "yandex_regions": [],
            "google_countries": [],
            "cities": [],
        }

        if search_type in ["all", "yandex"]:
            results["yandex_regions"] = self.find_yandex_regions(name)

        if search_type in ["all", "cities"]:
            results["cities"] = self.find_cities(name)

        return results

    def get_region_for_yandex_search(self, place_name: str) -> Optional[int]:
        """Получить ID региона Yandex для поиска по названию места"""
        # Сначала ищем среди городов
        cities = self.find_cities(place_name, exact=True)
        if cities:
            # Пытаемся найти соответствующий регион Yandex
            for city in cities:
                regions = self.find_yandex_regions(city.name, exact=True)
                if regions:
                    return regions[0].id

        # Если не нашли среди городов, ищем среди регионов
        regions = self.find_yandex_regions(place_name, exact=True)
        if regions:
            return regions[0].id

        # Если точного совпадения нет, ищем частичное
        regions = self.find_yandex_regions(place_name, exact=False)
        if regions:
            return regions[0].id

        return None

    def get_country_code_for_google_search(self, place_name: str) -> Optional[int]:
        """Получить код страны Google для поиска по названию места"""
        # Маппинг строковых кодов стран на числовые коды Google API
        country_code_mapping = {
            "RU": 2643,  # Россия
            "US": 2840,  # США
            "DE": 2276,  # Германия
            "GB": 2826,  # Великобритания
            "FR": 2250,  # Франция
            "IT": 2380,  # Италия
            "ES": 2724,  # Испания
            "CA": 2124,  # Канада
            "AU": 2036,  # Австралия
            "JP": 2392,  # Япония
            "CN": 2156,  # Китай
            "IN": 2356,  # Индия
            "BR": 2076,  # Бразилия
            "UA": 2804,  # Украина
            "BY": 2112,  # Беларусь
            "KZ": 2398,  # Казахстан
            "UZ": 2860,  # Узбекистан
            "KG": 2417,  # Киргизия
            "TJ": 2762,  # Таджикистан
            "TM": 2795,  # Туркменистан
            "AZ": 2031,  # Азербайджан
            "AM": 2051,  # Армения
            "GE": 2268,  # Грузия
            "MD": 2498,  # Молдова
        }

        # Сначала ищем среди городов
        cities = self.find_cities(place_name, exact=True)
        if cities:
            country_code = cities[0].country_code
            return country_code_mapping.get(country_code)

        return None

    # Статистика
    def get_stats(self) -> Dict[str, int]:
        """Получить статистику встроенных данных"""
        return {
            "yandex_regions": len(self._yandex_regions),
            "google_languages": len(self._google_languages),
            "google_domains": len(self._google_domains),
            "cities": len(self._cities),
        }


# Глобальный экземпляр менеджера
builtin_geo_manager = BuiltinGeoDataManager()


# Удобные функции для быстрого доступа
def get_yandex_region(region_id: int) -> Optional[YandexRegion]:
    """Получить регион Yandex по ID"""
    return builtin_geo_manager.get_yandex_region(region_id)


def find_yandex_regions(name: str, exact: bool = False) -> List[YandexRegion]:
    """Найти регионы Yandex по названию"""
    return builtin_geo_manager.find_yandex_regions(name, exact)


def get_yandex_regions_by_parent(parent_id: int) -> List[YandexRegion]:
    """Получить все регионы с указанным родительским ID"""
    return builtin_geo_manager.get_yandex_regions_by_parent(parent_id)


def get_yandex_region_hierarchy(region_id: int) -> List[YandexRegion]:
    """Получить иерархию региона"""
    return builtin_geo_manager.get_yandex_region_hierarchy(region_id)


def get_google_language(language_code: str) -> Optional[GoogleLanguage]:
    """Получить язык Google по коду"""
    return builtin_geo_manager.get_google_language(language_code)


def find_google_languages(name: str, exact: bool = False) -> List[GoogleLanguage]:
    """Найти языки Google по названию"""
    return builtin_geo_manager.find_google_languages(name, exact)


def get_all_google_languages() -> List[GoogleLanguage]:
    """Получить все языки Google"""
    return builtin_geo_manager.get_all_google_languages()


def get_google_domain(domain_code: str) -> Optional[GoogleDomain]:
    """Получить домен Google по коду"""
    return builtin_geo_manager.get_google_domain(domain_code)


def find_google_domains(name: str, exact: bool = False) -> List[GoogleDomain]:
    """Найти домены Google по названию"""
    return builtin_geo_manager.find_google_domains(name, exact)


def get_all_google_domains() -> List[GoogleDomain]:
    """Получить все домены Google"""
    return builtin_geo_manager.get_all_google_domains()


def get_city(city_id: int) -> Optional[City]:
    """Получить город по ID"""
    return builtin_geo_manager.get_city(city_id)


def find_cities(
    name: str, country_code: Optional[str] = None, exact: bool = False
) -> List[City]:
    """Найти города по названию"""
    return builtin_geo_manager.find_cities(name, country_code, exact)


def get_cities_by_country(country_code: str) -> List[City]:
    """Получить все города страны"""
    return builtin_geo_manager.get_cities_by_country(country_code)


def search_place(name: str, search_type: str = "all") -> Dict[str, List]:
    """Универсальный поиск места"""
    return builtin_geo_manager.search_place(name, search_type)


def get_region_for_yandex_search(place_name: str) -> Optional[int]:
    """Получить ID региона Yandex для поиска"""
    return builtin_geo_manager.get_region_for_yandex_search(place_name)


def get_country_code_for_google_search(place_name: str) -> Optional[int]:
    """Получить код страны Google для поиска"""
    return builtin_geo_manager.get_country_code_for_google_search(place_name)


def get_geo_stats() -> Dict[str, int]:
    """Получить статистику встроенных данных"""
    return builtin_geo_manager.get_stats()
