"use strict";
// import { expect, haveResource, haveResourceLike, SynthUtils } from '@aws-cdk/assert';
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const s3 = require("../lib");
class BucketVersioningChecker {
    visit(node) {
        if (node instanceof s3.CfnBucket) {
            if (!node.versioningConfiguration ||
                (!cdk.Tokenization.isResolvable(node.versioningConfiguration) && node.versioningConfiguration.status !== 'Enabled')) {
                node.node.addError('Bucket versioning is not enabled');
            }
        }
    }
}
module.exports = {
    'bucket must have versioning: failure'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        new s3.Bucket(stack, 'MyBucket');
        // WHEN
        cdk.Aspects.of(stack).add(new BucketVersioningChecker());
        // THEN
        const assembly = assert_1.SynthUtils.synthesize(stack);
        const errorMessage = assembly.messages.find(m => m.entry.data === 'Bucket versioning is not enabled');
        test.ok(errorMessage, 'Error message not reported');
        test.done();
    },
    'bucket must have versioning: success'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        new s3.Bucket(stack, 'MyBucket', {
            versioned: true,
        });
        // WHEN
        cdk.Aspects.of(stack).add(new BucketVersioningChecker());
        // THEN
        const assembly = assert_1.SynthUtils.synthesize(stack);
        test.deepEqual(assembly.messages, []);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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