# Contributing to HICA

Thank you for your interest in contributing to HICA! We welcome contributions from the community to make this project better for everyone.

## How to Contribute

### 1. Reporting Issues
- If you find a bug or have a feature request, please [open an issue](https://github.com/sandipan1/hica/issues).
- Please provide as much detail as possible, including steps to reproduce, expected behavior, and screenshots or logs if relevant.

### 2. Submitting Pull Requests
- Fork the repository and create your branch from `main`.
- If you've fixed a bug or added a feature, open a pull request (PR) with a clear description of your changes.
- Reference any related issues in your PR description (e.g., `Closes #123`).
- Ensure your code passes all tests and lints before submitting.
- Add or update documentation as needed.

### 3. Code Style
- Follow [PEP8](https://www.python.org/dev/peps/pep-0008/) for Python code.
- Use type annotations where possible.
- Write clear, concise commit messages (see [Conventional Commits](https://www.conventionalcommits.org/)).
- Add docstrings to all public classes and functions.

### 4. Tests
- Add tests for new features and bug fixes.
- Run the test suite with `pytest` before submitting your PR.
- Ensure your changes do not break existing tests.

### 5. Community Standards
- Be respectful and inclusive in all interactions.
- Follow the [Contributor Covenant Code of Conduct](https://www.contributor-covenant.org/version/2/1/code_of_conduct/).
- If you have questions, ask in the Discussions or open an issue.

## Getting Started

1. Fork the repo and clone it locally.
2. Install dependencies:
   ```sh
   pip install -e .[dev]
   ```
3. Run tests:
   ```sh
   pytest
   ```
4. Make your changes and open a pull request!

## License

By contributing, you agree that your contributions will be licensed under the [Apache License 2.0](LICENSE).

---

Thank you for helping make HICA better! 

