# Documentation 🔎

```{rubric} pyTCR: A physics-based model developed in python to estimate rainfall induced by tropical cyclones🌀
```

**Main Features:**

- Simulate convective tropical cyclone rainfall by correlating the precipitation rate 🌨️ with the total upward wind velocity 🌬️ within the tropical cyclone vortex.
- Generate detailed spatial-temporal tropical cyclone rainfall patterns that align with hurricane tracks.
- Integrate with outputs from tropical cyclone downscaling models driven by large-scale environmental conditions obtained from General Circulation Models (GCMs) 🌎.

This documentation explains how to install and use `pyTCR`.

---

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`gear;1.5em;sd-mr-1` Installation
:class-body: bg-dark-orange
:link: installation
:link-type: ref

Install *pyTCR* using your favorite package manager.
+++
[Learn more »](./installation.md)
:::

:::{grid-item-card} {octicon}`code-square;1.5em;sd-mr-1` Background
:class-body: bg-dark-green
:link: math
:link-type: ref

Read about the fundamentals of *pyTCR*.
+++
[Learn more »](math.md)
:::

:::{grid-item-card} {octicon}`book;1.5em;sd-mr-1` Tutorials
:class-body: bg-dark-gray
:link: examples/examples
:link-type: doc

Explore jupyter notebooks designed for training *pyTCR*.
+++
[Learn more »](./examples/examples.md)
:::

::::
