import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzureAdlsGen2MountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#client_id AzureAdlsGen2Mount#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#client_secret_key AzureAdlsGen2Mount#client_secret_key}
    */
    readonly clientSecretKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#client_secret_scope AzureAdlsGen2Mount#client_secret_scope}
    */
    readonly clientSecretScope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#cluster_id AzureAdlsGen2Mount#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#container_name AzureAdlsGen2Mount#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#directory AzureAdlsGen2Mount#directory}
    */
    readonly directory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#id AzureAdlsGen2Mount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#initialize_file_system AzureAdlsGen2Mount#initialize_file_system}
    */
    readonly initializeFileSystem: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#mount_name AzureAdlsGen2Mount#mount_name}
    */
    readonly mountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#storage_account_name AzureAdlsGen2Mount#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount#tenant_id AzureAdlsGen2Mount#tenant_id}
    */
    readonly tenantId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount databricks_azure_adls_gen2_mount}
*/
export declare class AzureAdlsGen2Mount extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_azure_adls_gen2_mount";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/azure_adls_gen2_mount databricks_azure_adls_gen2_mount} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzureAdlsGen2MountConfig
    */
    constructor(scope: Construct, id: string, config: AzureAdlsGen2MountConfig);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretKey?;
    get clientSecretKey(): string;
    set clientSecretKey(value: string);
    get clientSecretKeyInput(): string | undefined;
    private _clientSecretScope?;
    get clientSecretScope(): string;
    set clientSecretScope(value: string);
    get clientSecretScopeInput(): string | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initializeFileSystem?;
    get initializeFileSystem(): boolean | cdktf.IResolvable;
    set initializeFileSystem(value: boolean | cdktf.IResolvable);
    get initializeFileSystemInput(): boolean | cdktf.IResolvable | undefined;
    private _mountName?;
    get mountName(): string;
    set mountName(value: string);
    get mountNameInput(): string | undefined;
    get source(): string;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
