import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksAwsAssumeRolePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/aws_assume_role_policy#databricks_account_id DataDatabricksAwsAssumeRolePolicy#databricks_account_id}
    */
    readonly databricksAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/aws_assume_role_policy#external_id DataDatabricksAwsAssumeRolePolicy#external_id}
    */
    readonly externalId: string;
    /**
    * Grant AssumeRole to Databricks SaasUsageDeliveryRole instead of root account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/aws_assume_role_policy#for_log_delivery DataDatabricksAwsAssumeRolePolicy#for_log_delivery}
    */
    readonly forLogDelivery?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/aws_assume_role_policy#id DataDatabricksAwsAssumeRolePolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/aws_assume_role_policy databricks_aws_assume_role_policy}
*/
export declare class DataDatabricksAwsAssumeRolePolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_aws_assume_role_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/aws_assume_role_policy databricks_aws_assume_role_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksAwsAssumeRolePolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksAwsAssumeRolePolicyConfig);
    private _databricksAccountId?;
    get databricksAccountId(): string;
    set databricksAccountId(value: string);
    resetDatabricksAccountId(): void;
    get databricksAccountIdInput(): string | undefined;
    private _externalId?;
    get externalId(): string;
    set externalId(value: string);
    get externalIdInput(): string | undefined;
    private _forLogDelivery?;
    get forLogDelivery(): boolean | cdktf.IResolvable;
    set forLogDelivery(value: boolean | cdktf.IResolvable);
    resetForLogDelivery(): void;
    get forLogDeliveryInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get json(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
