import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#cluster_id DataDatabricksCluster#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#id DataDatabricksCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * cluster_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#cluster_info DataDatabricksCluster#cluster_info}
    */
    readonly clusterInfo?: DataDatabricksClusterClusterInfo;
}
export interface DataDatabricksClusterClusterInfoAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#max_workers DataDatabricksCluster#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#min_workers DataDatabricksCluster#min_workers}
    */
    readonly minWorkers?: number;
}
export declare function dataDatabricksClusterClusterInfoAutoscaleToTerraform(struct?: DataDatabricksClusterClusterInfoAutoscaleOutputReference | DataDatabricksClusterClusterInfoAutoscale): any;
export declare class DataDatabricksClusterClusterInfoAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoAutoscale | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoAutoscale | undefined);
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _minWorkers?;
    get minWorkers(): number;
    set minWorkers(value: number);
    resetMinWorkers(): void;
    get minWorkersInput(): number | undefined;
}
export interface DataDatabricksClusterClusterInfoAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#availability DataDatabricksCluster#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#ebs_volume_count DataDatabricksCluster#ebs_volume_count}
    */
    readonly ebsVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#ebs_volume_size DataDatabricksCluster#ebs_volume_size}
    */
    readonly ebsVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#ebs_volume_type DataDatabricksCluster#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#first_on_demand DataDatabricksCluster#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#instance_profile_arn DataDatabricksCluster#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#spot_bid_price_percent DataDatabricksCluster#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#zone_id DataDatabricksCluster#zone_id}
    */
    readonly zoneId?: string;
}
export declare function dataDatabricksClusterClusterInfoAwsAttributesToTerraform(struct?: DataDatabricksClusterClusterInfoAwsAttributesOutputReference | DataDatabricksClusterClusterInfoAwsAttributes): any;
export declare class DataDatabricksClusterClusterInfoAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoAwsAttributes | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _ebsVolumeCount?;
    get ebsVolumeCount(): number;
    set ebsVolumeCount(value: number);
    resetEbsVolumeCount(): void;
    get ebsVolumeCountInput(): number | undefined;
    private _ebsVolumeSize?;
    get ebsVolumeSize(): number;
    set ebsVolumeSize(value: number);
    resetEbsVolumeSize(): void;
    get ebsVolumeSizeInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface DataDatabricksClusterClusterInfoAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#availability DataDatabricksCluster#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#first_on_demand DataDatabricksCluster#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#spot_bid_max_price DataDatabricksCluster#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function dataDatabricksClusterClusterInfoAzureAttributesToTerraform(struct?: DataDatabricksClusterClusterInfoAzureAttributesOutputReference | DataDatabricksClusterClusterInfoAzureAttributes): any;
export declare class DataDatabricksClusterClusterInfoAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoAzureAttributes | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface DataDatabricksClusterClusterInfoClusterLogConfDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#destination DataDatabricksCluster#destination}
    */
    readonly destination: string;
}
export declare function dataDatabricksClusterClusterInfoClusterLogConfDbfsToTerraform(struct?: DataDatabricksClusterClusterInfoClusterLogConfDbfsOutputReference | DataDatabricksClusterClusterInfoClusterLogConfDbfs): any;
export declare class DataDatabricksClusterClusterInfoClusterLogConfDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoClusterLogConfDbfs | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoClusterLogConfDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface DataDatabricksClusterClusterInfoClusterLogConfS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#canned_acl DataDatabricksCluster#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#destination DataDatabricksCluster#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#enable_encryption DataDatabricksCluster#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#encryption_type DataDatabricksCluster#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#endpoint DataDatabricksCluster#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#kms_key DataDatabricksCluster#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#region DataDatabricksCluster#region}
    */
    readonly region?: string;
}
export declare function dataDatabricksClusterClusterInfoClusterLogConfS3ToTerraform(struct?: DataDatabricksClusterClusterInfoClusterLogConfS3OutputReference | DataDatabricksClusterClusterInfoClusterLogConfS3): any;
export declare class DataDatabricksClusterClusterInfoClusterLogConfS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoClusterLogConfS3 | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoClusterLogConfS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface DataDatabricksClusterClusterInfoClusterLogConf {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#dbfs DataDatabricksCluster#dbfs}
    */
    readonly dbfs?: DataDatabricksClusterClusterInfoClusterLogConfDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#s3 DataDatabricksCluster#s3}
    */
    readonly s3?: DataDatabricksClusterClusterInfoClusterLogConfS3;
}
export declare function dataDatabricksClusterClusterInfoClusterLogConfToTerraform(struct?: DataDatabricksClusterClusterInfoClusterLogConfOutputReference | DataDatabricksClusterClusterInfoClusterLogConf): any;
export declare class DataDatabricksClusterClusterInfoClusterLogConfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoClusterLogConf | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoClusterLogConf | undefined);
    private _dbfs;
    get dbfs(): DataDatabricksClusterClusterInfoClusterLogConfDbfsOutputReference;
    putDbfs(value: DataDatabricksClusterClusterInfoClusterLogConfDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): DataDatabricksClusterClusterInfoClusterLogConfDbfs | undefined;
    private _s3;
    get s3(): DataDatabricksClusterClusterInfoClusterLogConfS3OutputReference;
    putS3(value: DataDatabricksClusterClusterInfoClusterLogConfS3): void;
    resetS3(): void;
    get s3Input(): DataDatabricksClusterClusterInfoClusterLogConfS3 | undefined;
}
export interface DataDatabricksClusterClusterInfoClusterLogStatus {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#last_attempted DataDatabricksCluster#last_attempted}
    */
    readonly lastAttempted?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#last_exception DataDatabricksCluster#last_exception}
    */
    readonly lastException?: string;
}
export declare function dataDatabricksClusterClusterInfoClusterLogStatusToTerraform(struct?: DataDatabricksClusterClusterInfoClusterLogStatusOutputReference | DataDatabricksClusterClusterInfoClusterLogStatus): any;
export declare class DataDatabricksClusterClusterInfoClusterLogStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoClusterLogStatus | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoClusterLogStatus | undefined);
    private _lastAttempted?;
    get lastAttempted(): number;
    set lastAttempted(value: number);
    resetLastAttempted(): void;
    get lastAttemptedInput(): number | undefined;
    private _lastException?;
    get lastException(): string;
    set lastException(value: string);
    resetLastException(): void;
    get lastExceptionInput(): string | undefined;
}
export interface DataDatabricksClusterClusterInfoDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#password DataDatabricksCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#username DataDatabricksCluster#username}
    */
    readonly username: string;
}
export declare function dataDatabricksClusterClusterInfoDockerImageBasicAuthToTerraform(struct?: DataDatabricksClusterClusterInfoDockerImageBasicAuthOutputReference | DataDatabricksClusterClusterInfoDockerImageBasicAuth): any;
export declare class DataDatabricksClusterClusterInfoDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoDockerImageBasicAuth | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DataDatabricksClusterClusterInfoDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#url DataDatabricksCluster#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#basic_auth DataDatabricksCluster#basic_auth}
    */
    readonly basicAuth?: DataDatabricksClusterClusterInfoDockerImageBasicAuth;
}
export declare function dataDatabricksClusterClusterInfoDockerImageToTerraform(struct?: DataDatabricksClusterClusterInfoDockerImageOutputReference | DataDatabricksClusterClusterInfoDockerImage): any;
export declare class DataDatabricksClusterClusterInfoDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoDockerImage | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoDockerImage | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): DataDatabricksClusterClusterInfoDockerImageBasicAuthOutputReference;
    putBasicAuth(value: DataDatabricksClusterClusterInfoDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): DataDatabricksClusterClusterInfoDockerImageBasicAuth | undefined;
}
export interface DataDatabricksClusterClusterInfoDriverNodeAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#is_spot DataDatabricksCluster#is_spot}
    */
    readonly isSpot?: boolean | cdktf.IResolvable;
}
export declare function dataDatabricksClusterClusterInfoDriverNodeAwsAttributesToTerraform(struct?: DataDatabricksClusterClusterInfoDriverNodeAwsAttributesOutputReference | DataDatabricksClusterClusterInfoDriverNodeAwsAttributes): any;
export declare class DataDatabricksClusterClusterInfoDriverNodeAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoDriverNodeAwsAttributes | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoDriverNodeAwsAttributes | undefined);
    private _isSpot?;
    get isSpot(): boolean | cdktf.IResolvable;
    set isSpot(value: boolean | cdktf.IResolvable);
    resetIsSpot(): void;
    get isSpotInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataDatabricksClusterClusterInfoDriver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#host_private_ip DataDatabricksCluster#host_private_ip}
    */
    readonly hostPrivateIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#instance_id DataDatabricksCluster#instance_id}
    */
    readonly instanceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#node_id DataDatabricksCluster#node_id}
    */
    readonly nodeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#private_ip DataDatabricksCluster#private_ip}
    */
    readonly privateIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#public_dns DataDatabricksCluster#public_dns}
    */
    readonly publicDns?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#start_timestamp DataDatabricksCluster#start_timestamp}
    */
    readonly startTimestamp?: number;
    /**
    * node_aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#node_aws_attributes DataDatabricksCluster#node_aws_attributes}
    */
    readonly nodeAwsAttributes?: DataDatabricksClusterClusterInfoDriverNodeAwsAttributes;
}
export declare function dataDatabricksClusterClusterInfoDriverToTerraform(struct?: DataDatabricksClusterClusterInfoDriverOutputReference | DataDatabricksClusterClusterInfoDriver): any;
export declare class DataDatabricksClusterClusterInfoDriverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoDriver | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoDriver | undefined);
    private _hostPrivateIp?;
    get hostPrivateIp(): string;
    set hostPrivateIp(value: string);
    resetHostPrivateIp(): void;
    get hostPrivateIpInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    private _nodeId?;
    get nodeId(): string;
    set nodeId(value: string);
    resetNodeId(): void;
    get nodeIdInput(): string | undefined;
    private _privateIp?;
    get privateIp(): string;
    set privateIp(value: string);
    resetPrivateIp(): void;
    get privateIpInput(): string | undefined;
    private _publicDns?;
    get publicDns(): string;
    set publicDns(value: string);
    resetPublicDns(): void;
    get publicDnsInput(): string | undefined;
    private _startTimestamp?;
    get startTimestamp(): number;
    set startTimestamp(value: number);
    resetStartTimestamp(): void;
    get startTimestampInput(): number | undefined;
    private _nodeAwsAttributes;
    get nodeAwsAttributes(): DataDatabricksClusterClusterInfoDriverNodeAwsAttributesOutputReference;
    putNodeAwsAttributes(value: DataDatabricksClusterClusterInfoDriverNodeAwsAttributes): void;
    resetNodeAwsAttributes(): void;
    get nodeAwsAttributesInput(): DataDatabricksClusterClusterInfoDriverNodeAwsAttributes | undefined;
}
export interface DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#is_spot DataDatabricksCluster#is_spot}
    */
    readonly isSpot?: boolean | cdktf.IResolvable;
}
export declare function dataDatabricksClusterClusterInfoExecutorsNodeAwsAttributesToTerraform(struct?: DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributesOutputReference | DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributes): any;
export declare class DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributes | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributes | undefined);
    private _isSpot?;
    get isSpot(): boolean | cdktf.IResolvable;
    set isSpot(value: boolean | cdktf.IResolvable);
    resetIsSpot(): void;
    get isSpotInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataDatabricksClusterClusterInfoExecutors {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#host_private_ip DataDatabricksCluster#host_private_ip}
    */
    readonly hostPrivateIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#instance_id DataDatabricksCluster#instance_id}
    */
    readonly instanceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#node_id DataDatabricksCluster#node_id}
    */
    readonly nodeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#private_ip DataDatabricksCluster#private_ip}
    */
    readonly privateIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#public_dns DataDatabricksCluster#public_dns}
    */
    readonly publicDns?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#start_timestamp DataDatabricksCluster#start_timestamp}
    */
    readonly startTimestamp?: number;
    /**
    * node_aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#node_aws_attributes DataDatabricksCluster#node_aws_attributes}
    */
    readonly nodeAwsAttributes?: DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributes;
}
export declare function dataDatabricksClusterClusterInfoExecutorsToTerraform(struct?: DataDatabricksClusterClusterInfoExecutors | cdktf.IResolvable): any;
export declare class DataDatabricksClusterClusterInfoExecutorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksClusterClusterInfoExecutors | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoExecutors | cdktf.IResolvable | undefined);
    private _hostPrivateIp?;
    get hostPrivateIp(): string;
    set hostPrivateIp(value: string);
    resetHostPrivateIp(): void;
    get hostPrivateIpInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    private _nodeId?;
    get nodeId(): string;
    set nodeId(value: string);
    resetNodeId(): void;
    get nodeIdInput(): string | undefined;
    private _privateIp?;
    get privateIp(): string;
    set privateIp(value: string);
    resetPrivateIp(): void;
    get privateIpInput(): string | undefined;
    private _publicDns?;
    get publicDns(): string;
    set publicDns(value: string);
    resetPublicDns(): void;
    get publicDnsInput(): string | undefined;
    private _startTimestamp?;
    get startTimestamp(): number;
    set startTimestamp(value: number);
    resetStartTimestamp(): void;
    get startTimestampInput(): number | undefined;
    private _nodeAwsAttributes;
    get nodeAwsAttributes(): DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributesOutputReference;
    putNodeAwsAttributes(value: DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributes): void;
    resetNodeAwsAttributes(): void;
    get nodeAwsAttributesInput(): DataDatabricksClusterClusterInfoExecutorsNodeAwsAttributes | undefined;
}
export declare class DataDatabricksClusterClusterInfoExecutorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksClusterClusterInfoExecutors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksClusterClusterInfoExecutorsOutputReference;
}
export interface DataDatabricksClusterClusterInfoGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#availability DataDatabricksCluster#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#boot_disk_size DataDatabricksCluster#boot_disk_size}
    */
    readonly bootDiskSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#google_service_account DataDatabricksCluster#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#use_preemptible_executors DataDatabricksCluster#use_preemptible_executors}
    */
    readonly usePreemptibleExecutors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#zone_id DataDatabricksCluster#zone_id}
    */
    readonly zoneId?: string;
}
export declare function dataDatabricksClusterClusterInfoGcpAttributesToTerraform(struct?: DataDatabricksClusterClusterInfoGcpAttributesOutputReference | DataDatabricksClusterClusterInfoGcpAttributes): any;
export declare class DataDatabricksClusterClusterInfoGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoGcpAttributes | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoGcpAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _bootDiskSize?;
    get bootDiskSize(): number;
    set bootDiskSize(value: number);
    resetBootDiskSize(): void;
    get bootDiskSizeInput(): number | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _usePreemptibleExecutors?;
    get usePreemptibleExecutors(): boolean | cdktf.IResolvable;
    set usePreemptibleExecutors(value: boolean | cdktf.IResolvable);
    resetUsePreemptibleExecutors(): void;
    get usePreemptibleExecutorsInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface DataDatabricksClusterClusterInfoInitScriptsDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#destination DataDatabricksCluster#destination}
    */
    readonly destination: string;
}
export declare function dataDatabricksClusterClusterInfoInitScriptsDbfsToTerraform(struct?: DataDatabricksClusterClusterInfoInitScriptsDbfsOutputReference | DataDatabricksClusterClusterInfoInitScriptsDbfs): any;
export declare class DataDatabricksClusterClusterInfoInitScriptsDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoInitScriptsDbfs | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoInitScriptsDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface DataDatabricksClusterClusterInfoInitScriptsS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#canned_acl DataDatabricksCluster#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#destination DataDatabricksCluster#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#enable_encryption DataDatabricksCluster#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#encryption_type DataDatabricksCluster#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#endpoint DataDatabricksCluster#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#kms_key DataDatabricksCluster#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#region DataDatabricksCluster#region}
    */
    readonly region?: string;
}
export declare function dataDatabricksClusterClusterInfoInitScriptsS3ToTerraform(struct?: DataDatabricksClusterClusterInfoInitScriptsS3OutputReference | DataDatabricksClusterClusterInfoInitScriptsS3): any;
export declare class DataDatabricksClusterClusterInfoInitScriptsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoInitScriptsS3 | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoInitScriptsS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface DataDatabricksClusterClusterInfoInitScripts {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#dbfs DataDatabricksCluster#dbfs}
    */
    readonly dbfs?: DataDatabricksClusterClusterInfoInitScriptsDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#s3 DataDatabricksCluster#s3}
    */
    readonly s3?: DataDatabricksClusterClusterInfoInitScriptsS3;
}
export declare function dataDatabricksClusterClusterInfoInitScriptsToTerraform(struct?: DataDatabricksClusterClusterInfoInitScripts | cdktf.IResolvable): any;
export declare class DataDatabricksClusterClusterInfoInitScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksClusterClusterInfoInitScripts | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoInitScripts | cdktf.IResolvable | undefined);
    private _dbfs;
    get dbfs(): DataDatabricksClusterClusterInfoInitScriptsDbfsOutputReference;
    putDbfs(value: DataDatabricksClusterClusterInfoInitScriptsDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): DataDatabricksClusterClusterInfoInitScriptsDbfs | undefined;
    private _s3;
    get s3(): DataDatabricksClusterClusterInfoInitScriptsS3OutputReference;
    putS3(value: DataDatabricksClusterClusterInfoInitScriptsS3): void;
    resetS3(): void;
    get s3Input(): DataDatabricksClusterClusterInfoInitScriptsS3 | undefined;
}
export declare class DataDatabricksClusterClusterInfoInitScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksClusterClusterInfoInitScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksClusterClusterInfoInitScriptsOutputReference;
}
export interface DataDatabricksClusterClusterInfoTerminationReason {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#code DataDatabricksCluster#code}
    */
    readonly code?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#parameters DataDatabricksCluster#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#type DataDatabricksCluster#type}
    */
    readonly type?: string;
}
export declare function dataDatabricksClusterClusterInfoTerminationReasonToTerraform(struct?: DataDatabricksClusterClusterInfoTerminationReasonOutputReference | DataDatabricksClusterClusterInfoTerminationReason): any;
export declare class DataDatabricksClusterClusterInfoTerminationReasonOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfoTerminationReason | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfoTerminationReason | undefined);
    private _code?;
    get code(): string;
    set code(value: string);
    resetCode(): void;
    get codeInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface DataDatabricksClusterClusterInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#autotermination_minutes DataDatabricksCluster#autotermination_minutes}
    */
    readonly autoterminationMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#cluster_cores DataDatabricksCluster#cluster_cores}
    */
    readonly clusterCores?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#cluster_id DataDatabricksCluster#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#cluster_memory_mb DataDatabricksCluster#cluster_memory_mb}
    */
    readonly clusterMemoryMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#cluster_name DataDatabricksCluster#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#cluster_source DataDatabricksCluster#cluster_source}
    */
    readonly clusterSource?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#creator_user_name DataDatabricksCluster#creator_user_name}
    */
    readonly creatorUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#custom_tags DataDatabricksCluster#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#data_security_mode DataDatabricksCluster#data_security_mode}
    */
    readonly dataSecurityMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#default_tags DataDatabricksCluster#default_tags}
    */
    readonly defaultTags: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#driver_instance_pool_id DataDatabricksCluster#driver_instance_pool_id}
    */
    readonly driverInstancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#driver_node_type_id DataDatabricksCluster#driver_node_type_id}
    */
    readonly driverNodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#enable_elastic_disk DataDatabricksCluster#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#enable_local_disk_encryption DataDatabricksCluster#enable_local_disk_encryption}
    */
    readonly enableLocalDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#instance_pool_id DataDatabricksCluster#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#jdbc_port DataDatabricksCluster#jdbc_port}
    */
    readonly jdbcPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#last_activity_time DataDatabricksCluster#last_activity_time}
    */
    readonly lastActivityTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#last_state_loss_time DataDatabricksCluster#last_state_loss_time}
    */
    readonly lastStateLossTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#node_type_id DataDatabricksCluster#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#num_workers DataDatabricksCluster#num_workers}
    */
    readonly numWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#policy_id DataDatabricksCluster#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#single_user_name DataDatabricksCluster#single_user_name}
    */
    readonly singleUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#spark_conf DataDatabricksCluster#spark_conf}
    */
    readonly sparkConf?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#spark_context_id DataDatabricksCluster#spark_context_id}
    */
    readonly sparkContextId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#spark_env_vars DataDatabricksCluster#spark_env_vars}
    */
    readonly sparkEnvVars?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#spark_version DataDatabricksCluster#spark_version}
    */
    readonly sparkVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#ssh_public_keys DataDatabricksCluster#ssh_public_keys}
    */
    readonly sshPublicKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#start_time DataDatabricksCluster#start_time}
    */
    readonly startTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#state DataDatabricksCluster#state}
    */
    readonly state: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#state_message DataDatabricksCluster#state_message}
    */
    readonly stateMessage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#terminate_time DataDatabricksCluster#terminate_time}
    */
    readonly terminateTime?: number;
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#autoscale DataDatabricksCluster#autoscale}
    */
    readonly autoscale?: DataDatabricksClusterClusterInfoAutoscale;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#aws_attributes DataDatabricksCluster#aws_attributes}
    */
    readonly awsAttributes?: DataDatabricksClusterClusterInfoAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#azure_attributes DataDatabricksCluster#azure_attributes}
    */
    readonly azureAttributes?: DataDatabricksClusterClusterInfoAzureAttributes;
    /**
    * cluster_log_conf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#cluster_log_conf DataDatabricksCluster#cluster_log_conf}
    */
    readonly clusterLogConf?: DataDatabricksClusterClusterInfoClusterLogConf;
    /**
    * cluster_log_status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#cluster_log_status DataDatabricksCluster#cluster_log_status}
    */
    readonly clusterLogStatus?: DataDatabricksClusterClusterInfoClusterLogStatus;
    /**
    * docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#docker_image DataDatabricksCluster#docker_image}
    */
    readonly dockerImage?: DataDatabricksClusterClusterInfoDockerImage;
    /**
    * driver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#driver DataDatabricksCluster#driver}
    */
    readonly driver?: DataDatabricksClusterClusterInfoDriver;
    /**
    * executors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#executors DataDatabricksCluster#executors}
    */
    readonly executors?: DataDatabricksClusterClusterInfoExecutors[] | cdktf.IResolvable;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#gcp_attributes DataDatabricksCluster#gcp_attributes}
    */
    readonly gcpAttributes?: DataDatabricksClusterClusterInfoGcpAttributes;
    /**
    * init_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#init_scripts DataDatabricksCluster#init_scripts}
    */
    readonly initScripts?: DataDatabricksClusterClusterInfoInitScripts[] | cdktf.IResolvable;
    /**
    * termination_reason block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster#termination_reason DataDatabricksCluster#termination_reason}
    */
    readonly terminationReason?: DataDatabricksClusterClusterInfoTerminationReason;
}
export declare function dataDatabricksClusterClusterInfoToTerraform(struct?: DataDatabricksClusterClusterInfoOutputReference | DataDatabricksClusterClusterInfo): any;
export declare class DataDatabricksClusterClusterInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksClusterClusterInfo | undefined;
    set internalValue(value: DataDatabricksClusterClusterInfo | undefined);
    private _autoterminationMinutes?;
    get autoterminationMinutes(): number;
    set autoterminationMinutes(value: number);
    resetAutoterminationMinutes(): void;
    get autoterminationMinutesInput(): number | undefined;
    private _clusterCores?;
    get clusterCores(): number;
    set clusterCores(value: number);
    resetClusterCores(): void;
    get clusterCoresInput(): number | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterMemoryMb?;
    get clusterMemoryMb(): number;
    set clusterMemoryMb(value: number);
    resetClusterMemoryMb(): void;
    get clusterMemoryMbInput(): number | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _clusterSource?;
    get clusterSource(): string;
    set clusterSource(value: string);
    resetClusterSource(): void;
    get clusterSourceInput(): string | undefined;
    private _creatorUserName?;
    get creatorUserName(): string;
    set creatorUserName(value: string);
    resetCreatorUserName(): void;
    get creatorUserNameInput(): string | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataSecurityMode?;
    get dataSecurityMode(): string;
    set dataSecurityMode(value: string);
    resetDataSecurityMode(): void;
    get dataSecurityModeInput(): string | undefined;
    private _defaultTags?;
    get defaultTags(): {
        [key: string]: string;
    };
    set defaultTags(value: {
        [key: string]: string;
    });
    get defaultTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _driverInstancePoolId?;
    get driverInstancePoolId(): string;
    set driverInstancePoolId(value: string);
    resetDriverInstancePoolId(): void;
    get driverInstancePoolIdInput(): string | undefined;
    private _driverNodeTypeId?;
    get driverNodeTypeId(): string;
    set driverNodeTypeId(value: string);
    resetDriverNodeTypeId(): void;
    get driverNodeTypeIdInput(): string | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLocalDiskEncryption?;
    get enableLocalDiskEncryption(): boolean | cdktf.IResolvable;
    set enableLocalDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableLocalDiskEncryption(): void;
    get enableLocalDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _jdbcPort?;
    get jdbcPort(): number;
    set jdbcPort(value: number);
    resetJdbcPort(): void;
    get jdbcPortInput(): number | undefined;
    private _lastActivityTime?;
    get lastActivityTime(): number;
    set lastActivityTime(value: number);
    resetLastActivityTime(): void;
    get lastActivityTimeInput(): number | undefined;
    private _lastStateLossTime?;
    get lastStateLossTime(): number;
    set lastStateLossTime(value: number);
    resetLastStateLossTime(): void;
    get lastStateLossTimeInput(): number | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    resetNumWorkers(): void;
    get numWorkersInput(): number | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _singleUserName?;
    get singleUserName(): string;
    set singleUserName(value: string);
    resetSingleUserName(): void;
    get singleUserNameInput(): string | undefined;
    private _sparkConf?;
    get sparkConf(): {
        [key: string]: string;
    };
    set sparkConf(value: {
        [key: string]: string;
    });
    resetSparkConf(): void;
    get sparkConfInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkContextId?;
    get sparkContextId(): number;
    set sparkContextId(value: number);
    resetSparkContextId(): void;
    get sparkContextIdInput(): number | undefined;
    private _sparkEnvVars?;
    get sparkEnvVars(): {
        [key: string]: string;
    };
    set sparkEnvVars(value: {
        [key: string]: string;
    });
    resetSparkEnvVars(): void;
    get sparkEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    get sparkVersionInput(): string | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): string[] | undefined;
    private _startTime?;
    get startTime(): number;
    set startTime(value: number);
    resetStartTime(): void;
    get startTimeInput(): number | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
    private _stateMessage?;
    get stateMessage(): string;
    set stateMessage(value: string);
    resetStateMessage(): void;
    get stateMessageInput(): string | undefined;
    private _terminateTime?;
    get terminateTime(): number;
    set terminateTime(value: number);
    resetTerminateTime(): void;
    get terminateTimeInput(): number | undefined;
    private _autoscale;
    get autoscale(): DataDatabricksClusterClusterInfoAutoscaleOutputReference;
    putAutoscale(value: DataDatabricksClusterClusterInfoAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): DataDatabricksClusterClusterInfoAutoscale | undefined;
    private _awsAttributes;
    get awsAttributes(): DataDatabricksClusterClusterInfoAwsAttributesOutputReference;
    putAwsAttributes(value: DataDatabricksClusterClusterInfoAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): DataDatabricksClusterClusterInfoAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): DataDatabricksClusterClusterInfoAzureAttributesOutputReference;
    putAzureAttributes(value: DataDatabricksClusterClusterInfoAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): DataDatabricksClusterClusterInfoAzureAttributes | undefined;
    private _clusterLogConf;
    get clusterLogConf(): DataDatabricksClusterClusterInfoClusterLogConfOutputReference;
    putClusterLogConf(value: DataDatabricksClusterClusterInfoClusterLogConf): void;
    resetClusterLogConf(): void;
    get clusterLogConfInput(): DataDatabricksClusterClusterInfoClusterLogConf | undefined;
    private _clusterLogStatus;
    get clusterLogStatus(): DataDatabricksClusterClusterInfoClusterLogStatusOutputReference;
    putClusterLogStatus(value: DataDatabricksClusterClusterInfoClusterLogStatus): void;
    resetClusterLogStatus(): void;
    get clusterLogStatusInput(): DataDatabricksClusterClusterInfoClusterLogStatus | undefined;
    private _dockerImage;
    get dockerImage(): DataDatabricksClusterClusterInfoDockerImageOutputReference;
    putDockerImage(value: DataDatabricksClusterClusterInfoDockerImage): void;
    resetDockerImage(): void;
    get dockerImageInput(): DataDatabricksClusterClusterInfoDockerImage | undefined;
    private _driver;
    get driver(): DataDatabricksClusterClusterInfoDriverOutputReference;
    putDriver(value: DataDatabricksClusterClusterInfoDriver): void;
    resetDriver(): void;
    get driverInput(): DataDatabricksClusterClusterInfoDriver | undefined;
    private _executors;
    get executors(): DataDatabricksClusterClusterInfoExecutorsList;
    putExecutors(value: DataDatabricksClusterClusterInfoExecutors[] | cdktf.IResolvable): void;
    resetExecutors(): void;
    get executorsInput(): cdktf.IResolvable | DataDatabricksClusterClusterInfoExecutors[] | undefined;
    private _gcpAttributes;
    get gcpAttributes(): DataDatabricksClusterClusterInfoGcpAttributesOutputReference;
    putGcpAttributes(value: DataDatabricksClusterClusterInfoGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): DataDatabricksClusterClusterInfoGcpAttributes | undefined;
    private _initScripts;
    get initScripts(): DataDatabricksClusterClusterInfoInitScriptsList;
    putInitScripts(value: DataDatabricksClusterClusterInfoInitScripts[] | cdktf.IResolvable): void;
    resetInitScripts(): void;
    get initScriptsInput(): cdktf.IResolvable | DataDatabricksClusterClusterInfoInitScripts[] | undefined;
    private _terminationReason;
    get terminationReason(): DataDatabricksClusterClusterInfoTerminationReasonOutputReference;
    putTerminationReason(value: DataDatabricksClusterClusterInfoTerminationReason): void;
    resetTerminationReason(): void;
    get terminationReasonInput(): DataDatabricksClusterClusterInfoTerminationReason | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/cluster databricks_cluster}
*/
export declare class DataDatabricksCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/cluster databricks_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksClusterConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _clusterInfo;
    get clusterInfo(): DataDatabricksClusterClusterInfoOutputReference;
    putClusterInfo(value: DataDatabricksClusterClusterInfo): void;
    resetClusterInfo(): void;
    get clusterInfoInput(): DataDatabricksClusterClusterInfo | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
