import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksDbfsFileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file#id DataDatabricksDbfsFile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file#limit_file_size DataDatabricksDbfsFile#limit_file_size}
    */
    readonly limitFileSize: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file#path DataDatabricksDbfsFile#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file databricks_dbfs_file}
*/
export declare class DataDatabricksDbfsFile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_dbfs_file";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file databricks_dbfs_file} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksDbfsFileConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksDbfsFileConfig);
    get content(): string;
    get fileSize(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _limitFileSize?;
    get limitFileSize(): boolean | cdktf.IResolvable;
    set limitFileSize(value: boolean | cdktf.IResolvable);
    get limitFileSizeInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
