import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksNodeTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#category DataDatabricksNodeType#category}
    */
    readonly category?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#gb_per_core DataDatabricksNodeType#gb_per_core}
    */
    readonly gbPerCore?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#graviton DataDatabricksNodeType#graviton}
    */
    readonly graviton?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#id DataDatabricksNodeType#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#is_io_cache_enabled DataDatabricksNodeType#is_io_cache_enabled}
    */
    readonly isIoCacheEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#local_disk DataDatabricksNodeType#local_disk}
    */
    readonly localDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#min_cores DataDatabricksNodeType#min_cores}
    */
    readonly minCores?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#min_gpus DataDatabricksNodeType#min_gpus}
    */
    readonly minGpus?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#min_memory_gb DataDatabricksNodeType#min_memory_gb}
    */
    readonly minMemoryGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#photon_driver_capable DataDatabricksNodeType#photon_driver_capable}
    */
    readonly photonDriverCapable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#photon_worker_capable DataDatabricksNodeType#photon_worker_capable}
    */
    readonly photonWorkerCapable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#support_port_forwarding DataDatabricksNodeType#support_port_forwarding}
    */
    readonly supportPortForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/node_type#vcpu DataDatabricksNodeType#vcpu}
    */
    readonly vcpu?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/node_type databricks_node_type}
*/
export declare class DataDatabricksNodeType extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_node_type";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/node_type databricks_node_type} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksNodeTypeConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksNodeTypeConfig);
    private _category?;
    get category(): string;
    set category(value: string);
    resetCategory(): void;
    get categoryInput(): string | undefined;
    private _gbPerCore?;
    get gbPerCore(): number;
    set gbPerCore(value: number);
    resetGbPerCore(): void;
    get gbPerCoreInput(): number | undefined;
    private _graviton?;
    get graviton(): boolean | cdktf.IResolvable;
    set graviton(value: boolean | cdktf.IResolvable);
    resetGraviton(): void;
    get gravitonInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isIoCacheEnabled?;
    get isIoCacheEnabled(): boolean | cdktf.IResolvable;
    set isIoCacheEnabled(value: boolean | cdktf.IResolvable);
    resetIsIoCacheEnabled(): void;
    get isIoCacheEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _localDisk?;
    get localDisk(): boolean | cdktf.IResolvable;
    set localDisk(value: boolean | cdktf.IResolvable);
    resetLocalDisk(): void;
    get localDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _minCores?;
    get minCores(): number;
    set minCores(value: number);
    resetMinCores(): void;
    get minCoresInput(): number | undefined;
    private _minGpus?;
    get minGpus(): number;
    set minGpus(value: number);
    resetMinGpus(): void;
    get minGpusInput(): number | undefined;
    private _minMemoryGb?;
    get minMemoryGb(): number;
    set minMemoryGb(value: number);
    resetMinMemoryGb(): void;
    get minMemoryGbInput(): number | undefined;
    private _photonDriverCapable?;
    get photonDriverCapable(): boolean | cdktf.IResolvable;
    set photonDriverCapable(value: boolean | cdktf.IResolvable);
    resetPhotonDriverCapable(): void;
    get photonDriverCapableInput(): boolean | cdktf.IResolvable | undefined;
    private _photonWorkerCapable?;
    get photonWorkerCapable(): boolean | cdktf.IResolvable;
    set photonWorkerCapable(value: boolean | cdktf.IResolvable);
    resetPhotonWorkerCapable(): void;
    get photonWorkerCapableInput(): boolean | cdktf.IResolvable | undefined;
    private _supportPortForwarding?;
    get supportPortForwarding(): boolean | cdktf.IResolvable;
    set supportPortForwarding(value: boolean | cdktf.IResolvable);
    resetSupportPortForwarding(): void;
    get supportPortForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _vcpu?;
    get vcpu(): boolean | cdktf.IResolvable;
    set vcpu(value: boolean | cdktf.IResolvable);
    resetVcpu(): void;
    get vcpuInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
