import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksSchemasConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/schemas#catalog_name DataDatabricksSchemas#catalog_name}
    */
    readonly catalogName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/schemas#id DataDatabricksSchemas#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/schemas#ids DataDatabricksSchemas#ids}
    */
    readonly ids?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/schemas databricks_schemas}
*/
export declare class DataDatabricksSchemas extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_schemas";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/schemas databricks_schemas} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksSchemasConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksSchemasConfig);
    private _catalogName?;
    get catalogName(): string;
    set catalogName(value: string);
    get catalogNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ids?;
    get ids(): string[];
    set ids(value: string[]);
    resetIds(): void;
    get idsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
